/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.operate.webapi.OpWebApiHelper;
import kd.bos.entity.operate.webapi.OperationApi;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.webapi.query.g.convert.FilterValueConvertHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class DefaultOperate
extends OperationApi {
    private Log log = LogFactory.getLog(DefaultOperate.class);

    public ApiResult execute() {
        ApiResult result = new ApiResult();
        ConvertPkEvent e = new ConvertPkEvent((Object)this.getView(), this.getOperationNumber(), this.requestData);
        this.fireConvertPkEvent(e);
        List numbers = (List)this.requestData.get("numbers");
        ArrayList<Object> pkIds = (ArrayList<Object>)this.requestData.get("ids");
        String orgNumber = (String)this.requestData.get("org");
        String apiOrgtype = (String)this.requestData.get("api.orgtype");
        FormConfig config = FormMetadataCache.getFormConfig((String)this.formId);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)config.getEntityTypeId());
        if (pkIds == null) {
            pkIds = new ArrayList<Object>();
        }
        if (pkIds.size() > 1 && dt.getPrimaryKey() != null && dt.getPrimaryKey() instanceof LongProp) {
            ArrayList<Object> convertPkIds = new ArrayList<Object>(pkIds.size());
            for (Object pkId : pkIds) {
                this.log.info(String.format("WebApi_log DefaultOperate1 OperationNumber:%s input:%s pkIdType:%s ", this.getOperationNumber(), pkId, pkId.getClass().toString()));
                Object convertResult = FilterValueConvertHelper.getConvertResult((IDataEntityProperty)((DynamicProperty)dt.getPrimaryKey()), pkId);
                convertPkIds.add(convertResult);
            }
            pkIds = convertPkIds;
        }
        if (numbers != null) {
            List<Object> newpkIds = OpWebApiHelper.getPks(dt, numbers.toArray(new String[numbers.size()]), orgNumber, apiOrgtype);
            pkIds.addAll(newpkIds);
            for (Object pkId : newpkIds) {
                this.log.info(String.format("WebApi_log DefaultOperate2 OperationNumber:%s newpkIds:%s pkIdType:%s ", this.getOperationNumber(), pkId, pkId.getClass().toString()));
            }
        }
        if (pkIds.isEmpty()) {
            result.setSuccess(false);
            result.setMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u9700\u8981\u5904\u7406\u7684\u6570\u636e", (String)"DefaultOperate_\uff11", (String)"bos-entity-business", (Object[])new Object[0]));
        } else {
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)this.getOperationNumber(), (String)dt.getName(), (Object[])pkIds.toArray(), (OperateOption)this.createOption());
            if (!operationResult.isSuccess()) {
                result.setMessage(DefaultOperate.getFirstErrorMessage(operationResult));
            }
            result.setSuccess(operationResult.isSuccess());
            result.setData((Object)operationResult);
        }
        return result;
    }

    protected OperateOption createOption() {
        OperateOption option = OperateOption.create();
        Map optionVariables = (Map)this.requestData.get("optionvariables");
        if (optionVariables != null) {
            for (Map.Entry entry : optionVariables.entrySet()) {
                option.setVariableValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
        option.setVariableValue("ignorewarn", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        return option;
    }
}

