/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;

public class EntryIdsValidate {
    public static Map<Integer, Set<String>> validateFirst(IDataModel model, Map<String, Map<String, String>> dbIdPool, List<Map<String, Object>> sourceDatas) {
        HashMap<Integer, Set<String>> validateMsg = new HashMap<Integer, Set<String>>();
        HashMap localIdPoo = new HashMap();
        Map<String, EntityType> allEntities = EntryIdsValidate.getEntryEntities(model);
        for (int i = 0; i < sourceDatas.size(); ++i) {
            Map<String, Object> sourceData = sourceDatas.get(i);
            EntryIdsValidate.forEachEntry(allEntities, sourceData, item -> {
                String entryKey = (String)item[0];
                JSONObject entryJson = (JSONObject)item[2];
                if (localIdPoo.containsKey(entryKey)) {
                    Set localKeys = (Set)localIdPoo.get(entryKey);
                    String entryId = entryJson.getString("id");
                    Integer rowNum = (Integer)entryJson.get((Object)"rowNum");
                    if (localKeys.contains(entryId)) {
                        HashSet<String> duplyIds = (HashSet<String>)validateMsg.get(rowNum);
                        if (duplyIds == null) {
                            duplyIds = new HashSet<String>();
                        }
                        duplyIds.add(entryId);
                        validateMsg.put(rowNum, duplyIds);
                    } else {
                        localKeys.add(entryId);
                    }
                } else {
                    HashSet<String> sets = new HashSet<String>();
                    sets.add(entryJson.getString("id"));
                    localIdPoo.put(entryKey, sets);
                }
            });
        }
        for (Map.Entry entry : localIdPoo.entrySet()) {
            Map<String, String> dbKeys = EntryIdsValidate.getDbIds(allEntities.get(entry.getKey()), (Set)entry.getValue());
            dbIdPool.put((String)entry.getKey(), dbKeys);
        }
        return validateMsg;
    }

    public static Map<Integer, Set<String>> validateSecond(IDataModel model, Map<String, Map<String, String>> dbIdPool, Map<String, Object> sourceData, Map<Integer, Set<String>> firstValidateMsg) {
        HashMap<Integer, Set<String>> validateMsg = new HashMap<Integer, Set<String>>();
        Map<String, EntityType> allEntities = EntryIdsValidate.getEntryEntities(model);
        EntryIdsValidate.forEachEntry(allEntities, sourceData, item -> {
            Map dbKeys;
            String entryKey = (String)item[0];
            String entityId = String.valueOf(item[1]);
            JSONObject entryJson = (JSONObject)item[2];
            String entryId = entryJson.getString("id");
            Integer rowNum = (Integer)entryJson.get((Object)"rowNum");
            if (firstValidateMsg.containsKey(rowNum)) {
                Set localDuplyIds = (Set)firstValidateMsg.get(rowNum);
                if (validateMsg.containsKey(rowNum)) {
                    ((Set)validateMsg.get(rowNum)).addAll(localDuplyIds);
                    firstValidateMsg.remove(rowNum);
                } else {
                    validateMsg.put(rowNum, localDuplyIds);
                    firstValidateMsg.remove(rowNum);
                }
            }
            if (dbIdPool.containsKey(entryKey) && (dbKeys = (Map)dbIdPool.get(entryKey)).containsKey(entryId) && !StringUtils.equals((CharSequence)((CharSequence)dbKeys.get(entryId)), (CharSequence)entityId)) {
                HashSet<String> duplyIds = (HashSet<String>)validateMsg.get(rowNum);
                if (duplyIds == null) {
                    duplyIds = new HashSet<String>();
                }
                duplyIds.add(entryId);
                validateMsg.put(rowNum, duplyIds);
            }
        });
        return validateMsg;
    }

    public static void buildResult(OperationResult convResult, Map<Integer, Set<String>> validateMsg2, int entityRowNum) {
        Map<Integer, List> convertMsg = new HashMap();
        String msg = convResult.getMessage();
        if (validateMsg2.isEmpty()) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            try {
                convertMsg = (Map)JSONObject.parseObject((String)msg, HashMap.class);
            }
            catch (Exception e) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(msg);
                convertMsg.put(entityRowNum, list);
            }
        }
        for (Map.Entry<Integer, Set<String>> entry : validateMsg2.entrySet()) {
            int rowNum = entry.getKey();
            String validateMsg = String.format(ResManager.loadKDString((String)"\u5206\u5f55\u5185\u7801\u51b2\u7a81\uff1a%s;", (String)"EntryIdsValidate_0", (String)"bos-entity-business", (Object[])new Object[0]), StringUtils.join((Object[])entry.getValue().toArray(), (String)","));
            if (convertMsg.containsKey(rowNum)) {
                List listMsg = (List)convertMsg.get(rowNum);
                listMsg.add(validateMsg);
                convertMsg.put(rowNum, listMsg);
                continue;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(validateMsg);
            convertMsg.put(rowNum, list);
        }
        convResult.setSuccess(false);
        convResult.setMessage(JSONObject.toJSONString(convertMsg));
    }

    private static Map<String, EntityType> getEntryEntities(IDataModel model) {
        HashMap<String, EntityType> entryEntities = new HashMap<String, EntityType>(16);
        MainEntityType mainEntityType = model.getDataEntityType();
        Map allEntities = mainEntityType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            String key = (String)entry.getKey();
            if (StringUtils.equals((CharSequence)key, (CharSequence)mainEntityType.getName()) || !StringUtils.isNotBlank((CharSequence)((EntityType)allEntities.get(key)).getAlias())) continue;
            entryEntities.put(key, (EntityType)entry.getValue());
        }
        return entryEntities;
    }

    private static void forEachEntry(Map<String, EntityType> allEntities, Map<String, Object> sourceData, Consumer<Object[]> consumer) {
        Object entityId = sourceData.get("id");
        for (String entryKey : allEntities.keySet()) {
            Object entryObj = sourceData.get(entryKey);
            if (!(entryObj instanceof JSONArray)) continue;
            JSONArray entryArray = (JSONArray)entryObj;
            for (int j = 0; j < entryArray.size(); ++j) {
                JSONObject entryJson = entryArray.getJSONObject(j);
                if (StringUtils.isNotBlank((CharSequence)entryJson.getString("id"))) {
                    consumer.accept(new Object[]{entryKey, entityId, entryJson});
                }
                EntryIdsValidate.forEachEntry(allEntities, (Map<String, Object>)entryJson, consumer);
            }
        }
    }

    private static Map<String, String> getDbIds(EntityType entryType, Set<String> ids) {
        String tableName = entryType.getAlias();
        String idName = entryType.getPrimaryKey().getAlias();
        String parIdName = entryType.getParent().getPrimaryKey().getAlias();
        StringBuilder builder = new StringBuilder();
        builder.append("select ").append(idName).append(",").append(parIdName).append(" from ").append(tableName);
        builder.append(" where ").append(idName).append(" in (").append(StringUtils.join((Object[])ids.toArray(), (String)",")).append(")");
        DBRoute route = DBRoute.of((String)entryType.getDBRouteKey());
        Map dbIds = (Map)DB.query((DBRoute)route, (String)builder.toString(), null, ds -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            while (ds.next()) {
                map.put(ds.getString(idName), ds.getString(parIdName));
            }
            return map;
        });
        return dbIds;
    }
}

