/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.webapi.OpWebApiHelper;
import kd.bos.entity.operate.webapi.OperationApi;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class Load
extends OperationApi {
    private static final String ATTACHMENT_FIELDNAME = "_attachments";
    private static final String ATTACHMENT_ENTITY = "bos_attachment";
    private static final String ATTACHMENT_URL = "furl";
    private static final String ATTACHMENT_PANEL = "fattachmentpanel";
    private static final String[] ATTACHMENT_Fields = new String[]{"furl", "fattachmentpanel"};

    public ApiResult execute() {
        ConvertPkEvent e = new ConvertPkEvent((Object)this.getView(), this.getOperationNumber(), this.requestData);
        this.fireConvertPkEvent(e);
        String number = (String)this.requestData.get("number");
        Object pkId = this.requestData.get("id");
        FormConfig config = FormMetadataCache.getFormConfig((String)this.formId);
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)config.getEntityTypeId());
        BillEntityType newMainType = null;
        try {
            newMainType = (BillEntityType)dt.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("Load.execute.clone", exp.getMessage()), new Object[0]);
        }
        if (pkId == null) {
            String orgNumber = (String)this.requestData.get("org");
            pkId = OpWebApiHelper.getPk(dt, pkId, number, orgNumber);
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(pkId, (DynamicObjectType)newMainType);
        this.loadAttachments(pkId, dynamicObject);
        return ApiResult.success((Object)dynamicObject);
    }

    private void loadAttachments(Object pkId, DynamicObject dynamicObject) {
        IAttachmentModelProxy attachmentModel = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        Map attachments1 = attachmentModel.getAttachmentsForApi(this.formId, pkId);
        this.registerAttachmentField(dynamicObject.getDynamicObjectType());
        if (attachments1 != null) {
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(10);
            for (Map.Entry item : attachments1.entrySet()) {
                Attachment atta = new Attachment();
                atta.setPanel((String)item.getKey());
                atta.setUrl((String)item.getValue());
                attachments.add(atta);
            }
            dynamicObject.set(ATTACHMENT_FIELDNAME, attachments);
        }
    }

    private void registerAttachmentField(DynamicObjectType dynamicObjectType) {
        if (dynamicObjectType.getProperty(ATTACHMENT_FIELDNAME) != null) {
            return;
        }
        dynamicObjectType.registerProperty(ATTACHMENT_FIELDNAME, Collection.class, null, false);
    }

    static class Attachment {
        private String panel;
        private String url;

        Attachment() {
        }

        @SimplePropertyAttribute(isPrimaryKey=true)
        public String getPanel() {
            return this.panel;
        }

        public void setPanel(String panel) {
            this.panel = panel;
        }

        @SimplePropertyAttribute
        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

