/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.entity.operate.webapi;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.bill.BillViewPluginProxy;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.bill.events.ConvertPkEvent;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.service.webapi.WebApiHelper;

public abstract class OperationApi
extends AbstractOperateWebApi {
    public void fireConvertPkEvent(ConvertPkEvent e) {
        if ("true".equals(System.getProperty("api.enableopplugin", "true"))) {
            List<IBillWebApiPlugin> operationServicePlugin = WebApiHelper.getOperationServicePlugin(this.formId, this.getOperationNumber());
            for (IBillWebApiPlugin apiPlugin : operationServicePlugin) {
                apiPlugin.convertPk(e);
            }
        }
        BillViewPluginProxy pluginProxy = (BillViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
        pluginProxy.fireConvertPk(e);
    }

    static String getFirstErrorMessage(OperationResult operationResult) {
        ArrayList<String> errors = new ArrayList<String>();
        operationResult.getAllErrorOrValidateInfo().forEach(o -> errors.add(o.getMessage()));
        String message = operationResult.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            errors.add(message);
        }
        if (errors.isEmpty()) {
            return ApiConstant.OPERATIONFALSEMESSAGE;
        }
        if (errors.size() == 1) {
            return (String)errors.get(0);
        }
        return MessageFormat.format(ApiConstant.FIRSTMESSAGEERRORFMTTPL, errors.get(0), errors.size());
    }
}

