/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.query;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.algo.dataset.cache.DataSetCacheSpi;
import kd.bos.algo.dataset.cache.DataSetCacheSpiFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.mservice.query.DetailQueryResult;
import kd.bos.openapi.servicehelper.BusinessDataApiServiceHelper;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;
import kd.bos.permission.api.FieldControlRule;
import kd.bos.permission.api.PermissionService;
import kd.bos.query.QueryResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;

public class CachedQuery {
    public static final String NUMBER = "number";
    private static final String MASK_STRING = "***";
    private static final String ALGO_KEY = "kd.bos.CachedQuery";
    private static Map<Integer, List<FlexProperty>> flexProMap = new HashMap<Integer, List<FlexProperty>>();
    private static String billEntityId = null;

    private CachedQuery() {
    }

    public static QueryResult beginQuery(String entityId, String selectFields, QFilter[] filters, String orderBys, int pageSize) {
        CachedDataSetBuilder cacheBuilder;
        QueryResult ret = new QueryResult();
        ORM orm = ORM.create();
        MainEntityType et = EntityMetadataCache.getDataEntityType((String)entityId);
        String entityName = et.getName();
        orm.setDataEntityType(entityName, (IDataEntityType)et);
        try (DataSet ds = orm.queryDataSet(ALGO_KEY, entityName, selectFields, filters, orderBys, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            CacheHint cacheHint = new CacheHint();
            cacheBuilder = new CachedDataSetBuilder(ds.getRowMeta(), cacheHint, CachedQuery.class.getSimpleName() + ".query.run");
            cacheBuilder.append(ds.iterator());
        }
        CachedDataSet cds = cacheBuilder.build();
        ret.setRows(cds.getRowCount());
        ret.setCacheId(cds.getCacheId());
        ret.setSuccess(Boolean.valueOf(true));
        return ret;
    }

    public static List<Object> beginDetailQuery(String entityId, String selectFields, QFilter[] filters, String orderBys) {
        billEntityId = entityId;
        flexProMap.clear();
        ArrayList<Object> resultList = new ArrayList<Object>(10);
        String[] splitArray = selectFields.split(",");
        DynamicObject[] queryEntityList = BusinessDataServiceHelper.load((String)entityId, (String)selectFields, (QFilter[])filters, (String)orderBys);
        List<String> allEntryNames = CachedQuery.getAllEntryNames(entityId);
        ArrayList<String> headerList = new ArrayList<String>();
        HashMap entryMap = new HashMap();
        for (String string : splitArray) {
            if (string == null) continue;
            String name = string.contains(".") ? string.split("\\.")[0] : string;
            if (allEntryNames.contains(name) && string.contains(".")) {
                String entryName = string.split("\\.")[0];
                String entryProperty = string.split("\\.")[1];
                if (entryMap.containsKey(entryName)) {
                    ((List)entryMap.get(entryName)).add(entryProperty);
                    continue;
                }
                ArrayList<String> entryFields = new ArrayList<String>();
                entryFields.add(entryProperty);
                entryMap.put(entryName, entryFields);
                continue;
            }
            headerList.add(name);
        }
        for (String string : queryEntityList) {
            HashMap<String, Object> itemResultMap = new HashMap<String, Object>();
            for (String headerField : headerList) {
                IDataEntityProperty property;
                Map<String, Object> headerMap = CachedQuery.parseField(headerField, (DynamicObject)string, property = (IDataEntityProperty)string.getDataEntityType().getProperties().get((Object)headerField));
                if (headerMap.isEmpty()) continue;
                itemResultMap.putAll(headerMap);
            }
            HashMap allEntryMap = new HashMap(16);
            for (Map.Entry entry : entryMap.entrySet()) {
                String entryName = (String)entry.getKey();
                DynamicObjectCollection entryCollection = string.getDynamicObjectCollection(entryName);
                EntryProp entryProp = (EntryProp)string.getDataEntityType().getProperties().get((Object)entryName);
                if (entryCollection == null || entryCollection.isEmpty()) continue;
                ArrayList entryRowsList = new ArrayList();
                for (DynamicObject entryRow : entryCollection) {
                    List entryProperties = (List)entry.getValue();
                    HashMap<String, Object> entryRowsMap = new HashMap<String, Object>();
                    for (String entryProperty : entryProperties) {
                        DynamicProperty property;
                        Map<String, Object> entryRowProperty = CachedQuery.parseField(entryProperty, entryRow, property = entryProp.getDynamicCollectionItemPropertyType().getProperty(entryProperty));
                        if (entryRowProperty.isEmpty()) continue;
                        entryRowsMap.putAll(entryRowProperty);
                    }
                    if (entryRowsMap.isEmpty()) continue;
                    entryRowsList.add(entryRowsMap);
                }
                allEntryMap.put(entryName, entryRowsList);
            }
            itemResultMap.putAll(allEntryMap);
            resultList.add(itemResultMap);
        }
        return resultList;
    }

    public static Map<String, Object> parseField(String selectFiled, DynamicObject dynamicObject, Object fieldProperty) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put(selectFiled, "");
        ArrayList<DetailQueryResult> resultArrayList = new ArrayList<DetailQueryResult>();
        Object value = dynamicObject.get(selectFiled);
        if (value == null && !(fieldProperty instanceof ItemClassProp)) {
            return resultMap;
        }
        if (value instanceof String) {
            resultMap.put(selectFiled, value);
        } else if (fieldProperty instanceof ItemClassProp) {
            if (dynamicObject.getDynamicObjectType() instanceof EntryType) {
                DynamicObject typeDynamicObject = dynamicObject.getDynamicObject(((ItemClassProp)fieldProperty).getName());
                if (!ObjectUtils.isEmpty((Object)typeDynamicObject)) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)typeDynamicObject.get("name");
                    String name = ormLocaleValue.getLocaleValue();
                    Object number = typeDynamicObject.get(NUMBER);
                    DetailQueryResult detailQueryResult = new DetailQueryResult(name, String.valueOf(number));
                    resultMap.put(selectFiled, detailQueryResult);
                }
            } else {
                String classEntityType;
                String itemClassPropName = ((ItemClassProp)fieldProperty).getRefIdProp().getName();
                Long itemClassPropId = (Long)dynamicObject.get(itemClassPropName);
                String typePropName = ((ItemClassProp)fieldProperty).getTypePropName();
                Long rowId = (Long)dynamicObject.getPkValue();
                DynamicObject itemDynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)rowId, (String)billEntityId);
                if (!ObjectUtils.isEmpty((Object)itemDynamicObject) && StringUtils.isNotEmpty((CharSequence)(classEntityType = (String)itemDynamicObject.get(typePropName)))) {
                    DynamicObject itemClassRow = BusinessDataServiceHelper.loadSingleFromCache((Object)itemClassPropId, (String)classEntityType);
                    DetailQueryResult detailQueryResult = new DetailQueryResult(((OrmLocaleValue)itemClassRow.get("name")).getLocaleValue(), String.valueOf(itemClassRow.get(NUMBER)));
                    resultMap.put(selectFiled, detailQueryResult);
                }
            }
        } else if (fieldProperty instanceof FlexProp) {
            List<FlexProperty> flexProperties;
            int flexTypeId = ((FlexProp)fieldProperty).getFlexTypeId();
            if (flexProMap.containsKey(flexTypeId)) {
                flexProperties = flexProMap.get(flexTypeId);
            } else {
                flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexTypeId);
                flexProMap.put(flexTypeId, flexProperties);
            }
            List<DetailQueryResult> results = CachedQuery.getFlexValue(flexProperties, (DynamicObject)value);
            resultArrayList.addAll(results);
            if (!ObjectUtils.isEmpty(resultArrayList)) {
                resultMap.put(selectFiled, resultArrayList);
            }
        } else if (value != null && fieldProperty instanceof BasedataProp) {
            DetailQueryResult result = new DetailQueryResult(((OrmLocaleValue)((DynamicObject)value).get("name")).getLocaleValue(), String.valueOf(((DynamicObject)value).get(NUMBER)));
            resultMap.put(selectFiled, result);
        } else if (fieldProperty instanceof MulBasedataProp) {
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)value;
            for (DynamicObject dynamic : dynamicObjects) {
                DynamicObject item = (DynamicObject)dynamic.get((IDataEntityProperty)((MulBasedataProp)fieldProperty).getRefBaseProp());
                DetailQueryResult result = new DetailQueryResult(((OrmLocaleValue)item.get("name")).getLocaleValue(), String.valueOf(item.get(NUMBER)));
                resultArrayList.add(result);
            }
            if (!ObjectUtils.isEmpty(resultArrayList)) {
                resultMap.put(selectFiled, resultArrayList);
            }
        } else if (value != null && fieldProperty instanceof MuliLangTextProp) {
            resultMap.put(selectFiled, ((OrmLocaleValue)value).getLocaleValue());
        } else if (fieldProperty instanceof QtyProp && value instanceof BigDecimal) {
            resultMap.put(selectFiled, ((BigDecimal)value).toPlainString());
        } else {
            resultMap.put(selectFiled, value);
        }
        return resultMap;
    }

    private static List<DetailQueryResult> getFlexValue(List<FlexProperty> flexProperties, DynamicObject flexData) {
        ArrayList<DetailQueryResult> resultList = new ArrayList<DetailQueryResult>();
        String flexValue = (String)flexData.get("value");
        if (flexValue.contains("\\")) {
            flexValue = flexValue.replace("\\", "");
        }
        Map flexMap = (Map)JSON.parseObject((String)flexValue, Map.class);
        Set fkeySet = flexMap.keySet();
        for (FlexProperty flexProperty : flexProperties) {
            String flexField = flexProperty.getFlexField();
            if (!fkeySet.contains(flexField)) continue;
            DetailQueryResult result = new DetailQueryResult();
            Object pkValue = flexMap.get(flexField) instanceof Number ? Long.valueOf(Long.parseLong(String.valueOf(flexMap.get(flexField)))) : flexMap.get(flexField);
            if ("2".equals(flexProperty.getValueType())) {
                DynamicObject loadSingleBosAssistantDataDetail = BusinessDataServiceHelper.loadSingleFromCache(pkValue, (String)"bos_assistantdata_detail", (String)"name,number");
                result.setName(flexProperty.getGLName() + ":" + ((OrmLocaleValue)loadSingleBosAssistantDataDetail.get("name")).getLocaleValue());
                result.setNumber(String.valueOf(loadSingleBosAssistantDataDetail.get(NUMBER)));
                resultList.add(result);
                continue;
            }
            if ("1".equals(flexProperty.getValueType())) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(pkValue, (String)flexProperty.getValueSource(), (String)"name,number");
                if (dynamicObject == null) continue;
                result.setName(((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue());
                result.setNumber(String.valueOf(dynamicObject.get(NUMBER)));
                resultList.add(result);
                continue;
            }
            if (!"3".equals(flexProperty.getValueType())) continue;
            result.setNumber(flexProperty.getNumber());
            result.setName(flexProperty.getGLName() + ":" + pkValue);
            resultList.add(result);
        }
        return resultList;
    }

    public static DataSetCacheMeta getAlgoMetadata(String cacheId) {
        return CachedQuery.doAlgoAction(cacheId, (sp, meta) -> meta);
    }

    public static String[][] getRawData(String entityId, String cacheId, int from, int to) {
        return CachedQuery.doAlgoAction(cacheId, (sp, meta) -> {
            int orgIdx;
            List rows = sp.getList(meta, from, to - from);
            int fields = meta.getRowMeta().getFieldCount();
            Map<Long, FieldControlRule> rules = CachedQuery.getFieldControlRules(entityId);
            String[][] data = new String[rows.size()][fields];
            String orgField = EntityMetadataCache.getDataEntityType((String)entityId).getMainOrg();
            if (!StringUtils.isEmpty((CharSequence)orgField) && (orgIdx = meta.getRowMeta().getFieldIndex(orgField, false)) == -1) {
                throw new KDException(new ErrorCode("###", ResManager.loadKDString((String)"\u6240\u9009\u5b57\u6bb5\u4e2d\uff0c\u5fc5\u987b\u5305\u62ec\u7ec4\u7ec7\u5b57\u6bb5  %s", (String)"CachedQuery_0", (String)"bos-mservice-form", (Object[])new Object[0])), new Object[]{orgField});
            }
            boolean hasControlRight = !StringUtils.isEmpty((CharSequence)orgField);
            for (int j = 0; j < fields; ++j) {
                String field = meta.getRowMeta().getFieldName(j);
                for (int i = 0; i < rows.size(); ++i) {
                    Long orgId = 0L;
                    if (hasControlRight) {
                        orgId = ((Row)rows.get(i)).getLong(orgField);
                    }
                    data[i][j] = hasControlRight && !CachedQuery.canReadField(rules, orgId, field) ? MASK_STRING : ((Row)rows.get(i)).getString(j);
                    MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityId);
                    Map metFields = met.getAllFields();
                    for (IDataEntityProperty property : met.getProperties()) {
                        metFields.put(property.getName(), property);
                    }
                    String fieldKey = field;
                    String[] keys = field.split("\\.");
                    if (keys.length > 1) {
                        fieldKey = keys[1];
                    }
                    data[i][j] = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)entityId, (String)fieldKey, (String)Lang.get().toString(), (String)"api", null, (Object)data[i][j]);
                }
            }
            return data;
        });
    }

    public static List<LinkedHashMap<String, Object>> getRawDataJson(String entityId, String cacheId, int from, int to) {
        return CachedQuery.doAlgoAction(cacheId, (sp, meta) -> {
            List rows = sp.getList(meta, from, to - from);
            Field[] fields = meta.getRowMeta().getFields();
            ArrayList<String> fieldnames = new ArrayList<String>(10);
            for (Field field : fields) {
                fieldnames.add(field.getName());
            }
            int fieldLength = fields.length;
            ArrayList<LinkedHashMap<String, Object>> data = new ArrayList<LinkedHashMap<String, Object>>(10);
            MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityId);
            Map metFields = met.getAllFields();
            for (IDataEntityProperty property : met.getProperties()) {
                metFields.put(property.getName(), property);
            }
            HashMap flexBills = new HashMap();
            for (int i = 0; i < rows.size(); ++i) {
                LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
                data.add(item);
                for (int j = 0; j < fieldLength; ++j) {
                    Object pkValue;
                    String pkKey;
                    Object value = ((Row)rows.get(i)).get(j);
                    if (value instanceof Long) {
                        value = value.toString();
                    }
                    Field algofield = fields[j];
                    String algofieldKey = algofield.getName();
                    item.put(algofieldKey, value);
                    String entryKey = met.getPrimaryKey().getName();
                    String fieldKey = algofieldKey;
                    String[] keys = algofield.getName().split("\\.");
                    if (keys.length > 1) {
                        entryKey = keys[0];
                        fieldKey = keys[1];
                    }
                    IDataEntityProperty fieldProperty = (IDataEntityProperty)metFields.get(fieldKey);
                    if ("true".equals(System.getProperty("api.Privacy", "true"))) {
                        Object api = PrivacyCenterServiceHelper.getDesensitizeValue((String)entityId, (String)fieldKey, (String)Lang.get().toString(), (String)"api", null, (Object)value);
                        item.put(algofieldKey, api);
                    }
                    String api_FlexAssgrp = System.getProperty("api.FlexAssgrp");
                    if (fieldProperty instanceof FlexProp && "1".equals(api_FlexAssgrp) && Long.parseLong(String.valueOf(value)) > 0L) {
                        DynamicObject currentFlexRow;
                        pkKey = met.getPrimaryKey().getName();
                        if (!fieldnames.contains(pkKey)) {
                            throw new KDException(new ErrorCode("###", "select parm need contains field: %s"), new Object[]{pkKey});
                        }
                        pkValue = ((Row)rows.get(i)).get(pkKey);
                        String entrypkKey = ((EntityType)met.getAllEntities().get(entryKey)).getPrimaryKey().getName();
                        String entryfullpkKey = entryKey.concat(".").concat(entrypkKey);
                        if (!fieldnames.contains(entryfullpkKey)) {
                            throw new KDException(new ErrorCode("###", "select parm need contains field: %s"), new Object[]{entryfullpkKey});
                        }
                        Object entrypkValue = ((Row)rows.get(i)).get(entryfullpkKey);
                        if (!flexBills.containsKey(pkValue)) {
                            DynamicObject billData = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)entityId, (String)fieldKey);
                            DynamicObjectCollection entryFlexRows = (DynamicObjectCollection)billData.get(entryKey);
                            HashMap<Object, DynamicObject> rowItems = new HashMap<Object, DynamicObject>();
                            for (DynamicObject entryFlexRow : entryFlexRows) {
                                rowItems.put(entryFlexRow.getPkValue(), entryFlexRow);
                            }
                            flexBills.put(pkValue, rowItems);
                        }
                        if ((currentFlexRow = (DynamicObject)((Map)flexBills.get(pkValue)).get(entrypkValue)).get(fieldKey) == null) continue;
                        int flexTypeId = ((FlexProp)fieldProperty).getFlexTypeId();
                        List flexProperties = FlexEntityMetaUtils.getFlexProperties((int)flexTypeId);
                        Map<String, Object> append_data = CachedQuery.getFlexKeyValue(flexProperties, (DynamicObject)currentFlexRow.get(fieldKey));
                        item.put(fields[j].getName().concat("_data"), append_data);
                        continue;
                    }
                    if (!(fieldProperty instanceof MulBasedataProp) || Long.parseLong(String.valueOf(value)) <= 0L) continue;
                    pkKey = met.getPrimaryKey().getName();
                    if (!fieldnames.contains(pkKey)) {
                        throw new KDException(new ErrorCode("###", "select parm need contains field: %s"), new Object[]{pkKey});
                    }
                    pkValue = ((Row)rows.get(i)).get(pkKey);
                    DynamicObject dynamicObject = BusinessDataApiServiceHelper.loadSingleFromCache((Object)pkValue, (String)entityId, (String)fieldKey);
                    if (fieldProperty.getParent() instanceof MainEntityType) {
                        CachedQuery.appendMulBasedata(fieldProperty, item, dynamicObject, algofield);
                        continue;
                    }
                    if (!(fieldProperty.getParent() instanceof EntryType) || fieldProperty.getParent() instanceof SubEntryType) continue;
                    String entrypkKey = ((EntityType)met.getAllEntities().get(entryKey)).getPrimaryKey().getName();
                    String entryfullpkKey = entryKey.concat(".").concat(entrypkKey);
                    if (!fieldnames.contains(entryfullpkKey)) {
                        throw new KDException(new ErrorCode("###", "select parm need contains field: %s"), new Object[]{entryfullpkKey});
                    }
                    Object entrypkValue = ((Row)rows.get(i)).get(entryfullpkKey);
                    DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryKey);
                    for (DynamicObject object : dynamicObjectCollection) {
                        if (!object.getPkValue().equals(entrypkValue)) continue;
                        CachedQuery.appendMulBasedata(fieldProperty, item, object, algofield);
                    }
                }
            }
            return data;
        });
    }

    private static void appendMulBasedata(IDataEntityProperty fieldProperty, LinkedHashMap<String, Object> targetItem, DynamicObject sourceObject, Field algoField) {
        ArrayList objs = new ArrayList();
        DynamicObjectCollection items = (DynamicObjectCollection)sourceObject.get(fieldProperty.getName());
        for (DynamicObject iteme : items) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            objs.add(temp);
            DynamicObject fbasedataid = (DynamicObject)iteme.get("fbasedataid");
            temp.put("name", fbasedataid.get("name").toString());
            temp.put(NUMBER, fbasedataid.get(NUMBER));
        }
        targetItem.put(algoField.getName().concat("_data"), objs);
    }

    private static Map<String, Object> getFlexKeyValue(List<FlexProperty> flexProperties, DynamicObject flexData) {
        HashMap<String, Object> resultList = new HashMap<String, Object>();
        String flexValue = (String)flexData.get("value");
        if (flexValue.contains("\\")) {
            flexValue = flexValue.replace("\\", "");
        }
        Map flexMap = (Map)JSON.parseObject((String)flexValue, Map.class);
        Set fkeySet = flexMap.keySet();
        for (FlexProperty flexProperty : flexProperties) {
            String flexField = flexProperty.getFlexField();
            if (!fkeySet.contains(flexField)) continue;
            HashMap<String, String> temp = new HashMap<String, String>();
            Object pkValue = flexMap.get(flexField) instanceof Long ? Long.valueOf(Long.parseLong(String.valueOf(flexMap.get(flexField)))) : flexMap.get(flexField);
            if ("2".equals(flexProperty.getValueType())) {
                DynamicObject loadSingleBosAssistantDataDetail = BusinessDataApiServiceHelper.loadSingleFromCache(pkValue, (String)"bos_assistantdata_detail", (String)"name,number");
                temp.put(NUMBER, String.valueOf(loadSingleBosAssistantDataDetail.get(NUMBER)));
                temp.put("name", flexProperty.getGLName() + ":" + ((OrmLocaleValue)loadSingleBosAssistantDataDetail.get("name")).getLocaleValue());
                resultList.put(flexProperty.getName().toString(), temp);
                continue;
            }
            if ("1".equals(flexProperty.getValueType())) {
                DynamicObject dynamicObject = BusinessDataApiServiceHelper.loadSingleFromCache(pkValue, (String)flexProperty.getValueSource(), (String)"name,number");
                if (dynamicObject == null) continue;
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)flexProperty.getValueSource());
                Set fieldSet = type.getAllFields().keySet();
                if (!fieldSet.contains(NUMBER)) {
                    String numberProperty = ((BasedataEntityType)type).getNumberProperty();
                    temp.put(numberProperty, String.valueOf(dynamicObject.get(numberProperty)));
                } else {
                    temp.put(NUMBER, String.valueOf(dynamicObject.get(NUMBER)));
                }
                if (!fieldSet.contains("name")) {
                    String nameProperty = ((BasedataEntityType)type).getNameProperty();
                    temp.put(nameProperty, String.valueOf(dynamicObject.get(nameProperty)));
                } else {
                    temp.put("name", ((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue());
                }
                resultList.put(flexProperty.getName().toString(), temp);
                continue;
            }
            if (!"3".equals(flexProperty.getValueType())) continue;
            temp.put(NUMBER, flexProperty.getNumber());
            temp.put("name", flexProperty.getGLName() + ":" + pkValue);
            resultList.put(flexProperty.getName().toString(), temp);
        }
        return resultList;
    }

    private static Map<Long, FieldControlRule> getFieldControlRules(String entityId) {
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.getAllFieldControlRule(userId.longValue(), entityId);
    }

    private static boolean canReadField(Map<Long, FieldControlRule> rules, Long orgId, String field) {
        Set canNotReadFields;
        return rules == null || !rules.containsKey(orgId) || (canNotReadFields = rules.get(orgId).getCanNotReadFields()) == null || !canNotReadFields.contains(field);
    }

    private static <T> T doAlgoAction(String cacheId, AlgoAction<T> action) {
        DataSetCacheSpi sp = DataSetCacheSpiFactory.getSpi();
        DataSetCacheMeta meta = sp.getMeta(cacheId);
        return action.execute(sp, meta);
    }

    public static void release(String cacheId) {
        CachedQuery.doAlgoAction(cacheId, (sp, meta) -> {
            sp.delete(meta);
            return null;
        });
    }

    private static List<String> getAllEntryNames(String entityId) {
        ArrayList<String> fieldList = new ArrayList<String>();
        Map allEntities = EntityMetadataCache.getDataEntityType((String)entityId).getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            String fieldName = (String)entry.getKey();
            EntityType entityType = (EntityType)entry.getValue();
            if (!(entityType instanceof EntryType)) continue;
            fieldList.add(fieldName);
        }
        return fieldList;
    }

    static interface AlgoAction<T> {
        public T execute(DataSetCacheSpi var1, DataSetCacheMeta var2);
    }
}

