/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mservice.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Field;
import kd.bos.algo.dataset.cache.DataSetCacheMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.FmtInfoUtils;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.flex.FlexService;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.list.query.PageRowCacheUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.query.CachedQuery;
import kd.bos.mservice.query.QueryResult;
import kd.bos.mservice.query.QueryService;
import kd.bos.mservice.svc.attach.IAttachmentModelProxy;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.service.InteTimeZone;
import kd.bos.service.ServiceFactory;
import kd.bos.service.webapi.WebApiHelper;
import kd.bos.service.webapi.query.g.FilterVisitor;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class QueryServiceImpl
implements QueryService {
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";
    private static Log log = LogFactory.getLog(QueryServiceImpl.class);
    private static final String JSONFMT = "{\"name\":\"%s\",\"caption\":\"%s\",\"type\":\"%s\"}";

    public String startQuery(String entityNumber, String selectFields, List<String> filters, String orderBys, int pageSize) {
        List lstfilter = filters.stream().map(str -> QFilter.of((String)str, (Object[])new Object[0])).collect(Collectors.toList());
        int len = lstfilter.size();
        QFilter[] qfilters = new QFilter[len];
        qfilters = Arrays.copyOf(qfilters, len);
        return CachedQuery.beginQuery(entityNumber, selectFields, qfilters, orderBys, pageSize).getCacheId();
    }

    public QueryResult startWebApiQueryByParams(String entityId, String selectFields, String qFilterExpress, String orderBys, int pageSize, List<Object> params, boolean expressNullFlag) throws KDException {
        selectFields = WebApiHelper.preQuerySelectFields(entityId, selectFields);
        Object[] array = null;
        if (!expressNullFlag) {
            array = params.toArray(new Object[params.size()]);
        }
        QFilter[] qfilters = new QFilter[]{QFilter.of((String)qFilterExpress, (Object[])array)};
        return this.dealQuery(entityId, selectFields, qfilters, orderBys, pageSize);
    }

    public QueryResult startWebApiQuery(String entityId, String selectFields, String filters, String orderBys, int pageSize) {
        selectFields = WebApiHelper.preQuerySelectFields(entityId, selectFields);
        QFilter[] qfilters = null;
        MainEntityType met = MetadataServiceHelper.getDataEntityType((String)entityId);
        if (!StringUtils.isEmpty((CharSequence)filters)) {
            FilterVisitor.mainEntityType.set(met);
            String exp = filters.trim();
            log.info("FilterVisitor in exp:".concat(exp));
            QFilter flt = FilterVisitor.Parse(exp);
            log.info("FilterVisitor out flt:".concat(flt == null ? "" : flt.toString()));
            qfilters = new QFilter[]{flt};
        }
        return this.dealQuery(entityId, selectFields, qfilters, orderBys, pageSize);
    }

    private QueryResult dealQuery(String entityId, String selectFields, QFilter[] qfilters, String orderBys, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)selectFields) || StringUtils.contains((CharSequence)selectFields, (CharSequence)"*")) {
            throw new KDException(new ErrorCode("select statement error", ResManager.loadKDString((String)"select\u5b50\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u8005\u542b\u6709*\u901a\u914d\u7b26", (String)"QueryServiceImpl_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[0]);
        }
        QueryResult ret = null;
        kd.bos.query.QueryResult result = CachedQuery.beginQuery(entityId, selectFields, qfilters, orderBys, pageSize);
        ret = new QueryResult();
        ret.setCacheId(result.getCacheId());
        ret.setMessage(result.getMessage());
        ret.setSuccess(result.getSuccess());
        ret.setRows(result.getRows());
        return ret;
    }

    public Object startWebApiDetailQuery(String entityId, String selectFields, String filters, String orderBys) {
        QFilter[] qfilters = null;
        if (!StringUtils.isEmpty((CharSequence)filters)) {
            qfilters = new QFilter[]{FilterVisitor.Parse(filters.trim())};
        }
        if (StringUtils.isEmpty((CharSequence)selectFields) || StringUtils.contains((CharSequence)selectFields, (CharSequence)"*")) {
            throw new KDException(new ErrorCode("select statement error", ResManager.loadKDString((String)"select\u5b50\u53e5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u6216\u8005\u542b\u6709*\u901a\u914d\u7b26", (String)"QueryServiceImpl_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[0]);
        }
        return CachedQuery.beginDetailQuery(entityId, selectFields, qfilters, orderBys);
    }

    public String getQuerySegment(String entityId, String cacheId, int from, int to) {
        String[][] rows = CachedQuery.getRawData(entityId, cacheId, from, to);
        return SerializationUtils.toJsonString((Object)rows);
    }

    public String getQuerySegmentJson(String entityId, String cacheId, int from, int to) {
        List<LinkedHashMap<String, Object>> data = CachedQuery.getRawDataJson(entityId, cacheId, from, to);
        return SerializationUtils.toJsonString(data);
    }

    public DynamicObject getDynamicObject() {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"openapi_apilist", null, (String)"id", (int)1);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"openapi_apilist");
        return dynamicObject;
    }

    public DynamicObject[] getDynamicObjects() {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"openapi_apilist", null, (String)"id", (int)2);
        MainEntityType objectType = EntityMetadataCache.getDataEntityType((String)"openapi_apilist");
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)objectType);
        return objects;
    }

    public void release(String cacheId) {
        CachedQuery.release(cacheId);
    }

    public String[] getFieldNamesOnDetailQuery(String entityId, String select) {
        MainEntityType et = EntityMetadataCache.getDataEntityType((String)entityId);
        String[] split = select.split(",");
        String[] ret = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String name = split[i].toLowerCase();
            try {
                DynamicProperty dp = this.getProp((EntityType)et, name);
                String dispName = "";
                if (dp.getDisplayName() != null) {
                    dispName = dp.getDisplayName().getLocaleValue();
                }
                String type = "";
                type = dp instanceof BasedataProp ? ((BasedataProp)dp).getRefIdProp().getPropertyType().getSimpleName() : dp.getPropertyType().getSimpleName();
                ret[i] = String.format(JSONFMT, name, dispName, type);
                continue;
            }
            catch (Exception ex) {
                throw new KDException(new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0d\u5b58\u5728\u5b57\u6bb5%2$s", (String)"QueryServiceImpl_1", (String)"bos-open-service", (Object[])new Object[0]), et.getName(), name)), new Object[]{ex});
            }
        }
        return ret;
    }

    public String[] getFieldNames(String entityId, String cacheId) {
        DataSetCacheMeta meta = CachedQuery.getAlgoMetadata(cacheId);
        MainEntityType et = EntityMetadataCache.getDataEntityType((String)entityId);
        Field[] flds = meta.getRowMeta().getFields();
        String[] ret = new String[flds.length];
        for (int i = 0; i < ret.length; ++i) {
            String name = flds[i].getName().toLowerCase();
            try {
                DynamicProperty dp = this.getProp((EntityType)et, name);
                String dispName = "";
                if (dp.getDisplayName() != null) {
                    dispName = dp.getDisplayName().getLocaleValue();
                }
                String type = "";
                type = dp instanceof BasedataProp ? ((BasedataProp)dp).getRefIdProp().getPropertyType().getSimpleName() : dp.getPropertyType().getSimpleName();
                ret[i] = String.format(JSONFMT, name, dispName, type);
                continue;
            }
            catch (Exception ex) {
                throw new KDException(new ErrorCode("###", String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%1$s\u4e0d\u5b58\u5728\u5b57\u6bb5%2$s", (String)"QueryServiceImpl_1", (String)"bos-open-service", (Object[])new Object[0]), et.getName(), name)), new Object[]{ex});
            }
        }
        return ret;
    }

    private DynamicProperty getProp(EntityType et, String name) {
        int dotCount = this.getStringDot(name);
        int pos = name.indexOf(".");
        if (pos <= 0) {
            return (DynamicProperty)et.findProperty(name);
        }
        String propName = "";
        String parentPropName = "";
        propName = name.substring(pos + 1);
        parentPropName = name.substring(0, pos);
        IDataEntityProperty p = et.findProperty(parentPropName);
        if (p instanceof BasedataProp) {
            if (dotCount > 2) {
                throw new KDException(String.format(ResManager.loadKDString((String)"\u5c5e\u6027\u540d%s\u8d85\u8fc7\u4e09\u7ea7", (String)"QueryServiceImpl_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), name));
            }
            EntityType et2 = (EntityType)((BasedataProp)p).getDynamicComplexPropertyType();
            return this.getProp(et2, propName);
        }
        if (p instanceof EntryProp) {
            p = et.findProperty(name);
            if (p == null) {
                EntityType et3 = (EntityType)((EntryProp)et.findProperty(parentPropName)).getDynamicCollectionItemPropertyType();
                return this.getProp(et3, propName);
            }
            return (DynamicProperty)p;
        }
        if (p instanceof MulBasedataProp) {
            return (DynamicProperty)et.findProperty(parentPropName);
        }
        throw new KDException(new ErrorCode("###", ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5c5e\u6027\u7c7b\u578b%s", (String)"QueryServiceImpl_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[]{p.getClass().getName()});
    }

    private int getStringDot(String prop) {
        String destStr = prop.replaceAll("\\.", "");
        return prop.length() - destStr.length();
    }

    public String getExportData(String exportId, String entityNumber, String selectFields, int pageIndex, int pagesize) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String appId = mainEntityType.getAppId();
        log.error(String.format("exportbytemplate--get--appid=%s----exportId=%s----", appId, exportId));
        Map parameters = (Map)AppCache.get((String)appId).get(exportId, Map.class);
        QFilter filter = null;
        QFilter[] filters = null;
        List allPkIds = (List)parameters.get("PKIDs");
        boolean hasNextPage = false;
        int start = pageIndex * pagesize;
        int end = (pageIndex + 1) * pagesize;
        if (allPkIds != null && !allPkIds.isEmpty() && start >= 0 && start < allPkIds.size()) {
            hasNextPage = (end = Math.min(end, allPkIds.size())) < allPkIds.size();
            filter = new QFilter((String)parameters.get("PKNAME"), "in", allPkIds.subList(start, end));
        }
        if (filter == null) {
            filter = new QFilter((String)parameters.get("PKNAME"), "in", (Object)new Object[0]);
        }
        filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            selectFields = "*";
        } else {
            HashSet<String> appendControlProps = new HashSet<String>();
            List<String> fieldKeyArr = Arrays.asList(selectFields.split(","));
            Map allfields = mainEntityType.getAllFields();
            for (String fieldKey : fieldKeyArr) {
                String controlPropName;
                IDataEntityProperty prop = (IDataEntityProperty)allfields.get(fieldKey);
                if (!(prop instanceof DecimalProp) || !StringUtils.isNotBlank((CharSequence)(controlPropName = ((DecimalProp)prop).getControlPropName())) || fieldKeyArr.contains(controlPropName) || !appendControlProps.add(controlPropName)) continue;
                selectFields = selectFields + "," + controlPropName;
            }
            String mainOrgKey = mainEntityType.getMainOrg();
            if (StringUtils.isNotBlank((CharSequence)mainOrgKey) && !fieldKeyArr.contains(mainOrgKey)) {
                selectFields = mainOrgKey + "," + selectFields;
            }
        }
        String orderBys = (String)parameters.get("orderBys");
        String pageId = (String)parameters.get("pageId");
        IFormView view = SessionManager.getCurrent().getView(pageId);
        if (view instanceof ListView) {
            ListViewPluginProxy proxy = (ListViewPluginProxy)view.getService(FormViewPluginProxy.class);
            BeforeQueryOfExportEvent e = new BeforeQueryOfExportEvent((Object)view, selectFields, orderBys, filters);
            proxy.fireBeforeQueryOfExport(e);
            selectFields = e.getSelectFields();
            orderBys = e.getOrderBys();
            filters = e.getFilters();
        }
        selectFields = StringUtils.isBlank((CharSequence)selectFields) ? "*" : selectFields;
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields, (QFilter[])filters, (String)orderBys);
        LinkedList<DynamicObject> allListValue = new LinkedList<DynamicObject>();
        if (view instanceof ListView) {
            ListViewPluginProxy proxy = (ListViewPluginProxy)view.getService(FormViewPluginProxy.class);
            int fromIndex = 0;
            while (fromIndex < arr.length) {
                int toIndex = fromIndex + 1000 < arr.length ? fromIndex + 1000 : arr.length;
                DynamicObject[] subArray = Arrays.copyOfRange(arr, fromIndex, toIndex);
                fromIndex = toIndex;
                AfterQueryOfExportEvent e = new AfterQueryOfExportEvent((Object)view, subArray);
                proxy.fireAfterQueryOfExport(e);
                allListValue.addAll(Arrays.asList(e.getQueryValues()));
            }
        }
        arr = allListValue.toArray(arr);
        String json = SerializationUtils.toJsonString((Object)arr);
        JSONArray jsonArr = JSONArray.parseArray((String)json);
        ArrayList<Object> pkIds = new ArrayList<Object>();
        if (arr.length > 0) {
            BillEntityType entityType = (BillEntityType)arr[0].getDataEntityType();
            ArrayList<DynamicObject> lstMainOrg = new ArrayList<DynamicObject>();
            for (DynamicObject obj : arr) {
                pkIds.add(obj.getPkValue());
                MainOrgProp mainOrgProp = entityType.getMainOrgProperty();
                lstMainOrg.add(mainOrgProp == null ? null : (DynamicObject)mainOrgProp.getValueFast((Object)obj));
            }
            for (int i = 0; i < jsonArr.size(); ++i) {
                DynamicObject mainOrg = (DynamicObject)lstMainOrg.get(i);
                this.handleData(jsonArr.getJSONObject(i), (DynamicObjectType)entityType, mainOrg);
            }
            DynamicObjectCollection coll = new DynamicObjectCollection((DynamicObjectType)entityType, null, Arrays.asList(arr));
            boolean isApplyMaterialPrecision = FmtInfoUtils.applyMaterialPrecision();
            this.formatData(coll, entityType, jsonArr, isApplyMaterialPrecision);
        }
        HashMap<String, Object> retData = new HashMap<String, Object>();
        retData.put("data", jsonArr);
        retData.put("hasNextPage", hasNextPage);
        if (allPkIds != null && allPkIds.size() < 20) {
            IAttachmentModelProxy attachmentModel = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
            Set attachPkIds = attachmentModel.filterExistAttachmentByExport(entityNumber, new HashSet(pkIds));
            pkIds.replaceAll(pk -> attachPkIds.contains(pk) ? pk : null);
            retData.put("attachPkIds", pkIds);
        }
        return SerializationUtils.toJsonString(retData);
    }

    private void handleData(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            Object obj;
            if (prop instanceof DateTimeProp) {
                obj = jsonObject.get((Object)prop.getName());
                if (!StringUtils.isNotBlank((Object)obj)) continue;
                try {
                    Date datetime = InteTimeZone.getSysTimeZone().parse((String)obj);
                    if (prop instanceof DateProp) {
                        obj = ((DateProp)prop).getDateFormat().format(datetime);
                    } else {
                        InteTimeZone zone = ((DateTimeProp)prop).getTimeZone(Long.valueOf(mainOrg != null ? (Long)mainOrg.getPkValue() : 0L));
                        obj = zone.format(datetime);
                    }
                    jsonObject.put(prop.getName(), obj);
                }
                catch (ParseException e) {
                    log.error((Throwable)e);
                }
                continue;
            }
            if (prop instanceof AdminDivisionProp) {
                obj = jsonObject.get((Object)prop.getName());
                if (!StringUtils.isNotBlank((Object)obj)) continue;
                Object fullname = ORMUtil.getAdminDivisionFullName((String)obj.toString());
                jsonObject.put(prop.getName(), StringUtils.isNotBlank((Object)fullname) ? fullname.toString().replace('_', '/') : null);
                continue;
            }
            if (prop instanceof FlexProp) {
                this.handleFlexField(jsonObject, entityType, mainOrg, (FlexProp)prop);
                continue;
            }
            if (prop instanceof BasedataProp) {
                this.handleBaseDataField(jsonObject, entityType, mainOrg, (BasedataProp)prop);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            JSONArray coll = jsonObject.getJSONArray(prop.getName());
            for (int i = 0; i < coll.size(); ++i) {
                JSONObject entryDataEntity = coll.getJSONObject(i);
                this.handleData(entryDataEntity, ((EntryProp)prop).getDynamicCollectionItemPropertyType(), mainOrg);
            }
        }
    }

    private void handleBaseDataField(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg, BasedataProp bdProp) {
        BasedataEntityType bdType = (BasedataEntityType)bdProp.getComplexType();
        if (bdType == null) {
            return;
        }
        if (bdType.getMasteridType() == 2) {
            MasterBasedataProp masterIdProp = (MasterBasedataProp)bdType.findProperty(bdType.getMasteridPropName());
            if (masterIdProp == null || masterIdProp.getComplexType() == null) {
                return;
            }
            BasedataEntityType refMasterType = (BasedataEntityType)masterIdProp.getComplexType();
            Map bdObj = (Map)jsonObject.get((Object)bdProp.getName());
            if (bdObj == null || !bdObj.containsKey(masterIdProp.getName())) {
                return;
            }
            Map refMasterObj = (Map)bdObj.get(masterIdProp.getName());
            if (refMasterObj == null) {
                return;
            }
            if (refMasterObj.containsKey(refMasterType.getNameProperty())) {
                String nameKey = StringUtils.isBlank((CharSequence)bdType.getNameProperty()) ? "name" : bdType.getNameProperty();
                bdObj.put(nameKey, refMasterObj.get(refMasterType.getNameProperty()));
            }
            if (refMasterObj.containsKey(refMasterType.getNumberProperty())) {
                String numberKey = StringUtils.isBlank((CharSequence)bdType.getNumberProperty()) ? "number" : bdType.getNumberProperty();
                bdObj.put(numberKey, refMasterObj.get(refMasterType.getNumberProperty()));
            }
        }
    }

    private void handleFlexField(JSONObject jsonObject, DynamicObjectType entityType, DynamicObject mainOrg, FlexProp flexProp) {
        DynamicProperty refProp = entityType.getProperty(flexProp.getBasePropertyKey());
        JSONObject flexVal = jsonObject.getJSONObject(flexProp.getName());
        JSONObject refVal = jsonObject.getJSONObject(refProp.getName());
        if (flexVal != null && refVal != null) {
            Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexVal.getString("value"), Map.class);
            BasedataProp baseProp = (BasedataProp)refProp;
            RefEntityType bdType = (RefEntityType)baseProp.getComplexType();
            Object relateBDPk = refVal.get((Object)"id");
            String relateBDEntityNumber = bdType.getName();
            String relateBDFlexPropertyKey = bdType.getFlexProperty();
            if (StringUtils.isBlank((CharSequence)bdType.getFlexProperty()) && bdType.getMasteridType() != 0) {
                BasedataProp masterProp = (BasedataProp)bdType.getProperty(bdType.getMasteridPropName());
                relateBDFlexPropertyKey = ((BasedataEntityType)masterProp.getComplexType()).getFlexProperty();
                relateBDEntityNumber = masterProp.getBaseEntityId();
                Map refMasterVal = (Map)refVal.get((Object)bdType.getMasteridPropName());
                if (refMasterVal != null) {
                    relateBDPk = refMasterVal.get("id");
                }
            }
            BasedataEntityType baseEntityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)baseProp.getBaseEntityId());
            List flexPropertyIds = FlexService.getBaseUseFlexProperties((String)relateBDEntityNumber, (Object)relateBDPk, (String)relateBDFlexPropertyKey);
            FlexEntityType flexEntityType = FlexEntityMetaUtils.getBasedataPropFlexEntityType((String)entityType.getName(), (String)flexProp.getName(), (int)flexProp.getFlexTypeId(), (List)flexPropertyIds);
            HashMap flexValMap = new HashMap();
            for (IDataEntityProperty flexObjectProp : flexEntityType.getProperties()) {
                String name = flexObjectProp.getName();
                String[] nameSplit = name.split("__");
                if (nameSplit.length <= 1) continue;
                try {
                    Object baseValue = valueMap.get(nameSplit[1]);
                    if (baseValue != null && flexObjectProp instanceof BasedataProp) {
                        if (baseValue instanceof Integer) {
                            baseValue = ((Integer)baseValue).longValue();
                        }
                        DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache(baseValue, (String)((BasedataProp)flexObjectProp).getBaseEntityId());
                        String flexValKey = ((BasedataProp)flexObjectProp).getDisplayName().toString();
                        HashMap<String, Object> flexPropValMap = new HashMap<String, Object>();
                        Object caption = basedata.get(((BasedataProp)flexObjectProp).getDisplayProp());
                        flexPropValMap.put("name", caption == null ? "" : caption.toString());
                        flexPropValMap.put("number", basedata.get(((BasedataProp)flexObjectProp).getNumberProp()));
                        flexValMap.put(flexValKey, flexPropValMap);
                        continue;
                    }
                    if (baseValue == null || !(flexObjectProp instanceof TextProp)) continue;
                    String flexValKey = ((TextProp)flexObjectProp).getDisplayName().toString();
                    flexValMap.put(flexValKey, baseValue);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
            jsonObject.put(flexProp.getName(), flexValMap);
        }
    }

    private void formatData(DynamicObjectCollection coll, BillEntityType entityType, JSONArray jsonArr, boolean isApplyMaterialPrecision) {
        IDataEntityProperty controlProp;
        HashMap<String, List<FmtField>> fmtMapping = new HashMap<String, List<FmtField>>();
        Map allFields = entityType.getAllFields();
        for (IDataEntityProperty iDataEntityProperty : allFields.values()) {
            if (iDataEntityProperty instanceof BigIntProp || iDataEntityProperty.getParent() instanceof LinkEntryType || !(iDataEntityProperty instanceof DecimalProp)) continue;
            String controlPropName = ((DecimalProp)iDataEntityProperty).getControlPropName();
            if (StringUtils.isBlank((CharSequence)controlPropName)) {
                this.addNoFmtMapping(fmtMapping, iDataEntityProperty);
                continue;
            }
            controlProp = (IDataEntityProperty)allFields.get(controlPropName);
            if (controlProp == null) {
                this.addNoFmtMapping(fmtMapping, iDataEntityProperty);
                continue;
            }
            String controlParentKey = controlProp.getParent().getName();
            ArrayList<FmtField> fmtFields = (ArrayList<FmtField>)fmtMapping.get(controlParentKey);
            if (fmtFields == null) {
                fmtFields = new ArrayList<FmtField>();
                fmtMapping.put(controlParentKey, fmtFields);
            }
            FmtField fmtField = new FmtField(iDataEntityProperty, iDataEntityProperty.getName(), controlPropName);
            fmtFields.add(fmtField);
        }
        for (Map.Entry entry : fmtMapping.entrySet()) {
            DynamicObject dataRow;
            int entrysize;
            JSONArray dataRowsJSON;
            DynamicObjectCollection dataRows;
            NumberPrecision numberPrecision;
            DynamicObject subDataRow;
            int k;
            int subsize;
            NumberFormatProvider numberFormat;
            JSONObject dataObj;
            DynamicObject obj;
            int i;
            int size;
            List fmtFields = (List)entry.getValue();
            if (fmtFields == null || fmtFields.isEmpty()) continue;
            controlProp = (IDataEntityProperty)allFields.get(((FmtField)fmtFields.get(0)).getControlFieldName());
            if (controlProp == null || controlProp.getParent() instanceof BillEntityType) {
                size = coll.size();
                for (i = 0; i < size; ++i) {
                    obj = (DynamicObject)coll.get(i);
                    dataObj = jsonArr.getJSONObject(i);
                    for (FmtField fmt : fmtFields) {
                        IDataEntityType parentType = fmt.getFieldProp().getParent();
                        if (parentType instanceof SubEntryType) {
                            DynamicObjectCollection dataRows2 = obj.getDynamicObjectCollection(parentType.getParent().getName());
                            JSONArray dataRowsJSON2 = dataObj.getJSONArray(parentType.getParent().getName());
                            int entrysize2 = dataRows2.size();
                            for (int j = 0; j < entrysize2; ++j) {
                                DynamicObject dataRow2 = (DynamicObject)dataRows2.get(j);
                                JSONObject dataRowJSON = dataRowsJSON2.getJSONObject(j);
                                DynamicObjectCollection subDataRows = dataRow2.getDynamicObjectCollection(parentType.getName());
                                JSONArray subDataRowsJSON = dataRowJSON.getJSONArray(parentType.getName());
                                numberFormat = new NumberFormatProvider(fmtFields, subDataRows, obj, 0, isApplyMaterialPrecision);
                                subsize = subDataRows.size();
                                for (k = 0; k < subsize; ++k) {
                                    subDataRow = (DynamicObject)subDataRows.get(k);
                                    numberPrecision = numberFormat.getFormatPrecision(fmt.getFieldName(), subDataRow, obj);
                                    if (numberPrecision != null) {
                                        numberPrecision.setGroupingUsed(false);
                                        subDataRowsJSON.getJSONObject(k).put(fmt.getFieldName(), (Object)numberPrecision);
                                        continue;
                                    }
                                    subDataRowsJSON.getJSONObject(k).remove((Object)fmt.getFieldName());
                                }
                            }
                            continue;
                        }
                        if (parentType instanceof EntryType) {
                            DynamicObjectCollection dataRows2 = obj.getDynamicObjectCollection(parentType.getName());
                            JSONArray dataRowsJSON2 = dataObj.getJSONArray(parentType.getName());
                            NumberFormatProvider numberFormat2 = new NumberFormatProvider(fmtFields, dataRows2, obj, 0, isApplyMaterialPrecision);
                            int entrysize3 = dataRows2.size();
                            for (int j = 0; j < entrysize3; ++j) {
                                DynamicObject dataRow3 = (DynamicObject)dataRows2.get(j);
                                JSONObject dataRowJSON = dataRowsJSON2.getJSONObject(j);
                                NumberPrecision numberPrecision2 = numberFormat2.getFormatPrecision(fmt.getFieldName(), dataRow3, obj);
                                if (numberPrecision2 != null) {
                                    numberPrecision2.setGroupingUsed(false);
                                    dataRowsJSON2.getJSONObject(j).put(fmt.getFieldName(), (Object)numberPrecision2);
                                    continue;
                                }
                                dataRowsJSON2.getJSONObject(j).remove((Object)fmt.getFieldName());
                            }
                            continue;
                        }
                        if (!(parentType instanceof BillEntityType)) continue;
                        NumberFormatProvider numberFormat3 = new NumberFormatProvider(fmtFields, coll, null, 0, isApplyMaterialPrecision);
                        NumberPrecision numberPrecision3 = numberFormat3.getFormatPrecision(fmt.getFieldName(), obj, obj);
                        if (numberPrecision3 != null) {
                            numberPrecision3.setGroupingUsed(false);
                            dataObj.put(fmt.getFieldName(), (Object)numberPrecision3);
                            continue;
                        }
                        dataObj.remove((Object)fmt.getFieldName());
                    }
                }
                continue;
            }
            if (controlProp.getParent() instanceof SubEntryType) {
                size = coll.size();
                for (i = 0; i < size; ++i) {
                    obj = (DynamicObject)coll.get(i);
                    dataObj = jsonArr.getJSONObject(i);
                    dataRows = obj.getDynamicObjectCollection(controlProp.getParent().getParent().getName());
                    dataRowsJSON = dataObj.getJSONArray(controlProp.getParent().getParent().getName());
                    entrysize = dataRows.size();
                    for (int j = 0; j < entrysize; ++j) {
                        dataRow = (DynamicObject)dataRows.get(j);
                        JSONObject dataRowJSON = dataRowsJSON.getJSONObject(j);
                        DynamicObjectCollection subDataRows = dataRow.getDynamicObjectCollection(controlProp.getParent().getName());
                        JSONArray subDataRowsJSON = dataRowJSON.getJSONArray(controlProp.getParent().getName());
                        NumberFormatProvider numberFormat4 = new NumberFormatProvider(fmtFields, subDataRows, null, 0, isApplyMaterialPrecision);
                        int subsize2 = subDataRows.size();
                        for (int k2 = 0; k2 < subsize2; ++k2) {
                            DynamicObject subDataRow2 = (DynamicObject)subDataRows.get(k2);
                            for (FmtField fmt : fmtFields) {
                                NumberPrecision numberPrecision4 = numberFormat4.getFormatPrecision(fmt.getFieldName(), subDataRow2, subDataRow2);
                                if (numberPrecision4 != null) {
                                    numberPrecision4.setGroupingUsed(false);
                                    subDataRowsJSON.getJSONObject(k2).put(fmt.getFieldName(), (Object)numberPrecision4);
                                    continue;
                                }
                                subDataRowsJSON.getJSONObject(k2).remove((Object)fmt.getFieldName());
                            }
                        }
                    }
                }
                continue;
            }
            if (!(controlProp.getParent() instanceof EntryType)) continue;
            size = coll.size();
            for (i = 0; i < size; ++i) {
                obj = (DynamicObject)coll.get(i);
                dataObj = jsonArr.getJSONObject(i);
                dataRows = obj.getDynamicObjectCollection(controlProp.getParent().getName());
                dataRowsJSON = dataObj.getJSONArray(controlProp.getParent().getName());
                entrysize = dataRows.size();
                for (int j = 0; j < entrysize; ++j) {
                    dataRow = (DynamicObject)dataRows.get(j);
                    JSONObject dataRowJSON = dataRowsJSON.getJSONObject(j);
                    for (FmtField fmt : fmtFields) {
                        IDataEntityType parentType = fmt.getFieldProp().getParent();
                        if (parentType instanceof SubEntryType) {
                            DynamicObjectCollection subDataRows = dataRow.getDynamicObjectCollection(parentType.getName());
                            JSONArray subDataRowsJSON = dataRowJSON.getJSONArray(parentType.getName());
                            numberFormat = new NumberFormatProvider(fmtFields, subDataRows, dataRow, 0, isApplyMaterialPrecision);
                            subsize = subDataRows.size();
                            for (k = 0; k < subsize; ++k) {
                                subDataRow = (DynamicObject)subDataRows.get(k);
                                numberPrecision = numberFormat.getFormatPrecision(fmt.getFieldName(), subDataRow, dataRow);
                                if (numberPrecision != null) {
                                    numberPrecision.setGroupingUsed(false);
                                    subDataRowsJSON.getJSONObject(k).put(fmt.getFieldName(), (Object)numberPrecision);
                                    continue;
                                }
                                subDataRowsJSON.getJSONObject(k).remove((Object)fmt.getFieldName());
                            }
                            continue;
                        }
                        if (!(parentType instanceof EntryType)) continue;
                        NumberFormatProvider numberFormat5 = new NumberFormatProvider(fmtFields, dataRows, null, 0, isApplyMaterialPrecision);
                        NumberPrecision numberPrecision5 = numberFormat5.getFormatPrecision(fmt.getFieldName(), dataRow, dataRow);
                        if (numberPrecision5 != null) {
                            numberPrecision5.setGroupingUsed(false);
                            dataRowJSON.put(fmt.getFieldName(), (Object)numberPrecision5);
                            continue;
                        }
                        dataRowJSON.remove((Object)fmt.getFieldName());
                    }
                }
            }
        }
    }

    private void addNoFmtMapping(Map<String, List<FmtField>> fmtMapping, IDataEntityProperty prop) {
        List<FmtField> fmtFields = fmtMapping.get(prop.getParent().getName());
        if (fmtFields == null) {
            fmtFields = new ArrayList<FmtField>();
            fmtMapping.put(prop.getParent().getName(), fmtFields);
        }
        FmtField fmtField = new FmtField(prop, prop.getName(), null);
        fmtFields.add(fmtField);
    }

    public String getExportAttachment(String exportId, String entityNumber, int pageIndex, int pagesize) {
        String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
        Map parameters = (Map)AppCache.get((String)appId).get(exportId, Map.class);
        List allPkIds = (List)parameters.get("PKIDs");
        int start = pageIndex * pagesize;
        int end = (pageIndex + 1) * pagesize;
        List pkIds = new ArrayList();
        if (allPkIds != null && !allPkIds.isEmpty() && start >= 0 && start < allPkIds.size()) {
            pkIds = allPkIds.subList(start, Math.min(end, allPkIds.size()));
        }
        IAttachmentModelProxy attachmentModel = (IAttachmentModelProxy)ServiceFactory.getService(IAttachmentModelProxy.class);
        ArrayList<List> attachs = new ArrayList<List>(10);
        for (Object id : pkIds) {
            List atts = attachmentModel.getAttachmentsByExport(entityNumber, id);
            if (!atts.isEmpty()) {
                ((Map)atts.get(0)).put("pkId", id);
            }
            attachs.add(atts);
        }
        HashMap<String, Serializable> retdata = new HashMap<String, Serializable>();
        retdata.put("billCount", Integer.valueOf(pkIds.size()));
        retdata.put("attachs", attachs);
        return SerializationUtils.toJsonString(retdata);
    }

    public void releaseExportData(String exportId, String entityNumber) {
        String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
        Map parameters = (Map)AppCache.get((String)appId).get(exportId, Map.class);
        int releaseLock = (Integer)parameters.get("releaseLock");
        if (--releaseLock <= 0) {
            AppCache.get((String)appId).remove(exportId);
            PageRowCacheUtils.clearPageRowcache((String)exportId, (String)"tempExportControlKey");
            CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache").remove(CacheKeyUtil.getAcctId() + ".pagecache" + exportId);
        } else {
            parameters.put("releaseLock", releaseLock);
            AppCache.get((String)appId).put(exportId, (Object)parameters);
        }
    }

    public String getExportDataByList(String exportId, String entityNumber, boolean needDataIndex, int pageIndex, int pagesize) {
        String dataStr;
        JSONArray datas;
        int fromIndex;
        String appId = EntityMetadataCache.getDataEntityType((String)entityNumber).getAppId();
        Map parameters = (Map)AppCache.get((String)appId).get(exportId, Map.class);
        if (!needDataIndex) {
            parameters.remove("ListFieldCaptions");
        }
        parameters.put("Data", (fromIndex = pageIndex * pagesize) < (datas = JSON.parseArray((String)(dataStr = (String)parameters.get("Data")))).size() ? datas.subList(fromIndex, Math.min(datas.size(), (pageIndex + 1) * pagesize)) : new ArrayList());
        return SerializationUtils.toJsonString((Object)parameters);
    }
}

