/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MaterielProp;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.handle.PropertyHandle;
import kd.bos.openapi.handle.PropertyHandleUtil;

public abstract class AbstractPropertyHandle<T extends IDataEntityProperty>
implements PropertyHandle {
    protected String entityName;
    protected Object id;
    protected final T prop;
    protected final String propName;
    protected String parentFullPropName;
    protected Map<String, Set<String>> prefixMap;
    protected Set<String> select;

    public AbstractPropertyHandle(T prop) {
        if (prop == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u5c5e\u6027 prop \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPropertyHandle_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[0]);
        }
        this.prop = prop;
        this.propName = prop.getName();
    }

    public String getParentFullPropName() {
        return "$".equals(this.parentFullPropName) || StringUtil.isEmpty((String)this.parentFullPropName) ? "" : this.parentFullPropName.trim();
    }

    public String getCurrFullPropName() {
        String parentFullPropName = this.getParentFullPropName();
        return "".equals(parentFullPropName) ? this.propName : parentFullPropName + "." + this.propName;
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target) {
        this.checkNull(source, target);
        try {
            target.put(this.propName, source.get(this.propName));
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u5c5e\u6027%s : \u8d4b\u503c\u5931\u8d25\u3002", (String)"AbstractPropertyHandle_1", (String)"bos-open-service", (Object[])new Object[0]), this.getCurrFullPropName()), new Object[0]);
        }
    }

    protected List<Map<String, Object>> toMapList(DynamicObjectCollection sources) {
        return PropertyHandleUtil.toMapList(this.id, this.entityName, this.getCurrFullPropName(), sources, this.prefixMap);
    }

    protected Map<String, Object> toMap(DynamicObject source) {
        Object masteridObj;
        Map<String, Object> map = PropertyHandleUtil.toMap(this.id, this.entityName, this.getCurrFullPropName(), source, this.prefixMap);
        if (map == null) {
            return null;
        }
        if (this.prop instanceof MaterielProp && (masteridObj = source.get("masterid")) instanceof DynamicObject) {
            DynamicObject masterid = (DynamicObject)masteridObj;
            map.put("number", masterid.get("number"));
            map.put("name", masterid.getLocaleString("name").getLocaleValue());
        }
        return this.getSelectProp(map);
    }

    protected Map<String, Object> getSelectProp(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Set<String> set = this.prefixMap.get(this.getCurrFullPropName());
        if (set == null) {
            set = new HashSet<String>(1);
        }
        set.add("id");
        HashMap<String, Object> selectMap = new HashMap<String, Object>(set.size());
        for (String key : set) {
            selectMap.put(key, map.get(key));
        }
        return selectMap;
    }

    protected boolean isCurrPropHasChildProp() {
        return this.prefixMap.containsKey(this.getCurrFullPropName());
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }

    public void setParentFullPropName(String parentFullPropName) {
        this.parentFullPropName = parentFullPropName;
    }

    public Map<String, Set<String>> getPrefixMap() {
        return this.prefixMap;
    }

    public void setPrefixMap(Map<String, Set<String>> prefixMap) {
        this.prefixMap = prefixMap;
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        this.checkNull(sourceList, target);
        if (sourceList.isEmpty()) {
            target.set(this.prop, null);
        } else {
            try {
                target.set(this.prop, sourceList.get(0).get(this.getCurrFullPropName()));
            }
            catch (Exception e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u5c5e\u6027%s : \u8d4b\u503c\u5931\u8d25\u3002", (String)"AbstractPropertyHandle_1", (String)"bos-open-service", (Object[])new Object[0]), this.getCurrFullPropName()), new Object[0]);
            }
        }
    }

    protected <SRC, TAR> void checkNull(SRC sourceList, TAR target) {
        if (sourceList == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u5c5e\u6027 %s : \u6e90\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPropertyHandle_2", (String)"bos-open-service", (Object[])new Object[0]), new Object[]{this.getCurrFullPropName()});
        }
        if (target == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u5c5e\u6027 %s : \u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPropertyHandle_3", (String)"bos-open-service", (Object[])new Object[0]), new Object[]{this.getCurrFullPropName()});
        }
    }

    public Set<String> getSelect() {
        return this.select;
    }

    public void setSelect(Set<String> select) {
        this.select = select;
    }

    protected <K> List<DynamicObject> distinctByProp(Collection<DynamicObject> collection, Predicate<? super DynamicObject> filter, Function<? super DynamicObject, ? extends K> keyMapper) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        Stream<DynamicObject> stream = collection.stream();
        if (filter != null) {
            stream = stream.filter(filter);
        }
        return new ArrayList<DynamicObject>(stream.collect(Collectors.toMap(keyMapper, Function.identity(), (oldVal, newVal) -> oldVal)).values());
    }
}

