/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.handle;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.handle.AbstractPropertyHandle;
import kd.bos.openapi.handle.PropertyHandle;
import kd.bos.openapi.handle.prop.BasedataPropHandle;
import kd.bos.openapi.handle.prop.ComboPropHandle;
import kd.bos.openapi.handle.prop.CommonPropHandle;
import kd.bos.openapi.handle.prop.EntryPropHandle;
import kd.bos.openapi.handle.prop.FlexPropHandle;
import kd.bos.openapi.handle.prop.ItemClassPropHandle;
import kd.bos.openapi.handle.prop.ItemClassTypePropHandle;
import kd.bos.openapi.handle.prop.MaterielPropHandle;
import kd.bos.openapi.handle.prop.MulBasedataPropHandle;
import kd.bos.openapi.handle.prop.MuliLangTextPropHandle;
import kd.bos.openapi.handle.prop.RefBillPropHandle;

public class PropertyHandleFactory {
    public static PropertyHandle createHandle(Object id, String entityName, String fullParentPropName, IDataEntityProperty property, Map<String, Set<String>> prefixMap) {
        AbstractPropertyHandle<?> propertyHandle = PropertyHandleFactory.getPropertyHandle(fullParentPropName, property);
        propertyHandle.setId(id);
        propertyHandle.setEntityName(entityName);
        propertyHandle.setParentFullPropName(fullParentPropName);
        propertyHandle.setPrefixMap(prefixMap);
        return propertyHandle;
    }

    public static PropertyHandle createHandle(String fullParentPropName, IDataEntityProperty property, Set<String> select) {
        AbstractPropertyHandle<?> propertyHandle = PropertyHandleFactory.getPropertyHandle(fullParentPropName, property);
        propertyHandle.setParentFullPropName(fullParentPropName);
        propertyHandle.setSelect(select);
        return propertyHandle;
    }

    private static AbstractPropertyHandle<?> getPropertyHandle(String fullParentPropName, IDataEntityProperty property) {
        AbstractPropertyHandle propertyHandle;
        if (property instanceof MuliLangTextProp) {
            propertyHandle = new MuliLangTextPropHandle((MuliLangTextProp)property);
        } else if (property instanceof EntryProp) {
            propertyHandle = new EntryPropHandle((EntryProp)property);
        } else if (property instanceof ItemClassProp) {
            propertyHandle = new ItemClassPropHandle((ItemClassProp)property);
        } else if (property instanceof FlexProp) {
            propertyHandle = new FlexPropHandle((FlexProp)property);
        } else if (property instanceof MaterielProp) {
            propertyHandle = new MaterielPropHandle((MaterielProp)property);
        } else if (property instanceof BasedataProp) {
            propertyHandle = new BasedataPropHandle((BasedataProp)property);
        } else if (property instanceof MulBasedataProp) {
            propertyHandle = new MulBasedataPropHandle((MulBasedataProp)property);
        } else if (property instanceof ItemClassTypeProp) {
            propertyHandle = new ItemClassTypePropHandle((ItemClassTypeProp)property);
        } else if (property instanceof RefBillProp) {
            propertyHandle = new RefBillPropHandle((RefBillProp)property);
        } else if (property instanceof ComboProp && !(property instanceof MulComboProp)) {
            propertyHandle = new ComboPropHandle((ComboProp)property);
        } else {
            if (!(property instanceof FieldProp)) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5c5e\u6027 %1$s.%2$s\u7c7b\u578b %3$s\u3002", (String)"PropertyHandleFactory_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[]{fullParentPropName, property.getName(), property.getClass().getName()});
            }
            propertyHandle = new CommonPropHandle(property);
        }
        return propertyHandle;
    }
}

