/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.handle.prop;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.openapi.handle.AbstractPropertyHandle;
import kd.bos.openapi.service.context.ServiceApiContext;

public class MuliLangTextPropHandle
extends AbstractPropertyHandle<MuliLangTextProp> {
    public MuliLangTextPropHandle(MuliLangTextProp prop) {
        super(prop);
    }

    @Override
    public void copyValue(DynamicObject source, Map<String, Object> target) {
        super.copyValue(source, target);
        ILocaleString localeString = source.getLocaleString(this.propName);
        if (ServiceApiContext.getContext() != null) {
            boolean muliLang = ServiceApiContext.getRequest().getServiceApiData().isMuliLang();
            if (muliLang) {
                HashMap map = new HashMap();
                for (Map.Entry entry : localeString.entrySet()) {
                    map.put(entry.getKey(), entry.getValue());
                }
                target.put(this.propName, map);
            } else {
                target.put(this.propName, localeString == null ? null : localeString.getLocaleValue());
            }
        } else {
            target.put(this.propName, localeString == null ? null : localeString.getLocaleValue());
        }
    }

    @Override
    public void copyValue(List<DynamicObject> sourceList, DynamicObject target) {
        super.checkNull(sourceList, target);
        target.set(this.prop, (Object)new LocaleString(sourceList.get(0).getString(this.getCurrFullPropName())));
    }
}

