/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service;

import com.alibaba.fastjson.JSONException;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.instance.Instance;
import kd.bos.openapi.api.ApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.custom.cache.CustomApiCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.service.context.ServiceApiContext;

public abstract class AbstractApiService<P extends ApiParam<?, ? extends ApiPlugin>, R>
implements ApiService<P, R> {
    public ApiServiceData<R> execute(P param) {
        ServiceApiContext preServiceApiContext = ServiceApiContext.getContext();
        ServiceApiContext serviceApiContext = new ServiceApiContext(param.getRequest(), new OpenApiResponse());
        ServiceApiContext.set((ServiceApiContext)serviceApiContext);
        try {
            ApiServiceData result = this.doExecute((ApiParam)param);
            result.setPluginInstanceId(Instance.getInstanceId());
            ApiServiceData apiServiceData = result;
            return apiServiceData;
        }
        catch (JSONException ex) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ex.getMessage(), new Object[0]);
        }
        finally {
            ServiceApiContext.close();
            if (preServiceApiContext != null) {
                ServiceApiContext.set((ServiceApiContext)preServiceApiContext);
            }
        }
    }

    public <Plugin> List<Plugin> getPlugin(P param) {
        return param.getPlugins().stream().map(it -> CustomApiCacheUtil.getOrRegisterSingletonInstance((String)it)).collect(Collectors.toList());
    }
}

