/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom;

import com.alibaba.fastjson.parser.Feature;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiCustomParam;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.custom.cache.CustomApiCacheUtil;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.custom.CustomApiParseUtil;
import kd.bos.openapi.service.custom.validation.OpenApiMethodInvocation;
import kd.bos.openapi.service.custom.validation.OpenApiMethodValidationInterceptor;
import kd.bos.openapi.service.custom.validation.ValidatorUtil;
import org.springframework.context.i18n.LocaleContextHolder;

public class SpringUtil
extends ValidatorUtil {
    private static final Log LOG = LogFactory.getLog(SpringUtil.class);
    private static final OpenApiMethodValidationInterceptor METHOD_VALIDATION_INTERCEPTOR;

    public static ApiServiceData<Object> invoke(ApiCustomParam param) {
        ArrayList<Object> arguments;
        String className = param.getClassName();
        String methodName = param.getMethodName();
        Map methodParam = param.getMethodParam();
        CustomApiParseUtil.check(className, methodName);
        Object instance = CustomApiCacheUtil.getOrRegisterSingletonInstance((String)className);
        Method method = CustomApiParseUtil.getMethod(instance.getClass(), methodName);
        if (ApiDefType.WSDL == ApiDefType.getApiDefType((String)param.getApiDefTypeCode())) {
            arguments = new ArrayList<Object>(1);
            arguments.add(methodParam);
        } else {
            Parameter[] parameters = method.getParameters();
            List<String> varNameList = CustomApiParseUtil.getVarNameList(instance.getClass(), method);
            arguments = new ArrayList(parameters.length);
            boolean isRequestBody = CustomApiParseUtil.isRequestBody(parameters, varNameList);
            if (isRequestBody) {
                Type type = parameters[0].getParameterizedType();
                arguments.add(SpringUtil.formatParam(methodParam, type, param.getHttpMethod(), varNameList.get(0)));
            } else {
                for (int i = 0; i < parameters.length; ++i) {
                    Type type = parameters[i].getParameterizedType();
                    Object varValue = methodParam.get(varNameList.get(i));
                    arguments.add(SpringUtil.formatParam(varValue, type, param.getHttpMethod(), varNameList.get(i)));
                }
            }
        }
        return SpringUtil.invoke(instance, method, arguments.toArray());
    }

    private static Object formatParam(Object value, Type type, String httpMethod, String varName) {
        try {
            if (value == null) {
                return null;
            }
            if (value instanceof String) {
                if (String.class.equals((Object)type)) {
                    return value;
                }
                if (HttpMethod.GET.getCode().equals(httpMethod) && (CustomApiParseUtil.isGetBasicCollection(type) || CustomApiParseUtil.isGetBasicArray(type))) {
                    return JsonUtil.parseObject(Collections.singletonList(value), (Type)type, (Feature[])new Feature[0]);
                }
                return JsonUtil.parseObject((Object)value, (Type)type, (Feature[])new Feature[0]);
            }
            if (HttpMethod.GET.getCode().equals(httpMethod) && !value.getClass().isArray() && !(value instanceof Collection) && (CustomApiParseUtil.isGetBasicCollection(type) || CustomApiParseUtil.isGetBasicArray(type))) {
                return JsonUtil.parseObject(Collections.singletonList(value), (Type)type, (Feature[])new Feature[0]);
            }
            return JsonUtil.parseObject((Object)value, (Type)type, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570{0}\u8f6c\u6362\u5931\u8d25\uff1a{1}", (String)"SpringUtil_2", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[0]), new Object[]{varName, e.getMessage()});
        }
    }

    public static ApiServiceData<Object> invoke(String className, String methodName, Object ... params) {
        CustomApiParseUtil.check(className, methodName);
        Object instance = CustomApiCacheUtil.getOrRegisterSingletonInstance((String)className);
        Method method = CustomApiParseUtil.getMethod(instance.getClass(), methodName);
        return SpringUtil.invoke(instance, method, params);
    }

    @Deprecated
    public static ApiServiceData<Object> invoke(Class<?> cls, Method method, Object[] arguments) {
        LOG.info("==invoke==class=={}=={}=={}==", new Object[]{cls.getName(), method.getName(), arguments});
        Object instance = CustomApiCacheUtil.getOrRegisterSingletonInstance(cls);
        return SpringUtil.invoke(instance, method, arguments);
    }

    public static ApiServiceData<Object> invoke(Object instance, Method method, Object[] arguments) {
        LOG.info("==invoke==class=={}=={}=={}==", new Object[]{instance.getClass().getName(), method.getName(), arguments});
        long startTime = System.currentTimeMillis();
        boolean isSetLocaleOK = false;
        try {
            try {
                LocaleContextHolder.setLocale((Locale)RequestContext.get().getLang().getLocale());
                isSetLocaleOK = true;
            }
            catch (Exception e) {
                LOG.error(Locale.getDefault() + "=OpenLocale=" + LocaleContextHolder.getLocale(), (Throwable)e);
            }
            Object data = METHOD_VALIDATION_INTERCEPTOR.invoke(new OpenApiMethodInvocation(instance, method, arguments));
            if (data == null) {
                throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SpringUtil_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[0]);
            }
            if (!(data instanceof CustomApiResult)) {
                throw new OpenApiException(ApiErrorCode.PLUGIN_ERROR, ResManager.loadKDString((String)"\u8fd4\u56de\u503c\u7c7b\u578b\u4e0d\u662f {0}", (String)"SpringUtil_1", (String)"bos-open-service", (Object[])new Object[0]), new Object[]{CustomApiResult.class.getSimpleName()});
            }
            CustomApiResult result = (CustomApiResult)data;
            if (result.isStatus()) {
                ApiServiceData apiServiceData = ApiServiceData.of((boolean)true, (OpenApiResponse)ServiceApiContext.getResponse((Object)result.getData()), (long)(System.currentTimeMillis() - startTime), (String)result.getErrorCode(), (String)result.getMessage(), null);
                return apiServiceData;
            }
            ApiServiceData apiServiceData = ApiServiceData.ofFalse((String)result.getErrorCode(), (String)result.getMessage(), (OpenApiResponse)ServiceApiContext.getResponse((Object)result.getData()), (long)(System.currentTimeMillis() - startTime));
            return apiServiceData;
        }
        catch (ConstraintViolationException e) {
            Set set = e.getConstraintViolations();
            if (CollectionUtil.isEmpty((Collection)set)) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, ApiErrorCode.HTTP_BAD_REQUEST.toString(), new Object[0]);
            }
            ApiServiceData apiServiceData = ApiServiceData.ofFalse((String)ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode(), (String)e.getMessage(), (OpenApiResponse)ServiceApiContext.getResponse(null), (long)(System.currentTimeMillis() - startTime), null);
            return apiServiceData;
        }
        catch (Throwable e) {
            if (e instanceof OpenApiException) {
                throw (OpenApiException)e;
            }
            if (e.getCause() instanceof KDException) {
                throw (KDException)e.getCause();
            }
            throw new OpenApiException(e, ApiErrorCode.HTTP_BAD_REQUEST, e.getMessage(), new Object[0]);
        }
        finally {
            if (isSetLocaleOK) {
                LocaleContextHolder.resetLocaleContext();
            }
        }
    }

    static {
        try {
            LOG.info("OPEN_API\u521d\u59cb\u5316\u6821\u9a8c\u5668" + SpringUtil.class.getSimpleName() + ":" + EL_JAR);
            METHOD_VALIDATION_INTERCEPTOR = new OpenApiMethodValidationInterceptor(SpringUtil.getValidator());
        }
        catch (Exception e) {
            LOG.error("OPEN_API\u521d\u59cb\u5316\u6821\u9a8c\u5668\u5931\u8d25" + SpringUtil.class.getSimpleName() + ":" + EL_JAR, (Throwable)e);
            throw e;
        }
    }
}

