/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom.open;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Min;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.service.custom.open.LogModel;
import kd.bos.orm.query.QFilter;

@ApiController(value="dev", desc="\u5f00\u653e\u5e73\u53f0API")
@ApiMapping(value="/openapi/log")
public class CustomOpenApiLogController
implements Serializable {
    @ApiPostMapping(value="queryByUrl", desc="\u6839\u636eurl\u67e5\u8be2API\u8c03\u7528\u65e5\u5fd7\u8be6\u7ec6\u4fe1\u606f\uff08\u7528\u4e8e\u65e5\u5fd7\u5ba1\u8ba1\uff09")
    public CustomApiResult<List<LogModel>> queryByUrl(@ApiParam(value="\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42\u5730\u5740", required=true) @ApiParam(value="\u5f00\u653e\u5e73\u53f0\u63a5\u53e3\u8bf7\u6c42\u5730\u5740", required=true) String url, @Min(value=0L) @ApiParam(value="\u5206\u9875\u5927\u5c0f") @Min(value=0L) @ApiParam(value="\u5206\u9875\u5927\u5c0f") Integer pageSize, @Min(value=0L) @ApiParam(value="\u9875\u7801") @Min(value=0L) @ApiParam(value="\u9875\u7801") Integer pageNo) {
        QFilter qFilter = QFilter.of((String)"opdesc = ?", (Object[])new Object[]{url});
        return CustomApiResult.success(this.buildLogModel(qFilter, pageSize, pageNo));
    }

    @ApiPostMapping(value="getApiLog", desc="\u6839\u636e\u65f6\u95f4\u8303\u56f4\u67e5\u8be2API\u8c03\u7528\u65e5\u5fd7\u8be6\u7ec6\u4fe1\u606f\uff08\u7528\u4e8e\u65e5\u5fd7\u5ba1\u8ba1\uff09")
    public CustomApiResult<List<LogModel>> getApiLog(@ApiParam(value="\u5f00\u59cb\u65f6\u95f4", required=true) @ApiParam(value="\u5f00\u59cb\u65f6\u95f4", required=true) Date starTime, @ApiParam(value="\u7ed3\u675f\u65f6\u95f4", required=true) @ApiParam(value="\u7ed3\u675f\u65f6\u95f4", required=true) Date endTime, @Min(value=0L) @ApiParam(value="\u5206\u9875\u5927\u5c0f") @Min(value=0L) @ApiParam(value="\u5206\u9875\u5927\u5c0f") Integer pageSize, @Min(value=0L) @ApiParam(value="\u9875\u7801") @Min(value=0L) @ApiParam(value="\u9875\u7801") Integer pageNo) {
        QFilter qFilter = QFilter.of((String)"opdate >= ?", (Object[])new Object[]{starTime});
        qFilter.and(QFilter.of((String)"opdate <= ?", (Object[])new Object[]{endTime}));
        return CustomApiResult.success(this.buildLogModel(qFilter, pageSize, pageNo));
    }

    private List<LogModel> buildLogModel(QFilter qFilter, Integer pageSize, Integer pageNo) {
        DynamicObjectCollection ds;
        ArrayList<LogModel> logModelList = new ArrayList<LogModel>();
        LogORM logORM = LogORM.create();
        if (pageSize == null) {
            pageSize = 10;
        }
        if (pageNo == null) {
            pageNo = 1;
        }
        if ((ds = logORM.query("openapi_log_data", "opdesc,request,response,errmsg,apiid,opname,status,opdate,thirdappname,username,userid,ip,cloudname,appname,bizobject,timecost,operationtimecost,traceid", qFilter.toArray(), pageSize.intValue(), (pageNo - 1) * pageSize)).size() > 0) {
            ds.forEach(it -> {
                LogModel logModel = new LogModel();
                logModel.setApiId(it.getLong("apiid"));
                logModel.setApiNumber(it.getString("opname"));
                logModel.setAppName(it.getString("appname"));
                logModel.setCloudName(it.getString("cloudname"));
                logModel.setUrl(it.getString("opdesc"));
                logModel.setReqStr(it.getString("request"));
                logModel.setRespStr(it.getString("response"));
                logModel.setErrorMessage(it.getString("errmsg"));
                logModel.setStatus(it.getBoolean("status") ? "success" : "failed");
                logModel.setReqTime(it.getString("opdate"));
                logModel.setThirdNumber(it.getString("thirdappname"));
                logModel.setOperatorName(it.getString("username"));
                logModel.setOperatorId(it.getString("userid"));
                logModel.setIp(it.getString("ip"));
                logModel.setBizObject(it.getString("bizobject"));
                logModel.setTimeCost(it.getInt("timecost"));
                logModel.setOperationTimeCost(it.getInt("operationtimecost"));
                logModel.setTraceId(it.getString("traceid"));
                logModelList.add(logModel);
            });
        }
        return logModelList;
    }
}

