/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.custom.validation;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.el.ExpressionFactory;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.valueextraction.ValueExtractor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.custom.valueextraction.CustomApiResultValueExtractor;
import kd.bos.openapi.service.custom.validation.OpenApiCustomMessageInterpolator;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;
import org.hibernate.validator.HibernateValidator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@SdkPublic
public class ValidatorUtil {
    private static final Log LOG = LogFactory.getLog(ValidatorUtil.class);
    private static final Validator VALIDATOR;
    protected static String EL_JAR;

    protected static Validator getValidator() {
        return VALIDATOR;
    }

    public static ExecutableValidator forExecutables() {
        return ValidatorUtil.getValidator().forExecutables();
    }

    public static <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return ValidatorUtil.getValidator().validate(object, (Class[])groups);
    }

    public static <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return ValidatorUtil.getValidator().validateProperty(object, propertyName, (Class[])groups);
    }

    public static <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return ValidatorUtil.getValidator().validateValue(beanType, propertyName, value, (Class[])groups);
    }

    public static BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return ValidatorUtil.getValidator().getConstraintsForClass(clazz);
    }

    @SdkInternal
    public static <T> T unwrap(Class<T> type) {
        return (T)ValidatorUtil.getValidator().unwrap(type);
    }

    public static Map<String, Set<String>> toMap(Set<ConstraintViolation<?>> set) {
        if (set == null) {
            return Collections.emptyMap();
        }
        return set.stream().collect(Collectors.groupingBy(it -> it.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toCollection(HashSet::new))));
    }

    private static String getElJar() {
        String path = null;
        try {
            path = Objects.requireNonNull(ExpressionFactory.class.getClassLoader().getResource(ExpressionFactory.class.getName().replaceAll("\\.", "/") + ".class")).toString();
        }
        catch (Exception ex) {
            LOG.error("OPEN_API \u83b7\u53d6\u6821\u9a8c\u5668EL JAR\u5931\u8d25", (Throwable)ex);
        }
        return path;
    }

    static {
        EL_JAR = ValidatorUtil.getElJar();
        try {
            try (LocalValidatorFactoryBean localValidatorFactoryBean = new LocalValidatorFactoryBean();){
                localValidatorFactoryBean.setProviderClass(HibernateValidator.class);
                localValidatorFactoryBean.setMessageInterpolator((MessageInterpolator)new OpenApiCustomMessageInterpolator());
                localValidatorFactoryBean.afterPropertiesSet();
                ValidatorContext validatorContext = localValidatorFactoryBean.usingContext().addValueExtractor((ValueExtractor)new CustomApiResultValueExtractor());
                VALIDATOR = validatorContext.getValidator();
            }
            catch (Exception e) {
                LOG.error("OPEN_API\u521d\u59cb\u5316\u6821\u9a8c\u5668\u5931\u8d25" + ValidatorUtil.class.getSimpleName() + ":" + EL_JAR, (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            LOG.error("OPEN_API\u521d\u59cb\u5316\u6821\u9a8c\u5668\u5931\u8d25 LocalValidatorFactoryBean:" + ValidatorUtil.class.getSimpleName(), (Throwable)e);
            throw e;
        }
    }
}

