/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.openapi.api.DeleteApiService;
import kd.bos.openapi.api.model.OpenApiResponse;
import kd.bos.openapi.api.params.ApiDeleteParam;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.plugin.ApiDeletePlugin;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiDeleteResult;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.api.result.BaseFilterItemData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.service.AbstractApiService;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.statusconvert.StatusConvertApiServiceImpl;
import kd.bos.openapi.service.util.FilterUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class DeleteApiServiceImpl
extends AbstractApiService<ApiDeleteParam, ApiDeleteResult>
implements DeleteApiService {
    public ApiServiceData<ApiDeleteResult> doExecute(ApiDeleteParam param) {
        Pair<Boolean, QFilter> qFilterPair = FilterUtil.getQFilters(param.getRequest().getServiceApiData().getUrl(), (ApiParam<Map<String, Object>, ? extends ApiPlugin>)param);
        QFilter originFilter = (QFilter)qFilterPair.getValue();
        QFilter filter = originFilter != null ? originFilter.copy() : null;
        List pluginList = this.getPlugin(param);
        for (ApiDeletePlugin plugin : pluginList) {
            filter = plugin.getFilter(filter, Collections.unmodifiableMap((Map)param.getRequest().getData()));
        }
        if (filter == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u5220\u9664\u64cd\u4f5c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DeleteApiServiceImpl_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[0]);
        }
        Object[] filters = new QFilter[]{filter};
        long start = System.currentTimeMillis();
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)param.getFormId(), (QFilter[])filters, null, (int)Integer.MAX_VALUE);
        if (pkIds.size() == 0) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u672a\u67e5\u627e\u5230\u9700\u8981%1$s\u7684\u6570\u636e\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e3a%2$s", (String)"DeleteApiServiceImpl_1", (String)"bos-open-service", (Object[])new Object[0]), "delete", Arrays.toString(filters)), new Object[0]);
        }
        if (pkIds.size() == Integer.MAX_VALUE) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u8981\u5220\u9664\u7684\u6570\u636e\u8d85\u8fc7\u6700\u5927\u503c %s, \u8bf7\u4fee\u6539\u5220\u9664\u6761\u4ef6\u3002", (String)"DeleteApiServiceImpl_2", (String)"bos-open-service", (Object[])new Object[0]), Integer.MAX_VALUE), new Object[0]);
        }
        OperateOption option = OperateOption.create();
        FormConfig config = FormMetadataCache.getFormConfig((String)param.getFormId());
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)config.getEntityTypeId());
        String selectFields = "id";
        boolean dbBillnoExist = StatusConvertApiServiceImpl.isDbBillnoExist(dt);
        if (dbBillnoExist) {
            selectFields = selectFields.concat(",").concat(dt.getBillNo());
        }
        DynamicObjectCollection returnFields = QueryServiceHelper.query((String)param.getFormId(), (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pkIds)});
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)param.getOperationNumber(), (String)param.getFormId(), (Object[])pkIds.toArray(), (OperateOption)option);
        long end = System.currentTimeMillis();
        ApiDeleteResult result = new ApiDeleteResult();
        result.setSuccessCount((long)operationResult.getSuccessPkIds().size());
        result.setFailCount((long)(pkIds.size() - operationResult.getSuccessPkIds().size()));
        result.setFilter(Arrays.toString(filters));
        result.setTotalCount((long)pkIds.size());
        ArrayList<BaseFilterItemData> resultsData = new ArrayList<BaseFilterItemData>(pkIds.size());
        result.setResult(resultsData);
        for (Object pkId : pkIds) {
            Optional<Object> first;
            BaseFilterItemData data = new BaseFilterItemData();
            data.setId(pkId.toString());
            if (dbBillnoExist) {
                String sBillNo = returnFields.stream().filter(obj -> obj.get("id").equals(pkId)).findFirst().get().getString(dt.getBillNo());
                data.setNumber(sBillNo);
            }
            if ((first = operationResult.getSuccessPkIds().stream().filter(i -> i.equals(pkId)).findFirst()) == Optional.empty()) {
                for (IOperateInfo iOperateInfo : operationResult.getAllErrorOrValidateInfo().stream().filter(ev -> ev.getPkValue().equals(pkId)).collect(Collectors.toList())) {
                    data.getErrors().add(iOperateInfo.getMessage());
                }
            }
            data.setBillStatus(first != Optional.empty());
            resultsData.add(data);
        }
        if (operationResult.isSuccess()) {
            return ApiServiceData.ofTrue((OpenApiResponse)ServiceApiContext.getResponse((Object)result), (long)(end - start));
        }
        return ApiServiceData.ofFalse((String)ApiErrorCode.Data_Invalid.getStatusCode(), (String)result.fetchFirstErrorMessage(), (OpenApiResponse)ServiceApiContext.getResponse((Object)result), (long)(end - start));
    }
}

