/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service.convert;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.save.service.convert.BaseConvert;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Basedata
extends BaseConvert {
    private static Logger logger = LoggerFactory.getLogger(Basedata.class);

    public Basedata(IDataEntityProperty type, Object source) {
        super(type, source);
    }

    @Override
    Object Convert() {
        if (this.getSource() == null) {
            return super.Convert();
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getContext().getFormId());
        HashMap sv = (HashMap)this.getSource();
        if (dataEntityType instanceof BillEntityType) {
            String baseEntityId = ((BasedataProp)this.getType()).getBaseEntityId();
            BasedataEntityType basedataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)baseEntityId);
            String numberProperty = basedataEntityType.getNumberProperty();
            if (sv.containsKey(numberProperty) && ObjectUtils.isEmpty(sv.get(numberProperty))) {
                return super.Convert();
            }
            if (!sv.containsKey("id") && !numberProperty.equals("number") && sv.containsKey(numberProperty) || !sv.containsKey("id") && !sv.containsKey(numberProperty)) {
                sv.put("id", this.queryId(sv));
            }
        }
        return super.Convert();
    }

    private Object queryId(Map<String, Object> dataMap) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        for (Map.Entry<String, Object> stringObjectEntry : dataMap.entrySet()) {
            if (stringObjectEntry.getValue() instanceof Map) {
                Map ref = (Map)stringObjectEntry.getValue();
                for (Map.Entry objectEntry : ref.entrySet()) {
                    filters.add(new QFilter(MessageFormat.format("{0}.{1}", stringObjectEntry.getKey(), objectEntry.getKey()), "=", objectEntry.getValue()));
                }
                continue;
            }
            filters.add(new QFilter(stringObjectEntry.getKey(), "=", stringObjectEntry.getValue()));
        }
        return this.getPk(((BasedataProp)this.getType()).getBaseEntityId(), filters.toArray(new QFilter[filters.size()]));
    }

    private Object getPk(String formId, QFilter[] filters) {
        DynamicObjectCollection ids;
        String cacheType = "basedata.pk";
        StringBuilder cacheKeyBuilder = new StringBuilder();
        Object retVal = null;
        String cacheKey = "";
        if (StringUtil.isNotEmpty((String)formId) && filters != null) {
            cacheKeyBuilder.append(formId);
            for (QFilter qFilter : filters) {
                cacheKeyBuilder.append("-");
                cacheKeyBuilder.append(qFilter.toString());
            }
            cacheKey = cacheKeyBuilder.toString();
            retVal = Basedata.getLocalCache("basedata.pk").get(cacheKey);
            if (retVal != null) {
                return retVal;
            }
        }
        if ((ids = QueryServiceHelper.query((String)formId, (String)"id", (QFilter[])filters)) == null || ids.isEmpty()) {
            this.getContext().addErrorInfo(MessageFormat.format(ResManager.loadKDString((String)"\u7c7b\u578b\uff1a{0}\uff0c\u6839\u636e\u6761\u4ef6{1}\u672a\u67e5\u627e\u5230\u6570\u636e", (String)"Basedata_0", (String)"bos-open-service", (Object[])new Object[0]), formId, Arrays.asList(filters)));
        } else {
            retVal = ids.size() == 1 ? ((DynamicObject)ids.get(0)).get("id") : ((DynamicObject)ids.get(0)).get("id");
        }
        if (retVal != null && StringUtil.isNotEmpty((String)cacheKey)) {
            Basedata.getLocalCache("basedata.pk").put(cacheKey, retVal);
        }
        return retVal;
    }

    private static LocalMemoryCache getLocalCache(String cacheType) {
        int timeout = 600;
        int maxItemSize = 100000;
        String cacheSize = System.getProperty("openapi.basedataCacheSize", "50");
        int nCacheSize = DataUtil.i((Object)cacheSize);
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(600);
        info.setMaxItemSize(100000);
        info.setMaxMemSize(nCacheSize);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("OpenAPI".concat(RequestContext.get().getAccountId()), cacheType, info);
    }
}

