/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.save.service.upper;

import com.alibaba.fastjson.JSONObject;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.ModelEventProxy;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.operate.webapi.EntyRowMatchStyle;
import kd.bos.form.operate.webapi.OperateDataConverter;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.params.ApiSaveParam;
import kd.bos.openapi.api.params.Option;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.ApiSaveRowErrorData;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.openapi.service.save.service.convert.FormatConverter;
import kd.bos.openapi.service.save.service.upper.ApiServiceLocalCache;
import kd.bos.openapi.service.save.service.upper.SaveDataConvertResult;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public abstract class AbstractSaveService<P extends ApiPlugin> {
    private static final Log log = LogFactory.getLog(AbstractSaveService.class);
    private static final char PKKEYVALUESPLIT = ':';
    private static final char INDEXPKSPLIT = '$';
    private static final String KEYVALUESPLIT = "=";
    private static final String BOS_OPEN_SERVICE = "bos-open-service";
    protected ApiSaveParam<P> param;
    private Map<String, Object> options = new HashMap<String, Object>();
    private Map<String, Object> userOptions = new HashMap<String, Object>();
    private IFormView view;
    private String formId;
    private DynamicObject blankDataEntity;
    private OperateDataConverter dataConverter;
    private HasPermDimObjResult hasPermOrgResult;
    private List<String> dataConvertOrder = new ArrayList<String>();

    public Map<String, Object> getUserOptions() {
        return this.userOptions;
    }

    boolean isOnlyOverride() {
        return this.options != null && this.options.get("importType") != null && this.options.get("importType").equals("override");
    }

    boolean isOnlyNew() {
        return this.options != null && this.options.get("importType") != null && this.options.get("importType").equals("new");
    }

    public boolean getIsOnlyNew() {
        return this.isOnlyNew();
    }

    protected boolean isMutex_ignoremodify() {
        if (null != this.options && this.options.size() > 0 && null != this.options.get("mutex_ignoremodify")) {
            return this.options.get("mutex_ignoremodify").equals("true");
        }
        return false;
    }

    boolean isImportInit() {
        boolean falg = true;
        if (null != this.options && this.options.size() > 0 && null != this.options.get("is_importinit")) {
            falg = this.options.get("is_importinit").equals("true");
        }
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("is_importinit")) {
            falg = this.userOptions.get("is_importinit").equals("true");
        }
        return falg;
    }

    boolean isCheckEntryId() {
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("is_checkentryid")) {
            return this.userOptions.get("is_checkentryid").equals("true");
        }
        return true;
    }

    protected String isRmStatusControl() {
        String falg = "";
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("rmStatusControl")) {
            falg = this.userOptions.get("rmStatusControl").equals("true") ? "true" : "false";
        }
        return falg;
    }

    protected String isCheckStatus() {
        String falg = "";
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("isCheckStatus")) {
            falg = this.userOptions.get("isCheckStatus").equals("false") ? "false" : "true";
        }
        return falg;
    }

    boolean fireAfterCreateNewData() {
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("fireAfterCreateNewData")) {
            return this.userOptions.get("fireAfterCreateNewData").equals("true");
        }
        return true;
    }

    boolean isForcedaudit() {
        if (null != this.userOptions && this.userOptions.size() > 0 && null != this.userOptions.get("forcedAudit")) {
            return this.userOptions.get("forcedAudit").equals("true");
        }
        return false;
    }

    public void initialize(ApiSaveParam param) {
        this.formId = param.getFormId();
        this.param = param;
        this.getView();
    }

    public void preExecute() {
        int i = 0;
        for (Map objectMap : this.param.getDataList()) {
            objectMap.put("_index_", i++);
            objectMap.put("rowNum", objectMap.get("_index_"));
        }
        if (this.param.getSaveParam() != null) {
            if (this.param.getSaveParam().getOption() != null) {
                for (Option item : this.param.getSaveParam().getOption()) {
                    this.options.put(item.getKey(), item.getValues());
                }
                if (this.options.containsKey("importType")) {
                    this.options.put("importtype", this.options.get("importType"));
                }
            }
            if (this.param.getSaveParam().getUserOptions() != null) {
                for (Option item : this.param.getSaveParam().getUserOptions()) {
                    this.userOptions.put(item.getKey(), item.getValues());
                }
            }
        }
        this.options.put("appid", this.getApiAppId());
    }

    public abstract ApiSaveResult execute();

    protected IFormView getView() {
        if (this.view == null) {
            this.cerateView();
        }
        return this.view;
    }

    private void cerateView() {
        FormShowParameter parameter = this.createShowParameter();
        this.view = parameter.createViewForWebApi();
        this.view.initialize(parameter);
    }

    private FormShowParameter createShowParameter() {
        HashMap<String, String> mapParam = new HashMap<String, String>();
        mapParam.put("formId", this.formId);
        FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
        return parameter;
    }

    protected Object getBlankDataEntity(IDataModel model) {
        if (this.blankDataEntity == null) {
            this.blankDataEntity = ApiServiceLocalCache.getBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId());
        }
        if (this.blankDataEntity != null && !StringUtils.equals((CharSequence)this.blankDataEntity.getDataEntityType().getVersion(), (CharSequence)model.getDataEntityType().getVersion())) {
            this.blankDataEntity = null;
        }
        if (this.blankDataEntity == null) {
            model.beginInit();
            model.createNewData();
            model.endInit();
            this.blankDataEntity = model.getDataEntity();
            ApiServiceLocalCache.putBlankDataEntity(model.getDataEntityType().getName(), String.valueOf(RequestContext.get().getOrgId()), RequestContext.get().getUserId(), this.blankDataEntity);
        } else {
            IDataEntityType dt = this.blankDataEntity.getDataEntityType();
            for (IDataEntityProperty property : dt.getProperties()) {
                if (!(property instanceof CreateDateProp)) continue;
                property.setValue((Object)this.blankDataEntity, (Object)new Date());
                break;
            }
        }
        return OrmUtils.clone((IDataEntityBase)this.blankDataEntity, (boolean)false, (boolean)true);
    }

    protected OperateDataConverter getDataConverter(IDataModel model) {
        if (this.dataConverter == null) {
            String entityNumber = model.getDataEntityType().getName();
            Map<BasedataItem, Object> cacheBasePKs = ApiServiceLocalCache.getBasePKs(entityNumber);
            Map<String, Map<Object, DynamicObject>> cacheBaseObjs = ApiServiceLocalCache.getBaseOBJs(entityNumber);
            this.dataConverter = new OperateDataConverter(model, cacheBasePKs, cacheBaseObjs);
            this.dataConverter.setHasPermResult(this.getHasPermOrgResult());
        } else {
            this.dataConverter.beginNewBill(3);
        }
        return this.dataConverter;
    }

    public HasPermDimObjResult getHasPermOrgResult() {
        if (this.hasPermOrgResult == null) {
            PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
            this.hasPermOrgResult = permService.getHasPermDimObjs(Long.parseLong(RequestContext.get().getUserId()), this.getApiAppId(), this.formId, "47150e89000000ac");
        }
        return this.hasPermOrgResult;
    }

    private String getApiAppId() {
        String appId = "";
        if (ServiceApiContext.getRequest() != null && ServiceApiContext.getRequest().getServiceApiData() != null) {
            appId = ServiceApiContext.getRequest().getServiceApiData().getAppId();
        }
        return appId;
    }

    protected abstract void prepareDataEntity(IDataModel var1, Map<String, Object> var2, boolean var3, Supplier<OperationResult> var4);

    protected List<ApiSaveItemData> executeSave(List<Map<String, Object>> sourceDatas, boolean isInsert) {
        int i;
        ArrayList<DynamicObject> billObjs = new ArrayList<DynamicObject>();
        IDataModel model = this.getView().getModel();
        model.putContextVariable("MODEL_INIT_BY_WEBAPI", (Object)Boolean.TRUE);
        model.putContextVariable("fireAfterCreateNewData", (Object)this.fireAfterCreateNewData());
        ModelEventProxy eventProxy = (ModelEventProxy)model.getService(ModelEventProxy.class);
        if (eventProxy != null && this.isImportInit()) {
            InitImportDataEventArgs initImportDataEventArgs = new InitImportDataEventArgs((Object)model, sourceDatas, this.options, this.dataConvertOrder);
            eventProxy.fireInitImportData(initImportDataEventArgs);
            ArrayList<ApiSaveItemData> initResults = new ArrayList<ApiSaveItemData>();
            for (i = 0; i <= this.param.getDataList().size(); ++i) {
                Collection messages = initImportDataEventArgs.getCancelMessage(i).values();
                if (messages.isEmpty()) continue;
                ApiSaveItemData importInitResult = new ApiSaveItemData();
                importInitResult.setBillIndex(i);
                this.setKeys(model, importInitResult, (Map)this.param.getDataList().get(i));
                ArrayList<ApiSaveRowErrorData> errors = new ArrayList<ApiSaveRowErrorData>();
                ApiSaveRowErrorData saveRowErrorData = new ApiSaveRowErrorData();
                HashSet stringSet = new HashSet();
                for (List message : messages) {
                    stringSet.addAll(message);
                }
                saveRowErrorData.setRowMsg((Set)stringSet);
                errors.add(saveRowErrorData);
                importInitResult.setErrors(errors);
                initResults.add(importInitResult);
            }
            if (!initResults.isEmpty()) {
                return initResults;
            }
        }
        HashMap<String, ApiSaveItemData> results = new HashMap<String, ApiSaveItemData>(sourceDatas.size());
        SaveDataConvertResult convertResult = SaveDataConvertResult.of(System.currentTimeMillis());
        int len = sourceDatas.size();
        for (i = 0; i < len; ++i) {
            ApiSaveItemData apiSaveData = new ApiSaveItemData();
            Map<String, Object> sourceData = sourceDatas.get(i);
            if (sourceData.get("id") != null && sourceData.get("id").equals(0L)) {
                sourceData.remove("id");
            }
            Set entityKeys = model.getDataEntityType().getAllEntities().keySet();
            for (String entitykey : entityKeys) {
                if (sourceData.get(entitykey) == null) continue;
                this.removeId(sourceData, entitykey);
                List entrys = (List)sourceData.get(entitykey);
                for (Map entry : entrys) {
                    for (String subkey : entityKeys) {
                        if (entry.get(subkey) == null) continue;
                        this.removeId(entry, subkey);
                    }
                }
            }
            this.setKeys(model, apiSaveData, sourceData);
            this.resolve(model, sourceData, isInsert, convertResult);
            String pkValue = sourceData.getOrDefault("id", new Object()).toString();
            int index = Integer.parseInt(sourceData.get("_index_").toString());
            apiSaveData.setBillIndex(index);
            results.put(pkValue, apiSaveData);
            if (convertResult.isSuccess()) {
                apiSaveData.setBillStatus(true);
                billObjs.add(model.getDataEntity(true));
                continue;
            }
            apiSaveData.setBillStatus(false);
            apiSaveData.getErrors().add(convertResult.getErrorInfos().get(index));
            convertResult.setSuccess(true);
        }
        convertResult.setEndTime(System.currentTimeMillis());
        if (!billObjs.isEmpty()) {
            OperationResult result = OperationServiceHelper.executeOperate((String)this.getOperationNumber(), (String)model.getDataEntityType().getName(), (DynamicObject[])billObjs.toArray(new DynamicObject[billObjs.size()]), (OperateOption)this.getOperateOption());
            result = this.doAuditOp(result, model.getDataEntityType().getName());
            for (Map.Entry stringApiSaveDataEntry : results.entrySet()) {
                ((ApiSaveItemData)stringApiSaveDataEntry.getValue()).setBillStatus(false);
            }
            this.setBillNo(model, results, result);
            for (IOperateInfo operateErrorInfoitem : result.getAllErrorOrValidateInfo()) {
                OperateErrorInfo operateErrorInfo = (OperateErrorInfo)operateErrorInfoitem;
                ApiSaveRowErrorData saveErrorData = new ApiSaveRowErrorData();
                saveErrorData.setEntityKey(operateErrorInfo.getEntityKey());
                PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
                if (this.formId.equals(operateErrorInfo.getEntityKey())) {
                    saveErrorData.setKeys(null);
                } else if (this.param.getKeyMap().get(operateErrorInfo.getEntityKey()) != null) {
                    for (String entityKey : (List)this.param.getKeyMap().get(operateErrorInfo.getEntityKey())) {
                        Map objectMap = sourceDatas.stream().filter(item -> item.get("id").equals(pkProp instanceof LongProp ? Long.valueOf(Long.parseLong(operateErrorInfo.getPkValue().toString())) : operateErrorInfo.getPkValue())).findFirst().get();
                        if (entityKey.contains(".")) {
                            Object sourceBaseDataValue = this.getSourceBaseDataValue(objectMap, entityKey);
                            saveErrorData.getKeys().put(entityKey, sourceBaseDataValue.toString());
                            continue;
                        }
                        String sValue = objectMap.getOrDefault(entityKey, "").toString();
                        saveErrorData.getKeys().put(entityKey, sValue);
                    }
                }
                saveErrorData.getRowMsg().add(operateErrorInfo.getMessage());
                ((ApiSaveItemData)results.get(operateErrorInfo.getPkValue().toString())).getErrors().add(saveErrorData);
            }
            if (StringUtil.isNotEmpty((String)result.getMessage()) && CollectionUtil.isEmpty((Collection)result.getAllErrorOrValidateInfo())) {
                ApiSaveRowErrorData saveErrorData = new ApiSaveRowErrorData();
                saveErrorData.getRowMsg().add(result.getMessage());
                for (ApiSaveItemData itemData : results.values()) {
                    if (itemData.isBillStatus() || !itemData.getErrors().isEmpty()) continue;
                    itemData.getErrors().add(saveErrorData);
                }
            }
        }
        return results.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private void setKeys(IDataModel model, ApiSaveItemData apiSaveData, Map<String, Object> sourceData) {
        Object id = sourceData.getOrDefault("id", "");
        String pkValue = Optional.ofNullable(id).orElse("").toString();
        if (model.getDataEntityType() instanceof BillEntityType) {
            apiSaveData.setId(pkValue);
            for (String key : (List)this.param.getKeyMap().get("$")) {
                if (key.contains(".")) {
                    Object sourceBaseDataValue = this.getSourceBaseDataValue(sourceData, key);
                    apiSaveData.getKeys().put(key, sourceBaseDataValue.toString());
                    continue;
                }
                Object keyValue = sourceData.getOrDefault(key, "");
                apiSaveData.getKeys().put(key, keyValue != null ? keyValue.toString() : "");
            }
        }
    }

    private void removeId(Map<String, Object> objectMap, String entryKey) {
        Object o = objectMap.get(entryKey);
        if (o instanceof List) {
            List entrys = (List)o;
            for (Map entry : entrys) {
                if (entry.get("id") == null || !entry.get("id").equals(0L)) continue;
                entry.remove("id");
            }
        }
    }

    private Object getSourceBaseDataValue(Map value, String key) {
        String basefieldKey = key.substring(0, key.indexOf(46));
        String basefieldRefKey = key.substring(key.indexOf(46) + 1);
        if (value.get(basefieldKey) instanceof Map) {
            Object baseRefValue = ((Map)value.get(basefieldKey)).get(basefieldRefKey);
            if (baseRefValue instanceof Map) {
                return this.getSourceBaseDataValue((Map)baseRefValue, basefieldRefKey);
            }
            return baseRefValue;
        }
        return "";
    }

    protected abstract OperateOption getOperateOption();

    private void setBillNo(IDataModel model, Map<String, ApiSaveItemData> results, OperationResult result) {
        BillEntityType type = (BillEntityType)model.getDataEntityType();
        String billNo = type.getBillNo();
        if (StringUtils.isNotEmpty((CharSequence)billNo) && StringUtils.isNotEmpty((CharSequence)type.getProperty(billNo).getAlias())) {
            String selectFields = "id".concat(",").concat(billNo);
            DynamicObjectCollection returnFields = QueryServiceHelper.query((String)this.formId, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)result.getSuccessPkIds())});
            for (Object successPkId : result.getSuccessPkIds()) {
                String sPkId = successPkId.toString();
                ApiSaveItemData apiSaveData = results.get(sPkId);
                if (apiSaveData == null) continue;
                apiSaveData.setBillStatus(true);
                DynamicObject id = returnFields.stream().filter(i -> i.getString("id").equals(sPkId)).findFirst().get();
                apiSaveData.setNumber(id.getString(billNo));
                apiSaveData.setId(sPkId);
            }
        } else {
            for (Object successPkId : result.getSuccessPkIds()) {
                String sPkId = successPkId.toString();
                ApiSaveItemData apiSaveData = results.get(sPkId);
                if (apiSaveData == null) continue;
                apiSaveData.setBillStatus(true);
                apiSaveData.setId(sPkId);
            }
        }
    }

    private void resolve(IDataModel model, Map<String, Object> sourceData, boolean insert, SaveDataConvertResult result) {
        try {
            this.prepareDataEntity(model, sourceData, insert, () -> {
                boolean errorOccurred;
                Object id;
                HashMap<Integer, List<String>> optionval = new HashMap<Integer, List<String>>();
                ArrayList<String> vals = new ArrayList<String>();
                optionval.put(0, vals);
                FormatConverter formatConverter = new FormatConverter();
                formatConverter.replaceParamData(sourceData, model.getDataEntityType().getName());
                if (formatConverter.geterrorInfos() != null && formatConverter.geterrorInfos().size() > 0) {
                    vals.addAll(formatConverter.geterrorInfos());
                }
                Object pkId = sourceData.get("_pkid_");
                Object keyMapId = sourceData.get("_keymapid_");
                HashMap<String, String> keyValues = new HashMap<String, String>(((List)this.param.getKeyMap().get("$")).size());
                for (String key : (List)this.param.getKeyMap().get("$")) {
                    this.keysAppend(model, sourceData, keyValues, new StringBuilder(), key);
                }
                if (!this.isOnlyNew() && pkId != null && !pkId.equals(keyMapId)) {
                    vals.add(String.format(ResManager.loadKDString((String)"\u4f20\u5165id{%1$s}\u4e0e\u901a\u8fc7\u5019\u9009\u952e%2$s\u83b7\u53d6id{%3$s}\u4e0d\u4e00\u81f4", (String)"AbstractSaveService_0", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), pkId, ((Object)keyValues).toString(), keyMapId));
                }
                if (this.isOnlyOverride() && insert) {
                    id = sourceData.get("id");
                    if (id != null) {
                        vals.add(String.format(ResManager.loadKDString((String)"\u901a\u8fc7id{%s}\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e", (String)"AbstractSaveService_1", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), id));
                    } else {
                        vals.add(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e%s\u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e", (String)"AbstractSaveService_2", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), ((Object)keyValues).toString()));
                    }
                }
                if (this.isOnlyNew() && !insert) {
                    id = sourceData.get("_pkid_");
                    if (id != null) {
                        vals.add(String.format(ResManager.loadKDString((String)"\u901a\u8fc7id{%s}\u67e5\u627e\u5230\u6570\u636e\u5df2\u5b58\u5728,\u4e0d\u80fd\u65b0\u589e", (String)"AbstractSaveService_3", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), id));
                    } else {
                        vals.add(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5019\u9009\u952e%s\u67e5\u627e\u5230\u6570\u636e\u5df2\u5b58\u5728,\u4e0d\u80fd\u65b0\u589e", (String)"AbstractSaveService_16", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), ((Object)keyValues).toString()));
                    }
                }
                this.entryVals(model, sourceData, insert, vals);
                if (!vals.isEmpty()) {
                    OperationResult initOptionResult = this.buildInitResult(optionval);
                    return initOptionResult;
                }
                OperateDataConverter convert = this.getDataConverter(model);
                PKFieldProp pkProp = (PKFieldProp)model.getDataEntityType().getPrimaryKey();
                Object pkValue = model.getDataEntity().getPkValue();
                if (!pkProp.getValueComparator().compareValue(pkValue)) {
                    convert.setModify(true);
                } else {
                    convert.setModify(false);
                    if (sourceData.get("id") == null) {
                        if (pkProp instanceof LongProp) {
                            model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genGlobalLongId());
                            sourceData.put(pkProp.getName(), model.getValue(pkProp.getName()));
                        } else if (pkProp instanceof VarcharProp) {
                            model.getDataEntity().set((IDataEntityProperty)pkProp, (Object)DBServiceHelper.genStringId());
                            sourceData.put(pkProp.getName(), model.getValue(pkProp.getName()));
                        }
                    }
                }
                convert.setDataConvertOrder(this.dataConvertOrder);
                model.putContextVariable("IGNORE_RELOADDATAMODEL", (Object)Boolean.TRUE);
                Map contextErrorMap = convert.getContextErrorInfo();
                boolean fireAfterImportData = this.isFireAfterImportData();
                ModelEventProxy eventProxy = convert.getModelEventProxy();
                if (eventProxy != null && this.isImportInit()) {
                    BeforeImportDataEventArgs eventArgs = new BeforeImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), this.options);
                    eventProxy.fireBeforeImportData(eventArgs);
                    convert.setCheckImportable(eventArgs.isCheckImportable());
                    boolean bl = fireAfterImportData = fireAfterImportData && eventArgs.isFireAfterImportData();
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                boolean overrideEntry = false;
                if (null != this.options.get("OverrideEntry")) {
                    overrideEntry = Boolean.parseBoolean(this.options.get("OverrideEntry").toString());
                    if (convert.isModify() && !overrideEntry) {
                        convert.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
                    } else if (!convert.isModify()) {
                        convert.setEntyRowMatchStyle(EntyRowMatchStyle.Postion);
                    }
                } else {
                    convert.setEntyRowMatchStyle(EntyRowMatchStyle.PrimaryKey);
                }
                if (!this.isCheckEntryId()) {
                    sourceData.put("isCheckEntryId", "false");
                }
                convert.filterBasedatas(sourceData, model.getDataEntity(), 0);
                convert.cacheBasedataPKIds();
                convert.convertComplexProperty(sourceData, model.getDataEntity(), 0);
                boolean bl = errorOccurred = sourceData.get("_ERROR_DATA_") != null;
                if (this.isImportInit() && !errorOccurred && eventProxy != null && fireAfterImportData) {
                    ImportDataEventArgs eventArgs = new ImportDataEventArgs((Object)model, sourceData, convert.getBasePKs(), this.options);
                    eventProxy.fireAfterImportData(eventArgs);
                    if (eventArgs.isCancel()) {
                        this.mergeCancelMessages(eventArgs.getCancelMessages(), contextErrorMap);
                        return this.buildInitResult(contextErrorMap);
                    }
                }
                model.clearNoDataRow();
                model.removeContextVariable("IGNORE_RELOADDATAMODEL");
                OperationResult initResult = this.buildInitResult(contextErrorMap);
                if (errorOccurred) {
                    initResult.setSuccess(false);
                }
                return initResult;
            });
        }
        catch (KDBizException e) {
            result.setSuccess(false);
            ApiSaveRowErrorData ed = new ApiSaveRowErrorData();
            ed.setEntityKey(model.getDataEntityType().getName());
            String eMessage = e.getMessage();
            if (JSONObject.isValid((String)e.getMessage())) {
                Map hashMap = (Map)JSONObject.parseObject((String)eMessage, Map.class);
                for (Map.Entry listEntry : hashMap.entrySet()) {
                    for (String s : (List)listEntry.getValue()) {
                        ed.getRowMsg().add(s);
                    }
                }
            } else {
                ed.getRowMsg().add(eMessage);
            }
            for (String key : (List)this.param.getKeyMap().get("$")) {
                Object oValue = sourceData.getOrDefault(key, "");
                String sValue = oValue != null ? oValue.toString() : "";
                ed.getKeys().put(key, sValue);
            }
            int index = Integer.parseInt(sourceData.get("_index_").toString());
            result.getErrorInfos().put(index, ed);
        }
    }

    private void entryVals(IDataModel model, Map<String, Object> sourceData, boolean insert, List<String> vals) {
        if (!insert && !this.isOnlyNew() && this.isCheckEntryId()) {
            for (Map.Entry<String, List<String>> entry : this.param.getKeyMap().entrySet()) {
                List sourceEntryRows;
                String entryName = (String)entry.getKey();
                if ("$".equals(entryName) || entryName.contains(".") || ((List)entry.getValue()).size() == 0 || null == (sourceEntryRows = (List)sourceData.get(entryName))) continue;
                int entrySize = model.getEntryEntity(entryName).size();
                ArrayList<String> entryRecords = new ArrayList<String>(entrySize);
                for (int i = 0; i < entrySize; ++i) {
                    DynamicObject row = model.getEntryRowEntity(entryName, i);
                    StringBuilder sb = new StringBuilder();
                    sb.append(i);
                    sb.append('$');
                    sb.append(row.getPkValue());
                    sb.append(':');
                    for (String key : (List)entry.getValue()) {
                        sb.append(key.concat(KEYVALUESPLIT).concat(row.getString(key) != null ? row.getString(key) : ""));
                    }
                    entryRecords.add(sb.toString());
                }
                HashMap<String, String> keyValues = new HashMap<String, String>(((List)entry.getValue()).size());
                for (Object sourceEntryRow : sourceEntryRows) {
                    Map sourceEntryRowMap = (Map)sourceEntryRow;
                    StringBuilder sb = new StringBuilder();
                    for (String key : (List)entry.getValue()) {
                        this.keysAppend(model, sourceEntryRowMap, keyValues, sb, key);
                    }
                    String sourceKey = sb.toString();
                    long count = entryRecords.stream().filter(s -> s.substring(s.indexOf(58) + 1).equals(sourceKey)).count();
                    if (count == 0L) {
                        if (this.isOnlyOverride()) {
                            vals.add(String.format(ResManager.loadKDString((String)"\u5206\u5f55\uff1a%1$s \u901a\u8fc7\u5019\u9009\u952e\uff1a%2$s \u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e", (String)"AbstractSaveService_5", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entryName, ((Object)keyValues).toString()));
                        }
                    } else if (count == 1L) {
                        String entryidstr = entryRecords.stream().filter(s -> s.substring(s.indexOf(58) + 1).equals(sourceKey)).findFirst().get();
                        String entryid = entryidstr.substring(entryidstr.indexOf(36) + 1, entryidstr.indexOf(58));
                        sourceEntryRowMap.put("id", entryid);
                        String entryrIndex = entryidstr.substring(0, entryidstr.indexOf(36));
                        this.subEntryVals(model, sourceEntryRowMap, entry, entryrIndex, vals);
                    }
                    if (count <= 1L) continue;
                    vals.add(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u5206\u5f55\uff1a%1$s \u901a\u8fc7\u5019\u9009\u952e\uff1a%2$s \u627e\u5230 %3$s \u6570\u636e", (String)"AbstractSaveService_6", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entryName, ((Object)keyValues).toString(), count));
                }
            }
        }
    }

    private void keysAppend(IDataModel model, Map<String, Object> sourceRowMap, Map<String, String> keyValues, StringBuilder sb, String keyField) {
        IDataEntityProperty property = model.getDataEntityType().findProperty(keyField);
        if (property == null) {
            String fieldKey = keyField.contains(".") ? keyField.substring(keyField.lastIndexOf(46) + 1) : keyField;
            property = (IDataEntityProperty)model.getDataEntityType().getAllFields().get(fieldKey);
        }
        if (property instanceof AmountProp || property instanceof QtyProp) {
            int newScale = ((DecimalProp)property).getScale();
            StringBuilder pattern = new StringBuilder("0.");
            for (int i = 0; i < newScale; ++i) {
                pattern.append('0');
            }
            DecimalFormat df = new DecimalFormat(pattern.toString());
            Object ds = sourceRowMap.get(keyField);
            if (ds != null) {
                String format = df.format(Double.valueOf(ds.toString()));
                sb.append(keyField.concat(KEYVALUESPLIT).concat(format));
                keyValues.put(keyField, sourceRowMap.getOrDefault(keyField, "").toString());
            }
        } else if (keyField.contains(".")) {
            String baseKey = keyField.substring(0, keyField.indexOf(46));
            String basePro = keyField.substring(keyField.indexOf(46) + 1);
            Map sourceRowBaseMap = (Map)sourceRowMap.get(baseKey);
            String baseValue = sourceRowBaseMap == null ? "" : sourceRowBaseMap.getOrDefault(basePro, "");
            String sValue = baseValue != null ? baseValue.toString() : "";
            sb.append(keyField.concat(KEYVALUESPLIT).concat(sValue));
            keyValues.put(keyField, sValue);
        } else {
            Object value = sourceRowMap.getOrDefault(keyField, "");
            String sValue = value != null ? value.toString() : "";
            sb.append(keyField.concat(KEYVALUESPLIT).concat(sValue));
            keyValues.put(keyField, sValue);
        }
    }

    private void subEntryVals(IDataModel model, Map<String, Object> sourceEntryRowMap, Map.Entry<String, List<String>> keys, String entryIndex, List<String> vals) {
        for (Map.Entry se : this.param.getKeyMap().entrySet()) {
            String s = (String)se.getKey();
            if (!s.contains(".")) continue;
            String entryKey = s.substring(0, s.indexOf(46));
            String subEntryKey = s.substring(s.indexOf(46) + 1);
            if (!entryKey.equals(keys.getKey()) || ((List)se.getValue()).size() == 0) continue;
            DynamicObject object = (DynamicObject)model.getEntryEntity(entryKey).get(Integer.parseInt(entryIndex));
            int subEntrySize = object.getDynamicObjectCollection(subEntryKey).size();
            ArrayList<String> subEntryRecords = new ArrayList<String>(subEntrySize);
            for (int i = 0; i < subEntrySize; ++i) {
                DynamicObject entryRow = (DynamicObject)object.getDynamicObjectCollection(subEntryKey).get(i);
                StringBuilder sbsub = new StringBuilder();
                sbsub.append(entryRow.getPkValue());
                sbsub.append(':');
                for (String key : (List)this.param.getKeyMap().get(s)) {
                    sbsub.append(key.concat(KEYVALUESPLIT).concat(entryRow.getString(key)));
                }
                subEntryRecords.add(sbsub.toString());
            }
            Object subObjs = sourceEntryRowMap.get(subEntryKey);
            if (subObjs == null) continue;
            List subEntryRows = (List)subObjs;
            HashMap<String, String> subkeyValues = new HashMap<String, String>(keys.getValue().size());
            for (Object subEntryRow : subEntryRows) {
                Map sourceSubEntryRowMap = (Map)subEntryRow;
                StringBuilder sbsourcesub = new StringBuilder();
                for (String key : (List)this.param.getKeyMap().get(s)) {
                    this.keysAppend(model, sourceSubEntryRowMap, subkeyValues, sbsourcesub, key);
                }
                String sourcesubKey = sbsourcesub.toString();
                long subcount = subEntryRecords.stream().filter(subs -> subs.substring(subs.indexOf(58) + 1).equals(sourcesubKey)).count();
                if (subcount == 0L) {
                    if (!this.isOnlyOverride()) continue;
                    vals.add(String.format(ResManager.loadKDString((String)"\u5b50\u5206\u5f55\uff1a%1$s \u901a\u8fc7\u5019\u9009\u952e\uff1a%2$s \u672a\u627e\u5230\u9700\u8981\u4fee\u6539\u7684\u6570\u636e", (String)"AbstractSaveService_7", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), subEntryKey, ((Object)subkeyValues).toString()));
                    continue;
                }
                if (subcount == 1L) {
                    String subentryidstr = subEntryRecords.stream().filter(subs -> subs.substring(subs.indexOf(58) + 1).equals(sourcesubKey)).findFirst().get();
                    String subentryid = subentryidstr.substring(subentryidstr.indexOf(36) + 1, subentryidstr.indexOf(58));
                    sourceSubEntryRowMap.put("id", subentryid);
                    continue;
                }
                if (subcount <= 1L) continue;
                vals.add(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u552f\u4e00\uff0c\u5b50\u5206\u5f55\uff1a%1$s \u901a\u8fc7\u5019\u9009\u952e\uff1a%2$s \u627e\u5230 %3$s \u6570\u636e", (String)"AbstractSaveService_8", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), subEntryKey, ((Object)subkeyValues).toString(), subcount));
            }
        }
    }

    protected boolean isFirePropChanged() {
        Object paramValue;
        boolean firePropChanged = false;
        if (this.options != null && (paramValue = this.options.get("firePropChanged")) != null) {
            firePropChanged = StringUtils.isBlank((Object)paramValue) ? false : Boolean.parseBoolean(paramValue.toString());
        }
        return firePropChanged;
    }

    protected boolean isFireAfterImportData() {
        boolean fireAfterImportData = true;
        if (this.options != null) {
            Object paramValue = this.options.get("fireAfterImportData");
            fireAfterImportData = StringUtils.isBlank((Object)paramValue) || Boolean.parseBoolean(paramValue.toString());
        }
        return fireAfterImportData;
    }

    private void mergeCancelMessages(Map<Integer, List<String>> cancelMessages, Map<Integer, List<String>> contextErrorMap) {
        if (!cancelMessages.isEmpty()) {
            for (Map.Entry<Integer, List<String>> entry : cancelMessages.entrySet()) {
                List<String> errlist = contextErrorMap.get(entry.getKey());
                if (errlist == null) {
                    errlist = new ArrayList<String>();
                    contextErrorMap.put(entry.getKey(), errlist);
                }
                errlist.addAll((Collection<String>)entry.getValue());
            }
        } else {
            contextErrorMap.put(0, Collections.singletonList(ResManager.loadKDString((String)"\u63d2\u4ef6\u53d6\u6d88\u5f15\u5165\u672c\u5355", (String)"AbstractSave_0", (String)"bos-entity-business", (Object[])new Object[0])));
        }
    }

    public String getOperationNumber() {
        if (this.options == null || this.options.get("forcedSubmit") == null) {
            if (this.isForcedaudit()) {
                return "submit";
            }
            return this.param.getRequest().getServiceApiData().getApiOperationType();
        }
        String submit = this.options.get("forcedSubmit").toString();
        if (StringUtils.isEmpty((CharSequence)submit)) {
            return this.param.getRequest().getServiceApiData().getApiOperationType();
        }
        return submit;
    }

    private OperationResult buildInitResult(Map<Integer, List<String>> contextErrorMap) {
        OperationResult initResult = new OperationResult();
        if (!contextErrorMap.isEmpty()) {
            initResult.setSuccess(false);
            initResult.setMessage(JSONObject.toJSONString(contextErrorMap));
        }
        return initResult;
    }

    protected boolean isHashCtrlStrategy(BillEntityType dt) {
        return dt.getProperty("createorg") != null && dt.getProperty("ctrlstrategy") != null;
    }

    protected Object getStatusCaption(BillEntityType dt, String billStatusKey, BillStatus status) {
        BillStatusProp statusProp = (BillStatusProp)dt.getProperty(billStatusKey);
        for (ValueMapItem item : statusProp.getComboItems()) {
            if (!status.name().equals(item.getValue())) continue;
            return item.getName();
        }
        return status.getValue();
    }

    protected void classifyByKey(ApiSaveParam<P> param, List<Map<String, Object>> insertList, List<Map<String, Object>> updateList) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)param.getFormId());
        for (Map dataMap : param.getDataList()) {
            Object id = this.queryId(entityType, dataMap, param.getKeyMap());
            if (id == null) {
                insertList.add(dataMap);
                continue;
            }
            dataMap.put("id", id);
            updateList.add(dataMap);
        }
    }

    private Object queryId(MainEntityType entityType, Map<String, Object> dataMap, Map<String, List<String>> keyMap) {
        DynamicProperty pkProperty = AbstractSaveService.getProperty((EntityType)entityType, "id");
        Object pkValue = null;
        Object pkId = null;
        try {
            Object sourceId = dataMap.get("id");
            pkValue = AbstractSaveService.castSingleValue(pkProperty, "id", sourceId);
        }
        catch (Exception e) {
            log.warn("id:" + dataMap.remove("id") + "\uff0c\u7c7b\u578b\u975e\u6cd5\uff0c\u5c06\u901a\u8fc7\u5019\u9009\u952e\u627e\u76ee\u6807\u5355ID\u3002");
        }
        if (pkValue != null) {
            QFilter filter = new QFilter("id", KEYVALUESPLIT, pkValue);
            Object id = AbstractSaveService.innerGetPk(entityType.getName(), new QFilter[]{filter}, Collections.singletonList("id"), dataMap);
            if (id != null) {
                dataMap.put("_pkid_", id);
                pkId = id;
            }
        }
        if (!keyMap.containsKey("$")) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952ekey\u4e0d\u5b58\u5728!", (String)"AbstractSaveService_9", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entityType.getName()), new Object[0]);
        }
        List<String> fields = keyMap.get("$");
        if (fields == null || fields.isEmpty()) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53%s\u7684\u5019\u9009\u952e\u5b57\u6bb5\u4e0d\u5b58\u5728!", (String)"AbstractSaveService_10", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entityType.getName()), new Object[0]);
        }
        QFilter[] filters = new QFilter[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            Object sourceBaseDataValue = field.indexOf(46) < 0 ? dataMap.get(field) : this.getSourceBaseDataValue(dataMap, field);
            Object v = AbstractSaveService.castSingleValue(AbstractSaveService.getProperty((EntityType)entityType, field), field, sourceBaseDataValue);
            filters[i] = new QFilter(field, KEYVALUESPLIT, v);
        }
        Object keyMapId = AbstractSaveService.innerGetPk(entityType.getName(), filters, fields, dataMap);
        if (keyMapId != null) {
            dataMap.put("_keymapid_", keyMapId);
        }
        return pkId != null ? pkId : keyMapId;
    }

    public static DynamicProperty getProperty(EntityType entityType, String field) {
        int index = field.indexOf(46);
        if (index < 0) {
            return entityType.getProperty(field);
        }
        DynamicProperty property = entityType.getProperty(field.substring(0, index));
        if (property instanceof BasedataProp) {
            String name = ((BasedataProp)property).getComplexType().getName();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)name);
            return AbstractSaveService.getProperty((EntityType)type, field.substring(index + 1));
        }
        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5f15\u7528\u7c7b\u578b\u5c5e\u6027\u8fc7\u6ee4, \u4e0d\u652f\u6301%1$s\u7684\u5c5e\u6027%2$s\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6!", (String)"AbstractSaveService_11", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entityType.getName(), property.getName()), new Object[0]);
    }

    private static Object castSingleValue(DynamicProperty property, String field, Object oldValue) {
        String s = null;
        try {
            if (oldValue == null) {
                return null;
            }
            if (property instanceof MuliLangTextProp && oldValue instanceof Map) {
                return ((Map)oldValue).get(Lang.get().name());
            }
            if (property instanceof DateTimeProp) {
                return DataUtil.t((Object)oldValue);
            }
            if (property instanceof LongProp || property instanceof BigIntProp) {
                return DataUtil.l((Object)oldValue);
            }
            if (property instanceof IntegerProp) {
                return DataUtil.i((Object)oldValue);
            }
            if (property instanceof BooleanProp) {
                return DataUtil.x((Object)oldValue);
            }
            if (property instanceof VarcharProp && (s = DataUtil.s((Object)oldValue)) != null) {
                return s;
            }
            if (property instanceof BasedataProp) {
                return ((BasedataProp)property).getRefIdProp() instanceof LongProp ? Long.valueOf(DataUtil.l((Object)oldValue)) : DataUtil.s((Object)oldValue);
            }
            if (property instanceof TextProp) {
                return oldValue.toString();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_BAD_REQUEST, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u5c5e\u6027%1$s\u7684\u503c%2$s\u8f6c\u6362\u4e3a%3$s\u7c7b\u578b!", (String)"AbstractSaveService_12", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), field, s, property.getClass()), new Object[0]);
        }
    }

    private static Object innerGetPk(String entity, QFilter[] filters, List<String> fields, Map<String, Object> data) {
        String number;
        HashSet<String> requires = new HashSet<String>();
        requires.add("id");
        requires.addAll(fields);
        DynamicObjectCollection ids = QueryServiceHelper.query((String)entity, (String)String.join((CharSequence)",", requires), (QFilter[])filters);
        if (fields.size() == 1 && fields.contains("number") && (number = DataUtil.s((Object)data.get("number"))) != null) {
            return AbstractSaveService.findIdByNumber(entity, (List<DynamicObject>)ids, number);
        }
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ((DynamicObject)ids.get(0)).get("id");
        }
        return AbstractSaveService.handleMultiIds(entity, fields, (List<DynamicObject>)ids);
    }

    private static Object handleMultiIds(String entity, List<String> fields, List<DynamicObject> ids) {
        HashSet<DynamicObject> set = new HashSet<DynamicObject>(ids);
        if (set.size() > 1) {
            throw new OpenApiException(ApiErrorCode.Data_Duplicate, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53 %1$s\u6839\u636e\u5019\u9009\u952e%2$s\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55!", (String)"AbstractSaveService_13", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entity, String.join((CharSequence)",", fields)), new Object[0]);
        }
        return ids.get(0).get("id");
    }

    private static Object findIdByNumber(String entity, List<DynamicObject> ids, String number) {
        Object id = null;
        for (DynamicObject obj : ids) {
            if (!number.equals(DataUtil.s((Object)obj.get("number")))) continue;
            if (id == null) {
                id = obj.get("id");
                continue;
            }
            if (id.equals(obj.get("id"))) continue;
            throw new OpenApiException(ApiErrorCode.Data_Duplicate, String.format(ResManager.loadKDString((String)"\u5b9e\u4f53 %1$s\u5b58\u5728\u591a\u6761\u8bb0\u5f55\u7684\u7f16\u7801\u662f\uff08%2$s\uff09!", (String)"AbstractSaveService_14", (String)BOS_OPEN_SERVICE, (Object[])new Object[0]), entity, number), new Object[0]);
        }
        return id;
    }

    private OperationResult doAuditOp(OperationResult result, String formId) {
        if (this.isForcedaudit() && result.getSuccessPkIds().size() > 0) {
            Object[] ids = result.getSuccessPkIds().toArray(new Object[result.getSuccessPkIds().size()]);
            result = OperationServiceHelper.executeOperate((String)"audit", (String)formId, (Object[])ids, (OperateOption)this.getOperateOption());
        }
        return result;
    }
}

