/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.thirdapp.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.thirdapp.ApiInfoDto;
import kd.bos.openapi.thirdapp.BasicAgentUserDto;
import kd.bos.openapi.thirdapp.IpInfoDto;
import kd.bos.openapi.thirdapp.ThirdAppDto;
import kd.bos.openapi.thirdapp.ThirdAppService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.PasswordEncryptUtil;

public class ThirdAppServiceImpl
implements ThirdAppService {
    private static Log logger = LogFactory.getLog(ThirdAppServiceImpl.class);
    private static final Long BASICAUTH_STRATEGY_ID = 1651449551145428992L;

    private void saveValidate(ThirdAppDto thirdAppDto) {
        if (StringUtil.isEmpty((String)thirdAppDto.getNumber())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.number"}), new Object[0]);
        }
        if (StringUtil.isEmpty((String)thirdAppDto.getName())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.name"}), new Object[0]);
        }
        if (!("1".equalsIgnoreCase(thirdAppDto.getIsold()) || !StringUtil.isEmpty((String)thirdAppDto.getAccessToken()) && thirdAppDto.getAccessToken().matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$"))) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%s\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"ThirdAppServiceImpl_2", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.accessToken"}), new Object[0]);
        }
        if (StringUtil.isEmpty((String)thirdAppDto.getStatus())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.status"}), new Object[0]);
        }
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"third_app", (String)"number,name,status,enable,is_digest,publickey,syspwd,creator,createtime,modifier,modifytime,entryentity.id,entryentity.apiservice", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)thirdAppDto.getNumber())});
        if (apps.length > 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u7cfb\u7edf\u5df2\u5b58\u5728\u7f16\u7801\u4e3a %s \u7684\u7b2c\u4e09\u65b9\u5e94\u7528\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"ThirdAppServiceImpl_1", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{thirdAppDto.getNumber()}), new Object[0]);
        }
        if (thirdAppDto.isDigestAuthEnable() && StringUtil.isEmpty((String)thirdAppDto.getDigestSignKey())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.digestSignKey"}), new Object[0]);
        }
        if (thirdAppDto.isJwtAuthEnable() && StringUtil.isEmpty((String)thirdAppDto.getJwtShaKey())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.jwtShaKey"}), new Object[0]);
        }
        if (thirdAppDto.isSignAuthEnable() && StringUtil.isEmpty((String)thirdAppDto.getSignShaKey())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.signShaKey"}), new Object[0]);
        }
        if (thirdAppDto.isEnhanceToken() && (!thirdAppDto.isEnableAgency() || thirdAppDto.isEnableAgency() && CollectionUtil.isEmpty((Collection)thirdAppDto.getAgentUserIdList()))) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4f7f\u7528\u589e\u5f3a\u578bToken\u8ba4\u8bc1\uff0c\u5fc5\u987b\u5148\u542f\u7528\u4ee3\u7406\u7528\u6237\u63a7\u5236\u5e76\u7ef4\u62a4\u63a5\u53e3\u4ee3\u7406\u7528\u6237\u3002", (String)"AccessTokenUpdateServiceImpl_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private String getTrueFalseString(boolean params) {
        return params ? "1" : "0";
    }

    public boolean createThirdApp(ThirdAppDto thirdAppDto) {
        this.saveValidate(thirdAppDto);
        try {
            String srcType = StringUtil.isNotEmpty((String)thirdAppDto.getSrcType()) ? thirdAppDto.getSrcType() : "1";
            DynamicObject app = BusinessDataServiceHelper.newDynamicObject((String)"third_app");
            app.set("number", (Object)thirdAppDto.getNumber());
            app.set("name", (Object)thirdAppDto.getName());
            app.set("status", (Object)thirdAppDto.getStatus());
            app.set("srctype", (Object)srcType);
            app.set("enable", (Object)this.getTrueFalseString(thirdAppDto.isEnable()));
            app.set("isbasicauth", (Object)this.getTrueFalseString(thirdAppDto.isBasicAuthEnable()));
            app.set("syspwd", (Object)thirdAppDto.getAccessToken());
            app.set("is_digest", (Object)this.getTrueFalseString(thirdAppDto.isDigestAuthEnable()));
            if (thirdAppDto.isDigestAuthEnable()) {
                app.set("publickey", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getDigestSignKey()));
            }
            app.set("jwtasymmetic", (Object)this.getTrueFalseString(thirdAppDto.isJwtAuthEnable()));
            if (thirdAppDto.isJwtAuthEnable()) {
                app.set("jwt_type", (Object)(thirdAppDto.getJwtSignType() == null ? Long.valueOf(1L) : thirdAppDto.getJwtSignType()));
                app.set("securitypublickey", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getJwtShaKey()));
            }
            app.set("is_signature", (Object)this.getTrueFalseString(thirdAppDto.isSignAuthEnable()));
            if (thirdAppDto.isSignAuthEnable()) {
                app.set("sign_type", (Object)(thirdAppDto.getSignType() == null ? Long.valueOf(1L) : thirdAppDto.getSignType()));
                app.set("signature_key", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getSignShaKey()));
            }
            app.set("allowallapi", (Object)this.getTrueFalseString(thirdAppDto.isAllowallapi()));
            app.set("allowip", (Object)this.getTrueFalseString(thirdAppDto.isAllowip()));
            app.set("apiencryption", (Object)thirdAppDto.getApiencryption());
            app.set("encryptallapi", (Object)this.getTrueFalseString(thirdAppDto.isEncryptAllApi()));
            app.set("creator", (Object)thirdAppDto.getCreator());
            app.set("createtime", (Object)thirdAppDto.getCreateTime());
            app.set("modifier", (Object)thirdAppDto.getModifier());
            app.set("modifytime", (Object)thirdAppDto.getModifytime());
            app.set("lastenabletime", (Object)thirdAppDto.getLastenabletime());
            app.set("laststoptime", (Object)thirdAppDto.getLaststoptime());
            app.set("authpluginenable", (Object)this.getTrueFalseString(thirdAppDto.isEnableAuthExtPlugin()));
            app.set("isagencyuser", (Object)this.getTrueFalseString(thirdAppDto.isEnableAgency()));
            app.set("isenhancetoken", (Object)this.getTrueFalseString(thirdAppDto.isEnhanceToken()));
            if (CollectionUtil.isNotEmpty((Collection)thirdAppDto.getAgentUserIdList())) {
                DynamicObjectCollection agencyuserColl = app.getDynamicObjectCollection("agencyuser");
                DynamicObject[] bosUserDyObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)thirdAppDto.getAgentUserIdList())});
                DynamicObjectCollection agencyUsers = new DynamicObjectCollection();
                for (DynamicObject userDyObj : bosUserDyObjs) {
                    DynamicObject tempDyObj = new DynamicObject(agencyuserColl.getDynamicObjectType());
                    tempDyObj.set("fbasedataid", (Object)userDyObj);
                    agencyUsers.add((Object)tempDyObj);
                }
                app.set("agencyuser", (Object)agencyUsers);
            }
            OperateOption option = OperateOption.create();
            if (thirdAppDto.isHasRight()) {
                option.setVariableValue("ishasright", String.valueOf(true));
            }
            OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)app.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{app}, (OperateOption)option);
            ThirdAppServiceImpl.check(result);
            return true;
        }
        catch (Exception e) {
            logger.error("error:" + e.getMessage(), (Throwable)e);
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u5f02\u5e38%s,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_3", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{e.getMessage()}), new Object[]{e});
        }
    }

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo op : rs.getAllErrorOrValidateInfo()) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(op.getTitle()).append(' ').append(op.getMessage());
            }
            if (sb.length() == 0) {
                throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, rs.getMessage(), new Object[0]);
            }
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, sb.toString(), new Object[0]);
        }
    }

    public List<ThirdAppDto> findThirdApp(ThirdAppDto thirdAppDto) {
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"id,number,name,status,enable,isbasicauth,syspwd,is_digest,publickey,jwtasymmetic,jwt_type,securitypublickey,is_signature,sign_type,signature_key,allowallapi,allowip,apiencryption,encryptallapi,creator,createtime,modifier,modifytime,lastenabletime,laststoptime,entryentity_basicauth.basesigncode,entryentity_basicauth.agentuserid,srctype,isagencyuser,authpluginenable,agencyuser,isenhancetoken", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)thirdAppDto.getNumber())});
        if (thirdApps == null || thirdApps.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ThirdAppDto> thirdAppDtoList = new ArrayList<ThirdAppDto>(10);
        for (DynamicObject thirdApp : thirdApps) {
            ThirdAppDto dto = new ThirdAppDto();
            dto.setId(Long.valueOf(thirdApp.getLong("id")));
            dto.setName(thirdApp.getString("name"));
            dto.setNumber(thirdApp.getString("number"));
            dto.setStatus(thirdApp.getString("status"));
            dto.setEnable(thirdApp.getBoolean("enable"));
            dto.setBasicAuthEnable(thirdApp.getBoolean("isbasicauth"));
            dto.setAccessToken(thirdApp.getString("syspwd"));
            dto.setDigestAuthEnable(thirdApp.getBoolean("is_digest"));
            dto.setDigestSignKey(thirdApp.getString("publickey"));
            dto.setJwtAuthEnable(thirdApp.getBoolean("jwtasymmetic"));
            dto.setJwtSignType(Long.valueOf(thirdApp.getLong("jwt_type")));
            dto.setJwtShaKey(thirdApp.getString("securitypublickey"));
            dto.setSignAuthEnable(thirdApp.getBoolean("is_signature"));
            dto.setSignType(Long.valueOf(thirdApp.getLong("sign_type")));
            dto.setSignShaKey(thirdApp.getString("signature_key"));
            dto.setAllowallapi(thirdApp.getBoolean("allowallapi"));
            dto.setAllowip(thirdApp.getBoolean("allowip"));
            dto.setApiencryption(Long.valueOf(thirdApp.getLong("apiencryption")));
            dto.setEncryptAllApi(thirdApp.getBoolean("encryptallapi"));
            dto.setCreator(Long.valueOf(thirdApp.getLong("creator.id")));
            dto.setCreateTime(new Timestamp(thirdApp.getDate("createtime").getTime()));
            dto.setModifier(Long.valueOf(thirdApp.getLong("modifier.id")));
            dto.setModifytime(new Timestamp(thirdApp.getDate("modifytime").getTime()));
            dto.setLastenabletime(thirdApp.getDate("lastenabletime") == null ? null : new Timestamp(thirdApp.getDate("lastenabletime").getTime()));
            dto.setLaststoptime(thirdApp.getDate("laststoptime") == null ? null : new Timestamp(thirdApp.getDate("laststoptime").getTime()));
            dto.setSrcType(thirdApp.getString("srctype"));
            dto.setEnableAgency(thirdApp.getBoolean("isagencyuser"));
            dto.setEnableAuthExtPlugin(thirdApp.getBoolean("authpluginenable"));
            dto.setEnhanceToken(thirdApp.getBoolean("isenhancetoken"));
            DynamicObjectCollection dynamicObjectCollection = thirdApp.getDynamicObjectCollection("entryentity_basicauth");
            if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
                ArrayList agentUserList = new ArrayList();
                dynamicObjectCollection.forEach(agentUser -> {
                    BasicAgentUserDto agentUserDto = new BasicAgentUserDto();
                    agentUserDto.setUserId(Long.valueOf(agentUser.getLong("agentuserid.id")));
                    agentUserDto.setSecretKey(EncryptUtil.genSignWithAccountId((String)EncryptUtil.decode((String)agentUser.getString("basesigncode")), (String)RequestContext.get().getAccountId()));
                    agentUserList.add(agentUserDto);
                });
                dto.setBasicAgentUserList(agentUserList);
            }
            MulBasedataDynamicObjectCollection agencyUser = (MulBasedataDynamicObjectCollection)thirdApp.get("agencyuser");
            if (dto.isEnableAgency() && CollectionUtil.isNotEmpty((Collection)agencyUser)) {
                ArrayList userList = new ArrayList();
                agencyUser.forEach(agency -> userList.add(agency.getLong("fbasedataid_id")));
                dto.setAgentUserIdList(userList);
            }
            thirdAppDtoList.add(dto);
        }
        return thirdAppDtoList;
    }

    public boolean updateThirdApp(ThirdAppDto thirdAppDto) {
        if (thirdAppDto.getId() == null && StringUtil.isEmpty((String)thirdAppDto.getNumber())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u66f4\u65b0\u7b2c\u4e09\u65b9\u5e94\u7528ID\u6216\u7f16\u7801\u53c2\u6570\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_4", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)thirdAppDto.getNumber());
        qFilter.or(new QFilter("id", "=", (Object)thirdAppDto.getId()));
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"number,name,status,enable,isbasicauth,syspwd,is_digest,publickey,jwtasymmetic,jwt_type,securitypublickey,is_signature,sign_type,signature_key,allowallapi,allowip,apiencryption,encryptallapi,creator,createtime,modifier,modifytime,lastenabletime,laststoptime,srctype,isagencyuser,authpluginenable,isenhancetoken,agencyuser", (QFilter[])qFilter.toArray());
        if (thirdApps == null || thirdApps.length == 0) {
            return false;
        }
        for (DynamicObject thirdApp : thirdApps) {
            String newPwd;
            if (StringUtil.isNotEmpty((String)thirdAppDto.getNumber()) && !thirdAppDto.getNumber().equals(thirdApp.getString("number"))) {
                thirdApp.set("number", (Object)thirdAppDto.getNumber());
            }
            if (StringUtil.isNotEmpty((String)thirdAppDto.getName()) && !thirdAppDto.getName().equals(thirdApp.getString("name"))) {
                thirdApp.set("name", (Object)thirdAppDto.getName());
            }
            if (StringUtil.isNotEmpty((String)thirdAppDto.getStatus()) && !thirdAppDto.getStatus().equals(thirdApp.getString("status"))) {
                thirdApp.set("status", (Object)thirdAppDto.getStatus());
            }
            if (thirdApp.getBoolean("enable") != thirdAppDto.isEnable()) {
                thirdApp.set("enable", (Object)this.getTrueFalseString(thirdAppDto.isEnable()));
            }
            if (thirdApp.getBoolean("isbasicauth") != thirdAppDto.isBasicAuthEnable()) {
                thirdApp.set("isbasicauth", (Object)this.getTrueFalseString(thirdAppDto.isBasicAuthEnable()));
            }
            if (!"1".equalsIgnoreCase(thirdAppDto.getIsold()) && StringUtil.isNotEmpty((String)thirdAppDto.getAccessToken()) && !(newPwd = PasswordEncryptUtil.getEncryptePasswordWithSalt((String)thirdAppDto.getAccessToken())).equals(thirdApp.getString("syspwd"))) {
                if (!thirdAppDto.getAccessToken().matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$")) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%s\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"ThirdAppServiceImpl_2", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.accessToken"}), new Object[0]);
                }
                thirdApp.set("syspwd", (Object)thirdAppDto.getAccessToken());
            }
            if (thirdApp.getBoolean("is_digest") != thirdAppDto.isDigestAuthEnable()) {
                thirdApp.set("is_digest", (Object)this.getTrueFalseString(thirdAppDto.isDigestAuthEnable()));
            }
            if (!thirdApp.getString("publickey").equals(thirdAppDto.getDigestSignKey())) {
                thirdApp.set("publickey", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getDigestSignKey()));
            }
            if (thirdApp.getBoolean("jwtasymmetic") != thirdAppDto.isJwtAuthEnable()) {
                thirdApp.set("jwtasymmetic", (Object)this.getTrueFalseString(thirdAppDto.isJwtAuthEnable()));
            }
            if (thirdAppDto.getJwtSignType() != null && thirdAppDto.getJwtSignType().longValue() != thirdApp.getLong("jwt_type")) {
                thirdApp.set("jwt_type", (Object)thirdAppDto.getJwtSignType());
            }
            if (!thirdApp.getString("securitypublickey").equals(thirdAppDto.getJwtShaKey())) {
                thirdApp.set("securitypublickey", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getJwtShaKey()));
            }
            if (thirdApp.getBoolean("is_signature") != thirdAppDto.isSignAuthEnable()) {
                thirdApp.set("is_signature", (Object)this.getTrueFalseString(thirdAppDto.isSignAuthEnable()));
            }
            if (thirdAppDto.getSignType() != null && thirdAppDto.getSignType().longValue() != thirdApp.getLong("sign_type")) {
                thirdApp.set("sign_type", (Object)thirdAppDto.getSignType());
            }
            if (!thirdApp.getString("signature_key").equals(thirdAppDto.getSignShaKey())) {
                thirdApp.set("signature_key", (Object)EncrypterFactory.getEncrypter().encode(thirdAppDto.getSignShaKey()));
            }
            if (thirdApp.getBoolean("allowallapi") != thirdAppDto.isAllowallapi()) {
                thirdApp.set("allowallapi", (Object)this.getTrueFalseString(thirdAppDto.isAllowallapi()));
            }
            if (thirdApp.getBoolean("allowip") != thirdAppDto.isAllowip()) {
                thirdApp.set("allowip", (Object)this.getTrueFalseString(thirdAppDto.isAllowip()));
            }
            if (thirdAppDto.getApiencryption() != null && !thirdAppDto.getApiencryption().equals(thirdApp.getLong("apiencryption"))) {
                thirdApp.set("apiencryption", (Object)thirdAppDto.getApiencryption());
            }
            if (thirdApp.getBoolean("encryptallapi") != thirdAppDto.isEncryptAllApi()) {
                thirdApp.set("encryptallapi", (Object)this.getTrueFalseString(thirdAppDto.isEncryptAllApi()));
            }
            if (StringUtil.isNotEmpty((String)thirdApp.getString("srctype")) && !thirdApp.getString("srctype").equals(thirdAppDto.getSrcType())) {
                thirdApp.set("srctype", (Object)thirdAppDto.getSrcType());
            }
            thirdApp.set("modifier", (Object)thirdAppDto.getModifier());
            thirdApp.set("modifytime", (Object)(thirdAppDto.getModifytime() == null ? new Timestamp(new Date().getTime()) : thirdAppDto.getModifytime()));
            thirdApp.set("lastenabletime", (Object)thirdAppDto.getLastenabletime());
            thirdApp.set("laststoptime", (Object)thirdAppDto.getLaststoptime());
            if (thirdApp.getBoolean("authpluginenable") != thirdAppDto.isEnableAuthExtPlugin()) {
                thirdApp.set("authpluginenable", (Object)this.getTrueFalseString(thirdAppDto.isEnableAuthExtPlugin()));
            }
            if (thirdApp.getBoolean("isagencyuser") != thirdAppDto.isEnableAgency()) {
                thirdApp.set("isagencyuser", (Object)this.getTrueFalseString(thirdAppDto.isEnableAgency()));
            }
            if (thirdApp.getBoolean("isenhancetoken") != thirdAppDto.isEnhanceToken()) {
                thirdApp.set("isenhancetoken", (Object)this.getTrueFalseString(thirdAppDto.isEnhanceToken()));
            }
            if (thirdAppDto.isEnhanceToken() && (!thirdAppDto.isEnableAgency() || thirdAppDto.isEnableAgency() && CollectionUtil.isEmpty((Collection)thirdAppDto.getAgentUserIdList()))) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4f7f\u7528\u589e\u5f3a\u578bToken\u8ba4\u8bc1\uff0c\u5fc5\u987b\u5148\u542f\u7528\u4ee3\u7406\u7528\u6237\u63a7\u5236\u5e76\u7ef4\u62a4\u63a5\u53e3\u4ee3\u7406\u7528\u6237\u3002", (String)"AccessTokenUpdateServiceImpl_1", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
            }
            if (!CollectionUtil.isNotEmpty((Collection)thirdAppDto.getAgentUserIdList())) continue;
            DynamicObjectCollection agencyUserColl = thirdApp.getDynamicObjectCollection("agencyuser");
            DynamicObject[] bosUserDyObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)thirdAppDto.getAgentUserIdList())});
            DynamicObjectCollection agencyUsers = new DynamicObjectCollection();
            for (DynamicObject userDyObj : bosUserDyObjs) {
                DynamicObject tempDyObj = new DynamicObject(agencyUserColl.getDynamicObjectType());
                tempDyObj.set("fbasedataid", (Object)userDyObj);
                agencyUsers.add((Object)tempDyObj);
            }
            thirdApp.set("agencyuser", (Object)agencyUsers);
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)thirdApps[0].getDataEntityType().getName(), (DynamicObject[])thirdApps, (OperateOption)option);
        ThirdAppServiceImpl.check(result);
        return true;
    }

    public boolean updateThirdAppStatus(ThirdAppDto thirdAppDto) {
        if (StringUtil.isEmpty((String)thirdAppDto.getStatus())) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.status"}), new Object[0]);
        }
        if (thirdAppDto.getModifier() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.modifier"}), new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)thirdAppDto.getNumber());
        qFilter.or(new QFilter("id", "=", (Object)thirdAppDto.getId()));
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"number,name,status,enable,creator,createtime,modifier,modifytime", (QFilter[])qFilter.toArray());
        if (thirdApps == null || thirdApps.length == 0) {
            return false;
        }
        for (DynamicObject thirdApp : thirdApps) {
            thirdApp.set("status", (Object)thirdAppDto.getStatus());
            thirdApp.set("modifier", (Object)thirdAppDto.getModifier());
            thirdApp.set("modifytime", (Object)(thirdAppDto.getModifytime() == null ? new Timestamp(new Date().getTime()) : thirdAppDto.getModifytime()));
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)thirdApps[0].getDataEntityType().getName(), (DynamicObject[])thirdApps, (OperateOption)option);
        ThirdAppServiceImpl.check(result);
        return true;
    }

    public boolean updateThirdAppEnable(ThirdAppDto thirdAppDto) {
        if (thirdAppDto.getModifier() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4fdd\u5b58\u7b2c\u4e09\u65b9\u5e94\u7528\u53c2\u6570%s\u4e3a\u7a7a,\u8bf7\u68c0\u67e5\u3002", (String)"ThirdAppServiceImpl_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{"thirdAppDto.modifier"}), new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)thirdAppDto.getNumber());
        qFilter.or(new QFilter("id", "=", (Object)thirdAppDto.getId()));
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"number,name,status,enable,creator,createtime,modifier,modifytime", (QFilter[])qFilter.toArray());
        if (thirdApps == null || thirdApps.length == 0) {
            return false;
        }
        for (DynamicObject thirdApp : thirdApps) {
            thirdApp.set("enable", (Object)this.getTrueFalseString(thirdAppDto.isEnable()));
            thirdApp.set("modifier", (Object)thirdAppDto.getModifier());
            thirdApp.set("modifytime", (Object)(thirdAppDto.getModifytime() == null ? new Timestamp(new Date().getTime()) : thirdAppDto.getModifytime()));
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)thirdApps[0].getDataEntityType().getName(), (DynamicObject[])thirdApps, (OperateOption)option);
        ThirdAppServiceImpl.check(result);
        return true;
    }

    public boolean saveThirdApp(ThirdAppDto thirdAppDto) {
        List<ThirdAppDto> list;
        boolean result = false;
        switch (thirdAppDto.getSense()) {
            case 1: {
                result = this.createThirdApp(thirdAppDto);
                break;
            }
            case 2: {
                result = this.updateThirdApp(thirdAppDto);
            }
        }
        if (result && thirdAppDto.isCreateAgentUser() && CollectionUtil.isNotEmpty(list = this.findThirdApp(thirdAppDto))) {
            ThirdAppDto thirdApp = list.get(0);
            result = this.createAgentUser(thirdApp, thirdAppDto.getAgentUserId());
        }
        return result;
    }

    public boolean deleteThirdApp(ThirdAppDto thirdAppDto) {
        QFilter qFilter = new QFilter("number", "=", (Object)thirdAppDto.getNumber());
        qFilter.or(new QFilter("id", "=", (Object)thirdAppDto.getId()));
        DynamicObject[] thirdApps = BusinessDataServiceHelper.load((String)"third_app", (String)"number,name,status,enable,creator,createtime,modifier,modifytime", (QFilter[])qFilter.toArray());
        if (thirdApps == null || thirdApps.length == 0) {
            return false;
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)thirdApps[0].getDataEntityType().getName(), (DynamicObject[])thirdApps, (OperateOption)option);
        ThirdAppServiceImpl.check(result);
        return true;
    }

    private boolean createAgentUser(ThirdAppDto thirdApp, Long agencyUserId) {
        String resourceThirdId = thirdApp.getId().toString();
        String key = EncryptUtil.genSign((String)resourceThirdId, (String)agencyUserId.toString());
        String accountId = RequestContext.get().getAccountId();
        boolean result = false;
        Object[] params = null;
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            String sql = "select fentryid from t_open_3rdapps_basicauth where fagentuserid=? and fid=? ";
            params = new SqlParameter[]{new SqlParameter(":Fagentuserid", -5, (Object)agencyUserId), new SqlParameter(":Fid", -5, (Object)thirdApp.getId())};
            Long exitsId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                Long id = 0L;
                while (rs.next()) {
                    id = rs.getLong(1);
                }
                return id;
            });
            if (exitsId != 0L) {
                sql = "DELETE from t_open_3rdapps_basicauth where fentryid =? ";
                params = new SqlParameter[]{new SqlParameter(":Fentryid", -5, (Object)exitsId)};
                DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            }
            sql = "INSERT INTO t_open_3rdapps_basicauth(fid,fentryid,fseq,fagentuserid,fbasesigncode,fstatus) values (?,?,1,?,?,'1') ";
            params = new SqlParameter[]{new SqlParameter(":Fid", -5, (Object)thirdApp.getId()), new SqlParameter(":Fentryid", -5, (Object)DB.genLongId((String)"t_open_3rdapps_basicauth")), new SqlParameter(":Fagentuserid", -5, (Object)agencyUserId), new SqlParameter(":Fbasesigncode", 12, (Object)EncryptUtil.encode((String)key))};
            result = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            if (thirdApp.isEnableAgency()) {
                sql = "select fbasedataid from t_open_3rdapps_agency where fbasedataid=? and fid=? ";
                params = new SqlParameter[]{new SqlParameter(":fbasedataid", -5, (Object)agencyUserId), new SqlParameter(":Fid", -5, (Object)thirdApp.getId())};
                Long exitUserId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                    Long id = null;
                    while (rs.next()) {
                        id = rs.getLong(1);
                    }
                    return id;
                });
                if (exitUserId == null) {
                    sql = "INSERT INTO t_open_3rdapps_agency(fid,fpkid,fbasedataid) values (?,?,?) ";
                    params = new SqlParameter[]{new SqlParameter(":Fid", -5, (Object)thirdApp.getId()), new SqlParameter(":fpkid", -5, (Object)DB.genLongId((String)"t_open_3rdapps_agency")), new SqlParameter(":fbasedataid", -5, (Object)agencyUserId)};
                    DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
                }
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                logger.error(String.format("createAgentUser-An error occurred while create agentUser for thirdApp: %s  db: accountId:%s, errorMsg:%s", resourceThirdId, accountId, e.getMessage()), (Throwable)e);
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, e.getMessage(), new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public ApiCommonResult<OperationResult> saveOpenApi(ThirdAppDto thirdAppDto) {
        OperationResult saveResult;
        if (thirdAppDto == null || thirdAppDto.getId() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, " thirdAppDto is null or thirdAppDto.id is null\u3002", new Object[0]);
        }
        DynamicObject applyObj = BusinessDataServiceHelper.loadSingle((Object)thirdAppDto.getId(), (String)"third_app");
        applyObj.set("allowallapi", (Object)(thirdAppDto.isAllowallapi() ? "1" : "0"));
        DynamicObjectCollection saveBefore = applyObj.getDynamicObjectCollection("entryentity");
        List list = thirdAppDto.getApiInfoDtoList() == null ? new ArrayList() : thirdAppDto.getApiInfoDtoList();
        Map saveAfter = list.stream().collect(Collectors.toMap(ApiInfoDto::getEntryId, Function.identity(), (key1, key2) -> key2));
        HashMap beforeDetailMap = new HashMap();
        HashMap afterDetailMap = new HashMap();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                beforeDetailMap.put(before.getLong("id"), before);
                beforeIdList.add(before.getLong("id"));
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (Map.Entry entry : saveAfter.entrySet()) {
                afterIdList.add(entry.getKey());
                afterDetailMap.put(entry.getKey(), entry.getValue());
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        Iterator iterator = saveBefore.iterator();
        while (iterator.hasNext()) {
            DynamicObject ipInfo = (DynamicObject)iterator.next();
            Long id = ipInfo.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                iterator.remove();
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            ApiInfoDto afterDto = (ApiInfoDto)afterDetailMap.get(id);
            ipInfo.set("apiservice_id", (Object)afterDto.getApiServiceId());
        }
        DynamicObjectCollection entryEntity = saveBefore;
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            ApiInfoDto afterDto = (ApiInfoDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("apiservice_id", (Object)afterDto.getApiServiceId());
            entryEntity.add((Object)dynamicObject);
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        boolean isSuccess = (saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"third_app", (DynamicObject[])new DynamicObject[]{applyObj}, (OperateOption)option)) == null ? true : saveResult.isSuccess();
        ApiCommonResult result = null;
        result = isSuccess ? ApiCommonResult.getSuccessResult((String)"0", (String)"") : ApiCommonResult.getFailResult((String)ApiErrorCode.Data_UpdateFail.getStatusCode(), (String)StringUtil.getErrorMsg((OperationResult)saveResult));
        return result;
    }

    public ApiCommonResult<OperationResult> saveOpenIpInfo(ThirdAppDto thirdAppDto) {
        OperationResult saveResult;
        if (thirdAppDto == null || thirdAppDto.getId() == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, " thirdAppDto is null or thirdAppDto.id is null\u3002", new Object[0]);
        }
        DynamicObject applyObj = BusinessDataServiceHelper.loadSingle((Object)thirdAppDto.getId(), (String)"third_app");
        applyObj.set("allowip", (Object)(thirdAppDto.isAllowip() ? "1" : "0"));
        DynamicObjectCollection saveBefore = applyObj.getDynamicObjectCollection("entryentity_ip");
        List list = thirdAppDto.getIpInfoDtoList() == null ? new ArrayList() : thirdAppDto.getIpInfoDtoList();
        Map saveAfter = list.stream().collect(Collectors.toMap(IpInfoDto::getEntryId, Function.identity(), (key1, key2) -> key2));
        HashMap beforeDetailMap = new HashMap();
        HashMap afterDetailMap = new HashMap();
        ArrayList beforeIdList = new ArrayList();
        ArrayList<Long> afterIdList = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty((Collection)saveBefore)) {
            saveBefore.forEach(before -> {
                beforeDetailMap.put(before.getLong("id"), before);
                beforeIdList.add(before.getLong("id"));
            });
        }
        if (saveAfter != null && saveAfter.size() > 0) {
            for (Map.Entry entry : saveAfter.entrySet()) {
                afterIdList.add(entry.getKey());
                afterDetailMap.put(entry.getKey(), entry.getValue());
            }
        }
        List updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        Iterator iterator = saveBefore.iterator();
        while (iterator.hasNext()) {
            DynamicObject ipInfo = (DynamicObject)iterator.next();
            Long id = ipInfo.getLong("id");
            if (deleteList.indexOf(id) > -1) {
                iterator.remove();
                continue;
            }
            if (updateList.indexOf(id) <= -1) continue;
            IpInfoDto afterDto = (IpInfoDto)afterDetailMap.get(id);
            ipInfo.set("startip", (Object)afterDto.getFromIp());
            ipInfo.set("endip", (Object)afterDto.getToIp());
            ipInfo.set("policytype", (Object)afterDto.getPolicyType());
        }
        DynamicObjectCollection entryEntity = saveBefore;
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        for (Long newId : addList) {
            IpInfoDto afterDto = (IpInfoDto)afterDetailMap.get(newId);
            DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
            dynamicObject.set("id", (Object)afterDto.getEntryId());
            dynamicObject.set("startip", (Object)afterDto.getFromIp());
            dynamicObject.set("endip", (Object)afterDto.getToIp());
            dynamicObject.set("policytype", (Object)afterDto.getPolicyType());
            entryEntity.add((Object)dynamicObject);
        }
        DynamicObjectCollection strategyList = applyObj.getDynamicObjectCollection("strategy");
        List<Object> lists = new ArrayList();
        Long strategyTypeId = 1651453463273433088L;
        if (!strategyList.isEmpty()) {
            lists = strategyList.stream().filter(st -> strategyTypeId.equals(st.getLong("strategytypeid.id"))).collect(Collectors.toList());
        }
        if (CollectionUtil.isEmpty(lists)) {
            DynamicObjectCollection strategyEntity = applyObj.getDynamicObjectCollection("strategy");
            DynamicObjectType strategyType = strategyEntity.getDynamicObjectType();
            DynamicObject dynamicObject = new DynamicObject(strategyType);
            dynamicObject.set("strategytypeid_id", (Object)strategyTypeId);
            dynamicObject.set("seq", (Object)strategyList.size());
            strategyList.add((Object)dynamicObject);
        }
        OperateOption option = OperateOption.create();
        if (thirdAppDto.isHasRight()) {
            option.setVariableValue("ishasright", String.valueOf(true));
        }
        boolean isSuccess = (saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"third_app", (DynamicObject[])new DynamicObject[]{applyObj}, (OperateOption)option)) == null ? true : saveResult.isSuccess();
        ApiCommonResult result = null;
        result = isSuccess ? ApiCommonResult.getSuccessResult((String)"0", (String)"") : ApiCommonResult.getFailResult((String)ApiErrorCode.Data_UpdateFail.getStatusCode(), (String)StringUtil.getErrorMsg((OperationResult)saveResult));
        return result;
    }

    public String genBasicSignToken(String thirdId, String agentUserId, String sysTag, String description) {
        if (StringUtil.isEmpty((String)thirdId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "thirdId is null.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)agentUserId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "agentUserId is null.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)sysTag)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "sysTag is null.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)description)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "description is null.", new Object[0]);
        }
        String accountId = RequestContext.get().getAccountId();
        Long userId = Long.valueOf(agentUserId);
        Long thirdAppId = Long.valueOf(thirdId);
        String sql = "select fbasesigncode from t_open_3rdapps_basicauth where fagentuserid=? and fid=? and fsysTag=? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fagentuserid", -5, (Object)userId), new SqlParameter(":fid", -5, (Object)thirdAppId), new SqlParameter(":fsysTag", 12, (Object)sysTag)};
        String baseCodeSign = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            String exitsBaseCode = "";
            while (rs.next()) {
                String baseCode = rs.getString("fbasesigncode");
                if (!StringUtil.isNotEmpty((String)baseCode)) continue;
                exitsBaseCode = baseCode;
                break;
            }
            return exitsBaseCode;
        });
        if (StringUtil.isNotEmpty((String)baseCodeSign)) {
            return EncryptUtil.genSignWithAccountId((String)EncryptUtil.decode((String)baseCodeSign), (String)accountId);
        }
        DynamicObject thirdApp = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(thirdId), (String)"third_app");
        thirdApp.set("isbasicauth", (Object)"1");
        DynamicObjectCollection entryEntity = thirdApp.getDynamicObjectCollection("entryentity_basicauth");
        String baseSecretKey = EncryptUtil.genSignString((String)thirdId, (String)agentUserId, (String)sysTag);
        DynamicObjectType dynamicObjectType = entryEntity.getDynamicObjectType();
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("id", (Object)DB.genLongId((String)"t_open_3rdapps_basicauth"));
        dynamicObject.set("agentuserid", (Object)userId);
        dynamicObject.set("basesigncode", (Object)EncryptUtil.encode((String)baseSecretKey));
        dynamicObject.set("basicstatus", (Object)"1");
        dynamicObject.set("agentuserid_id", (Object)userId);
        dynamicObject.set("type", (Object)"0");
        dynamicObject.set("systag", (Object)sysTag);
        dynamicObject.set("remark", (Object)description);
        entryEntity.add((Object)dynamicObject);
        DynamicObjectCollection strategyList = thirdApp.getDynamicObjectCollection("strategy");
        List<Object> list = new ArrayList();
        if (!strategyList.isEmpty()) {
            list = strategyList.stream().filter(st -> BASICAUTH_STRATEGY_ID.longValue() == st.getLong("strategytypeid.id")).collect(Collectors.toList());
        }
        if (CollectionUtil.isEmpty(list)) {
            DynamicObjectType strategyBasicType = strategyList.getDynamicObjectType();
            DynamicObject strategyObject = new DynamicObject(strategyBasicType);
            strategyObject.set("strategytypeid_id", (Object)BASICAUTH_STRATEGY_ID);
            strategyList.add((Object)strategyObject);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)"third_app", (DynamicObject[])new DynamicObject[]{thirdApp}, (OperateOption)option);
        ThirdAppServiceImpl.check(result);
        return EncryptUtil.genSignWithAccountId((String)baseSecretKey, (String)accountId);
    }
}

