/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.webservice;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.service.webservice.Java2WSDLInterface;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisService2WSDL11;
import org.apache.axis2.description.AxisService2WSDL20;
import org.apache.axis2.description.java2wsdl.DefaultNamespaceGenerator;
import org.apache.axis2.description.java2wsdl.DefaultSchemaGenerator;
import org.apache.axis2.description.java2wsdl.DocLitBareSchemaGenerator;
import org.apache.axis2.description.java2wsdl.Java2WSDLUtils;
import org.apache.axis2.description.java2wsdl.NamespaceGenerator;
import org.apache.axis2.description.java2wsdl.SchemaGenerator;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.util.Loader;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.XMLPrettyPrinter;

public class Java2WSDLBuilder
implements Java2WSDLInterface {
    public static final String ALL = "all";
    private OutputStream out;
    private String className;
    private ClassLoader classLoader;
    private String wsdlPrefix = "wsdl";
    private String serviceName = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String style = "document";
    private String use = "literal";
    private String locationUri;
    private ArrayList<String> extraClasses;
    private boolean nillableElementsAllowed = true;
    private boolean optionalElementsAllowed = true;
    private String nsGenClassName = null;
    private Map<String, String> pkg2nsMap = null;
    private boolean pretty = true;
    private String wsdlVersion = "1.1";
    private String schemaGenClassName = null;
    private boolean generateDocLitBare = false;
    private AxisConfiguration axisConfig;
    private String customSchemaLocation;
    private String mappingFileLocation;
    private HashMap<String, MessageReceiver> messageReceivers = null;
    private boolean disableSOAP11 = false;
    private boolean disableSOAP12 = false;
    private boolean disableREST = false;
    private String messagePartName;
    private String portTypeName;
    private String soap11BindingName;
    private String soap12BindingName;
    private String restBindingName;
    private String requestElementSuffix;
    private boolean anonymousTypesAllowed = true;

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader, HashMap<String, MessageReceiver> messageReceivers) {
        this(out, className, classLoader);
        this.messageReceivers = messageReceivers;
    }

    public Java2WSDLBuilder(OutputStream out, String className, ClassLoader classLoader) {
        try {
            ConfigurationContext configCtx = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.axisConfig = configCtx.getAxisConfiguration();
            this.out = out;
            this.className = className;
            this.classLoader = classLoader;
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "create Java2WSDLBuilder error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String getSchemaTargetNamespace() throws OpenApiException {
        if (this.schemaTargetNamespace == null) {
            try {
                this.schemaTargetNamespace = Java2WSDLUtils.schemaNamespaceFromClassName((String)this.className, (ClassLoader)this.classLoader, (NamespaceGenerator)this.resolveNSGen()).toString();
            }
            catch (Exception e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "wsdl/getSchemaTargetNamespace error:" + e.getMessage(), new Object[0]);
            }
        }
        return this.schemaTargetNamespace;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getLocationUri() {
        return this.locationUri;
    }

    @Override
    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String getUse() {
        return this.use;
    }

    @Override
    public void setUse(String use) {
        this.use = use;
    }

    @Override
    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    @Override
    public String getSchemaTargetNamespacePrefix() {
        if (this.schemaTargetNamespacePrefix == null) {
            this.schemaTargetNamespacePrefix = "ns";
        }
        return this.schemaTargetNamespacePrefix;
    }

    @Override
    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    public String getTargetNamespacePrefix() {
        if (this.targetNamespacePrefix == null) {
            this.targetNamespacePrefix = "tns";
        }
        return this.targetNamespacePrefix;
    }

    @Override
    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getWsdlPrefix() {
        return this.wsdlPrefix;
    }

    @Override
    public void setWsdlPrefix(String wsdlPrefix) {
        this.wsdlPrefix = wsdlPrefix;
    }

    @Override
    public boolean isGenerateDocLitBare() {
        return this.generateDocLitBare;
    }

    @Override
    public void setGenerateDocLitBare(boolean generateDocLitBare) {
        this.generateDocLitBare = generateDocLitBare;
    }

    @Override
    public void generateWSDL() throws OpenApiException {
        try {
            AxisService2WSDL11 g;
            String uri;
            SchemaGenerator schemaGenerator = this.resolveSchemaGen(this.classLoader, this.className, this.getSchemaTargetNamespace(), this.getSchemaTargetNamespacePrefix());
            ArrayList excludedOperation = new ArrayList();
            org.apache.axis2.deployment.util.Utils.addExcludeMethods(excludedOperation);
            schemaGenerator.setExcludeMethods(excludedOperation);
            schemaGenerator.setAttrFormDefault(this.getAttrFormDefault());
            schemaGenerator.setElementFormDefault(this.getElementFormDefault());
            schemaGenerator.setExtraClasses(this.getExtraClasses());
            schemaGenerator.setNsGen(this.resolveNSGen());
            schemaGenerator.setPkg2nsmap(this.getPkg2nsMap());
            schemaGenerator.setMappingFileLocation(this.getMappingFileLocation());
            schemaGenerator.setCustomSchemaLocation(this.getCustomSchemaLocation());
            if (this.getPkg2nsMap() != null && !this.getPkg2nsMap().isEmpty() && (this.getPkg2nsMap().containsKey(ALL) || this.getPkg2nsMap().containsKey(ALL.toUpperCase(Locale.ENGLISH)))) {
                schemaGenerator.setUseWSDLTypesNamespace(true);
            }
            if (this.messageReceivers == null) {
                this.messageReceivers = new HashMap();
                Class inOnlyMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver");
                MessageReceiver messageReceiver = (MessageReceiver)inOnlyMessageReceiver.newInstance();
                this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-only", messageReceiver);
                Class inoutMessageReceiver = Loader.loadClass((String)"org.apache.axis2.rpc.receivers.RPCMessageReceiver");
                MessageReceiver inOutmessageReceiver = (MessageReceiver)inoutMessageReceiver.newInstance();
                this.messageReceivers.put("http://www.w3.org/ns/wsdl/in-out", inOutmessageReceiver);
            }
            AxisService service = new AxisService();
            if (!this.nillableElementsAllowed) {
                service.addParameter("disallowNillableElements", (Object)"true");
            }
            if (!this.optionalElementsAllowed) {
                service.addParameter("disallowOptionalElements", (Object)"true");
            }
            if (this.messagePartName != null) {
                service.addParameter("messagePartName", (Object)this.messagePartName);
            }
            if (this.portTypeName != null) {
                service.addParameter("portTypeName", (Object)this.portTypeName);
            }
            if (this.soap11BindingName != null) {
                service.addParameter("soap11BindingName", (Object)this.soap11BindingName);
            }
            if (this.soap12BindingName != null) {
                service.addParameter("soap12BindingName", (Object)this.soap12BindingName);
            }
            if (this.restBindingName != null) {
                service.addParameter("restBindingName", (Object)this.restBindingName);
            }
            if (this.messagePartName != null) {
                service.addParameter("messagePartName", (Object)this.messagePartName);
            }
            if (this.requestElementSuffix != null) {
                service.addParameter("requestElementSuffix", (Object)this.requestElementSuffix);
            }
            if (!this.anonymousTypesAllowed) {
                service.addParameter("disallowAnonymousTypes", (Object)"true");
            }
            schemaGenerator.setAxisService(service);
            AxisService axisService = AxisService.createService((String)this.className, (String)(this.serviceName == null ? Java2WSDLUtils.getSimpleClassName((String)this.className) : this.serviceName), (AxisConfiguration)this.axisConfig, this.messageReceivers, (String)(this.targetNamespace == null ? Java2WSDLUtils.namespaceFromClassName((String)this.className, (ClassLoader)this.classLoader, (NamespaceGenerator)this.resolveNSGen()).toString() : this.targetNamespace), (ClassLoader)this.classLoader, (SchemaGenerator)schemaGenerator, (AxisService)service);
            schemaGenerator.setAxisService(axisService);
            axisService.setTargetNamespacePrefix(this.getTargetNamespacePrefix());
            axisService.setSchemaTargetNamespace(this.getSchemaTargetNamespace());
            axisService.setSchemaTargetNamespacePrefix(this.getSchemaTargetNamespacePrefix());
            if (this.disableREST) {
                axisService.addParameter("disableREST", (Object)this.disableREST);
            }
            if (this.disableSOAP11) {
                axisService.addParameter("disableSOAP11", (Object)this.disableSOAP11);
            }
            if (this.disableSOAP12) {
                axisService.addParameter("disableSOAP12", (Object)this.disableSOAP12);
            }
            if ((uri = this.locationUri) == null) {
                uri = "http://localhost:8080/axis2/services/" + (this.serviceName == null ? Java2WSDLUtils.getSimpleClassName((String)this.className) : this.serviceName);
            }
            this.setServiceEPR(axisService, uri);
            this.axisConfig.addService(axisService);
            if ("1.1".equals(this.wsdlVersion)) {
                g = new AxisService2WSDL11(axisService);
                g.setStyle(this.style);
                g.setUse(this.use);
                g.setCheckIfEndPointActive(false);
                OMElement wsdlElement = g.generateOM();
                if (!this.isPretty()) {
                    wsdlElement.serialize(this.out);
                } else {
                    XMLPrettyPrinter.prettify((OMElement)wsdlElement, (OutputStream)this.out);
                }
            } else {
                g = new AxisService2WSDL20(axisService);
                g.setCheckIfEndPointActive(false);
                OMElement wsdlElement = g.generateOM();
                if (!this.isPretty()) {
                    wsdlElement.serialize(this.out);
                } else {
                    XMLPrettyPrinter.prettify((OMElement)wsdlElement, (OutputStream)this.out);
                }
            }
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "make wsdl error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    @Override
    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    @Override
    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    @Override
    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    @Override
    public ArrayList<String> getExtraClasses() {
        return this.extraClasses;
    }

    @Override
    public void setExtraClasses(ArrayList<String> extraClasses) {
        this.extraClasses = extraClasses;
    }

    @Override
    public String getNsGenClassName() {
        return this.nsGenClassName;
    }

    @Override
    public void setNsGenClassName(String nsGenClassName) {
        this.nsGenClassName = nsGenClassName;
    }

    @Override
    public String getSchemaGenClassName() {
        return this.schemaGenClassName;
    }

    @Override
    public void setSchemaGenClassName(String schemaGenClassName) {
        this.schemaGenClassName = schemaGenClassName;
    }

    @Override
    public Map<String, String> getPkg2nsMap() {
        return this.pkg2nsMap;
    }

    @Override
    public void setPkg2nsMap(Map<String, String> pkg2nsMap) {
        this.pkg2nsMap = pkg2nsMap;
    }

    private NamespaceGenerator resolveNSGen() {
        DefaultNamespaceGenerator nsGen;
        if (this.nsGenClassName == null) {
            nsGen = new DefaultNamespaceGenerator();
        } else {
            try {
                nsGen = (NamespaceGenerator)Class.forName(this.nsGenClassName).newInstance();
            }
            catch (Exception e) {
                nsGen = new DefaultNamespaceGenerator();
            }
        }
        return nsGen;
    }

    private SchemaGenerator resolveSchemaGen(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws OpenApiException {
        SchemaGenerator schemaGen;
        if (this.schemaGenClassName == null) {
            schemaGen = this.createSchemaGen(loader, className, schematargetNamespace, schematargetNamespacePrefix);
        } else {
            try {
                Class<?> clazz = Class.forName(this.schemaGenClassName);
                Constructor<?> constructor = clazz.getConstructor(ClassLoader.class, String.class, String.class, String.class);
                schemaGen = (SchemaGenerator)constructor.newInstance(loader, className, schematargetNamespace, schematargetNamespacePrefix);
            }
            catch (Exception e) {
                schemaGen = this.createSchemaGen(loader, className, schematargetNamespace, schematargetNamespacePrefix);
            }
        }
        return schemaGen;
    }

    private SchemaGenerator createSchemaGen(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) {
        Object schemaGen = null;
        try {
            schemaGen = this.generateDocLitBare ? new DocLitBareSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null) : new DefaultSchemaGenerator(loader, className, schematargetNamespace, schematargetNamespacePrefix, null);
            return schemaGen;
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "wsdl/setServiceEPR error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public boolean isPretty() {
        return this.pretty;
    }

    @Override
    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    @Override
    public void setWSDLVersion(String wsdlVersion) {
        this.wsdlVersion = wsdlVersion;
    }

    private void setServiceEPR(AxisService axisService, String urlString) throws OpenApiException {
        try {
            String[] urls;
            for (String url : urls = urlString.split(",")) {
                org.apache.axis2.deployment.util.Utils.addSoap11Endpoint((AxisService)axisService, (String)url);
                org.apache.axis2.deployment.util.Utils.addSoap12Endpoint((AxisService)axisService, (String)url);
                if (!"http".equals(Utils.getURIScheme((String)url)) && !"https".equals(Utils.getURIScheme((String)url))) continue;
                org.apache.axis2.deployment.util.Utils.addHttpEndpoint((AxisService)axisService, (String)url);
            }
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "wsdl/setServiceEPR error:" + e.getMessage(), new Object[0]);
        }
    }

    @Override
    public String getCustomSchemaLocation() {
        return this.customSchemaLocation;
    }

    @Override
    public void setCustomSchemaLocation(String customSchemaLocation) {
        this.customSchemaLocation = customSchemaLocation;
    }

    @Override
    public String getMappingFileLocation() {
        return this.mappingFileLocation;
    }

    @Override
    public void setMappingFileLocation(String mappingFileLocation) {
        this.mappingFileLocation = mappingFileLocation;
    }

    @Override
    public boolean isNillableElementsAllowed() {
        return this.nillableElementsAllowed;
    }

    @Override
    public void setNillableElementsAllowed(boolean nillableElementsAllowed) {
        this.nillableElementsAllowed = nillableElementsAllowed;
    }

    @Override
    public boolean isOptionalElementsAllowed() {
        return this.optionalElementsAllowed;
    }

    @Override
    public void setOptionalElementsAllowed(boolean optionalElementsAllowed) {
        this.optionalElementsAllowed = optionalElementsAllowed;
    }

    @Override
    public boolean isDisableREST() {
        return this.disableREST;
    }

    @Override
    public void setDisableREST(boolean disableREST) {
        this.disableREST = disableREST;
    }

    @Override
    public boolean isDisableSOAP12() {
        return this.disableSOAP12;
    }

    @Override
    public void setDisableSOAP12(boolean disableSOAP12) {
        this.disableSOAP12 = disableSOAP12;
    }

    @Override
    public boolean isDisableSOAP11() {
        return this.disableSOAP11;
    }

    @Override
    public void setDisableSOAP11(boolean disableSOAP11) {
        this.disableSOAP11 = disableSOAP11;
    }

    @Override
    public String getMessagePartName() {
        return this.messagePartName;
    }

    @Override
    public void setMessagePartName(String messagePartName) {
        this.messagePartName = messagePartName;
    }

    @Override
    public String getPortTypeName() {
        return this.portTypeName;
    }

    @Override
    public void setPortTypeName(String portTypeName) {
        this.portTypeName = portTypeName;
    }

    @Override
    public String getSoap11BindingName() {
        return this.soap11BindingName;
    }

    @Override
    public void setSoap11BindingName(String soap11BindingName) {
        this.soap11BindingName = soap11BindingName;
    }

    @Override
    public String getSoap12BindingName() {
        return this.soap12BindingName;
    }

    @Override
    public void setSoap12BindingName(String soap12BindingName) {
        this.soap12BindingName = soap12BindingName;
    }

    @Override
    public String getRestBindingName() {
        return this.restBindingName;
    }

    @Override
    public void setRestBindingName(String restBindingName) {
        this.restBindingName = restBindingName;
    }

    @Override
    public String getRequestElementSuffix() {
        return this.requestElementSuffix;
    }

    @Override
    public void setRequestElementSuffix(String requestElementSuffix) {
        this.requestElementSuffix = requestElementSuffix;
    }

    @Override
    public boolean isAnonymousTypesAllowed() {
        return this.anonymousTypesAllowed;
    }

    @Override
    public void setAnonymousTypesAllowed(boolean anonymousTypesAllowed) {
        this.anonymousTypesAllowed = anonymousTypesAllowed;
    }
}

