/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.webservice;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.id.IDGenner;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.WsdlService;
import kd.bos.openapi.api.model.ServiceApiData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.BaseFilterResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ClassNameSpaceUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.IOUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.service.webservice.custom.Java2WSDLCustomBuilder;
import kd.bos.openapi.service.webservice.util.SchemaGeneratorUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WsdlServiceImpl
implements WsdlService {
    private static final Log log = LogFactory.getLog(WsdlServiceImpl.class);
    private static final String SOAP11_BINDING = "Soap11Binding";
    private static final String SOAP12_BINDING = "Soap12Binding";
    private static final String WSDL_VERSION_2 = "2.0";
    private static final String DEFAULT_SCHEMA_TARGET_NAME_SPACE_PREFIX = "nx";
    private static final String DEFAULT_TARGET_NAME_SPACE_PREFIX = "tns";
    private static final String DEFAULT_MESSAGE_PART_NAME = "parameters";
    private static final String SOAP_11 = "soap11";
    private static final String BODY_ENTRY = "bodyentryentity";
    private static final String BODY_LPARAMS_DES = "bodyparamdes";
    private static final String BODY_LEVEL = "body_level";
    private static final String PARAM_NAME = "paramname";
    private static final String PARAM_TYPE = "paramtype";
    private static final String PARAM_MUST = "must";
    private static final String IS_REQ_MUL_VALUE = "is_req_mul_value";
    private static final String NAME = "name";
    private static final String RESP_ENTRY = "respentryentity";
    private static final String RESP_LEVEL = "resp_level";
    private static final String RESP_DES = "respdes";
    private static final String IS_RESP_MUL_VALUE = "is_resp_mul_value";
    private static final String IS_RESP_MUST = "respparammust";
    private static final String RESP_PARAM_NAME = "respparamname";
    private static final String RESP_PARAM_TYPE = "respparamtype";
    private static final String METHOD_NAME = "methodname";
    private static final String OUTPUT_PARAMS = "wsoutputparam";
    private static final String INPUT_PARAMS = "wsinputparam";
    private static final String NUMBER = "number";
    private static final String NAMESPACE = "namespace";
    private static final String API_DEF_TYPE = "apideftype";
    private static final String FIELD_URL = "urlformat";
    private static final String OPEN_APISERVICE = "openapi_customapi";
    private static final String ID = "id";
    private static final String PID = "pid";
    private static final String KEY_NAME_SPACE = "nameSpace";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_METHOD = "method";
    private static final String KEY_WS_METHOD = "wsMethodName";
    private static final String INPUT = "ReqRes";
    private static final String OUTPUT = "output";
    private static final String URL_PREFIX = "kapi/";
    private static final String DEMO_TEST_CONTROLLER = "kd.bos.openapi.service.custom.demo.DemoTestController";
    private static final String DEMO_TEST_CONTROLLER_METHOD = "execute";
    private static Set<String> muleTypeSet = new HashSet<String>();
    public static IDGenner idGenner;

    private Map<String, String> getClassAndNameSpace(ServiceApiData serviceApiData) {
        String className = DEMO_TEST_CONTROLLER;
        String nameSpace = serviceApiData.getNamespace();
        String method = serviceApiData.getMethodName();
        String wsMethodName = serviceApiData.getWsMethodName();
        HashMap<String, String> res = new HashMap<String, String>();
        if (ApiServiceType.CUSTOM.name().equalsIgnoreCase(serviceApiData.getApiServiceType())) {
            nameSpace = StringUtil.isEmpty((String)nameSpace) ? this.genNameSpace(serviceApiData.getClassName()) : nameSpace;
        } else if (ApiServiceType.OPERATION.name().equalsIgnoreCase(serviceApiData.getApiServiceType()) || ApiServiceType.SCRIPT.name().equalsIgnoreCase(serviceApiData.getApiServiceType())) {
            nameSpace = serviceApiData.getNamespace();
            method = DEMO_TEST_CONTROLLER_METHOD;
        } else {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "makeWsdl getClassAndNameSpace exception: cannot support apiServiceType.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)nameSpace)) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "makeWsdl getClassAndNameSpace exception: please provide nameSpace.", new Object[0]);
        }
        Pair namespacePair = SoapUtil.getNamespace((String)nameSpace);
        res.put(KEY_NAME_SPACE, (String)namespacePair.getValue());
        res.put(KEY_CLASS_NAME, className);
        res.put(KEY_METHOD, method);
        res.put(KEY_WS_METHOD, wsMethodName);
        return res;
    }

    public String genWsdl(ServiceApiData serviceApiData, String soapVersion) {
        Map<String, String> classAndNameSpace = this.getClassAndNameSpace(serviceApiData);
        String className = classAndNameSpace.get(KEY_CLASS_NAME);
        String method = classAndNameSpace.get(KEY_METHOD);
        String wsMethodName = classAndNameSpace.get(KEY_WS_METHOD);
        String nameSpace = classAndNameSpace.get(KEY_NAME_SPACE);
        if (ApiDefType.WSDL.getCode().equalsIgnoreCase(serviceApiData.getApiDefType()) && ApiServiceType.CUSTOM.name().equalsIgnoreCase(serviceApiData.getApiServiceType()) && StringUtil.isNotEmpty((String)wsMethodName)) {
            method = wsMethodName;
        }
        CustomApiInfo customApiInfo = this.buildTreeParams(this.findCustomApiInfo(serviceApiData.getApiId(), classAndNameSpace), serviceApiData);
        boolean isSoap11 = SOAP_11.equalsIgnoreCase(soapVersion);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String url = this.getUrl();
            Java2WSDLCustomBuilder builder = null;
            builder = new Java2WSDLCustomBuilder(out, className, customApiInfo);
            builder.setLocationUri(url);
            if (isSoap11) {
                builder.setDisableSOAP12(false);
                builder.setDisableSOAP11(false);
                builder.setSoap11BindingName(SOAP11_BINDING);
                builder.setSoap12BindingName(SOAP12_BINDING);
            } else {
                builder.setDisableSOAP12(false);
                builder.setDisableSOAP11(true);
                builder.setWSDLVersion(WSDL_VERSION_2);
                builder.setSoap12BindingName(SOAP12_BINDING);
            }
            builder.setSchemaTargetNamespace(nameSpace);
            builder.setSchemaTargetNamespacePrefix(DEFAULT_SCHEMA_TARGET_NAME_SPACE_PREFIX);
            builder.setPretty(true);
            builder.setDisableREST(true);
            builder.setTargetNamespace(nameSpace);
            builder.setTargetNamespacePrefix(DEFAULT_TARGET_NAME_SPACE_PREFIX);
            builder.setMessagePartName(DEFAULT_MESSAGE_PART_NAME);
            builder.setGenerateDocLitBare(false);
            builder.setServiceName(method);
            builder.generateWSDL();
            String string = out.toString();
            return string;
        }
        catch (Exception e) {
            log.error("make wsdl exception, please check all the params dataType of " + className, (Throwable)e);
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "makeWsdl exception:please check all the params dataType of " + className + ",Reason:" + e.getMessage(), new Object[0]);
        }
        finally {
            IOUtil.closeQuietly((Closeable)out);
        }
    }

    private String getUrl() {
        String clientFullContextPath = RequestContext.get().getClientFullContextPath();
        String clientUrl = RequestContext.get().getClientUrl();
        if (StringUtil.isEmpty((String)clientFullContextPath) || StringUtil.isEmpty((String)clientUrl)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(clientFullContextPath).append(clientUrl.substring(clientUrl.indexOf(URL_PREFIX)));
        return stringBuilder.toString();
    }

    public String genNameSpace(String className) {
        return ClassNameSpaceUtil.genNameSpace((String)className, (ClassLoader)this.getClass().getClassLoader());
    }

    private List<CustomApiParam> buildTree(List<CustomApiParam> paramList, String apiServiceType) {
        if (CollectionUtil.isEmpty(paramList)) {
            return paramList;
        }
        if (ApiServiceType.OPERATION.name().equalsIgnoreCase(apiServiceType)) {
            this.handleFelx(paramList);
        }
        Map<Long, List<CustomApiParam>> collect = paramList.stream().collect(Collectors.groupingBy(CustomApiParam::getParentId));
        List<CustomApiParam> headList = collect.get(0L);
        ArrayList<CustomApiParam> list = new ArrayList<CustomApiParam>();
        if (CollectionUtil.isNotEmpty(headList)) {
            for (CustomApiParam head : headList) {
                WsdlServiceImpl.forEach(collect, head);
                list.add(head);
            }
        }
        return list;
    }

    private void handleFelx(List<CustomApiParam> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        for (CustomApiParam apiParam : paramList) {
            if (!DataType.FLEX.type().equalsIgnoreCase(apiParam.getParamType())) continue;
            Object flex = DataType.FLEX.defaultValue();
            apiParam.setParamType(DataType.STRUCT.type());
            if (!(flex instanceof Map)) continue;
            Map flexMap = (Map)flex;
            for (Map.Entry entry : flexMap.entrySet()) {
                CustomApiParam apiP = this.createCustomApiInfo(idGenner.nextId(), apiParam.getEntryId(), false, (String)entry.getKey(), DataType.STRING.type());
                Object entryValue = entry.getValue();
                if (entryValue instanceof Long) {
                    apiP.setParamType(DataType.LONG.type());
                } else if (entryValue instanceof Map) {
                    apiP.setParamType(DataType.STRUCT.type());
                    Map entryValueMap = (Map)entryValue;
                    for (Map.Entry entryValueMapEntry : entryValueMap.entrySet()) {
                        CustomApiParam apiPValue = this.createCustomApiInfo(idGenner.nextId(), apiP.getEntryId(), false, (String)entryValueMapEntry.getKey(), DataType.STRING.type());
                        apiP.addChild(apiPValue);
                    }
                }
                apiParam.addChild(apiP);
            }
        }
    }

    private CustomApiInfo buildTreeParams(CustomApiInfo customApiInfo, ServiceApiData serviceApiData) {
        String apiServiceType = serviceApiData.getApiServiceType();
        List<CustomApiParam> request = this.buildTree(customApiInfo.getRequest(), apiServiceType);
        ArrayList response = this.buildTree(customApiInfo.getResponse(), apiServiceType);
        if (ApiServiceType.OPERATION.name().equalsIgnoreCase(apiServiceType)) {
            if (ApiOperationType.getTypeByOp((String)serviceApiData.getApiOperationType()) == ApiOperationType.QUERY) {
                long dataId = idGenner.nextId();
                CustomApiParam data = this.createCustomApiInfo(dataId, 0L, false, "data", DataType.STRUCT.type());
                for (CustomApiParam customApiParam : request) {
                    customApiParam.setMulValue(this.isMulValue(customApiParam.getParamType()));
                    customApiParam.setParentId(Long.valueOf(dataId));
                }
                data.getChildList().addAll(request);
                ArrayList<CustomApiParam> requestList = new ArrayList<CustomApiParam>();
                requestList.add(data);
                requestList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "pageSize", DataType.INTEGER.type()));
                requestList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "pageNo", DataType.INTEGER.type()));
                requestList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "orderBy", DataType.STRING.type()));
                request = requestList;
                ArrayList<CustomApiParam> responseList = new ArrayList<CustomApiParam>();
                dataId = idGenner.nextId();
                data = this.createCustomApiInfo(dataId, 0L, false, "data", DataType.STRUCT.type());
                long rowId = idGenner.nextId();
                CustomApiParam rows = this.createCustomApiInfo(rowId, dataId, true, "rows", DataType.STRUCT.type());
                for (CustomApiParam customApiParam : response) {
                    customApiParam.setParentId(Long.valueOf(rowId));
                }
                rows.getChildList().addAll(response);
                data.getChildList().add(rows);
                data.getChildList().add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "filter", DataType.STRING.type()));
                data.getChildList().add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "lastPage", DataType.BOOLEAN.type()));
                data.getChildList().add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "pageNo", DataType.INTEGER.type()));
                data.getChildList().add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "pageSize", DataType.INTEGER.type()));
                data.getChildList().add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "totalCount", DataType.INTEGER.type()));
                responseList.add(data);
                responseList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "errorCode", DataType.STRING.type()));
                responseList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "message", DataType.STRING.type()));
                responseList.add(this.createCustomApiInfo(idGenner.nextId(), 0L, false, "status", DataType.BOOLEAN.type()));
                response = responseList;
            } else {
                Pair<List<CustomApiParam>, List<CustomApiParam>> savePair = this.getOpParams(serviceApiData.getApiOperationType(), request);
                request = (List<CustomApiParam>)savePair.getKey();
                response = (ArrayList)savePair.getValue();
            }
        } else if (ApiServiceType.SCRIPT.name().equalsIgnoreCase(apiServiceType)) {
            ArrayList<CustomApiParam> responseList = new ArrayList<CustomApiParam>();
            long dataId = idGenner.nextId();
            CustomApiParam data = this.createCustomApiInfo(dataId, 0L, false, "data", DataType.STRUCT.type());
            for (CustomApiParam customApiParam : response) {
                customApiParam.setParentId(Long.valueOf(dataId));
            }
            data.getChildList().addAll(response);
            responseList.add(data);
            responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "errorCode", DataType.STRING.type()));
            responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "message", DataType.STRING.type()));
            responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "status", DataType.BOOLEAN.type()));
            response = responseList;
        }
        ArrayList responseNewList = new ArrayList();
        if (serviceApiData.isOutParaWithoutStatus() && response.size() > 0) {
            for (CustomApiParam customParams : response) {
                if (!"data".equalsIgnoreCase(customParams.getParamName())) continue;
                responseNewList.addAll(customParams.getChildList());
                response = responseNewList;
                break;
            }
        }
        request = WsdlServiceImpl.updateEntryKeyValue(request);
        WsdlServiceImpl.updateMapParams(request, null);
        WsdlServiceImpl.updateMapParams(response, null);
        customApiInfo.setRequest(request);
        customApiInfo.setResponse((List)response);
        if (StringUtil.isEmpty((String)customApiInfo.getInputParamsName()) && CollectionUtil.isNotEmpty((Collection)customApiInfo.getRequest())) {
            customApiInfo.setInputParamsName(INPUT);
        }
        if (StringUtil.isEmpty((String)customApiInfo.getOutputParamsName()) && CollectionUtil.isNotEmpty((Collection)customApiInfo.getResponse())) {
            customApiInfo.setOutputParamsName(OUTPUT);
        }
        return customApiInfo;
    }

    private static List<CustomApiParam> updateEntryKeyValue(List<CustomApiParam> request) {
        ArrayList<CustomApiParam> requestNewList = new ArrayList<CustomApiParam>();
        for (int i = 0; i < request.size(); ++i) {
            CustomApiParam customApiParam2;
            CustomApiParam customApiParam = request.get(i);
            CustomApiParam customApiParam3 = customApiParam2 = i + 1 < request.size() ? request.get(i + 1) : new CustomApiParam();
            if ("$key$".equalsIgnoreCase(customApiParam.getParamName()) && "$value$".equalsIgnoreCase(customApiParam2.getParamName())) {
                CustomApiParam entry = new CustomApiParam();
                entry.setParamType("Entry");
                entry.setParamName("entry");
                entry.setMulValue(true);
                entry.setEntryId(Long.valueOf(idGenner.nextId()));
                customApiParam.setParentId(entry.getEntryId());
                customApiParam2.setParentId(entry.getEntryId());
                entry.addChild(customApiParam);
                entry.addChild(customApiParam2);
                requestNewList.add(entry);
                ++i;
                continue;
            }
            requestNewList.add(customApiParam);
        }
        return requestNewList;
    }

    private static void updateMapParams(List<CustomApiParam> request, CustomApiParam parent) {
        if (CollectionUtil.isEmpty(request)) {
            return;
        }
        for (int i = 0; i < request.size(); ++i) {
            CustomApiParam customApiParam = request.get(i);
            if (parent != null && parent.getEntryId() != null) {
                customApiParam.setParentId(parent.getEntryId());
            }
            if (customApiParam.getParamType() == null) continue;
            CustomApiParam newEntry = null;
            if (customApiParam.getParamType().startsWith("Map") || customApiParam.getParamType().startsWith("List<Map") || customApiParam.getParamType().startsWith("Set<Map")) {
                CustomApiParam entry = new CustomApiParam();
                entry.setParamType("Entry");
                entry.setParamName("entry");
                entry.setMulValue(true);
                entry.setParentId(customApiParam.getEntryId());
                entry.setEntryId(Long.valueOf(idGenner.nextId()));
                entry.getChildList().addAll(customApiParam.getChildList());
                newEntry = entry;
                customApiParam.getChildList().clear();
                customApiParam.getChildList().add(entry);
            }
            WsdlServiceImpl.updateMapParams(customApiParam.getChildList(), newEntry);
        }
    }

    private boolean isMulValue(String type) {
        if (StringUtil.isEmpty((String)type)) {
            return false;
        }
        return muleTypeSet.contains(type);
    }

    private Pair<List<CustomApiParam>, List<CustomApiParam>> getOpParams(String opType, List<CustomApiParam> request) {
        ApiOperationType.getTypeByOp((String)opType);
        long dataId = idGenner.nextId();
        CustomApiParam data = this.createCustomApiInfo(dataId, 0L, false, "data", DataType.STRUCT.type());
        ArrayList<CustomApiParam> requestList = new ArrayList<CustomApiParam>();
        for (CustomApiParam customApiParam : request) {
            customApiParam.setMulValue(this.isMulValue(customApiParam.getParamType()));
            customApiParam.setParentId(Long.valueOf(dataId));
        }
        data.getChildList().addAll(request);
        requestList.add(data);
        ArrayList<CustomApiParam> responseList = new ArrayList<CustomApiParam>();
        data = this.createCustomApiInfo(dataId, 0L, false, "data", DataType.STRUCT.type());
        data.getChildList().addAll(this.createClassInfo(ApiService.getTypeByOp((String)opType.toUpperCase()).getResultType().getClass(), "data", data.getEntryId()).getChildList());
        responseList.add(data);
        responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "errorCode", DataType.STRING.type()));
        responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "message", DataType.STRING.type()));
        responseList.add(this.createCustomApiInfo(idGenner.nextId(), dataId, false, "status", DataType.BOOLEAN.type()));
        Pair pair = new Pair(requestList, responseList);
        return pair;
    }

    private static void forEach(Map<Long, List<CustomApiParam>> collect, CustomApiParam treeMenuNode) {
        List<CustomApiParam> treeMenuNodes = collect.get(treeMenuNode.getEntryId());
        if (collect.get(treeMenuNode.getEntryId()) != null) {
            treeMenuNode.getChildList().addAll(treeMenuNodes);
            treeMenuNode.getChildList().forEach(t -> WsdlServiceImpl.forEach(collect, t));
        }
    }

    private CustomApiInfo findCustomApiInfo(Long apiId, Map<String, String> classAndNameSpace) {
        if (apiId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The apiId cannot be null!", new Object[0]);
        }
        DynamicObject apiObj = BusinessDataServiceHelper.loadSingle((Object)apiId, (String)OPEN_APISERVICE);
        if (apiObj == null || apiObj.getString(ID) == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "The apiId is null!", new Object[0]);
        }
        CustomApiInfo customApiInfo = new CustomApiInfo();
        customApiInfo.setNumber(apiObj.getString(NUMBER));
        customApiInfo.setName(apiObj.getString(NAME));
        customApiInfo.setUrl(apiObj.getString(FIELD_URL));
        customApiInfo.setInputParamsName(apiObj.getString(INPUT_PARAMS));
        customApiInfo.setOutputParamsName(apiObj.getString(OUTPUT_PARAMS));
        customApiInfo.setMethodName(apiObj.getString(METHOD_NAME));
        customApiInfo.setNamespace(apiObj.getString(NAMESPACE));
        customApiInfo.setApiId(apiObj.get(ID).toString());
        customApiInfo.setApidefType(apiObj.getString(API_DEF_TYPE));
        DynamicObjectCollection bodyCollection = apiObj.getDynamicObjectCollection(BODY_ENTRY);
        ArrayList<Iterator> request = new ArrayList<Iterator>();
        if (bodyCollection != null && !bodyCollection.isEmpty()) {
            for (int i = 0; i < bodyCollection.size(); ++i) {
                DynamicObject bodyParams = (DynamicObject)bodyCollection.get(i);
                Iterator customApiParam = this.createCustomApiInfo(bodyParams.getLong(ID), bodyParams.getLong(PID), Boolean.parseBoolean(bodyParams.getString(IS_REQ_MUL_VALUE)), bodyParams.getString(PARAM_NAME), bodyParams.getString(PARAM_TYPE), "1".equals(bodyParams.getString(PARAM_MUST)));
                customApiParam.setDesc(bodyParams.getString(BODY_LPARAMS_DES));
                customApiParam.setLevel(Integer.parseInt(bodyParams.getString(BODY_LEVEL)));
                request.add(customApiParam);
            }
        }
        customApiInfo.setRequest(request);
        DynamicObjectCollection resCollection = apiObj.getDynamicObjectCollection(RESP_ENTRY);
        ArrayList<CustomApiParam> response = new ArrayList<CustomApiParam>();
        if (resCollection != null && !resCollection.isEmpty()) {
            for (DynamicObject bodyParams : resCollection) {
                CustomApiParam customApiParam = this.createCustomApiInfo(bodyParams.getLong(ID), bodyParams.getLong(PID), Boolean.parseBoolean(bodyParams.getString(IS_RESP_MUL_VALUE)), bodyParams.getString(RESP_PARAM_NAME), bodyParams.getString(RESP_PARAM_TYPE), "1".equals(bodyParams.getString(IS_RESP_MUST)));
                customApiParam.setDesc(bodyParams.getString(RESP_DES));
                customApiParam.setLevel(StringUtil.isNotEmpty((String)bodyParams.getString(RESP_LEVEL)) ? Integer.parseInt(bodyParams.getString(RESP_LEVEL)) : 1);
                response.add(customApiParam);
            }
        }
        customApiInfo.setResponse(response);
        String method = classAndNameSpace.get(KEY_METHOD);
        String nameSpace = classAndNameSpace.get(KEY_NAME_SPACE);
        if (StringUtil.isEmpty((String)customApiInfo.getMethodName())) {
            customApiInfo.setMethodName(method);
        }
        if (StringUtil.isEmpty((String)customApiInfo.getNamespace())) {
            customApiInfo.setNamespace(nameSpace);
        }
        return customApiInfo;
    }

    private CustomApiParam createCustomApiInfo(Long entryId, Long parentId, boolean isMulValue, String paramName, String paramType) {
        return this.createCustomApiInfo(entryId, parentId, isMulValue, paramName, paramType, true);
    }

    private CustomApiParam createCustomApiInfo(Long entryId, Long parentId, boolean isMulValue, String paramName, String paramType, boolean isRequired) {
        CustomApiParam customApiParam = new CustomApiParam();
        customApiParam.setEntryId(entryId);
        customApiParam.setParentId(parentId);
        customApiParam.setMulValue(isMulValue);
        customApiParam.setParamName(paramName);
        customApiParam.setParamType(paramType);
        customApiParam.setRequired(isRequired);
        return customApiParam;
    }

    public static List<Field> getDeclaredField(Class<?> clazz) {
        ArrayList<Field> fieldLists = new ArrayList<Field>();
        while (clazz != Object.class) {
            try {
                Field[] fields = clazz.getDeclaredFields();
                fieldLists.addAll(Arrays.asList(fields));
            }
            catch (Exception e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while generating the WSDL\uff1a" + e.getMessage(), new Object[0]);
            }
            clazz = clazz.getSuperclass();
        }
        return fieldLists;
    }

    public CustomApiParam createClassInfo(Class<?> clz, String name, Long parentId) {
        List<Field> list = WsdlServiceImpl.getDeclaredField(clz);
        CustomApiParam classInfo = new CustomApiParam();
        classInfo.setParentId(parentId);
        Long fid = idGenner.nextId();
        classInfo.setEntryId(fid);
        classInfo.setParamName(name);
        classInfo.setParamType(DataType.STRUCT.type());
        classInfo.setMulValue(false);
        for (Field field : list) {
            String typename = field.getGenericType().getTypeName();
            CustomApiParam fieldInfo = new CustomApiParam();
            name = field.getName();
            if ("serialVersionUID".equals(name) || ApiSaveResult.class.getSimpleName().equalsIgnoreCase(clz.getSimpleName()) && ("inserts".equalsIgnoreCase(name) || "updates".equalsIgnoreCase(name)) || BaseFilterResult.class.getName().equalsIgnoreCase(clz.getGenericSuperclass().getTypeName()) && "message".equalsIgnoreCase(name)) continue;
            fieldInfo.setParamName(name);
            fieldInfo.setMulValue(false);
            Long ffid = idGenner.nextId();
            if (field.getGenericType() instanceof ParameterizedType) {
                Pair<String, CustomApiParam> typeinfo;
                int i;
                Type[] types;
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                Type rawType = type.getRawType();
                typename = this.getType(rawType);
                if (Map.class.equals((Object)rawType)) {
                    typename = DataType.STRUCT.type();
                    types = type.getActualTypeArguments();
                    for (i = 0; i < types.length; ++i) {
                        typeinfo = this.typeHandle(types[i], name, ffid);
                        CustomApiParam keyParams = this.createCustomApiInfo(idGenner.nextId(), ffid, false, i == 0 ? "key" : "value", (String)typeinfo.getKey());
                        keyParams.setMulValue(false);
                        if (typeinfo.getValue() != null) {
                            keyParams.addChild((CustomApiParam)typeinfo.getValue());
                        }
                        fieldInfo.addChild(keyParams);
                    }
                    fieldInfo.setMulValue(true);
                } else if (Set.class.equals((Object)rawType) || List.class.equals((Object)rawType)) {
                    types = type.getActualTypeArguments();
                    for (i = 0; i < types.length; ++i) {
                        typeinfo = this.typeHandle(types[i], name, ffid);
                        fieldInfo.setParamsExtType((String)typeinfo.getKey());
                        if (typeinfo.getValue() == null) continue;
                        fieldInfo.getChildList().addAll(((CustomApiParam)typeinfo.getValue()).getChildList());
                    }
                    fieldInfo.setMulValue(true);
                }
            } else if (field.getGenericType() instanceof Class) {
                CustomApiParam classinfo;
                typename = this.getType(field.getGenericType());
                if (!SchemaGeneratorUtil.isBaseTypeName(typename) && (classinfo = this.createClassInfo((Class)field.getGenericType(), name, ffid)) != null) {
                    fieldInfo.addChild(classinfo);
                }
            } else {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5", (String)"WsdlServiceImpl_0", (String)"bos-open-service", (Object[])new Object[0]), new Object[0]);
            }
            fieldInfo.setParamType(typename);
            fieldInfo.setParentId(fid);
            fieldInfo.setEntryId(ffid);
            classInfo.addChild(fieldInfo);
        }
        return classInfo;
    }

    private String getType(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return "";
    }

    private Pair<String, CustomApiParam> typeHandle(Type type, String name, Long fid) {
        String extType = "";
        CustomApiParam classInfo = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            extType = this.getType(rawType);
        } else if (type instanceof Class && !SchemaGeneratorUtil.isBaseTypeName(extType = this.getType(type)) && !type.getTypeName().contains("java.lang") && !type.getTypeName().contains("java.util")) {
            classInfo = this.createClassInfo((Class)type, name, fid);
        }
        return new Pair((Object)extType, classInfo);
    }

    static {
        muleTypeSet.add(DataType.ARRAY_DATE.type());
        muleTypeSet.add(DataType.ARRAY_LONG.type());
        muleTypeSet.add(DataType.ARRAY_STRING.type());
        muleTypeSet.add(DataType.ARRAY_INTEGER.type());
        idGenner = new IDGenner(IDGenner.default_max_worker_id, System.currentTimeMillis());
    }
}

