/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.webservice.custom;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.custom.info.CustomApiInfo;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.webservice.constant.OpenWSDLConstants;
import kd.bos.openapi.service.webservice.util.SchemaGeneratorUtil;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.WSDL2Constants;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;

public class AxisCustomService2WSDL20
implements WSDL2Constants {
    private static final Log log = LogFactory.getLog(AxisCustomService2WSDL20.class);
    protected AxisService axisService;
    protected String serviceName;
    private String[] eprs = null;
    private OMNamespace wsaw;
    private OMNamespace wsdl;
    private OMNamespace wsoap;
    private OMNamespace whttp;
    private OMNamespace wsdlx;
    private OMNamespace wrpc;
    private OMNamespace tns;
    private String interfaceName;
    private CustomApiInfo customApiInfo;
    private HashMap policiesInDescription = new HashMap();
    private ExternalPolicySerializer filter = null;
    private boolean checkIfEndPointActive = true;

    public AxisCustomService2WSDL20(AxisService service, CustomApiInfo customApiInfo) {
        this.axisService = service;
        this.serviceName = service.getName();
        this.customApiInfo = customApiInfo;
    }

    public void setCheckIfEndPointActive(boolean flag) {
        this.checkIfEndPointActive = flag;
    }

    public OMElement generateOM() throws OpenApiException {
        OMElement types;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement descriptionElement = this.generateDescription(omFactory);
        OMElement documentation = this.generateDocumentation(omFactory);
        if (documentation != null) {
            descriptionElement.addChild((OMNode)documentation);
        }
        if ((types = this.generateCustomTypes(omFactory)) != null) {
            descriptionElement.addChild((OMNode)types);
        }
        try {
            OMElement interfaces = this.generateCustomInterface(omFactory);
            if (interfaces != null) {
                descriptionElement.addChild((OMNode)interfaces);
            }
            this.generateService(omFactory, descriptionElement, this.isDisableREST(), this.isDisableSOAP12(), this.isDisableSOAP11());
            this.addPoliciesToDescriptionElement(this.getPoliciesInDefinitions(), descriptionElement);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "generate wsdl error:" + e.getMessage(), new Object[0]);
        }
        return descriptionElement;
    }

    private OMElement getInterfaceElement(OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMNamespace wrpc, OMFactory fac, String interfaceName) throws URISyntaxException, AxisFault, XMLStreamException, FactoryConfigurationError {
        OMElement interfaceElement = fac.createOMElement("interface", wsdl);
        interfaceElement.addAttribute(fac.createOMAttribute("name", null, interfaceName));
        this.addPolicyAsExtensibleElement((AxisDescription)this.axisService, interfaceElement);
        Iterator iterator = this.axisService.getOperations();
        ArrayList<OMElement> interfaceOperations = new ArrayList<OMElement>();
        ArrayList<String> interfaceFaults = new ArrayList<String>();
        int i = 0;
        while (iterator.hasNext()) {
            AxisOperation axisOperation = (AxisOperation)iterator.next();
            if (axisOperation.isControlOperation()) continue;
            interfaceOperations.add(i, this.generateInterfaceOperationElement(axisOperation, wsdl, tns, wsdlx, wrpc));
            ++i;
            for (AxisMessage faultMessage : axisOperation.getFaultMessages()) {
                String name = faultMessage.getName();
                if (interfaceFaults.contains(name)) continue;
                OMElement faultElement = fac.createOMElement("fault", wsdl);
                faultElement.addAttribute(fac.createOMAttribute("name", null, name));
                faultElement.addAttribute(fac.createOMAttribute("element", null, WSDLSerializationUtil.getElementName((AxisMessage)faultMessage, (Map)this.axisService.getNamespaceMap())));
                interfaceFaults.add(name);
                interfaceElement.addChild((OMNode)faultElement);
            }
        }
        for (i = 0; i < interfaceOperations.size(); ++i) {
            interfaceElement.addChild((OMNode)interfaceOperations.get(i));
        }
        return interfaceElement;
    }

    private OMElement getServiceElement(OMNamespace wsdl, OMNamespace tns, OMFactory omFactory, String interfaceName) {
        OMElement serviceElement = omFactory.createOMElement("service", wsdl);
        serviceElement.addAttribute(omFactory.createOMAttribute("name", null, this.serviceName));
        serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + interfaceName));
        return serviceElement;
    }

    public OMElement generateInterfaceOperationElement(AxisOperation axisOperation, OMNamespace wsdl, OMNamespace tns, OMNamespace wsdlx, OMNamespace wrpc) throws URISyntaxException, AxisFault, XMLStreamException, FactoryConfigurationError {
        ArrayList faults;
        AxisMessage outMessage;
        String mep;
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement axisOperationElement = omFactory.createOMElement("operation", wsdl);
        WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)axisOperation, (OMElement)axisOperationElement, (OMFactory)omFactory, (OMNamespace)wsdl);
        axisOperationElement.addAttribute(omFactory.createOMAttribute("name", null, axisOperation.getName().getLocalPart()));
        this.addPolicyAsExtensibleElement((AxisDescription)axisOperation, axisOperationElement);
        URI[] opStyle = (URI[])axisOperation.getParameterValue("operationStyle");
        if (opStyle == null) {
            opStyle = this.checkStyle(axisOperation);
            Parameter opStyleParameter = new Parameter();
            opStyleParameter.setName("operationStyle");
            opStyleParameter.setValue((Object)opStyle);
            axisOperation.addParameter(opStyleParameter);
        }
        if (opStyle != null && opStyle.length > 0) {
            StringBuilder style = new StringBuilder();
            style.append(opStyle[0].toString());
            for (int i = 1; i < opStyle.length; ++i) {
                URI uri = opStyle[i];
                style.append(" ").append(uri);
            }
            axisOperationElement.addAttribute(omFactory.createOMAttribute("style", null, style.toString()));
            if (style.indexOf("http://www.w3.org/ns/wsdl/style/rpc") >= 0) {
                axisOperationElement.addAttribute(omFactory.createOMAttribute("signature", wrpc, (String)axisOperation.getParameterValue("wrpc:signature")));
            }
        }
        axisOperationElement.addAttribute(omFactory.createOMAttribute("pattern", null, axisOperation.getMessageExchangePattern()));
        Parameter param = axisOperation.getParameter("wsdlx:safe");
        if (param != null) {
            axisOperationElement.addAttribute(omFactory.createOMAttribute("safe", wsdlx, param.getValue().toString()));
        }
        AxisService axisService = axisOperation.getAxisService();
        Map nameSpaceMap = axisService.getNamespaceMap();
        AxisMessage inMessage = (AxisMessage)axisOperation.getChild((Object)"inMessage");
        if (inMessage != null) {
            OMElement inMessageElement = omFactory.createOMElement("input", wsdl);
            inMessageElement.addAttribute(omFactory.createOMAttribute("element", null, axisService.getSchemaTargetNamespacePrefix() + ":" + this.customApiInfo.getInputParamsName()));
            WSDLSerializationUtil.addWSAWActionAttribute((OMElement)inMessageElement, (String)axisOperation.getInputAction(), (OMNamespace)this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)inMessage, (OMElement)inMessageElement, (OMFactory)omFactory, (OMNamespace)wsdl);
            axisOperationElement.addChild((OMNode)inMessageElement);
        }
        if (("http://www.w3.org/ns/wsdl/out-only".equals(mep = axisOperation.getMessageExchangePattern()) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(mep) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(mep) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep)) && (outMessage = (AxisMessage)axisOperation.getChild((Object)"outMessage")) != null) {
            OMElement outMessageElement = omFactory.createOMElement("output", wsdl);
            outMessageElement.addAttribute(omFactory.createOMAttribute("element", null, axisService.getSchemaTargetNamespacePrefix() + ":" + this.customApiInfo.getOutputParamsName()));
            WSDLSerializationUtil.addWSAWActionAttribute((OMElement)outMessageElement, (String)axisOperation.getOutputAction(), (OMNamespace)this.wsaw);
            WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)outMessage, (OMElement)outMessageElement, (OMFactory)omFactory, (OMNamespace)wsdl);
            axisOperationElement.addChild((OMNode)outMessageElement);
        }
        if ((faults = axisOperation.getFaultMessages()) != null) {
            for (AxisMessage faultMessage : faults) {
                OMElement faultElement = "in".equals(faultMessage.getDirection()) ? omFactory.createOMElement("infault", wsdl) : omFactory.createOMElement("outfault", wsdl);
                faultElement.addAttribute(omFactory.createOMAttribute("ref", null, tns.getPrefix() + ":" + faultMessage.getName()));
                WSDLSerializationUtil.addWSAWActionAttribute((OMElement)faultElement, (String)axisOperation.getFaultAction(faultMessage.getName()), (OMNamespace)this.wsaw);
                WSDLSerializationUtil.addWSDLDocumentationElement((AxisDescription)faultMessage, (OMElement)faultElement, (OMFactory)omFactory, (OMNamespace)wsdl);
                axisOperationElement.addChild((OMNode)faultElement);
            }
        }
        return axisOperationElement;
    }

    public void setEPRs(String[] eprs) {
        this.eprs = eprs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URI[] checkStyle(AxisOperation axisOperation) throws URISyntaxException, AxisFault {
        boolean isRPC = true;
        boolean isMultipart = true;
        boolean isIRI = true;
        ArrayList<URI> styles = new ArrayList<URI>(3);
        String mep = axisOperation.getMessageExchangePattern();
        if (!"http://www.w3.org/ns/wsdl/in-only".equals(mep) && !"http://www.w3.org/ns/wsdl/in-out".equals(mep)) {
            isRPC = false;
        }
        LinkedHashMap<String, QName> inMessageElementDetails = new LinkedHashMap<String, QName>();
        AxisMessage inMessage = axisOperation.getMessage("In");
        if (inMessage == null) return new URI[0];
        QName qName = inMessage.getElementQName();
        if (qName == null || Constants.XSD_ANY.equals(qName)) {
            return new URI[0];
        }
        XmlSchemaElement schemaElement = inMessage.getSchemaElement();
        if (schemaElement == null) return new URI[0];
        if (!axisOperation.getName().getLocalPart().equals(schemaElement.getName())) {
            return new URI[0];
        }
        QName inMessageElementQname = schemaElement.getQName();
        XmlSchemaType type = schemaElement.getSchemaType();
        if (!(type instanceof XmlSchemaComplexType)) return new URI[0];
        XmlSchemaComplexType complexType = (XmlSchemaComplexType)type;
        XmlSchemaParticle particle = complexType.getParticle();
        if (!(particle instanceof XmlSchemaSequence)) return new URI[0];
        XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
        if (!xmlSchemaSequence.getItems().isEmpty()) {
            for (XmlSchemaSequenceMember member : xmlSchemaSequence.getItems()) {
                String name;
                if (!(member instanceof XmlSchemaElement)) {
                    return new URI[0];
                }
                XmlSchemaElement innerElement = (XmlSchemaElement)member;
                if (innerElement.getRef().getTargetQName() != null) {
                    return new URI[0];
                }
                if (innerElement.getMinOccurs() != 1L || innerElement.getMaxOccurs() != 1L) {
                    isMultipart = false;
                }
                XmlSchemaType schemaType = innerElement.getSchemaType();
                QName innerElementQName = innerElement.getSchemaTypeName();
                if (schemaType instanceof XmlSchemaSimpleType) {
                    if (Constants.XSD_QNAME.equals(innerElementQName) || Constants.XSD_NOTATION.equals(innerElementQName) || Constants.XSD_HEXBIN.equals(innerElementQName) || Constants.XSD_BASE64.equals(innerElementQName)) {
                        isIRI = false;
                    }
                } else {
                    isIRI = false;
                }
                if (Constants.XSD_ANY.equals(innerElementQName)) {
                    isRPC = false;
                }
                if (inMessageElementDetails.get(name = innerElement.getName()) != null) {
                    isRPC = false;
                    isMultipart = false;
                }
                inMessageElementDetails.put(name, innerElementQName);
            }
        }
        AxisMessage outMessage = null;
        LinkedHashMap<String, QName> outMessageElementDetails = new LinkedHashMap<String, QName>();
        if (isRPC && !"http://www.w3.org/ns/wsdl/in-only".equals(mep)) {
            outMessage = axisOperation.getMessage("Out");
            QName qName2 = outMessage.getElementQName();
            XmlSchemaElement schemaElement2 = outMessage.getSchemaElement();
            if (schemaElement2 != null) {
                XmlSchemaType type2;
                if (!(axisOperation.getName().getLocalPart() + "Response").equals(schemaElement2.getName())) {
                    isRPC = false;
                }
                if (!schemaElement2.getQName().getNamespaceURI().equals(inMessageElementQname.getNamespaceURI())) {
                    isRPC = false;
                }
                if ((type2 = schemaElement2.getSchemaType()) instanceof XmlSchemaComplexType) {
                    XmlSchemaComplexType complexType2 = (XmlSchemaComplexType)type2;
                    XmlSchemaParticle particle2 = complexType2.getParticle();
                    if (particle2 instanceof XmlSchemaSequence) {
                        XmlSchemaSequence xmlSchemaSequence2 = (XmlSchemaSequence)particle2;
                        if (!xmlSchemaSequence2.getItems().isEmpty()) {
                            for (XmlSchemaSequenceMember member : xmlSchemaSequence2.getItems()) {
                                QName inMessageElementType;
                                if (!(member instanceof XmlSchemaElement)) {
                                    isRPC = false;
                                }
                                XmlSchemaElement innerElement = (XmlSchemaElement)member;
                                QName schemaTypeName = innerElement.getSchemaTypeName();
                                String name = innerElement.getName();
                                if (innerElement.getRef().getTargetQName() != null) {
                                    isRPC = false;
                                }
                                if (outMessageElementDetails.get(name) != null) {
                                    isRPC = false;
                                }
                                if ((inMessageElementType = (QName)inMessageElementDetails.get(name)) != null && inMessageElementType != schemaTypeName) {
                                    isRPC = false;
                                }
                                outMessageElementDetails.put(name, schemaTypeName);
                            }
                        }
                    } else {
                        isRPC = false;
                    }
                } else {
                    isRPC = false;
                }
            } else {
                isRPC = false;
            }
        }
        int count = 0;
        if (isRPC) {
            styles.add(new URI("http://www.w3.org/ns/wsdl/style/rpc"));
            axisOperation.addParameter("wrpc:signature", (Object)this.generateRPCSignature(inMessageElementDetails, outMessageElementDetails));
            ++count;
        }
        if (isIRI) {
            styles.add(new URI("http://www.w3.org/ns/wsdl/style/iri"));
            ++count;
        }
        if (!isMultipart) return styles.toArray(new URI[count]);
        styles.add(new URI("http://www.w3.org/ns/wsdl/style/multipart"));
        ++count;
        return styles.toArray(new URI[count]);
    }

    private String generateRPCSignature(Map inMessageElementDetails, Map outMessageElementDetails) {
        StringBuilder in = new StringBuilder();
        StringBuilder out = new StringBuilder();
        StringBuilder inOut = new StringBuilder();
        Set inElementSet = inMessageElementDetails.keySet();
        Set outElementSet = outMessageElementDetails.keySet();
        for (String inElementName : inElementSet) {
            if (outElementSet.remove(inElementName)) {
                inOut.append(inElementName).append(" ").append("#inout").append(" ");
                continue;
            }
            in.append(inElementName).append(" ").append("#in").append(" ");
        }
        for (String outElementName : outElementSet) {
            out.append(outElementName).append(" ").append("#return").append(" ");
        }
        return in.append((CharSequence)out).append((CharSequence)inOut).toString();
    }

    private void addPolicyAsExtensibleElement(AxisDescription axisDescription, OMElement descriptionElement) throws XMLStreamException, FactoryConfigurationError, AxisFault {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        Collection attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        for (Object policyElement : attachPolicyComponents) {
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                PolicyReference policyReference = PolicyUtil.createPolicyReference((Policy)((Policy)policyElement));
                OMElement policyRefElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyReference, (ExternalPolicySerializer)this.filter);
                OMElement firstChildElem = descriptionElement.getFirstElement();
                if (firstChildElem == null) {
                    descriptionElement.addChild((OMNode)policyRefElement);
                } else {
                    firstChildElem.insertSiblingBefore((OMNode)policyRefElement);
                }
                String key = policyReference.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                this.policiesInDescription.put(key, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMElement child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)((PolicyComponent)policyElement));
            OMElement firstChildElem = descriptionElement.getFirstElement();
            if (firstChildElem == null) {
                descriptionElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(this.axisService)).lookup(key)) == null) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "Policy cannot be found, the uri is " + key, new Object[0]);
            }
            this.policiesInDescription.put(key, p);
        }
    }

    protected void addPoliciesToDescriptionElement(List policies, OMElement descriptionElement) throws XMLStreamException, FactoryConfigurationError {
        for (int i = 0; i < policies.size(); ++i) {
            Policy policy = (Policy)policies.get(i);
            OMElement policyElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policy, (ExternalPolicySerializer)this.filter);
            OMNode firstChild = descriptionElement.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore((OMNode)policyElement);
                continue;
            }
            descriptionElement.addChild((OMNode)policyElement);
        }
    }

    protected OMElement generateDescription(OMFactory omFactory) {
        Map nameSpacesMap = this.axisService.getNamespaceMap();
        this.filter = new ExternalPolicySerializer();
        AxisConfiguration axisConfiguration = this.axisService.getAxisConfiguration();
        if (axisConfiguration != null) {
            this.filter.setAssertionsToFilter(axisConfiguration.getLocalPolicyAssertions());
        }
        this.wsdl = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", WSDLSerializationUtil.getPrefix((String)"http://www.w3.org/ns/wsdl", (Map)nameSpacesMap)) : omFactory.createOMNamespace("http://www.w3.org/ns/wsdl", "wsdl2");
        OMElement descriptionElement = omFactory.createOMElement("description", this.wsdl);
        WSDLSerializationUtil.populateNamespaces((OMElement)descriptionElement, (Map)nameSpacesMap);
        descriptionElement.declareNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        this.wsaw = descriptionElement.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        OMAttribute targetNamespace = omFactory.createOMAttribute("targetNamespace", null, this.axisService.getTargetNamespace());
        descriptionElement.addAttribute(targetNamespace);
        this.tns = omFactory.createOMNamespace(this.axisService.getTargetNamespace(), this.axisService.getTargetNamespacePrefix());
        this.wsoap = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/soap") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/soap", WSDLSerializationUtil.getPrefix((String)"http://www.w3.org/ns/wsdl/soap", (Map)nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/soap", "wsoap");
        this.whttp = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/http") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/http", WSDLSerializationUtil.getPrefix((String)"http://www.w3.org/ns/wsdl/http", (Map)nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/http", "whttp");
        this.wsdlx = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl-extensions") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl-extensions", WSDLSerializationUtil.getPrefix((String)"http://www.w3.org/ns/wsdl-extensions", (Map)nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl-extensions", "wsdlx");
        this.wrpc = nameSpacesMap != null && nameSpacesMap.containsValue("http://www.w3.org/ns/wsdl/rpc") ? omFactory.createOMNamespace("http://www.w3.org/ns/wsdl/rpc", WSDLSerializationUtil.getPrefix((String)"http://www.w3.org/ns/wsdl/rpc", (Map)nameSpacesMap)) : descriptionElement.declareNamespace("http://www.w3.org/ns/wsdl/rpc", "wrpc");
        return descriptionElement;
    }

    protected OMElement generateDocumentation(OMFactory omFactory) {
        return WSDLSerializationUtil.generateDocumentationElement((AxisDescription)this.axisService, (OMFactory)omFactory, (OMNamespace)this.wsdl);
    }

    protected XmlSchemaForm getAttrFormDefaultSetting() {
        return XmlSchemaForm.schemaValueOf((String)"unqualified");
    }

    protected XmlSchemaForm getElementFormDefaultSetting() {
        return XmlSchemaForm.schemaValueOf((String)"unqualified");
    }

    protected XmlSchema getXmlSchema(String targetNamespace) {
        String targetNamespacePrefix = "";
        XmlSchema xmlSchema = new XmlSchema(targetNamespace, new XmlSchemaCollection());
        xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
        xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
        NamespaceMap prefixmap = new NamespaceMap();
        prefixmap.put((Object)"xsd", (Object)"http://www.w3.org/2001/XMLSchema");
        prefixmap.put((Object)targetNamespacePrefix, (Object)targetNamespace);
        xmlSchema.setNamespaceContext((NamespacePrefixList)prefixmap);
        return xmlSchema;
    }

    protected OMElement generateCustomTypes(OMFactory fac) {
        XmlSchemaComplexType xmlSchemaComplexType;
        XmlSchemaAnnotation anno;
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        String inputName = this.customApiInfo.getInputParamsName();
        boolean hasInputParams = StringUtil.isNotEmpty((String)inputName);
        String outputName = this.customApiInfo.getOutputParamsName();
        boolean hasOutputParams = StringUtil.isNotEmpty((String)outputName);
        List inputParams = this.customApiInfo.getRequest();
        List outputParams = this.customApiInfo.getResponse();
        String inputNameDT = "DT_" + inputName;
        String outputNameDT = "DT_" + outputName;
        XmlSchema xmlSchema = this.getXmlSchema(this.axisService.getTargetNamespace());
        if (hasInputParams) {
            XmlSchemaElement elt1 = new XmlSchemaElement(xmlSchema, false);
            elt1.setName(inputName);
            elt1.setSchemaTypeName(SchemaGeneratorUtil.createQname(inputNameDT));
            xmlSchema.getItems().add(elt1);
        }
        if (hasOutputParams) {
            XmlSchemaElement elt2 = new XmlSchemaElement(xmlSchema, false);
            elt2.setName(outputName);
            elt2.setSchemaTypeName(SchemaGeneratorUtil.createQname(outputNameDT));
            xmlSchema.getItems().add(elt2);
        }
        if (hasInputParams) {
            XmlSchemaComplexType inputNameComplexType = new XmlSchemaComplexType(xmlSchema, true);
            inputNameComplexType.setName(inputNameDT);
            inputNameComplexType.setAnnotation(SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open", OpenWSDLConstants.APPINFO, this.customApiInfo.getName() + " " + this.customApiInfo.getNumber()));
            ArrayList<XmlSchemaElement> list = new ArrayList<XmlSchemaElement>();
            for (CustomApiParam customApiParam : inputParams) {
                anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam.getEntryId().toString(), customApiParam.getDesc());
                xmlSchemaComplexType = this.createComplexType(customApiParam, xmlSchema);
                list.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam.getParamName(), customApiParam.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, SchemaGeneratorUtil.isComplexType(customApiParam) ? null : SchemaGeneratorUtil.getParamType(customApiParam), anno, (XmlSchemaComplexType)(SchemaGeneratorUtil.isComplexType(customApiParam) ? xmlSchemaComplexType : null), customApiParam.isRequired() ? 1L : 0L));
            }
            XmlSchemaSequence inputNameComplexTypeSequence = SchemaGeneratorUtil.createSequence(list);
            inputNameComplexType.setParticle((XmlSchemaParticle)inputNameComplexTypeSequence);
        }
        if (hasOutputParams) {
            XmlSchemaComplexType outputNameComplexType = new XmlSchemaComplexType(xmlSchema, true);
            outputNameComplexType.setName(outputNameDT);
            outputNameComplexType.setAnnotation(SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open", OpenWSDLConstants.APPINFO, null));
            ArrayList<XmlSchemaElement> outlist = new ArrayList<XmlSchemaElement>();
            for (CustomApiParam customApiParam : outputParams) {
                anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam.getEntryId().toString(), customApiParam.getDesc());
                xmlSchemaComplexType = this.createComplexType(customApiParam, xmlSchema);
                outlist.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam.getParamName(), customApiParam.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, SchemaGeneratorUtil.isComplexType(customApiParam) ? null : SchemaGeneratorUtil.getParamType(customApiParam), anno, (XmlSchemaComplexType)(SchemaGeneratorUtil.isComplexType(customApiParam) ? xmlSchemaComplexType : null), customApiParam.isRequired() ? 1L : 0L));
            }
            XmlSchemaSequence outputNameComplexTypeSequence = SchemaGeneratorUtil.createSequence(outlist);
            outputNameComplexType.setParticle((XmlSchemaParticle)outputNameComplexTypeSequence);
        }
        StringWriter writer = new StringWriter();
        xmlSchema.write((Writer)writer);
        String schemaString = writer.toString();
        if (!"".equals(schemaString)) {
            try {
                wsdlTypes.addChild(XMLUtils.toOM((Reader)new StringReader(schemaString)));
            }
            catch (XMLStreamException e) {
                log.error("writer xml error:", (Throwable)e);
                return null;
            }
        }
        return wsdlTypes;
    }

    private XmlSchemaComplexType createComplexType(CustomApiParam customApiParam, XmlSchema xmlSchema) {
        if (CollectionUtil.isEmpty((Collection)customApiParam.getChildList())) {
            return null;
        }
        Object xmlSchemaComplexType = null;
        ArrayList<XmlSchemaElement> elementList2 = new ArrayList<XmlSchemaElement>();
        for (CustomApiParam customApiParam2 : customApiParam.getChildList()) {
            XmlSchemaAnnotation anno = SchemaGeneratorUtil.createAnnotation("https://dev.kingdee.com/index/open/TextID", customApiParam2.getEntryId().toString(), customApiParam2.getDesc());
            xmlSchemaComplexType = CollectionUtil.isEmpty((Collection)customApiParam2.getChildList()) ? null : this.createComplexType(customApiParam2, xmlSchema);
            elementList2.add(SchemaGeneratorUtil.createElement(xmlSchema, customApiParam2.getParamName(), customApiParam2.isMulValue() ? Long.valueOf(Long.MAX_VALUE) : null, DataType.STRUCT.type().equalsIgnoreCase(customApiParam2.getParamType()) ? null : customApiParam2.getParamType(), anno, (XmlSchemaComplexType)(DataType.STRUCT.type().equalsIgnoreCase(customApiParam2.getParamType()) ? xmlSchemaComplexType : null), customApiParam2.isRequired() ? 1L : 0L));
        }
        xmlSchemaComplexType = SchemaGeneratorUtil.createComplexType(xmlSchema, elementList2);
        return xmlSchemaComplexType;
    }

    protected OMElement generateCustomInterface(OMFactory omFactory) throws AxisFault, URISyntaxException, XMLStreamException, FactoryConfigurationError {
        this.interfaceName = this.customApiInfo.getMethodName();
        return this.getInterfaceElement(this.wsdl, this.tns, this.wsdlx, this.wrpc, omFactory, this.interfaceName);
    }

    protected OMElement generateService(OMFactory omFactory, OMElement descriptionElement, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11) throws AxisFault {
        OMElement serviceElement;
        HashSet<AxisBinding> bindings = new HashSet<AxisBinding>();
        Map endpointMap = this.axisService.getEndpoints();
        Object value = this.axisService.getParameterValue("isCodegen");
        boolean isCodegen = false;
        if (JavaUtils.isTrueExplicitly((Object)value)) {
            isCodegen = true;
        }
        if (endpointMap != null && endpointMap.size() > 0) {
            serviceElement = this.getServiceElement(this.wsdl, this.tns, omFactory, this.interfaceName);
            for (AxisEndpoint axisEndpoint : endpointMap.values()) {
                String propertySOAPVersion;
                AxisBinding axisBinding;
                String type;
                if (!isCodegen && this.checkIfEndPointActive && !axisEndpoint.isActive() || "http://www.w3.org/ns/wsdl/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && this.isDisableREST() || "http://www.w3.org/2003/05/soap-envelope".equals(propertySOAPVersion = (String)axisBinding.getProperty("wsoap:version")) && this.isDisableSOAP12() || "http://schemas.xmlsoap.org/soap/envelope/".equals(propertySOAPVersion) && this.isDisableSOAP11()) continue;
                bindings.add(axisBinding);
                OMElement endpointElement = axisEndpoint.toWSDL20(this.wsdl, this.tns, this.whttp);
                boolean endpointAlreadyAdded = false;
                Iterator endpointsAdded = serviceElement.getChildren();
                while (endpointsAdded.hasNext()) {
                    OMElement endpoint = (OMElement)endpointsAdded.next();
                    if (!endpoint.getAttribute(new QName("binding")).getAttributeValue().equals(endpointElement.getAttribute(new QName("binding")).getAttributeValue()) || !endpoint.getAttribute(new QName("address")).getAttributeValue().equals(endpointElement.getAttribute(new QName("address")).getAttributeValue())) continue;
                    endpointAlreadyAdded = true;
                }
                if (endpointAlreadyAdded) continue;
                Parameter modifyAddressParam = this.axisService.getParameter("modifyUserWSDLPortAddress");
                if (modifyAddressParam != null && Boolean.parseBoolean((String)modifyAddressParam.getValue())) {
                    String endpointURL = axisEndpoint.calculateEndpointURL();
                    endpointElement.getAttribute(new QName("address")).setAttributeValue(endpointURL);
                }
                serviceElement.addChild((OMNode)this.modifyEndpoint(endpointElement));
            }
            for (AxisBinding binding : bindings) {
                OMElement bindingElement = binding.toWSDL20(this.wsdl, this.tns, this.wsoap, this.whttp, this.interfaceName, this.axisService.getNamespaceMap(), AddressingHelper.getAddressingRequirementParemeterValue((AxisDescription)this.axisService), this.serviceName, this.wsaw);
                descriptionElement.addChild((OMNode)this.modifyBinding(bindingElement));
            }
            descriptionElement.addChild((OMNode)serviceElement);
        } else {
            descriptionElement.addChild((OMNode)WSDLSerializationUtil.generateSOAP11Binding((OMFactory)omFactory, (AxisService)this.axisService, (OMNamespace)this.wsdl, (OMNamespace)this.wsoap, (OMNamespace)this.tns, (String)this.serviceName));
            if (!this.isDisableSOAP12()) {
                descriptionElement.addChild((OMNode)this.modifyBinding(WSDLSerializationUtil.generateSOAP12Binding((OMFactory)omFactory, (AxisService)this.axisService, (OMNamespace)this.wsdl, (OMNamespace)this.wsoap, (OMNamespace)this.tns, (String)this.serviceName)));
            }
            if (!this.isDisableSOAP11()) {
                descriptionElement.addChild((OMNode)this.modifyBinding(WSDLSerializationUtil.generateSOAP11Binding((OMFactory)omFactory, (AxisService)this.axisService, (OMNamespace)this.wsdl, (OMNamespace)this.wsoap, (OMNamespace)this.tns, (String)this.serviceName)));
            }
            if (!this.isDisableREST()) {
                descriptionElement.addChild((OMNode)this.modifyBinding(WSDLSerializationUtil.generateHTTPBinding((OMFactory)omFactory, (AxisService)this.axisService, (OMNamespace)this.wsdl, (OMNamespace)this.whttp, (OMNamespace)this.tns, (String)this.serviceName)));
            }
            serviceElement = this.generateServiceElement(omFactory, this.wsdl, this.tns, this.axisService, this.isDisableREST(), this.isDisableSOAP12(), this.isDisableSOAP11(), this.eprs, this.serviceName);
            descriptionElement.addChild((OMNode)serviceElement);
        }
        return serviceElement;
    }

    protected boolean isDisableREST() {
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly((Object)disableRESTParameter.getValue())) {
            disableREST = true;
        }
        return disableREST;
    }

    protected boolean isDisableSOAP11() {
        boolean disableSOAP11 = false;
        Parameter disableSOAP11Parameter = this.axisService.getParameter("disableSOAP11");
        if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP11Parameter.getValue())) {
            disableSOAP11 = true;
        }
        return disableSOAP11;
    }

    protected boolean isDisableSOAP12() {
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly((Object)disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        return disableSOAP12;
    }

    protected List getPoliciesInDefinitions() {
        return new ArrayList(this.policiesInDescription.values());
    }

    protected OMElement modifyEndpoint(OMElement endpoint) {
        return endpoint;
    }

    protected OMElement modifyBinding(OMElement binding) {
        return binding;
    }

    public OMElement generateServiceElement(OMFactory omFactory, OMNamespace wsdl, OMNamespace tns, AxisService axisService, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11, String serviceName) throws OpenApiException {
        return this.generateServiceElement(omFactory, wsdl, tns, axisService, disableREST, disableSOAP12, disableSOAP11, null, serviceName);
    }

    public OMElement generateServiceElement(OMFactory omFactory, OMNamespace wsdl, OMNamespace tns, AxisService axisService, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11, String[] eprs, String serviceName) throws OpenApiException {
        OMElement serviceElement;
        if (eprs == null && (eprs = axisService.getEPRs()) == null) {
            eprs = new String[]{serviceName};
        }
        if ((serviceElement = omFactory.createOMElement("service", wsdl)) != null) {
            serviceElement.addAttribute(omFactory.createOMAttribute("name", null, serviceName));
            serviceElement.addAttribute(omFactory.createOMAttribute("interface", null, tns.getPrefix() + ":" + "ServiceInterface"));
        }
        for (int i = 0; i < eprs.length; ++i) {
            OMElement httpDocumentation;
            OMElement soap12Documentation;
            OMElement soap11Documentation;
            String name = "";
            String epr = eprs[i];
            if (epr.startsWith("https://")) {
                name = "Secure";
            }
            OMElement soap11EndpointElement = null;
            if (!disableSOAP11) {
                soap11EndpointElement = omFactory.createOMElement("endpoint", wsdl);
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "SOAP11Endpoint"));
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "SOAP11Binding"));
                soap11EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                if (serviceElement != null) {
                    serviceElement.addChild((OMNode)this.modifyEndpoint(soap11EndpointElement));
                }
            }
            OMElement soap12EndpointElement = null;
            if (!disableSOAP12) {
                soap12EndpointElement = omFactory.createOMElement("endpoint", wsdl);
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "SOAP12Endpoint"));
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "SOAP12Binding"));
                soap12EndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                if (serviceElement != null) {
                    serviceElement.addChild((OMNode)this.modifyEndpoint(soap12EndpointElement));
                }
            }
            OMElement httpEndpointElement = null;
            if (!disableREST) {
                httpEndpointElement = omFactory.createOMElement("endpoint", wsdl);
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("name", null, name + "HTTPEndpoint"));
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("binding", null, tns.getPrefix() + ":" + serviceName + "HttpBinding"));
                httpEndpointElement.addAttribute(omFactory.createOMAttribute("address", null, epr));
                if (serviceElement != null) {
                    serviceElement.addChild((OMNode)this.modifyEndpoint(httpEndpointElement));
                }
            }
            if (epr.startsWith("https://")) {
                if (!disableSOAP11) {
                    soap11Documentation = omFactory.createOMElement("documentation", wsdl);
                    soap11Documentation.setText("This endpoint exposes a SOAP 11 binding over a HTTPS");
                    if (soap11EndpointElement != null) {
                        soap11EndpointElement.addChild((OMNode)soap11Documentation);
                    }
                }
                if (!disableSOAP12) {
                    soap12Documentation = omFactory.createOMElement("documentation", wsdl);
                    soap12Documentation.setText("This endpoint exposes a SOAP 12 binding over a HTTPS");
                    if (soap12EndpointElement != null) {
                        soap12EndpointElement.addChild((OMNode)soap12Documentation);
                    }
                }
                if (disableREST) continue;
                httpDocumentation = omFactory.createOMElement("documentation", wsdl);
                httpDocumentation.setText("This endpoint exposes a HTTP binding over a HTTPS");
                if (httpEndpointElement == null) continue;
                httpEndpointElement.addChild((OMNode)httpDocumentation);
                continue;
            }
            if (!epr.startsWith("http://")) continue;
            if (!disableSOAP11) {
                soap11Documentation = omFactory.createOMElement("documentation", wsdl);
                soap11Documentation.setText("This endpoint exposes a SOAP 11 binding over a HTTP");
                if (soap11EndpointElement != null) {
                    soap11EndpointElement.addChild((OMNode)soap11Documentation);
                }
            }
            if (!disableSOAP12) {
                soap12Documentation = omFactory.createOMElement("documentation", wsdl);
                soap12Documentation.setText("This endpoint exposes a SOAP 12 binding over a HTTP");
                if (soap12EndpointElement != null) {
                    soap12EndpointElement.addChild((OMNode)soap12Documentation);
                }
            }
            if (disableREST) continue;
            httpDocumentation = omFactory.createOMElement("documentation", wsdl);
            httpDocumentation.setText("This endpoint exposes a HTTP binding over a HTTP");
            if (httpEndpointElement == null) continue;
            httpEndpointElement.addChild((OMNode)httpDocumentation);
        }
        return serviceElement;
    }
}

