/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.service.webservice.util;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.service.webservice.util.DocumentFragmentNodeList;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SchemaGeneratorUtil {
    public static Document newXmlDocument = null;
    private static String DATA_TYPE_LIST = "List";
    private static String DATA_TYPE_SET = "Set";
    private static String DATA_TYPE_MAP = "Map";
    private static Map<String, String> baseTypeMap = new HashMap<String, String>();

    public static Document getXmlDocument() {
        if (newXmlDocument == null) {
            try {
                newXmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while generating the WSDL\uff1a" + e.getMessage(), new Object[0]);
            }
        }
        return newXmlDocument;
    }

    public static QName createQname(String name) {
        return SchemaGeneratorUtil.createQname("", name, "");
    }

    public static QName createQname(String uri, String name, String prefix) {
        return new QName(uri, name, prefix);
    }

    public static XmlSchemaAnnotation createAnnotation(String source, String appInfo, String docString) {
        XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
        XmlSchemaAppInfo appinfo = new XmlSchemaAppInfo();
        appinfo.setSource(source);
        appinfo.setMarkup(SchemaGeneratorUtil.createDocument(appInfo));
        annotation.getItems().add(appinfo);
        if (!StringUtil.isEmpty((String)docString)) {
            XmlSchemaDocumentation documentation = new XmlSchemaDocumentation();
            documentation.setLanguage("EN");
            documentation.setMarkup(SchemaGeneratorUtil.createDocument(docString));
            annotation.getItems().add(documentation);
        }
        return annotation;
    }

    public static NodeList createDocument(String text) {
        Document newXmlDocument = SchemaGeneratorUtil.getXmlDocument();
        Element root = newXmlDocument.createElement("root");
        root.setTextContent(text);
        DocumentFragmentNodeList docu = new DocumentFragmentNodeList(root);
        return docu;
    }

    public static XmlSchemaSequence createSequence(List<XmlSchemaElement> list) {
        XmlSchemaSequence sequence = new XmlSchemaSequence();
        sequence.getItems().addAll(list);
        return sequence;
    }

    public static XmlSchemaElement createElement(XmlSchema xmlSchema, String name, Long maxOccurs, String type, XmlSchemaAnnotation annotation, XmlSchemaComplexType complexType) {
        return SchemaGeneratorUtil.createElement(xmlSchema, name, maxOccurs, type, annotation, complexType, null);
    }

    private static String updateSpecName(String name) {
        if ("$key$".equalsIgnoreCase(name)) {
            name = "key";
        } else if ("$value$".equalsIgnoreCase(name)) {
            name = "value";
        }
        return name;
    }

    public static XmlSchemaElement createElement(XmlSchema xmlSchema, String name, Long maxOccurs, String type, XmlSchemaAnnotation annotation, XmlSchemaComplexType complexType, Long minOccurs) {
        XmlSchemaElement element = new XmlSchemaElement(xmlSchema, false);
        name = SchemaGeneratorUtil.updateSpecName(name);
        element.setName(name);
        if (maxOccurs != null && maxOccurs != 1L) {
            element.setMaxOccurs(maxOccurs.longValue());
        }
        if (DataType.isArray((String)type)) {
            element.setMaxOccurs(Long.MAX_VALUE);
        }
        if (minOccurs != null && minOccurs != 1L) {
            element.setMinOccurs(minOccurs.longValue());
        }
        if (!StringUtil.isEmpty((String)type)) {
            String typeQname;
            block9: {
                try {
                    typeQname = DataType.getByType((String)type).getXmlType();
                }
                catch (OpenApiException e) {
                    typeQname = type.toLowerCase();
                    if (typeQname.indexOf("[]") <= 0) break block9;
                    typeQname = typeQname.replace("[]", "");
                }
            }
            if (StringUtil.isNotEmpty((String)typeQname)) {
                element.setSchemaTypeName(new QName("http://www.w3.org/2001/XMLSchema", typeQname, "xsd"));
            }
        }
        if (annotation != null) {
            element.setAnnotation(annotation);
        }
        if (complexType != null) {
            element.setSchemaType((XmlSchemaType)complexType);
        }
        return element;
    }

    public static boolean isArrayComplexType(String dataType) {
        boolean isArrayComplexType = false;
        if (!StringUtil.isEmpty((String)dataType)) {
            switch (dataType) {
                case "Array<Integer>": 
                case "Array<String>": 
                case "Array<Long>": 
                case "Array<Date>": {
                    isArrayComplexType = true;
                    break;
                }
            }
        }
        return isArrayComplexType;
    }

    public static XmlSchemaComplexType createComplexType(XmlSchema xmlSchema, List<XmlSchemaElement> elementList) {
        if (CollectionUtil.isEmpty(elementList)) {
            return new XmlSchemaComplexType(xmlSchema, false);
        }
        XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema, false);
        XmlSchemaSequence sequence2 = new XmlSchemaSequence();
        sequence2.getItems().addAll(elementList);
        xmlSchemaComplexType.setParticle((XmlSchemaParticle)sequence2);
        return xmlSchemaComplexType;
    }

    public static boolean isBaseTypeName(String type) {
        return baseTypeMap.get(type) != null && "1".equals(baseTypeMap.get(type));
    }

    public static boolean isComplexType(CustomApiParam customApiParam) {
        String paramsType = customApiParam.getParamType();
        boolean isComplexTpe = false;
        if (CollectionUtil.isNotEmpty((Collection)customApiParam.getChildList())) {
            isComplexTpe = true;
        } else if (DataType.STRUCT.type().equalsIgnoreCase(paramsType) || DataType.ENTRIES.type().equalsIgnoreCase(paramsType)) {
            isComplexTpe = true;
        } else if (DATA_TYPE_LIST.equals(paramsType) || DATA_TYPE_SET.equals(paramsType)) {
            if (!SchemaGeneratorUtil.isBaseTypeName(customApiParam.getParamsExtType())) {
                isComplexTpe = true;
            }
        } else if (SchemaGeneratorUtil.isComplexTypeForSpec(customApiParam)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b %s\uff0c\u65e0\u6cd5\u751f\u6210WSDL\uff0c\u8bf7\u5220\u9664\u540e\u518d\u8bd5\u3002", (String)"SchemaGeneratorUtil_0", (String)ResSystemType.SERVICE.getType(), (Object[])new Object[]{customApiParam.getParamType()}), new Object[0]);
        }
        return isComplexTpe;
    }

    public static boolean isComplexTypeForSpec(CustomApiParam customApiParam) {
        String paramsType = customApiParam.getParamType();
        return (paramsType.startsWith("Set") || paramsType.startsWith("List")) && paramsType.indexOf("<") > 0 && paramsType.indexOf(">") > 0 && paramsType.indexOf("[") > 0 && paramsType.indexOf("]") > 0 || paramsType.indexOf("[][]") > 0 || paramsType.equalsIgnoreCase("class");
    }

    public static String getParamType(CustomApiParam customApiParam) {
        String paramsType = "";
        if (DATA_TYPE_LIST.equals(customApiParam.getParamType()) || DATA_TYPE_SET.equals(customApiParam.getParamType())) {
            if (SchemaGeneratorUtil.isBaseTypeName(customApiParam.getParamsExtType())) {
                paramsType = customApiParam.getParamsExtType();
            }
        } else {
            paramsType = DATA_TYPE_MAP.equals(customApiParam.getParamType()) ? customApiParam.getParamsExtType() : customApiParam.getParamType();
        }
        if (paramsType.indexOf("<") > 0 && paramsType.indexOf(">") > 0) {
            paramsType = paramsType.substring(paramsType.indexOf("<") + 1, paramsType.indexOf(">"));
        }
        if ("bigdecimal".equalsIgnoreCase(paramsType)) {
            paramsType = "decimal";
        } else if ("character".equalsIgnoreCase(paramsType)) {
            paramsType = "string";
        } else if ("object".equalsIgnoreCase(paramsType)) {
            paramsType = "Any";
        } else if ("HttpMethod".equalsIgnoreCase(paramsType)) {
            paramsType = "string";
        }
        return paramsType;
    }

    static {
        baseTypeMap.put(Long.class.getSimpleName(), "1");
        baseTypeMap.put(Long.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Integer.class.getSimpleName(), "1");
        baseTypeMap.put(Integer.TYPE.getSimpleName(), "1");
        baseTypeMap.put(String.class.getSimpleName(), "1");
        baseTypeMap.put(Short.class.getSimpleName(), "1");
        baseTypeMap.put(Short.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Character.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Byte.class.getSimpleName(), "1");
        baseTypeMap.put(Byte.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Double.class.getSimpleName(), "1");
        baseTypeMap.put(Double.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Boolean.class.getSimpleName(), "1");
        baseTypeMap.put(Boolean.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Date.class.getSimpleName(), "1");
        baseTypeMap.put("Decimal", "1");
        baseTypeMap.put(Float.TYPE.getSimpleName(), "1");
        baseTypeMap.put(Float.class.getSimpleName(), "1");
        baseTypeMap.put(Number.class.getSimpleName(), "1");
    }
}

