/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.webapi.ApiService;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ApiServiceImpl
implements ApiService {
    private static final Log log = LogFactory.getLog(ApiServiceImpl.class);
    private static final String OPENAPISERVICEFORMID = "open_apiservice_new";

    public Boolean checkApiUserIsTrue(String apiNumber) {
        DynamicObjectCollection users;
        QFilter[] filters;
        DynamicObject object;
        RequestContext rs = RequestContext.get();
        String userId = rs.getUserId();
        if ("-1".equals(userId) && (object = BusinessDataServiceHelper.loadSingleFromCache((String)OPENAPISERVICEFORMID, (String)"enable", (QFilter[])(filters = new QFilter[]{new QFilter("number", "=", (Object)apiNumber), new QFilter("allowguest", "=", (Object)"1"), new QFilter("version", "!=", (Object)"2"), new QFilter("enable", "=", (Object)"1")}))) == null) {
            return false;
        }
        filters = new QFilter[]{new QFilter("api_number", "=", (Object)apiNumber)};
        object = BusinessDataServiceHelper.loadSingleFromCache((String)"open_apiauthorize", (String)"api_users", (QFilter[])filters);
        if (object != null && !(users = object.getDynamicObjectCollection("api_users")).isEmpty()) {
            ArrayList<String> uidList = new ArrayList<String>();
            for (DynamicObject user : users) {
                uidList.add(String.valueOf(user.get("fbasedataid_id")));
            }
            if (!uidList.contains(userId)) {
                return false;
            }
        }
        return true;
    }

    public Boolean checkAppByAppNumber(String appNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        return this.checkAppByAppId(appId);
    }

    public Boolean checkAppByFormId(String formId) {
        String appId = BizAppServiceHelp.getAppIdByFormNum((String)formId);
        return this.checkAppByAppId(appId);
    }

    public Boolean checkApiUserIsTrue(String formId, String operation) {
        QFilter[] filters = new QFilter[]{new QFilter("bizobject", "=", (Object)formId), new QFilter("operation", "=", (Object)operation), new QFilter("version", "!=", (Object)"2")};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPENAPISERVICEFORMID, (String)"number", (QFilter[])filters);
        if (object == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"%1$s\u7684%2$s\u64cd\u4f5c\u670d\u52a1\u6ca1\u6709\u5728\u670d\u52a1\u5217\u8868\u4e2d\u6ce8\u518c", (String)"ApiServiceImpl_0", (String)"bos-open-service", (Object[])new Object[0]), formId, operation);
            throw new KDException(errMsg);
        }
        String serviceNumber = object.getString("number");
        return this.checkApiUserIsTrue(serviceNumber);
    }

    public Boolean checkApiForbidden(String formId, String operation) {
        QFilter[] filters = new QFilter[]{new QFilter("bizobject", "=", (Object)formId), new QFilter("operation", "=", (Object)operation), new QFilter("version", "!=", (Object)"2"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPENAPISERVICEFORMID, (String)"enable", (QFilter[])filters);
        if (object == null) {
            return false;
        }
        return true;
    }

    public Boolean getApiNeedOperationLog() {
        boolean open = true;
        try {
            AppParam appParam = new AppParam();
            appParam.setAppId("W3NF+MX967M");
            appParam.setViewType("15");
            appParam.setOrgId(Long.valueOf(ParameterOrgUtils.getParamRootOrgId()));
            appParam.setActBookId(Long.valueOf(0L));
            Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            if (paramMap != null) {
                String result = paramMap.getOrDefault("kapiloglevel", null);
                open = "opLog".equals(result);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return open;
    }

    private Boolean checkAppByAppId(String appId) {
        QFilter[] filters = new QFilter[]{new QFilter("BIZAPP", "=", (Object)appId)};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"open_appauthorize_list", (String)"isforbidden", (QFilter[])filters);
        if (object != null) {
            return !object.getBoolean("isforbidden");
        }
        return true;
    }
}

