/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.webapi.CustomWebApiServiceProxy;
import kd.bos.service.webapi.WebApiHelper;

public class CustomWebApiService
implements IBillWebApiPlugin {
    private static final Log log = LogFactory.getLog(CustomWebApiService.class);

    public String getVersion() {
        return "1.1";
    }

    public ApiResult hello(Map<String, Object> args) {
        return ApiResult.success((Object)String.format("hello %s ,%s", args.get("name"), args.get("date")));
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        return ApiResult.success((Object)String.format("hello %s ,%s", params.get("name"), params.get("date")));
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        Map params = ctx.getData();
        return ApiResult.success((Object)String.format("hello.new %s ,%s", params.get("name"), params.get("date")));
    }

    public String call(String appId, String serviceName, String args) {
        Object result = new Object();
        List<IBillWebApiPlugin> plugins = WebApiHelper.getCustomServicePlugin(appId, serviceName);
        if (plugins.size() == 1) {
            IBillWebApiPlugin plugin = plugins.get(0);
            CustomWebApiServiceProxy customWebApiServiceProxy = (CustomWebApiServiceProxy)plugin;
            if (plugin.getVersion().equals("1.0")) {
                Map argMap = this.getServiceArgs(args, Map.class, new HashMap());
                Object object = argMap.get("data");
                if (object == null) {
                    object = new HashMap();
                }
                if (object instanceof Map) {
                    if (!customWebApiServiceProxy.getMethod().equalsIgnoreCase("doCustomService")) {
                        result = customWebApiServiceProxy.doCustomWebApiService((Map)object);
                    } else {
                        ApiResult apiResult = plugin.doCustomService((Map)object);
                        result = WebApiHelper.convertStatusApiResult(apiResult);
                    }
                } else if (object instanceof List) {
                    List argList = (List)object;
                    result = plugin.doCustomServiceList(argList);
                }
            } else {
                WebApiContext argMap = this.getServiceArgs(args, WebApiContext.class, new WebApiContext());
                if (!customWebApiServiceProxy.getMethod().equalsIgnoreCase("doCustomService")) {
                    result = customWebApiServiceProxy.doCustomWabApiService(argMap);
                } else {
                    ApiResult apiResult = plugin.doCustomService(argMap);
                    result = WebApiHelper.convertStatusApiResult(apiResult);
                }
            }
        } else {
            ApiResult apiResult = new ApiResult();
            apiResult.setMessage(String.format("404 - Cannot found the OpenAPI(disabled or plugin not exists), appId: %s, serviceName: %s", appId, serviceName));
            apiResult.setSuccess(false);
            result = WebApiHelper.convertStatusApiResult(apiResult);
        }
        boolean formatNull = "true".equals(System.getProperty("api.jsonFormatIncludeNull", "false"));
        return WebApiHelper.getUseSysTimeZoneFormat(result, !formatNull, args);
    }

    private <T> T getServiceArgs(String args, Class<?> cls, T defultValue) {
        Object argMap = defultValue;
        if (StringUtils.isNotBlank((CharSequence)args)) {
            argMap = SerializationUtils.fromJsonString((String)args, cls);
        }
        return argMap;
    }
}

