/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.OperateOptionPrivate;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.AICommand;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormMetadataCache;
import kd.bos.metadata.Plugin;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.ScriptContext;
import kd.bos.script.ScriptExecutor;
import kd.bos.service.KDDateUtils;
import kd.bos.service.webapi.CustomWebApiServiceProxy;
import kd.bos.service.webapi.StatusApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class WebApiHelper {
    private static final String CUSTOM_METHOD = "doCustomService";
    private static final String KEY_CUSTOMMETHOD = "custommethod";
    private static final int PLUGIN_TYPE_JS = 1;
    private static final int PLUGIN_TYPE_JAVA = 0;
    private static final String KEY_PLUGIN_NAME = "plugin";
    private static final String KEY_APPID = "appid";
    private static final String KEY_BIZOBJECT = "bizobject";
    private static final String FORMID_API_SERVICE = "open_apiservice";
    private static final String FORMID_API_SERVICE_NEW = "open_apiservice_new";
    private static final String API_SERVICETYPE = "apiservicetype";
    private static final String ENABLE = "enable";
    private static final String VERSION = "version";
    private static final String BOS_MSERVICE_FORM = "bos-mservice-form";

    private WebApiHelper() {
    }

    public static String getServicePlugin() {
        return null;
    }

    public static List<IBillWebApiPlugin> getOperationServicePlugin(String formId, String operationKey) {
        ArrayList<IBillWebApiPlugin> plugins = new ArrayList();
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobject.id", "=", (Object)formId), new QFilter("operation", "=", (Object)operationKey), new QFilter(API_SERVICETYPE, "=", (Object)"0"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE), new QFilter(VERSION, "!=", (Object)"2")};
        Map cacheWebApiMetas = BusinessDataServiceHelper.loadFromCache((String)FORMID_API_SERVICE_NEW, (String)KEY_PLUGIN_NAME, (QFilter[])qFilters);
        try {
            plugins = cacheWebApiMetas.values().stream().flatMap(apiMeta -> WebApiHelper.createWebApiPlugin(apiMeta.getString(KEY_PLUGIN_NAME)).stream()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("### ", ResManager.loadKDString((String)"\u64cd\u4f5cAPI\u670d\u52a1--\u8868\u5355\uff1a%1$s \u64cd\u4f5c\uff1a%2$s \u5b9e\u4f8b\u5316\u63d2\u4ef6\u4ea7\u751f\u5f02\u5e38", (String)"WebApiHelper_0", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[]{formId, operationKey});
        }
        return plugins;
    }

    public static List<IBillWebApiPlugin> getAIServicePlugin(AICommand command) {
        ArrayList<IBillWebApiPlugin> plugins = new ArrayList();
        QFilter[] qFilters = new QFilter[]{new QFilter("aicommand.ainumber", "=", (Object)command.getCommand()), new QFilter(API_SERVICETYPE, "=", (Object)"1"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        Map cacheWebApiMetas = BusinessDataServiceHelper.loadFromCache((String)FORMID_API_SERVICE, (String)WebApiHelper.buildSelect(KEY_PLUGIN_NAME, KEY_BIZOBJECT), (QFilter[])qFilters);
        try {
            plugins = cacheWebApiMetas.values().stream().flatMap(apiMeta -> {
                List<IBillWebApiPlugin> createWebApiPlugin = WebApiHelper.createWebApiPlugin(apiMeta.getString(KEY_PLUGIN_NAME));
                if (createWebApiPlugin != null) {
                    for (IBillWebApiPlugin plugin : createWebApiPlugin) {
                        DynamicObject bizObject = apiMeta.getDynamicObject(KEY_BIZOBJECT);
                        if (bizObject == null) continue;
                        plugin.setFormId(bizObject.getPkValue().toString());
                    }
                }
                return createWebApiPlugin.stream();
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("### ", ResManager.loadKDString((String)"AI\u670d\u52a1--\u547d\u4ee4\uff1a%s \u5b9e\u4f8b\u5316\u63d2\u4ef6\u4ea7\u751f\u5f02\u5e38", (String)"WebApiHelper_1", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[]{command.getCommand()});
        }
        return plugins;
    }

    public static List<IBillWebApiPlugin> getCustomServicePlugin(String appId, String number) {
        ArrayList<IBillWebApiPlugin> plugins = new ArrayList<IBillWebApiPlugin>();
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter(API_SERVICETYPE, "=", (Object)"2"), new QFilter(ENABLE, "=", (Object)Boolean.TRUE), new QFilter(VERSION, "!=", (Object)"2")};
        Map cacheWebApiMetas = BusinessDataServiceHelper.loadFromCache((String)FORMID_API_SERVICE_NEW, (String)WebApiHelper.buildSelect(KEY_APPID, KEY_PLUGIN_NAME, KEY_CUSTOMMETHOD), (QFilter[])qFilters);
        HashMap cacheWebApiMetasByAppid = new HashMap();
        if (cacheWebApiMetas.size() > 1) {
            for (Map.Entry objectEntry : cacheWebApiMetas.entrySet()) {
                Object cacheWebApiMetasKey = objectEntry.getKey();
                DynamicObject cacheWebApiMetasValue = (DynamicObject)objectEntry.getValue();
                DynamicObject cacheWebApiMetaappid = (DynamicObject)cacheWebApiMetasValue.get(KEY_APPID);
                if (!cacheWebApiMetaappid.get("number").equals(appId)) continue;
                cacheWebApiMetasByAppid.put(cacheWebApiMetasKey, cacheWebApiMetasValue);
                break;
            }
        }
        try {
            Collection apiMetavalues = cacheWebApiMetasByAppid.size() > 0 ? cacheWebApiMetasByAppid.values() : cacheWebApiMetas.values();
            for (DynamicObject apiMeta : apiMetavalues) {
                List<IBillWebApiPlugin> createWebApiPlugin = WebApiHelper.createWebApiPlugin(apiMeta.getString(KEY_PLUGIN_NAME));
                String customMethod = StringUtils.isNotBlank((CharSequence)apiMeta.getString(KEY_CUSTOMMETHOD)) ? apiMeta.getString(KEY_CUSTOMMETHOD) : CUSTOM_METHOD;
                List serviceProxies = createWebApiPlugin.stream().map(plugin -> new CustomWebApiServiceProxy((IBillWebApiPlugin)plugin, customMethod)).collect(Collectors.toList());
                plugins.addAll(serviceProxies);
            }
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("### ", ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u670d\u52a1--\u5e94\u7528\u7f16\u7801\uff1a%1$s \u670d\u52a1\u7f16\u7801\uff1a%2$s  \u5b9e\u4f8b\u5316\u63d2\u4ef6\u4ea7\u751f\u5f02\u5e38", (String)"WebApiHelper_2", (String)BOS_MSERVICE_FORM, (Object[])new Object[0])), new Object[]{appId, number});
        }
        return plugins;
    }

    public static String getServiceRequestSchema() {
        return null;
    }

    public static String getSericeRequestSchema() {
        return null;
    }

    public static String getSericeResponseSchema() {
        return null;
    }

    private static DynamicObject getDynObj() {
        return null;
    }

    public static List<IBillWebApiPlugin> createWebApiPlugin(String pluginInfoStr) {
        ArrayList<IBillWebApiPlugin> webApiPlugins = new ArrayList<IBillWebApiPlugin>();
        if (StringUtils.isBlank((CharSequence)pluginInfoStr)) {
            return webApiPlugins;
        }
        if (WebApiHelper.isUseNewVersionPlugin(pluginInfoStr)) {
            List pluginDescriptions = null;
            try {
                pluginDescriptions = JSON.parseArray((String)pluginInfoStr, Plugin.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pluginDescriptions == null) {
                pluginDescriptions = JSON.parseArray((String)pluginInfoStr.replace("\\\"", "\""), Plugin.class);
            }
            for (Plugin pluginDes : pluginDescriptions) {
                if (!pluginDes.isEnabled()) continue;
                if (pluginDes.getType() == 0) {
                    webApiPlugins.add((IBillWebApiPlugin)TypesContainer.createInstance((String)pluginDes.getClassName()));
                    continue;
                }
                if (pluginDes.getType() == 1) {
                    webApiPlugins.add(WebApiHelper.createJSPlugin(pluginDes.getClassName()));
                    continue;
                }
                throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"%s\u63d2\u4ef6\u4fe1\u606f\u6709\u8bef", (String)"WebApiHelper_3", (String)BOS_MSERVICE_FORM, (Object[])new Object[0]), pluginInfoStr));
            }
        } else {
            webApiPlugins.add((IBillWebApiPlugin)TypesContainer.createInstance((String)pluginInfoStr));
        }
        return webApiPlugins;
    }

    private static boolean isUseNewVersionPlugin(String pluginInfoStr) {
        return pluginInfoStr.matches("\\[.+\\]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IBillWebApiPlugin createJSPlugin(String scriptKey) {
        String script = FormMetadataCache.getFormPluginScripts((String)FORMID_API_SERVICE, (String)scriptKey);
        ScriptExecutor executor = ScriptExecutor.create();
        executor.init(ctx -> ctx.require(new String[]{"kd.bos.bill.KDBillWebApiPlugin"}));
        try {
            IBillWebApiPlugin plugin;
            executor.begin();
            executor.exec(new String[]{script});
            ScriptContext ctx2 = executor.getContext();
            IBillWebApiPlugin iBillWebApiPlugin = plugin = (IBillWebApiPlugin)ctx2.get(KEY_PLUGIN_NAME);
            return iBillWebApiPlugin;
        }
        finally {
            executor.end();
        }
    }

    private static String buildSelect(String ... properties) {
        return StringUtils.join((Object[])properties, (String)",");
    }

    public static boolean checkCustomApiForbidden(String appId, String number) {
        boolean result = false;
        QFilter[] filters = new QFilter[]{new QFilter(KEY_APPID, "=", (Object)AppMetadataCache.getAppInfo((String)appId).getId()), new QFilter("number", "=", (Object)number)};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)FORMID_API_SERVICE, (String)ENABLE, (QFilter[])filters);
        if (object != null) {
            String enable = object.getString(ENABLE);
            result = "0".equals(enable);
        }
        return result;
    }

    static String getUseSysTimeZoneFormat(Object obj, boolean inclusionNON_NULL, String args) {
        String dateSdfParam = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_datesdf", "api.datesdf", "yyyy-MM-dd HH:mm:ss");
        String dateShortSdfParam = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_dateshortsdf", "api.dateshortsdf", "yyyy-MM-dd");
        OperateOptionPrivate params = new OperateOptionPrivate();
        params.setVariableValue("datesdf", dateSdfParam);
        params.setVariableValue("dateshortsdf", dateShortSdfParam);
        Map argMap = WebApiHelper.getServiceArgs(args, Map.class, new HashMap());
        Map requestHeaders = (Map)argMap.get("requestHeaders");
        if (requestHeaders != null && "true".equals(requestHeaders.get("usesystimezone"))) {
            params.setVariableValue("timeZoneId", KDDateUtils.getSysTimeZone().getID());
        }
        return SerializationUtils.toJsonString((Object)obj, (boolean)inclusionNON_NULL, (OperateOption)params);
    }

    static <T> T getServiceArgs(String args, Class<?> cls, T defultValue) {
        Object argMap = defultValue;
        if (StringUtils.isNotBlank((CharSequence)args)) {
            argMap = SerializationUtils.fromJsonString((String)args, cls);
        }
        return argMap;
    }

    public static String preQuerySelectFields(String entityId, String selectFields) {
        String orgField = EntityMetadataCache.getDataEntityType((String)entityId).getMainOrg();
        if (StringUtils.isNotEmpty((CharSequence)orgField) && !selectFields.toLowerCase().contains(orgField)) {
            selectFields = selectFields.concat(",").concat(orgField);
        }
        return selectFields;
    }

    public static ApiResult convertStatusApiResult(ApiResult result) {
        if (result != null && result.getClass().getCanonicalName().equals("kd.bos.entity.api.ApiResult")) {
            return new StatusApiResult(result);
        }
        return result;
    }
}

