/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi.query.g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.webapi.query.g.GBaseVisitor;
import kd.bos.service.webapi.query.g.GLexer;
import kd.bos.service.webapi.query.g.GParser;
import kd.bos.service.webapi.query.g.convert.FilterValueConvertHelper;
import kd.bos.utils.DbTypeConverter;
import kd.sdk.annotation.SdkInternal;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

@SdkInternal
public class FilterVisitor
extends GBaseVisitor<QFilter> {
    public static final ThreadLocal<MainEntityType> mainEntityType = new ThreadLocal();
    private static Log log = LogFactory.getLog(FilterVisitor.class);
    static final HashMap<String, String> operators = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("EQ", "=");
            this.put("NQ", "!=");
            this.put("BT", ">");
            this.put("LT", "<");
            this.put("BQ", ">=");
            this.put("LQ", "<=");
            this.put("IN", "in");
            this.put("NI", "not in");
            this.put("CS", "like");
            this.put("BG", "like");
        }
    };
    List<QFilter> filters = new ArrayList<QFilter>();
    List<QFilter> compare_filters = new ArrayList<QFilter>();
    static String[] stringpack = new String[]{"'", "\""};

    public QFilter[] getFilters() {
        QFilter[] items = new QFilter[this.filters.size()];
        return this.filters.toArray(items);
    }

    public static QFilter Parse(String exp) {
        ANTLRInputStream stream = new ANTLRInputStream(exp);
        GLexer lexer = new GLexer((CharStream)stream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GParser parser = new GParser((TokenStream)tokens);
        parser.setBuildParseTree(true);
        GParser.ParseContext ctx = parser.parse();
        return (QFilter)new FilterVisitor().visitFilterExp(ctx.filterExp());
    }

    @Override
    public QFilter visitExp(GParser.ExpContext ctx) {
        GParser.In_expContext inctx = ctx.in_exp();
        GParser.Compare_expContext cctx = ctx.compare_exp();
        GParser.Logic_operatorContext lctx = ctx.logic_operator();
        if (inctx != null) {
            return this.visitIN(inctx);
        }
        if (cctx != null) {
            return this.visitCompare(cctx);
        }
        if (lctx != null) {
            QFilter left = this.visitExp(ctx.exp(0));
            QFilter right = this.visitExp(ctx.exp(1));
            if (lctx.AND() != null) {
                return left.and(right);
            }
            return left.or(right);
        }
        if ("(".equals(ctx.getChild(0).getText())) {
            return this.visitExp(ctx.exp(0));
        }
        throw new RuntimeException("not supported");
    }

    private QFilter visitIN(GParser.In_expContext ctx) {
        String fn = ctx.fieldName().getText();
        String value = ctx.in_tuple().getText();
        QFilter filter = ctx.in_operator() != null && "NI".equals(ctx.in_operator().getText().toUpperCase()) ? this.newFilter(fn, "NI", value) : this.newFilter(fn, "IN", value);
        return filter;
    }

    private QFilter visitCompare(GParser.Compare_expContext ctx) {
        String fn = ctx.fieldName().getText();
        String compare = ctx.compare_operator().getText();
        String value = ctx.value_exp().getText();
        return this.newFilter(fn, compare, value);
    }

    QFilter newFilter(String field, String op, String value) {
        String fop = operators.get(op.toUpperCase());
        QFilter qFilter = new QFilter(field, fop, (Object)value, false);
        if ("in".equals(fop) || "not in".equals(fop)) {
            if (mainEntityType.get() != null) {
                IDataEntityProperty property = mainEntityType.get().findProperty(field);
                if (property == null) {
                    String fieldKey = field.contains(".") ? field.substring(field.indexOf(".") + 1) : field;
                    property = (IDataEntityProperty)mainEntityType.get().getAllFields().get(fieldKey);
                }
                if (property instanceof DateTimeProp) {
                    throw new KDException(new ErrorCode("opnotsupport", String.format("field:%s type:datetime not support op:%s invoke", property.getName(), op)), new Object[0]);
                }
            }
            String[] splitObjs = null;
            splitObjs = value.startsWith("(") && value.endsWith(")") ? value.substring(1, value.lastIndexOf(")")).split(",") : value.split(",");
            Object[] convertObjs = new Object[splitObjs.length];
            for (int i = 0; i < splitObjs.length; ++i) {
                String objStr = splitObjs[i];
                if (mainEntityType.get() != null) {
                    convertObjs[i] = this.getConvertValue(field, objStr);
                    log.info(String.format("FilterVisitor FilterValueConvert1 fop: %s value: %s convertResult: %s convertType: %s", fop, value, convertObjs[i], convertObjs[i].getClass().toString()));
                    continue;
                }
                convertObjs[i] = StringUtils.isNumeric((CharSequence)objStr) ? DbTypeConverter.safeConvert((int)6, (Object)objStr) : objStr;
            }
            qFilter = new QFilter(field, fop, (Object)convertObjs, false);
        } else if (mainEntityType.get() != null) {
            if ("null".equalsIgnoreCase(value)) {
                return new QFilter(field, "is null", null, false);
            }
            Object convertResult = this.getConvertValue(field, value);
            if (convertResult != null) {
                log.info(String.format("FilterVisitor FilterValueConvert3 fop: %s value: %s convertResult: %s convertType: %s", fop, value, convertResult, convertResult.getClass().toString()));
                qFilter = new QFilter(field, fop, convertResult, false);
            }
        }
        return qFilter;
    }

    private Object getConvertValue(String field, String value) {
        IDataEntityProperty property = this.getProperty(field);
        for (String sp : stringpack) {
            if (!value.startsWith(sp) || !value.endsWith(sp)) continue;
            value = value.substring(1, value.lastIndexOf(sp));
        }
        return FilterValueConvertHelper.getConvertResult(property, value);
    }

    @Override
    public QFilter visitCompare_exp(GParser.Compare_expContext ctx) {
        this.compare_filters.add(this.visitCompare(ctx));
        return (QFilter)super.visitCompare_exp(ctx);
    }

    private IDataEntityProperty getProperty(String fieldStr) {
        String[] fields = fieldStr.split("\\.");
        return this.getProperty(fields, (DynamicObjectType)mainEntityType.get(), 0);
    }

    private IDataEntityProperty getProperty(String[] fields, DynamicObjectType type, int i) {
        if (i >= fields.length) {
            return type == null ? null : type.getPrimaryKey();
        }
        DynamicProperty property = type.getProperty(fields[i]);
        if (property instanceof FlexProp) {
            FlexProp flexProp = (FlexProp)property;
            DynamicObjectType complexPropertyType = flexProp.getDynamicComplexPropertyType();
            return this.getProperty(fields, complexPropertyType, i + 1);
        }
        if (property instanceof MulBasedataProp) {
            DynamicObjectType itemPropertyType = ((MulBasedataProp)property).getDynamicCollectionItemPropertyType();
            return this.getProperty(fields, itemPropertyType, i + 1);
        }
        if (property instanceof BasedataProp) {
            return this.getProperty(fields, ((BasedataProp)property).getDynamicComplexPropertyType(), i + 1);
        }
        if (property instanceof EntryProp) {
            return this.getProperty(fields, ((EntryProp)property).getDynamicCollectionItemPropertyType(), i + 1);
        }
        if (i + 1 != fields.length) {
            return null;
        }
        return property;
    }
}

