/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.webapi.swagger;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.webapi.swagger.ApiToSwaggerImpl;
import kd.bos.service.webapi.swagger.ContentType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;

public class ApiToSwaggerData {
    private static final String GET = "Get";
    private static Log log = LogFactory.getLog(ApiToSwaggerData.class);
    private static final String ENTITY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String KEY_HTTP_METHOD = "httpmethod";
    private static final String ENTITY_OPEN_API_SERVICE = "open_apiservice";
    private static final String SELECT_FIELD_API = "id,name,number,bizobject,appid";
    private static final String DATA_FIELD_APP_ID = "appid";
    private List<Tag> clouds = new LinkedList<Tag>();
    private HashMap<Long, String> apiCloudMap = new HashMap();
    private Map<String, Model> definitions = new HashMap<String, Model>();
    private Map<String, Response> responses = new HashMap<String, Response>();

    public String getApiInfo() {
        String apiJson;
        DynamicObject[] dynamicObjects;
        Object[] apiIds;
        Set apiIdSet;
        String[] swArr;
        String swaggerWhiteList = System.getProperty("api.SwaggerWhiteList");
        if (!(null == swaggerWhiteList || (swArr = swaggerWhiteList.split(",")).length > 0 && Arrays.asList(swArr).contains(RequestContext.get().getUserId()))) {
            return "unauthorized access";
        }
        this.buildApiCloudMap();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_OPEN_API_SERVICE_NEW);
        String openApiSql = "select fid from t_open_apiservice order by fcreatetime desc";
        try {
            apiIdSet = (Set)DB.query((DBRoute)new DBRoute(mainEntityType.getDBRouteKey()), (String)openApiSql, null, rs -> {
                HashSet<Long> idSet = new HashSet<Long>(16);
                while (rs.next()) {
                    long id = rs.getLong("fid");
                    idSet.add(id);
                }
                return idSet;
            });
        }
        catch (Exception e) {
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), openApiSql);
            log.info("Swagger DB.query:".concat(msg));
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        HashMap<String, Path> pathMap = new HashMap<String, Path>(16);
        try {
            long[] ids = apiIdSet.stream().mapToLong(Long::longValue).toArray();
            apiIds = new Long[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                apiIds[i] = ids[i];
            }
        }
        catch (Exception e) {
            String msg = String.format("error:%s", e.getMessage());
            log.info("Swagger apiIds:".concat(msg));
            throw new KDException((Throwable)e, BosErrorCode.parse, new Object[]{msg});
        }
        for (DynamicObject apiInfo : dynamicObjects = BusinessDataServiceHelper.load((Object[])apiIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ENTITY_OPEN_API_SERVICE_NEW))) {
            Object pkValue = apiInfo.getPkValue();
            Long apiId = Long.valueOf(String.valueOf(pkValue));
            try {
                String url = apiInfo.getString("urlformat");
                if (url.contains("{") || url.contains("}")) {
                    url = url.replace("{", "[").replace("}", "]");
                }
                Path path = this.buildPath(apiInfo, apiId);
                pathMap.put(String.format("/kapi%s", url), path);
            }
            catch (Exception e) {
                String msg = String.format("error:%s", e.getMessage());
                log.info("Swagger apiId:".concat(msg));
            }
        }
        Swagger swagger = this.createSwagger();
        swagger.setTags(this.clouds);
        swagger.setPaths(pathMap);
        swagger.setDefinitions(this.definitions);
        swagger.setResponses(this.responses);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            apiJson = objectMapper.writeValueAsString((Object)swagger);
        }
        catch (Exception e) {
            log.error("API\u4fe1\u606f\u683c\u5f0f\u5316\u9519\u8bef: ", (Throwable)e);
            throw new KDException(ResManager.loadKDString((String)"API\u4fe1\u606f\u683c\u5f0f\u5316\u9519\u8bef\u3002", (String)"ApiToSwaggerData_1", (String)"bos-open-service", (Object[])new Object[0]));
        }
        return apiJson;
    }

    private Swagger createSwagger() {
        String contextUrl = UrlService.getDomainContextUrl();
        String url = contextUrl.replace("http://", "").replace("https://", "");
        String[] items = url.split("/");
        String host = "";
        if (items.length > 0) {
            host = items[0];
        }
        Swagger swagger = new Swagger();
        ApiToSwaggerImpl apiToSwagger = new ApiToSwaggerImpl();
        swagger.setInfo(apiToSwagger.getInfo());
        swagger.setHost(host);
        swagger.setBasePath(url.replace(host, ""));
        swagger.setSchemes(apiToSwagger.getSchemes());
        return swagger;
    }

    private Path buildPath(DynamicObject apiInfo, Long apiId) {
        String apiName = apiInfo.getString("name");
        String contenttype = apiInfo.getString("contenttype");
        apiName = StringUtils.isBlank((CharSequence)apiName) ? apiInfo.getString("number") : apiName;
        String description = apiInfo.getString("discription");
        String info = String.format(ResManager.loadKDString((String)"\u4e91\uff1a%1$s \uff0c\u5e94\u7528\uff1a%2$s \uff0c\u8d1f\u8d23\u4eba\uff1a%3$s ", (String)"ApiToSwaggerData_0", (String)"bos-open-service", (Object[])new Object[0]), apiInfo.getString("appid.bizcloud.name"), apiInfo.getString("appid.name"), apiInfo.getString("modifier.name"));
        description = info.concat(description);
        String reqType = this.getHttpRequestType(apiInfo);
        Path path = new Path();
        Operation operation = new Operation();
        path.set(reqType.toLowerCase(), operation);
        operation.setTags(Collections.singletonList(this.apiCloudMap.get(apiId)));
        operation.setSummary(apiName);
        operation.setDescription(description);
        operation.setOperationId(this.getHttpUrl(apiInfo) + "RestUsing" + reqType);
        ApiToSwaggerImpl apiToSwagger = new ApiToSwaggerImpl();
        ArrayList<Parameter> allParameters = new ArrayList<Parameter>();
        allParameters.addAll(apiToSwagger.buildRequestHeader(apiInfo));
        allParameters.addAll(apiToSwagger.buildQueryParameters(apiInfo));
        if (!reqType.equalsIgnoreCase(GET)) {
            allParameters.addAll(apiToSwagger.buildBody(apiInfo, this.definitions));
        }
        operation.setParameters(allParameters);
        if (StringUtils.isNotBlank((CharSequence)contenttype) && ContentType.forKey(contenttype) != null) {
            operation.setConsumes(Collections.singletonList(ContentType.forKey(contenttype).getValue()));
        }
        operation.setResponses(apiToSwagger.buildResponse(apiInfo));
        return path;
    }

    private String getHttpRequestType(DynamicObject apiInfo) {
        List comboItems = ((ComboProp)apiInfo.getDynamicObjectType().getProperty(KEY_HTTP_METHOD)).getComboItems();
        String type = apiInfo.getString(KEY_HTTP_METHOD);
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equals(type)) continue;
            return item.getName().toString();
        }
        return "";
    }

    private String getHttpUrl(DynamicObject apiInfo) {
        String url = apiInfo.getString("urlformat");
        url = String.format("/kapi%s", url);
        DynamicObjectCollection queryParams = apiInfo.getDynamicObjectCollection("urlparamentryentity");
        if (CollectionUtils.isEmpty((Collection)queryParams)) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url).append("?");
        for (DynamicObject param : queryParams) {
            String name = param.getString("urlparamname");
            urlBuilder.append(name).append("={").append(name).append("}");
        }
        return urlBuilder.toString();
    }

    private void buildApiCloudMap() {
        Map apiMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_OPEN_API_SERVICE, (String)SELECT_FIELD_API, null);
        for (Map.Entry entry : apiMap.entrySet()) {
            LocaleDynamicObjectCollection bizcloud;
            Long apiId = (Long)entry.getKey();
            DynamicObject api = (DynamicObject)entry.getValue();
            DynamicObject app = api.getDynamicObject(DATA_FIELD_APP_ID);
            if (!Objects.nonNull(app) || (bizcloud = (LocaleDynamicObjectCollection)app.getDynamicObject("bizcloud").get("multilanguagetext")) == null) continue;
            for (DynamicObject dynamicObject : bizcloud) {
                String langName = RequestContext.get().getLang().name();
                if (!StringUtils.equals((CharSequence)dynamicObject.getString("localeid"), (CharSequence)langName)) continue;
                String name = dynamicObject.getString("name");
                this.apiCloudMap.put(apiId, name);
                Tag tag = new Tag();
                tag.setName(name);
                if (this.clouds.contains(tag)) continue;
                this.clouds.add(tag);
            }
        }
    }
}

