/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.constant;

import kd.sdk.annotation.SdkPublic;

@SdkPublic
public enum ApiErrorCode {
    OK("0", "OK"),
    ERROR("999", "Unknown"),
    Data_Duplicate("601", "Find duplicate data"),
    Data_NotFound("602", "No data found"),
    Data_Invalid("603", "Data is invalid"),
    Data_Repeat_Execute("604", "The server rejected your request because of repeated requests"),
    Save_Data_Repeat_Execute("605", "The server rejected your request because of repeated requests"),
    Data_UpdateFail("611", "Failed to update the data"),
    Data_NoAuth("612", "No data operation permission"),
    SCRIPT_ERROR("701", "Script execution error"),
    PLUGIN_ERROR("702", "Plugin execution error"),
    SIGN_ERROR("703", "Signature failure"),
    HTTP_BAD_REQUEST("400", "Bad Request or Parameters is invalid"),
    HTTP_UNAUTHORIZED("401", "Unauthorized or Token is invalid"),
    HTTP_FORBIDDEN("403", "Forbidden, Access is denied"),
    HTTP_NOT_FOUND("404", "Not Found or Api is disabled"),
    HTTP_NOT_ALLOWED("405", "Method Not Allowed"),
    HTTP_NOT_ACCEPTABLE("406", "Not Acceptable"),
    HTTP_REQUEST_TIMEOUT("408", "Request Timeout"),
    HTTP_BODY_TOO_LARGE("413", "Request Entity Too Large"),
    HTTP_UNSUPPORTED_MEDIA_TYPE("415", "Unsupported Media Type"),
    HTTP_TOO_MANY_REQUEST("429", "Too many request"),
    HTTP_BREAK_REQUEST("439", "The request has been broken"),
    HTTP_INTERNAL_ERROR("500", "Service is unavailable"),
    HTTP_OK("200", "OK"),
    HTTP_CREATED("201", "Created"),
    HTTP_ACCEPTED("202", "Accepted"),
    HTTP_NOCONTENT("204", "No Content"),
    HTTP_MOVED("301", "Moved Permanently"),
    HTTP_FOUND("302", "Found"),
    LOGIN_BIZ_ERROR("login.loginBizException", "loginBizException");

    private final String code;
    private final String errorMsg;

    private ApiErrorCode(String errorCode, String errorMsg) {
        this.code = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getStatusCode() {
        return this.code;
    }

    public String toString() {
        return this.errorMsg;
    }

    public static ApiErrorCode fromStatusCode(String errorCode) {
        for (ApiErrorCode s : ApiErrorCode.values()) {
            if (!s.code.equals(errorCode)) continue;
            return s;
        }
        return null;
    }
}

