/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.exception;

import java.text.MessageFormat;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.openapi.common.constant.ApiErrorCode;

public class OpenApiException
extends KDException {
    private static final long serialVersionUID = 3424240424445L;
    private int httpStatus = 200;

    public OpenApiException(ApiErrorCode errorCode, int httpStatus, String messageTemplate, Object ... params) {
        super(new ErrorCode(errorCode.getStatusCode(), OpenApiException.getFormat(messageTemplate, params)), new Object[0]);
        this.httpStatus = httpStatus;
    }

    public OpenApiException(ApiErrorCode errorCode, String messageTemplate, Object ... params) {
        super(new ErrorCode(errorCode.getStatusCode(), OpenApiException.getFormat(messageTemplate, params)), new Object[0]);
    }

    public OpenApiException(Throwable cause, ApiErrorCode errorCode, String messageTemplate, Object ... params) {
        super(cause, new ErrorCode(errorCode.getStatusCode(), OpenApiException.getFormat(messageTemplate, params)), new Object[0]);
    }

    public String getCode() {
        return this.getErrorCode().getCode();
    }

    private static String getFormat(String messageTemplate, Object[] params) {
        if (params == null || params.length == 0) {
            return messageTemplate;
        }
        return messageTemplate.contains("{0}") ? MessageFormat.format(messageTemplate, params) : String.format(messageTemplate, params);
    }

    public static void throwNotImplementedException() {
        throw new OpenApiException(ApiErrorCode.HTTP_NOT_ACCEPTABLE, "This method is not implemented.", new Object[0]);
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    @Deprecated
    public OpenApiException(String message) {
        super(new ErrorCode("", message), new Object[0]);
    }

    @Deprecated
    public OpenApiException(String message, Throwable cause) {
        super(cause, new ErrorCode("", message), new Object[0]);
    }

    @Deprecated
    public OpenApiException(Throwable cause) {
        super(cause, new ErrorCode("", ""), new Object[0]);
    }

    @Deprecated
    public OpenApiException(String messageTemplate, Object ... params) {
        super(new ErrorCode("", OpenApiException.getFormat(messageTemplate, params)), new Object[0]);
    }

    @Deprecated
    public OpenApiException(String code, String message, Throwable cause) {
        super(cause, new ErrorCode(code, message), new Object[0]);
    }
}

