/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.jackson.dser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import kd.bos.openapi.common.util.DataUtil;

public final class CustomDateDeserializer
extends JsonDeserializer<Date> {
    public static final CustomDateDeserializer instance = new CustomDateDeserializer();

    private CustomDateDeserializer() {
    }

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String dateString = jsonParser.getText();
        try {
            Timestamp timestamp = DataUtil.t(dateString);
            if (timestamp == null) {
                return null;
            }
            Date date = new Date(timestamp.getTime());
            return date;
        }
        catch (Exception exception) {
            throw new IOException("Failed to parse date: " + dateString);
        }
    }
}

