/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.model;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import kd.bos.openapi.common.util.PathVariableMatcher;
import kd.bos.openapi.common.util.PathVariableUtil;
import org.apache.commons.lang3.StringUtils;

public class ApiUriModel {
    private final String apiUri;
    private final boolean isPathVariable;
    private int wordCount;
    private PathVariableMatcher pathVariableMatcher;

    public ApiUriModel(String apiUri) {
        Objects.requireNonNull(apiUri, "api uri not null");
        this.apiUri = apiUri;
        this.isPathVariable = PathVariableUtil.isPathVariableUri(apiUri);
        if (this.isPathVariable) {
            this.wordCount = StringUtils.countMatches((CharSequence)apiUri, (char)'/');
            this.pathVariableMatcher = new PathVariableMatcher(apiUri);
        }
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public boolean isPathVariable() {
        return this.isPathVariable;
    }

    public int getWordCount() {
        return this.wordCount;
    }

    public Map<String, String> getMatchValues(String requestUri) {
        if (!this.isPathVariable) {
            return Collections.emptyMap();
        }
        return this.pathVariableMatcher.match(requestUri);
    }

    public boolean isMatch(String requestUri) {
        return this.pathVariableMatcher.isMatch(requestUri);
    }
}

