/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiAlarmService;
import kd.bos.openapi.common.spi.OpenApiAsyncDataService;
import kd.bos.openapi.common.spi.OpenApiBillService;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiSdkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiDataServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(OpenApiDataServiceFactory.class);
    private static OpenApiDataService openApiDataService = (OpenApiDataService)OpenApiDataServiceFactory.loadService(OpenApiDataService.class);
    private static OpenApiSdkService openApiSdkService = (OpenApiSdkService)OpenApiDataServiceFactory.loadService(OpenApiSdkService.class);
    private static OpenApiAlarmService openApiAlarmService = (OpenApiAlarmService)OpenApiDataServiceFactory.loadService(OpenApiAlarmService.class);
    private static OpenApiAsyncDataService openApiAsyncDataService = (OpenApiAsyncDataService)OpenApiDataServiceFactory.loadService(OpenApiAsyncDataService.class);
    private static OpenApiBillService openApiBillService = (OpenApiBillService)OpenApiDataServiceFactory.loadService(OpenApiBillService.class);

    private static Object loadService(Class<?> clazz) {
        ServiceLoader<?> loadedService = ServiceLoader.load(clazz);
        Iterator<?> serviceIterator = loadedService.iterator();
        try {
            if (serviceIterator.hasNext()) {
                return serviceIterator.next();
            }
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "Cannot found ServiceImpl:" + clazz.getCanonicalName(), new Object[0]);
        }
        catch (Throwable e) {
            log.info("An error occurred while creating the OpenApiDataServiceFactory:", e);
            return null;
        }
    }

    public static OpenApiDataService getOpenApiDataService() {
        if (openApiDataService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiDataService.", new Object[0]);
        }
        return openApiDataService;
    }

    public static OpenApiSdkService getOpenApiSdkService() {
        if (openApiDataService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiSdkService.", new Object[0]);
        }
        return openApiSdkService;
    }

    public static OpenApiAlarmService getOpenApiAlarmService() {
        if (openApiAlarmService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiSdkService.", new Object[0]);
        }
        return openApiAlarmService;
    }

    public static OpenApiAsyncDataService getOpenApiAsyncDataService() {
        if (openApiAsyncDataService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiAsyncDataService.", new Object[0]);
        }
        return openApiAsyncDataService;
    }

    public static OpenApiBillService getOpenApiBillService() {
        if (openApiBillService == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "An error occurred while getting the OpenApiBillService.", new Object[0]);
        }
        return openApiBillService;
    }
}

