/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheUtil {
    private static Logger logger = LoggerFactory.getLogger(CacheUtil.class);
    private static final String APPID_KEY = "_openapi_";
    private static final int CACHE_TIME_OUT = 600;
    private static final int CACHE_MAX_ITEM_SIZE = 10000;
    private static final int CACHE_MAX_MEM_SIZE = 200;

    public static LocalMemoryCache getLocalMemoryCache(String cacheType, String accountId) {
        return CacheUtil.getLocalMemoryCache(cacheType, 600, accountId);
    }

    public static LocalMemoryCache getLocalMemoryCache(String cacheType, int timeOutInSeconds, String accountId) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(timeOutInSeconds);
        info.setTimeToLive(true);
        info.setMaxItemSize(10000);
        info.setMaxMemSize(200);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("OpenAPI".concat(accountId), cacheType, info);
    }

    public static Object getCacheByKey(String cacheType, String key, String accountId) {
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        return CacheUtil.getLocalMemoryCache(cacheType, accountId).get(newKey);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, String accountId) {
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        CacheUtil.getLocalMemoryCache(cacheType, accountId).put(newKey, value);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, int timeOutInSeconds, String accountId) {
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        CacheUtil.getLocalMemoryCache(cacheType, timeOutInSeconds, accountId).put(newKey, value);
    }

    public static void removeCacheByKey(String cacheType, String key, String accountId) {
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        CacheUtil.getLocalMemoryCache(cacheType, accountId).remove(new String[]{newKey});
    }

    public static void clear(String cacheType, String accountId) {
        CacheUtil.getLocalMemoryCache(cacheType, accountId).clear();
    }

    public static <T> boolean checkIsInCache(Class<T> dataType, String key, String accountId) {
        String cacheType = dataType.getName();
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        Object object = CacheUtil.getLocalMemoryCache(dataType.getName(), accountId).get(newKey);
        return object != null;
    }

    public static <T> T getCacheByKey(Class<T> dataType, String key, String accountId) {
        String cacheType = dataType.getName();
        String newKey = CacheUtil.getNewCacheKey(accountId, cacheType, key);
        return (T)CacheUtil.getLocalMemoryCache(dataType.getName(), accountId).get(newKey);
    }

    public static <T> void removeCacheByKey(Class<T> dataType, String key, String accountId) {
        CacheUtil.removeCacheByKey(dataType.getName(), key, accountId);
    }

    public static <T> void setCacheByKey(String key, T object, String accountId) {
        CacheUtil.setCacheByKey(object.getClass().getName(), key, object, accountId);
    }

    public static <T> void clear(Class<T> dataType, String accountId) {
        CacheUtil.clear(dataType.getName(), accountId);
    }

    public static String getNewCacheKey(String cacheType, String key) {
        String accountId = RequestContext.get().getAccountId();
        return CacheUtil.getNewCacheKey(accountId, cacheType, key);
    }

    public static String getNewCacheKey(String accountId, String cacheType, String key) {
        return accountId + APPID_KEY + cacheType + "_" + key;
    }
}

