/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;

public class ClassNameSpaceUtil {
    private static final String HTTP_PREFIX = "http://";
    private static final char SPLIT_CHAR = '.';

    public static String genNameSpace(String className, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genNameSpace exception, the classLoader should not be null", new Object[0]);
        }
        if (StringUtil.isEmpty(className)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genNameSpace exception, the className should not be null or empty", new Object[0]);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "genNameSpace exception, the className " + className + " is not found", new Object[0]);
        }
        String packageName = clazz.getPackage().getName();
        StringBuilder sbNameSpace = new StringBuilder();
        String[] packageNames = packageName.split("\\.");
        for (int i = packageNames.length - 1; i >= 0; --i) {
            sbNameSpace.append(packageNames[i]).append('.');
        }
        return HTTP_PREFIX + sbNameSpace.subSequence(0, sbNameSpace.length() - 1).toString();
    }
}

