/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.lang.reflect.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;

public class ConvertObjectHelper {
    public static <T> T convertFromDynamicObject(DynamicObject dynamicObject, Class<T> tClass) {
        T instance = null;
        try {
            Field[] fields = tClass.getDeclaredFields();
            instance = tClass.newInstance();
            for (Field field : fields) {
                ApiParam property = field.getAnnotation(ApiParam.class);
                if (property == null) continue;
                String fieldId = StringUtil.isNotEmpty(property.example()) ? property.example() : field.getName();
                field.set(instance, dynamicObject.get(fieldId));
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.ERROR.getStatusCode(), " convertFromDynamicObject error:" + e.getMessage(), e);
        }
        return instance;
    }

    @Deprecated
    public static <T> DynamicObject convertToDynamicObject(T data) throws IllegalAccessException, InstantiationException {
        if (data == null || data.getClass().getAnnotation(ApiModel.class) == null) {
            return null;
        }
        return null;
    }

    public static <T> DynamicObject convertToDynamicObject(String dyName, T data) throws IllegalAccessException, InstantiationException {
        Field[] fields;
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dyName));
        for (Field field : fields = data.getClass().getDeclaredFields()) {
            ApiParam property = field.getAnnotation(ApiParam.class);
            if (property == null) continue;
            dynamicObject.set(field.getName(), field.get(data));
        }
        return dynamicObject;
    }
}

