/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class IOUtil {
    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            IOUtil.doNothing();
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception ex) {
            IOUtil.doNothing();
        }
    }

    public static byte[] getByteArray(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            byte[] data = outputStream.toByteArray();
            outputStream.close();
            byte[] byArray = data;
            return byArray;
        }
    }

    public static String getString(InputStream inputStream, Charset charset) throws IOException {
        byte[] data = IOUtil.getByteArray(inputStream);
        String ret = new String(data, charset);
        return ret;
    }

    private static void doNothing() {
    }
}

