/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.security.SecureRandom;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RandomUtil {
    private static final Log log = LogFactory.getLog(RandomUtil.class);
    private static final String UPPERCASE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String LOWERCASE_LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private static final String NUMERIC_CHARACTERS = "0123456789";
    private static final String SPECIAL_CHARACTERS = "!@#$%^&*()-_=+[]{}|;:',.<>/?";
    private static final String DEFAULT_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final String LOCK_KEY_RANDOM = "randomStringLock";
    private static final long LOCK_TIME = 5000L;
    private static final int MAX_RETRIES = 5;
    private static final long RETRY_WAIT_TIME = 100L;

    public static String getRandomString(int length) {
        return RandomUtil.getRandomString(length, DEFAULT_CHARACTERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRandomString(int length, String customCharacters) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be greater than 0");
        }
        if (customCharacters == null || customCharacters.isEmpty()) {
            throw new IllegalArgumentException("Custom characters must not be null or empty");
        }
        for (int attempt = 0; attempt < 5; ++attempt) {
            DLock dLock = DLock.create((String)LOCK_KEY_RANDOM);
            if (dLock.tryLock(5000L)) {
                try {
                    StringBuilder result = new StringBuilder(length);
                    for (int i = 0; i < length; ++i) {
                        int randomIndex = RANDOM.nextInt(customCharacters.length());
                        result.append(customCharacters.charAt(randomIndex));
                    }
                    String string = result.toString();
                    return string;
                }
                catch (Exception e) {
                    log.info("Random String Generation Exception", (Object)e);
                    String string = "";
                    return string;
                }
                finally {
                    dLock.unlock();
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("Thread was interrupted during random string generation", (Object)e);
                return "";
            }
        }
        return "";
    }

    public static String getUppercaseRandomString(int length) {
        return RandomUtil.getRandomString(length, UPPERCASE_LETTERS);
    }

    public static String getLowercaseRandomString(int length) {
        return RandomUtil.getRandomString(length, LOWERCASE_LETTERS);
    }

    public static String getNumericRandomString(int length) {
        return RandomUtil.getRandomString(length, NUMERIC_CHARACTERS);
    }

    public static String getSpecialRandomString(int length) {
        return RandomUtil.getRandomString(length, SPECIAL_CHARACTERS);
    }

    public static String getAlphaRandomString(int length) {
        return RandomUtil.getRandomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
    }

    public static String getAlphaNumericRandomString(int length) {
        return RandomUtil.getRandomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static String getAlphaNumericSpecialRandomString(int length) {
        return RandomUtil.getRandomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()-_=+[]{}|;:',.<>/?");
    }

    public static String getRandomString(int length, boolean includeUppercase, boolean includeLowercase, boolean includeNumeric, boolean includeSpecial) {
        StringBuilder characterSet = new StringBuilder();
        if (includeUppercase) {
            characterSet.append(UPPERCASE_LETTERS);
        }
        if (includeLowercase) {
            characterSet.append(LOWERCASE_LETTERS);
        }
        if (includeNumeric) {
            characterSet.append(NUMERIC_CHARACTERS);
        }
        if (includeSpecial) {
            characterSet.append(SPECIAL_CHARACTERS);
        }
        if (characterSet.length() == 0) {
            throw new IllegalArgumentException("At least one character set must be selected");
        }
        return RandomUtil.getRandomString(length, characterSet.toString());
    }
}

