/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;

public class XmlUtil {
    public static final char GT = '>';
    public static final String CRLF = "\r\n";
    public static final String LT2 = "</";
    public static final char LT = '<';
    public static final String XML_ROOT = "root";
    public static final List<Character> XML_CHARS = Arrays.asList(Character.valueOf('&'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf('\"'), Character.valueOf('\''));

    public static String objectToXml(Object obj) {
        return XmlUtil.objectToXml(obj, true, false, true, XML_ROOT, 0);
    }

    public static String objectToXml(Object obj, String xmlRootName) {
        return XmlUtil.objectToXml(obj, true, false, true, xmlRootName, 0);
    }

    public static String objectToXml(Object obj, boolean isFormat, boolean showComment, boolean isIncludeRoot, int indent) {
        return XmlUtil.objectToXml(obj, isFormat, showComment, isIncludeRoot, XML_ROOT, indent);
    }

    public static String objectToXml(Object obj, boolean isFormat, boolean showComment, boolean isIncludeRoot, String xmlRootName, int indent) {
        StringBuffer xml = new StringBuffer();
        if (isIncludeRoot) {
            XmlUtil.getXmlPrefix(xml, isFormat, xmlRootName);
        }
        if (!isFormat) {
            showComment = false;
        }
        Stack<Boolean> stack = new Stack<Boolean>();
        XmlUtil.objToXml(xml, obj, stack, isFormat, showComment, indent);
        if (isIncludeRoot) {
            XmlUtil.appendXmlSuffix(xml, isFormat, xmlRootName);
        }
        return xml.toString();
    }

    public static String jsonToXml(String json, boolean isFormat, boolean showComment, int indent) {
        return XmlUtil.jsonToXml(json, isFormat, showComment, indent, XML_ROOT);
    }

    public static String jsonToXml(String json, boolean isFormat, boolean showComment, int indent, String xmlRootName) {
        try {
            StringBuffer xml = new StringBuffer();
            XmlUtil.getXmlPrefix(xml, isFormat, xmlRootName);
            Object jsonObject = JSON.parse((String)json);
            if (!isFormat) {
                showComment = false;
            }
            Stack<Boolean> stack = new Stack<Boolean>();
            XmlUtil.objToXml(xml, jsonObject, stack, isFormat, showComment, indent);
            XmlUtil.appendXmlSuffix(xml, isFormat, xmlRootName);
            return xml.toString();
        }
        catch (Exception e) {
            throw new OpenApiException(e, ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"XML \u6570\u636e\u89e3\u6790\u5f02\u5e38\u3002", (String)"XmlUtil_0", (String)"bos-open-common", (Object[])new Object[0]), new Object[0]);
        }
    }

    private static void getXmlPrefix(StringBuffer xml, boolean isFormat, String xmlRootName) {
        if (StringUtil.isEmpty(xmlRootName)) {
            xmlRootName = XML_ROOT;
        }
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (isFormat) {
            xml.append(CRLF);
        }
        xml.append("<").append(xmlRootName).append(">");
    }

    private static void appendXmlSuffix(StringBuffer xml, boolean isFormat, String xmlRootName) {
        if (StringUtil.isEmpty(xmlRootName)) {
            xmlRootName = XML_ROOT;
        }
        if (isFormat) {
            xml.append(CRLF);
        }
        xml.append(LT2).append(xmlRootName).append(">");
    }

    private static void objToXml(StringBuffer xml, Object obj, Stack<Boolean> stack, boolean isFormat, boolean showComment, int indent) {
        if (obj == null) {
            return;
        }
        if (DataUtil.isBaseType(obj)) {
            XmlUtil.getIndent(xml, stack, isFormat, indent);
            xml.append(obj.toString());
            return;
        }
        Object json = JSON.toJSON((Object)obj);
        if (json instanceof Map) {
            JSONObject jsonObject = (JSONObject)json;
            XmlUtil.jsonToXml(jsonObject, xml, stack, isFormat, showComment, indent);
        } else if (json instanceof List) {
            List jsonArray = (List)json;
            for (Object o : jsonArray) {
                XmlUtil.objToXml(xml, o, stack, isFormat, showComment, indent);
            }
        } else {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "xml exception\uff1a" + json.getClass().getName(), new Object[0]);
        }
    }

    private static StringBuffer jsonToXml(JSONObject jsonObject, StringBuffer xml, Stack<Boolean> stack, boolean isFormat, boolean showComment, int indent) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                XmlUtil.getLeft(xml, stack, true, isFormat, indent).append(key).append('>').append(XmlUtil.xmlNote(Object.class, showComment));
                XmlUtil.jsonToXml((JSONObject)value, xml, stack, isFormat, showComment, indent);
                XmlUtil.getLeft2(xml, stack, isFormat, indent).append(key).append('>');
                continue;
            }
            if (value instanceof List) {
                JSONArray jArray = (JSONArray)value;
                for (Object o : jArray) {
                    XmlUtil.getLeft(xml, stack, true, isFormat, indent).append(key);
                    if (o instanceof Map) {
                        xml.append('>').append(XmlUtil.xmlNote(List.class, showComment));
                        XmlUtil.jsonToXml((JSONObject)o, xml, stack, isFormat, showComment, indent);
                        XmlUtil.getLeft2(xml, stack, isFormat, indent).append(key).append('>');
                        continue;
                    }
                    if (o instanceof List) {
                        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"%s\uff1a\u4e0d\u652f\u6301\u591a\u7ef4\u6570\u7ec4\u3002", (String)"XmlUtil_1", (String)"bos-open-common", (Object[])new Object[0]), key));
                    }
                    xml.append('>');
                    stack.pop();
                    xml.append(o).append(LT2).append(key).append('>').append(XmlUtil.xmlNote(Array.class, showComment));
                }
                continue;
            }
            String strValue = DataUtil.s(value);
            if (strValue != null) {
                boolean hasChar = false;
                for (int i = 0; i < strValue.length(); ++i) {
                    if (!XML_CHARS.contains(Character.valueOf(strValue.charAt(i)))) continue;
                    hasChar = true;
                    break;
                }
                if (hasChar) {
                    strValue = "<![CDATA[" + strValue + "]]>";
                }
            }
            XmlUtil.getLeft(xml, stack, false, isFormat, indent).append(key).append('>').append(strValue);
            XmlUtil.getLeft2(xml, stack, isFormat, indent).append(key).append('>').append(XmlUtil.xmlNote(value == null ? Object.class : value.getClass(), showComment));
        }
        return xml;
    }

    private static String xmlNote(Class<?> typeClass, boolean showComment) {
        if (!showComment) {
            return "";
        }
        return "\t<!-- " + typeClass.getSimpleName() + " -->";
    }

    private static StringBuffer getLeft(StringBuffer xml, Stack<Boolean> stack, boolean isWrap, boolean isFormat, int indent) {
        XmlUtil.getIndent(xml, stack, isFormat, indent);
        xml.append('<');
        stack.push(isWrap);
        return xml;
    }

    private static StringBuffer getIndent(StringBuffer xml, Stack<Boolean> stack, boolean isFormat, int indent) {
        if (isFormat) {
            xml.append(CRLF);
            for (int i = 0; i < stack.size() + indent + 1; ++i) {
                xml.append('\t');
            }
        }
        return xml;
    }

    private static StringBuffer getLeft2(StringBuffer xml, Stack<Boolean> stack, boolean isFormat, int indent) {
        if (stack.pop().booleanValue() && isFormat) {
            xml.append(CRLF);
            for (int i = 0; i < stack.size() + indent + 1; ++i) {
                xml.append('\t');
            }
        }
        xml.append(LT2);
        return xml;
    }
}

