/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.plugin.form;

import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ResourceOperationLogListPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(ResourceOperationLogListPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("view".equals(operationKey)) {
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection listSelectedRows = listView.getSelectedRows();
            if (listSelectedRows.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e00\u884c\u3002", (String)"ResourceOperationLogListPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                return;
            }
            if (listSelectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"ResourceOperationLogListPlugin_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                return;
            }
            Object selectedId = listSelectedRows.getPrimaryKeyValues()[0];
            if (selectedId == null) {
                return;
            }
            DynamicObject log = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"res_pub_operation_log");
            String entity = log.getString("type.number");
            if (this.objIsNotDeleted(entity, log.get("typeid"))) {
                BillShowParameter param = new BillShowParameter();
                param.setFormId(entity);
                param.setPkId(log.get("typeid"));
                param.setCustomParam("oplog", (Object)"1");
                param.getOpenStyle().setShowType(this.getShowType(entity));
                param.setCustomParam("MUTEX_OBJ_ID", (Object)String.valueOf(log.get("typeid")));
                param.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private ShowType getShowType(String entity) {
        return ShowType.MainNewTabPage;
    }

    private boolean objIsNotDeleted(String type, Object id) {
        QFilter qFilter = new QFilter("id", "=", id);
        DynamicObject obj = QueryServiceHelper.queryOne((String)type, (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (obj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"ResourceOperationLogListPlugin_2", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), Integer.valueOf(1500));
        }
        return obj != null;
    }
}

