/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.plugin.form;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.isc.util.misc.Hash;
import kd.bos.isc.util.misc.Json;
import kd.bos.isc.util.misc.NetUtil;
import kd.bos.isc.util.misc.StringUtil;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.model.ThirdAppApplyValidateResultDto;
import kd.bos.open.res.plugin.service.ServiceFacetory;
import kd.bos.open.res.util.ResourceClientUtil;
import kd.bos.open.res.util.WarningMessageTypeEnum;
import kd.bos.openapi.base.util.ProductLineEnum;
import kd.bos.openapi.base.util.ProductLineUtil;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.IPWhiteListUtil;
import kd.bos.openapi.common.util.RandomUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.AESUtils;

public class ThirdAppApplyFormPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(ThirdAppApplyFormPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        BillShowParameter parameter = (BillShowParameter)e.getFormShowParameter();
        Map<String, Object> data = this.getData();
        if (!data.isEmpty()) {
            parameter.setPkId((Object)D.l((Object)data.get("id")));
            this.setFormStatus(parameter, data);
        }
    }

    private Map<String, Object> getData() {
        String curAccountId = RequestContext.get().getAccountId();
        Map<String, Object> data = this.queryData(curAccountId);
        return data;
    }

    private void setFormStatus(BillShowParameter parameter, Map<String, Object> data) {
        if ("A".equals(data.get("billstatus"))) {
            parameter.setStatus(OperationStatus.EDIT);
        } else {
            parameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id == 0L) {
            this.initData();
        } else {
            String tenantId = D.s((Object)this.getModel().getValue("tenantid"));
            String accountId = D.s((Object)this.getModel().getValue("accountid"));
            this.checkEnvironment(id, tenantId, accountId);
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if ("A".equalsIgnoreCase(billStatus)) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"phone,email,username");
            this.getModel().setValue("applier", (Object)D.s((Object)user.get("id")));
            this.updateProdInstance();
            this.updateTenantAndAccount();
            this.getModel().setValue("appilerusername", user.getLocaleString("name").getDefaultItem());
        }
        String targetUrl = D.s((Object)this.getModel().getValue("targeturl"));
        if ("R".equalsIgnoreCase(billStatus) && !IPWhiteListUtil.isNetworkEnable((String)targetUrl)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            return;
        }
        if ("R".equalsIgnoreCase(billStatus)) {
            this.refreshStatus();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.updateButtonVisible();
    }

    private void updateProdInstance() {
        String instanceNumber = (String)this.getModel().getValue("instancenumber");
        List licenseProductInfos = LicenseServiceHelper.getProductInfos();
        if (kd.bos.openapi.common.util.StringUtil.isEmpty((String)instanceNumber)) {
            String instanceNumberNew = CollectionUtil.isNotEmpty((Collection)licenseProductInfos) ? (String)((Map)licenseProductInfos.get(0)).get("prodInstCode") : "";
            instanceNumber = kd.bos.openapi.common.util.StringUtil.isNotEmpty((String)instanceNumberNew) && !instanceNumberNew.equalsIgnoreCase(instanceNumber) ? instanceNumberNew : instanceNumber;
        }
        this.getModel().setValue("instancenumber", (Object)instanceNumber);
    }

    private void updateButtonVisible() {
        String billstatus = (String)this.getModel().getValue("billstatus");
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean isOpLog = "1".equals(parameter.getCustomParam("oplog"));
        boolean isReApply = ("S".equals(billstatus) || "F".equals(billstatus)) && !isOpLog;
        this.getView().setVisible(Boolean.valueOf(isReApply), new String[]{"re_apply"});
        this.getView().setVisible(Boolean.valueOf("A".equals(billstatus)), new String[]{"bar_save,cancelapply"});
        this.getView().setVisible(Boolean.valueOf("A".equals(billstatus)), new String[]{"bar_submit"});
        this.getView().setVisible(Boolean.valueOf(!isOpLog), new String[]{"btn_show_log", "refreshstatus"});
        this.getView().setVisible(Boolean.valueOf("R".equals(billstatus)), new String[]{"revoke"});
    }

    private void checkEnvironment(long id, String tenantId, String accountId) {
        String curTenantId = RequestContext.get().getTenantId();
        String curAccountId = RequestContext.get().getAccountId();
        if (!curTenantId.equals(tenantId) || !curAccountId.equals(accountId)) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"res_pub_thirdapp_apply"), (Object[])new Object[]{id});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u6709\u7533\u8bf7\u8bb0\u5f55\u4e0e\u5f53\u524d\u73af\u5883\u8d26\u5957ID\u6216\u79df\u6237ID\u4e0d\u5339\u914d\uff0c\u8bf7\u5173\u95ed\u5f53\u524d\u9875\u9762\uff0c\u91cd\u65b0\u63d0\u4ea4\u4e91\u8d44\u6e90\u5e94\u7528\u7533\u8bf7\u3002", (String)"ThirdAppApplyFormPlugin_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }

    private Map<String, Object> queryData(String accountId) {
        String sql = "SELECT TOP 1 fid as id,fbillstatus as billstatus,fthirdcode as thirdcode,fbillno as billno,ftenantid as tenantid,faccountid as accountid, fversion as version FROM t_pub_res_app_apply where faccountid=? order by fversion desc ";
        Object[] params = new SqlParameter[]{new SqlParameter(":Faccountid", 12, (Object)accountId)};
        Map result = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            ResultSetMetaData md = rs.getMetaData();
            ArrayList resultList = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Object> rowData = new HashMap<String, Object>(10);
                for (int i = 1; i <= md.getColumnCount(); ++i) {
                    rowData.put(md.getColumnName(i).toLowerCase(), rs.getObject(i));
                }
                resultList.add(rowData);
            }
            if (resultList.size() > 0) {
                return (Map)resultList.get(0);
            }
            return new HashMap(1);
        });
        return result;
    }

    private void updateTenantAndAccount() {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        Account currentCenter = AccountUtils.getAccountById((String)accountId);
        this.getModel().setValue("tenantid", (Object)tenantId);
        this.getModel().setValue("tenantname", (Object)RequestContext.get().getTenantInfo().getName());
        this.getModel().setValue("accountid", (Object)accountId);
        this.getModel().setValue("accountname", (Object)currentCenter.getAccountName());
    }

    private void initData() {
        String serverUrl = D.s((Object)System.getProperty("public.resource.server"));
        if (serverUrl != null) {
            this.getModel().setValue("targeturl", (Object)serverUrl.trim());
        } else {
            this.getModel().setValue("targeturl", (Object)"https://resource.kdcloud.com/");
        }
        String serverAccountId = D.s((Object)System.getProperty("public.resource.accountid"));
        if (serverAccountId != null) {
            this.getModel().setValue("targetaccountid", (Object)serverAccountId.trim());
        } else {
            this.getModel().setValue("targetaccountid", (Object)"143244152805884929");
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user", (String)"phone,email,username");
        String phone = D.s((Object)user.get("phone"));
        String email = "";
        if (phone != null) {
            this.getModel().setValue("phone", (Object)phone);
        }
        int version = 1;
        String randString = Hash.mur2digital32((Object[])new Object[]{RequestContext.get().getTenantId() + ',' + RequestContext.get().getAccountId() + ',' + version});
        String thirdCode = "KDRS_" + randString;
        String alphaNumericRandomString = RandomUtil.getAlphaNumericRandomString((int)3);
        email = thirdCode + version + alphaNumericRandomString + "@kingdee.com";
        this.getModel().setValue("email", (Object)email);
        this.getModel().setValue("source", (Object)ProductLineEnum.getProductLineByCode((String)ProductLineUtil.getProductLine()).getSource());
        this.refreshDigest(false);
        this.refreshAccessToken(false);
        this.refreshThirdCodeAndBillno(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("targeturl".equals(propName)) {
            String server = D.s((Object)this.getModel().getValue("targeturl"));
            if (server != null) {
                server = server.trim();
                try {
                    if (!IPWhiteListUtil.isNetworkEnable((String)server)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                        return;
                    }
                    List<Map<String, Object>> dataCenters = this.queryDataCenters(server);
                    String accountId = "";
                    if (!CollectionUtil.isEmpty(dataCenters)) {
                        Map<String, Object> objectMap = dataCenters.get(0);
                        accountId = String.valueOf(objectMap.get("accountId"));
                    }
                    this.getModel().setValue("targetaccountid", (Object)accountId);
                }
                catch (Exception ex) {
                    LOG.error("error:" + ex.getMessage(), (Throwable)ex);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e91\u7aef\u670d\u52a1\u5668\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_11", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        try {
            if ("save_ext".equalsIgnoreCase(operate.getOperateKey()) || "submit".equalsIgnoreCase(operate.getOperateKey())) {
                String accesstoken;
                boolean valid;
                String targetUrl = D.s((Object)this.getModel().getValue("targeturl"));
                if (!IPWhiteListUtil.isNetworkEnable((String)targetUrl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String phone = D.s((Object)this.getModel().getValue("phone"));
                Pattern pattern = Pattern.compile("^[1]\\d{10}$");
                boolean bl = valid = kd.bos.openapi.common.util.StringUtil.isNotEmpty((String)phone) && pattern.matcher(phone).matches();
                if (!valid) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u4e0d\u5408\u6cd5\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ThirdAppApplyFormPlugin_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    args.setCancel(true);
                }
                String thirdCode = (String)this.getModel().getValue("thirdcode");
                String email = (String)this.getModel().getValue("email");
                if (!StringUtils.isEmail((String)email)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"ThirdAppApplyFormPlugin_2", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                targetUrl = targetUrl == null ? "" : targetUrl.trim();
                this.getModel().setValue("targeturl", (Object)targetUrl);
                if (!this.validateTargetUrl(targetUrl)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u4e91\u7aef\u5730\u5740\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e91\u7aef\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_23", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto(thirdCode, targetUrl, (String)this.getModel().getValue("tenantid"), (String)this.getModel().getValue("accountid"));
                thirdAppApplyDto.setEmail(email);
                thirdAppApplyDto.setTargetaccountid((String)this.getModel().getValue("targetaccountid"));
                ServiceFacetory.getThirdAppApplyService().checkEmailServerExits(thirdAppApplyDto);
                ThirdAppApplyValidateResultDto thirdCodeExitsResult = ServiceFacetory.getThirdAppApplyService().checkThirdCodeServerValid(thirdAppApplyDto);
                if (!thirdCodeExitsResult.isOldCode() && !thirdCodeExitsResult.isApplyExits() && thirdCodeExitsResult.isThirdAppExits()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\uff1a%s \u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ThirdAppApplyFormPlugin_4", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), email));
                    args.setCancel(true);
                }
                if (thirdCodeExitsResult.isApplyExits() && "R".equalsIgnoreCase(thirdCodeExitsResult.getApplyStatus())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\uff1a%s \u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u6570\u636e\u4e2d\u5fc3\u5df2\u6709\u4e00\u4e2a\u7533\u8bf7\u5355\u5728\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6279\u3002", (String)"ThirdAppApplyFormPlugin_5", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), thirdCode));
                    args.setCancel(true);
                }
                if (thirdCodeExitsResult.isApplyExits() && "D".equalsIgnoreCase(thirdCodeExitsResult.getApplyStatus())) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e94\u7528\u7f16\u7801\uff1a%s \u63d0\u4ea4\u5931\u8d25\uff0c\u8be5\u7f16\u7801\u5728\u670d\u52a1\u7aef\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u63d0\u4ea4\u7533\u8bf7\u3002", (String)"ThirdAppApplyFormPlugin_6", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), thirdCode));
                    args.setCancel(true);
                }
                if (kd.bos.openapi.common.util.StringUtil.isEmpty((String)(accesstoken = (String)this.getModel().getValue("accesstoken"))) || !EncrypterFactory.getEncrypter().isEncrypted(accesstoken)) {
                    if (StringUtils.isEmpty((CharSequence)accesstoken) || !accesstoken.matches("^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$")) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"AccessToken\u8ba4\u8bc1\u5bc6\u94a5\u4e0d\u7b26\u5408\u5bc6\u7801\u590d\u6742\u6027\u53ca\u957f\u5ea6\u8981\u6c42\uff0816~50\u4f4d\u5b57\u7b26\uff0c\u5927\u5c0f\u5199\u53ca\u6570\u5b57\u3001\u7279\u6b8a\u7b26\u53f7\u6df7\u5408\uff09\u3002", (String)"OpenApi3rdappsPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    String publickey = (String)this.getModel().getValue("publickey");
                    if (kd.bos.openapi.common.util.StringUtil.isNotEmpty((String)publickey) && !EncrypterFactory.getEncrypter().isEncrypted(publickey)) {
                        this.getModel().setValue("publickey", (Object)EncrypterFactory.getEncrypter().encode(publickey));
                    }
                    this.getModel().setValue("accesstoken", (Object)EncrypterFactory.getEncrypter().encode(accesstoken));
                }
                if ("save_ext".equalsIgnoreCase(operate.getOperateKey())) {
                    targetUrl = D.s((Object)this.getModel().getValue("targeturl"));
                    if (!IPWhiteListUtil.isNetworkEnable((String)targetUrl)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.getView().invokeOperation("save");
                }
            }
        }
        catch (KDException e) {
            LOG.error("beforeDoOperation error:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(e.getMessage());
            args.setCancel(true);
        }
    }

    private boolean validateTargetUrl(String targetUrl) {
        try {
            List<Map<String, Object>> dataCenters = this.queryDataCenters(targetUrl);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        String thirdCode = D.s((Object)this.getModel().getValue("thirdcode"));
        String email = D.s((Object)this.getModel().getValue("email"));
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        operationResult.setShowMessage(false);
        if ("submit".equals(operateKey)) {
            if (operationResult.isSuccess()) {
                this.getModel().setValue("billstatus", (Object)"R");
                SaveServiceHelper.update((DynamicObject)this.getModel().getDataEntity());
                this.getModel().setDataChanged(false);
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
                this.getModel().updateCache();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u4e91\u7aef\u5ba1\u6838\uff0c\u8bf730s\u540e\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u83b7\u53d6\u5ba1\u6838\u7ed3\u679c\u3002", (String)"ThirdAppApplyFormPlugin_9", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), Integer.valueOf(15000));
                this.updateButtonVisible();
            } else {
                String message = operationResult.getMessage();
                if (WarningMessageTypeEnum.isInMessage((String)message)) {
                    if (WarningMessageTypeEnum.THIRD_CODE_NEW_EXITS_IN_APP.name().equals(message)) {
                        this.refreshThirdCodeAndBillno(true);
                    }
                    message = WarningMessageTypeEnum.getMessage((String)args.getOperationResult().getMessage(), (String)thirdCode, (String)email);
                } else {
                    if (CollectionUtil.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo()) && operationResult.getAllErrorOrValidateInfo() != null) {
                        StringBuilder opMessage = new StringBuilder();
                        for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                            opMessage.append(operateInfo.getMessage()).append(" ");
                        }
                        this.getView().showTipNotification(opMessage.toString());
                        return;
                    }
                    message = operationResult.getMessage();
                }
                this.getView().showErrorNotification(message);
            }
            return;
        }
        if ("revoke".equalsIgnoreCase(operateKey)) {
            ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
            Long id = (Long)this.getModel().getValue("id");
            if (id == 0L) {
                return;
            }
            thirdAppApplyDto.setId(id);
            thirdAppApplyDto.setTargeturl((String)this.getModel().getValue("targeturl"));
            thirdAppApplyDto.setTargetaccountid((String)this.getModel().getValue("targetaccountid"));
            ThirdAppApplyDto resultDto = ServiceFacetory.getThirdAppApplyService().findThirdApplyServerStatus(thirdAppApplyDto);
            if (null == resultDto || kd.bos.openapi.common.util.StringUtil.isEmpty((String)resultDto.getBillstatus())) {
                SqlBuilder sql = new SqlBuilder().append("UPDATE t_pub_res_app_apply set fbillstatus=? WHERE fid=?", new Object[]{"A", id});
                DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
                this.getView().invokeOperation("refresh");
                ResourceClientUtil.removeCache((String)RequestContext.get().getAccountId());
            } else if (null != resultDto) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff0c\u5e94\u7528\u7533\u8bf7\u5df2\u63d0\u4ea4\u8d44\u6e90\u4e91\u5ba1\u6279\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6279\u3002", (String)"ThirdAppApplyFormPlugin_30", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        }
        if (operationResult.isSuccess()) {
            if ("save_ext".equalsIgnoreCase(operateKey)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"ThirdAppApplyFormPlugin_8", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
            if ("modify".equals(operateKey) || "save".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.EDIT);
            } else if ("re_apply".equals(operateKey)) {
                DynamicObjectCollection dyc = QueryServiceHelper.query((String)"res_pub_thirdapp_apply", (String)"*", (QFilter[])new QFilter("thirdcode", "=", this.getModel().getValue("thirdcode")).toArray(), (String)"version desc", (int)1);
                DynamicObject dynamicObject = (DynamicObject)dyc.get(0);
                Integer version = dynamicObject.getInt("version");
                if (version > (Integer)this.getModel().getValue("version")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539\uff0c\u8bf7\u5237\u65b0\u6570\u636e\u540e\u91cd\u8bd5\u3002", (String)"ThirdAppApplyFormPlugin_28", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    this.getView().updateView();
                    this.getModel().updateCache();
                    this.getView().invokeOperation("refresh");
                    return;
                }
                DynamicObject dynamicObjectNew = BusinessDataServiceHelper.newDynamicObject((String)"res_pub_thirdapp_apply");
                DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dynamicObjectNew);
                dynamicObjectNew.set("version", (Object)(dynamicObject.getInt("version") + 1));
                long now = new Date().getTime();
                long currentUserId = RequestContext.get().getCurrUserId();
                DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user", (String)"phone,email,username");
                dynamicObjectNew.set("createtime", (Object)now);
                dynamicObjectNew.set("creator", (Object)currentUserId);
                dynamicObjectNew.set("modifytime", (Object)now);
                dynamicObjectNew.set("applier", (Object)currentUserId);
                dynamicObjectNew.set("appilerusername", user.get("name." + Lang.get().name()));
                dynamicObjectNew.set("modifier", (Object)currentUserId);
                dynamicObjectNew.set("parentid", dynamicObject.get("id"));
                dynamicObjectNew.set("billno", (Object)(dynamicObjectNew.getString("thirdcode") + dynamicObjectNew.getInt("version")));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjectNew});
                this.getModel().setValue("id", dynamicObjectNew.get("id"));
                this.getView().invokeOperation("refresh");
                this.getModel().setValue("billstatus", (Object)"A");
                this.getView().invokeOperation("save");
                this.getView().updateView();
                this.getModel().updateCache();
                this.getModel().setDataChanged(false);
                this.getView().setStatus(OperationStatus.EDIT);
                ResourceClientUtil.removeCache((String)RequestContext.get().getAccountId());
            } else if ("cancelapply".equals(operateKey)) {
                if (0L == (Long)this.getModel().getValue("parentid")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e00\u4e2a\u7248\u672c\uff0c\u65e0\u6cd5\u53d6\u6d88\u5f53\u524d\u7533\u8bf7\u3002", (String)"ThirdAppApplyFormPlugin_10", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    return;
                }
                Long parentId = (Long)this.getModel().getValue("parentid");
                Object[] idList = new Object[]{this.getModel().getValue("id")};
                DeleteServiceHelper.delete((String)"res_pub_thirdapp_apply", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"res_pub_thirdapp_apply");
                this.getModel().setValue("id", dynamicObject.get("id"));
                this.getView().invokeOperation("refresh");
                this.getView().setStatus(OperationStatus.VIEW);
            } else if ("refreshstatus".equals(operateKey)) {
                String targetUrl = D.s((Object)this.getModel().getValue("targeturl"));
                if (!IPWhiteListUtil.isNetworkEnable((String)targetUrl)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u4e91\u7aef\u73af\u5883\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u73af\u5883\u662f\u5426\u6709\u5916\u7f51\u8bbf\u95ee\u6743\u9650\u3002", (String)"ThirdAppApplyFormPlugin_29", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                    return;
                }
                this.refreshStatus();
                String billstatus = (String)this.getModel().getValue("billstatus");
                if ("A".equals(billstatus)) {
                    this.getView().setStatus(OperationStatus.EDIT);
                } else {
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                this.updateButtonVisible();
            } else if ("show_log".equals(operateKey)) {
                this.showLog();
            }
        } else {
            String dataError = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef", (String)"ThirdAppApplyFormPlugin_26", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]);
            String message = operationResult.getMessage();
            if (operationResult.getMessage().contains(dataError) && CollectionUtil.isNotEmpty((Collection)operationResult.getAllErrorOrValidateInfo()) && operationResult.getAllErrorOrValidateInfo() != null) {
                StringBuilder opMessage = new StringBuilder();
                for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
                    opMessage.append(operateInfo.getMessage()).append(" ");
                }
                message = opMessage.toString();
                this.getView().showTipNotification(message);
                return;
            }
            this.getView().showErrorNotification(message);
        }
    }

    private void refreshStatus() {
        ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
        Long id = (Long)this.getModel().getValue("id");
        if (id == 0L) {
            return;
        }
        thirdAppApplyDto.setId(id);
        thirdAppApplyDto.setTargeturl((String)this.getModel().getValue("targeturl"));
        thirdAppApplyDto.setTargetaccountid((String)this.getModel().getValue("targetaccountid"));
        ThirdAppApplyDto resultDto = ServiceFacetory.getThirdAppApplyService().findThirdApplyServerStatus(thirdAppApplyDto);
        if (resultDto.getBillstatus() != null && !resultDto.getBillstatus().equalsIgnoreCase(D.s((Object)this.getModel().getValue("billstatus")))) {
            SqlBuilder sql = new SqlBuilder().append("UPDATE t_pub_res_app_apply set fbillstatus=?,ffileserver=?,fsecretkey=? WHERE fid=?", new Object[]{resultDto.getBillstatus(), resultDto.getFileserver(), resultDto.getSecretKey(), id});
            DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
            this.getView().invokeOperation("refresh");
            ResourceClientUtil.removeCache((String)RequestContext.get().getAccountId());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit keyPublickey = (TextEdit)this.getView().getControl("publickey");
        keyPublickey.addClickListener((ClickListener)this);
        TextEdit keyAccesstoken = (TextEdit)this.getView().getControl("accesstoken");
        keyAccesstoken.addClickListener((ClickListener)this);
        TextEdit targetaccountid = (TextEdit)this.getView().getControl("targetaccountid");
        targetaccountid.addClickListener((ClickListener)this);
        TextEdit thirdcode = (TextEdit)this.getView().getControl("thirdcode");
        thirdcode.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof TextEdit) {
            TextEdit textEdit = (TextEdit)evt.getSource();
            if ("publickey".equalsIgnoreCase(textEdit.getKey())) {
                this.refreshDigest(true);
            } else if ("accesstoken".equalsIgnoreCase(textEdit.getKey())) {
                this.refreshAccessToken(true);
            } else if ("thirdcode".equalsIgnoreCase(textEdit.getKey())) {
                this.refreshThirdCodeAndBillno(true);
            } else if ("targetaccountid".equals(textEdit.getKey())) {
                String server = D.s((Object)this.getModel().getValue("targeturl"));
                if (server != null) {
                    server = server.trim();
                    this.openAccountList(server);
                    this.getModel().setValue("targeturl", (Object)server);
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4e91\u7aef\u670d\u52a1\u5668\u5730\u5740\u3002", (String)"ThirdAppApplyFormPlugin_11", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                }
            }
        }
    }

    public void openAccountList(String serverUrl) {
        try {
            List<Map<String, Object>> dataCenters = this.queryDataCenters(serverUrl);
            ArrayList<String> dcList = new ArrayList<String>(dataCenters.size());
            for (Map<String, Object> dc : dataCenters) {
                dcList.add(dc.get("accountName") + "(" + dc.get("accountId") + ")");
            }
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("dc_list", dcList);
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_datacenter_list", (String)ResManager.loadKDString((String)"\u8d26\u5957\u5217\u8868", (String)"ThirdAppApplyFormPlugin_20", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), params, (String)"select_account");
        }
        catch (Exception e) {
            LOG.error("error:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e91\u7aef\u5730\u5740\u4e0d\u5b58\u5728\uff0c\u83b7\u53d6\u4e0d\u5230\u8d26\u5957\u4fe1\u606f\u3002", (String)"ThirdAppApplyFormPlugin_12", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }

    private List<Map<String, Object>> queryDataCenters(String serverUrl) throws IOException {
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        String fullUrl = serverUrl + "/auth/getAllDatacenters.do";
        Reader reader = NetUtil.httpGet((String)fullUrl, (String)"utf-8");
        List dataCenters = (List)Json.toObject((Reader)reader);
        return dataCenters;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String info;
        super.closedCallBack(evt);
        if ("select_account".equals(evt.getActionId()) && (info = D.s((Object)evt.getReturnData())) != null) {
            String accountId = info.substring(info.indexOf(40) + 1, info.lastIndexOf(41));
            this.getModel().setValue("targetaccountid", (Object)accountId);
        }
    }

    private void refreshThirdCodeAndBillno(boolean isShowMessage) {
        try {
            Integer version = (Integer)this.getModel().getValue("version");
            String thirdCode = this.getThirdCode(version, 1);
            String name = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90_%s", (String)"ThirdAppApplyFormPlugin_21", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), thirdCode);
            this.getModel().setValue("name", (Object)name);
            if (isShowMessage) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u5f00\u653e\u5e94\u7528\u7f16\u7801\u6210\u529f\u3002", (String)"ThirdAppApplyFormPlugin_13", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOG.error("error:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f00\u653e\u5e94\u7528\u7f16\u7801\u751f\u6210\u5931\u8d25, the error: %s ", (String)"ThirdAppApplyFormPlugin_14", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), StringUtil.getCascadeMessage((Throwable)e)));
        }
    }

    private String getThirdCode(int version, int times) {
        if (times > 20) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "getThirdCode error: cannot get thirdCode from server.", new Object[0]);
        }
        boolean isNewData = this.getModel().getValue("id") == null || D.l((Object)this.getModel().getValue("id")) == 0L;
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String randString = Hash.mur2digital32((Object[])new Object[]{tenantId + ',' + accountId + ',' + version});
        String randomString = RandomUtil.getRandomString((int)2);
        String thirdcode = "KDRS_" + randString + randomString;
        if (!isNewData) {
            ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto(thirdcode, (String)this.getModel().getValue("targeturl"), tenantId, accountId);
            thirdAppApplyDto.setTargetaccountid((String)this.getModel().getValue("targetaccountid"));
            ThirdAppApplyValidateResultDto result = ServiceFacetory.getThirdAppApplyService().checkThirdCodeServerValid(thirdAppApplyDto);
            if (!result.isOldCode() && !result.isApplyExits() && result.isThirdAppExits()) {
                thirdcode = this.getThirdCode(++version, ++times);
            }
        }
        this.getModel().setValue("thirdcode", (Object)thirdcode);
        this.getModel().setValue("billno", (Object)(thirdcode + version));
        this.getModel().setValue("version", (Object)version);
        return thirdcode;
    }

    private void refreshDigest(boolean isShowMessage) {
        try {
            String base64EncodeKey = AESUtils.getBase64EncodeKey();
            this.getModel().setValue("publickey", (Object)EncrypterFactory.getEncrypter().encode(base64EncodeKey));
            if (isShowMessage) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6458\u8981\u8ba4\u8bc1\u5bc6\u94a5\u6210\u529f\u3002", (String)"ThirdAppApplyFormPlugin_15", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOG.error("error:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6458\u8981\u8ba4\u8bc1\u5bc6\u94a5\u751f\u6210\u5931\u8d25\u3002", (String)"ThirdAppApplyFormPlugin_16", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }

    private void refreshAccessToken(boolean isShowMessage) {
        try {
            String accessToken = EncryptUtil.generatePwCode();
            this.getModel().setValue("accesstoken", (Object)EncrypterFactory.getEncrypter().encode(accessToken));
            if (isShowMessage) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0AccessToken\u5bc6\u94a5\u6210\u529f\u3002", (String)"ThirdAppApplyFormPlugin_17", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            LOG.error("error:" + e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"AccessToken\u5bc6\u94a5\u751f\u6210\u5931\u8d25\u3002", (String)"ThirdAppApplyFormPlugin_18", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }

    private void showLog() {
        String type = this.getModel().getDataEntityType().getName();
        if (kd.bos.openapi.common.util.StringUtil.isNotEmpty((String)type)) {
            FormOpener.openBillList((AbstractFormPlugin)this, (String)"res_pub_operation_log", Collections.singletonList(new QFilter("type", "=", (Object)type)), (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u65e5\u5fd7", (String)"ThirdAppApplyFormPlugin_22", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"ThirdAppApplyFormPlugin_19", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
    }
}

