/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.open.res.plugin.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.isc.util.misc.Hash;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.open.res.model.ThirdAppApplyDto;
import kd.bos.open.res.model.ThirdAppApplyInfoDto;
import kd.bos.open.res.plugin.service.ServiceFacetory;
import kd.bos.open.res.service.ThirdAppApplyClientService;
import kd.bos.open.res.util.OpenApiSecurityUtil;
import kd.bos.open.res.util.ResourceClientUtil;
import kd.bos.openapi.base.util.ProductLineEnum;
import kd.bos.openapi.base.util.ProductLineUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.RandomUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.service.authorize.model.ApiCommonResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.AESUtils;

public class ThirdAppApplyClientServiceImpl
implements ThirdAppApplyClientService {
    private static Log logger = LogFactory.getLog(ThirdAppApplyClientServiceImpl.class);

    public ThirdAppApplyDto findThirdAppApply(String accountId) {
        try {
            ThirdAppApplyDto result = this.findNewThirdAppApply(accountId);
            if (result != null) {
                return result;
            }
            this.copyOldDataToThirdAppApply(accountId);
            result = this.findNewThirdAppApply(accountId);
            return result;
        }
        catch (Exception e) {
            String message = "ThirdAppApplyClientService.findThirdAppApply error:" + e.getMessage();
            logger.error(message, (Throwable)e);
            throw new KDBizException(new ErrorCode("", message), new Object[0]);
        }
    }

    private ThirdAppApplyDto findNewThirdAppApply(String accountId) {
        return this.findNewThirdAppApply(accountId, "S");
    }

    private ThirdAppApplyDto findNewThirdAppApply(String accountId, String billStatus) {
        String base_sql = "SELECT TOP 1 fid as id,fbillstatus as billstatus,fthirdcode as thirdcode,fbillno as billno,ftenantid as tenantid,faccountid as accountid, fversion as version,fname as name, fphone as phone, femail as email, fpublickey as publickey, faccesstoken as accesstoken, ftargetaccountid as targetaccountid, ftargeturl as targeturl,finstancenumber as instancenumber, fapplier as applier,fappilerusername as appilerusername, ffileserver as fileserver, fsecretkey as secretkey  FROM t_pub_res_app_apply where faccountid=? ";
        if (StringUtil.isNotEmpty((String)billStatus)) {
            base_sql = base_sql + " and fbillstatus=? ";
        }
        String sql = base_sql + " order by fversion desc ";
        ArrayList<SqlParameter> parameterList = new ArrayList<SqlParameter>(2);
        parameterList.add(new SqlParameter(":Faccountid", 12, (Object)accountId));
        if (StringUtil.isNotEmpty((String)billStatus)) {
            parameterList.add(new SqlParameter(":fbillstatus", 12, (Object)billStatus));
        }
        ThirdAppApplyDto result = (ThirdAppApplyDto)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])parameterList.toArray(), rs -> {
            ArrayList<ThirdAppApplyDto> resultList = new ArrayList<ThirdAppApplyDto>(10);
            while (rs.next()) {
                ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
                thirdAppApplyDto.setAccesstoken(rs.getString("accesstoken"));
                thirdAppApplyDto.setPublickey(rs.getString("publickey"));
                thirdAppApplyDto.setId(Long.valueOf(rs.getLong("id")));
                thirdAppApplyDto.setAccountid(rs.getString("accountid"));
                thirdAppApplyDto.setTenantid(rs.getString("tenantid"));
                thirdAppApplyDto.setBillno(rs.getString("billno"));
                thirdAppApplyDto.setBillstatus(rs.getString("billstatus"));
                thirdAppApplyDto.setName(rs.getString("name"));
                thirdAppApplyDto.setPhone(rs.getString("phone"));
                thirdAppApplyDto.setEmail(rs.getString("email"));
                thirdAppApplyDto.setTargetaccountid(rs.getString("targetaccountid"));
                thirdAppApplyDto.setTargeturl(rs.getString("targeturl"));
                thirdAppApplyDto.setThirdcode(rs.getString("thirdcode"));
                thirdAppApplyDto.setVersion(Integer.valueOf(rs.getInt("version")));
                thirdAppApplyDto.setInstancenumber(rs.getString("instancenumber"));
                thirdAppApplyDto.setApplier(Long.valueOf(rs.getLong("applier")));
                thirdAppApplyDto.setAppilerusername(rs.getString("appilerusername"));
                thirdAppApplyDto.setFileserver(rs.getString("fileserver"));
                thirdAppApplyDto.setSecretKey(rs.getString("secretkey"));
                resultList.add(thirdAppApplyDto);
            }
            if (resultList.size() > 0) {
                return (ThirdAppApplyDto)resultList.get(0);
            }
            return null;
        });
        return result;
    }

    private void copyOldDataToThirdAppApply(String accountId) {
        String sql = "SELECT TOP 1 fid as id,fstatus as billstatus,fapp_number as thirdcode,ftenantid as tenantid,faccountid as accountid, fapp_name as name, fphone as phone, femail as email, fpublickey_enp as publickey, fpublickey_enp as accesstoken, fserver_accountid as targetaccountid, fserver_url as targeturl, fmodifier as applier,ffileserver as fileserver,fcreator,fcreatetime,fmodifier,fmodifytime  FROM T_ISCR_APP_APPLY where faccountid=? and fstatus in ('B','C') order by fmodifytime desc ";
        Object[] params = new SqlParameter[]{new SqlParameter(":Faccountid", 12, (Object)accountId)};
        ThirdAppApplyDto result = (ThirdAppApplyDto)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)sql, (Object[])params, rs -> {
            ArrayList<ThirdAppApplyDto> resultList = new ArrayList<ThirdAppApplyDto>(10);
            while (rs.next()) {
                ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
                thirdAppApplyDto.setAccesstoken(rs.getString("accesstoken"));
                thirdAppApplyDto.setPublickey(rs.getString("publickey"));
                thirdAppApplyDto.setId(Long.valueOf(rs.getLong("id")));
                thirdAppApplyDto.setAccountid(rs.getString("accountid"));
                thirdAppApplyDto.setTenantid(rs.getString("tenantid"));
                thirdAppApplyDto.setBillstatus(rs.getString("billstatus"));
                thirdAppApplyDto.setName(rs.getString("name"));
                thirdAppApplyDto.setPhone(rs.getString("phone"));
                thirdAppApplyDto.setEmail(rs.getString("email"));
                thirdAppApplyDto.setTargetaccountid(rs.getString("targetaccountid"));
                thirdAppApplyDto.setTargeturl(rs.getString("targeturl"));
                thirdAppApplyDto.setThirdcode(rs.getString("thirdcode"));
                thirdAppApplyDto.setApplier(Long.valueOf(rs.getLong("applier")));
                thirdAppApplyDto.setFileserver(rs.getString("fileserver"));
                thirdAppApplyDto.setCreatorid(Long.valueOf(rs.getLong("fcreator")));
                thirdAppApplyDto.setCreatetime(rs.getTimestamp("fcreatetime"));
                thirdAppApplyDto.setModifierid(Long.valueOf(rs.getLong("fmodifier")));
                thirdAppApplyDto.setModifytime(rs.getTimestamp("fmodifytime"));
                resultList.add(thirdAppApplyDto);
            }
            if (resultList.size() > 0) {
                return (ThirdAppApplyDto)resultList.get(0);
            }
            return null;
        });
        if (result == null) {
            return;
        }
        sql = "INSERT INTO t_pub_res_app_apply(fid,fbillstatus,fthirdcode,fbillno,ftenantid,faccountid,fversion,fname,fphone,femail,fpublickey,faccesstoken,ftargetaccountid,ftargeturl,finstancenumber,fapplier,fappilerusername,ffileserver,fsource,fcreatorid,fmodifierid,fmodifytime,fcreatetime,ftenantname,faccountname) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
        params = new SqlParameter[25];
        params[0] = new SqlParameter(":fid", -5, (Object)DB.genLongId((String)"t_pub_res_app_apply"));
        params[1] = new SqlParameter(":fbillstatus", 12, (Object)"S");
        params[2] = new SqlParameter(":fthirdcode", 12, (Object)result.getThirdcode());
        params[3] = new SqlParameter(":fbillno", 12, (Object)(result.getThirdcode() + "1"));
        params[4] = new SqlParameter(":ftenantid", 12, (Object)result.getTenantid());
        params[5] = new SqlParameter(":faccountid", 12, (Object)result.getAccountid());
        params[6] = new SqlParameter(":fversion", -5, (Object)1);
        params[7] = new SqlParameter(":fname", 12, (Object)result.getName());
        params[8] = new SqlParameter(":fphone", 12, (Object)result.getPhone());
        params[9] = new SqlParameter(":femail", 12, (Object)result.getEmail());
        params[10] = new SqlParameter(":fpublickey", 12, (Object)result.getPublickey());
        params[11] = new SqlParameter(":faccesstoken", 12, (Object)result.getAccesstoken());
        params[12] = new SqlParameter(":ftargetaccountid", 12, (Object)result.getTargetaccountid());
        params[13] = new SqlParameter(":ftargeturl", 12, (Object)result.getTargeturl());
        List licenseProductInfos = LicenseServiceHelper.getProductInfos();
        String instanceNumberNew = "";
        if (CollectionUtil.isNotEmpty((Collection)licenseProductInfos)) {
            instanceNumberNew = (String)((Map)licenseProductInfos.get(0)).get("prodInstCode");
        }
        params[14] = new SqlParameter(":finstancenumber", 12, (Object)instanceNumberNew);
        params[15] = new SqlParameter(":fapplier", -5, (Object)result.getApplier());
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)result.getApplier(), (String)"bos_user", (String)"phone,email,username");
        params[16] = new SqlParameter(":fappilerusername", 12, user.get("name." + Lang.get().name()));
        params[17] = new SqlParameter(":ffileserver", 12, (Object)result.getFileserver());
        params[18] = new SqlParameter(":fsource", 12, (Object)"1");
        params[19] = new SqlParameter(":fcreatorid", -5, (Object)result.getCreatorid());
        params[20] = new SqlParameter(":fmodifierid", -5, (Object)result.getModifierid());
        params[21] = new SqlParameter(":fmodifytime", 93, (Object)result.getModifytime());
        params[22] = new SqlParameter(":fcreatetime", 93, (Object)result.getCreatetime());
        Account currentCenter = AccountUtils.getAccountById((String)accountId);
        params[23] = new SqlParameter(":ftenantname", 12, (Object)RequestContext.get().getTenantInfo().getName());
        params[24] = new SqlParameter(":faccountname", 12, (Object)currentCenter.getAccountName());
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
    }

    public ApiCommonResult<ThirdAppApplyDto> findThirdAppApplyInfo(ThirdAppApplyInfoDto thirdAppApplyInfoDto) {
        ApiCommonResult apiCommonResult = null;
        ThirdAppApplyDto thirdAppApplyDto = this.findNewThirdAppApply(RequestContext.get().getAccountId(), null);
        if (thirdAppApplyDto == null) {
            ThirdAppApplyDto appApplyDto = this.saveAppApply(null);
            appApplyDto.setIsold("0");
            CustomApiResult result = OpenApiSecurityUtil.sendSignApiRequest((Object)appApplyDto, (String)appApplyDto.getTargeturl(), Map.class, (String)appApplyDto.getTargetaccountid());
            String message = "";
            boolean submitStatus = false;
            if (result != null && (ApiErrorCode.Data_Invalid.getStatusCode().equalsIgnoreCase(result.getErrorCode()) || ApiErrorCode.Data_UpdateFail.getStatusCode().equalsIgnoreCase(result.getErrorCode()))) {
                message = result.getMessage();
                submitStatus = false;
            } else if (result != null && result.getData() != null && "true".equalsIgnoreCase((String)((Map)result.getData()).get("status"))) {
                submitStatus = true;
            } else {
                message = result == null ? "result is null." : result.getMessage();
            }
            apiCommonResult = ApiCommonResult.getSuccessResult((String)"APPLY01", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u6210\u529f\uff0c\u8bf7\u7b49\u5f85\u4e91\u7aef\u5ba1\u6838\u540e\u518d\u6b21\u67e5\u8be2\u3002", (String)"ThirdAppApplyClientServiceImpl_1", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            if (!submitStatus) {
                apiCommonResult.setStatus(Boolean.valueOf(false));
                apiCommonResult.setErrorCode("APPLY03");
                apiCommonResult.setMessage(String.format(ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\u3002", (String)"ThirdAppApplyClientServiceImpl_0", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), message));
            } else {
                appApplyDto.setBillstatus("R");
                this.updateAppApplyStatus(appApplyDto);
            }
            return apiCommonResult;
        }
        if ("S".equals(thirdAppApplyDto.getBillstatus())) {
            if (StringUtil.isEmpty((String)thirdAppApplyDto.getSecretKey())) {
                ThirdAppApplyDto result = ServiceFacetory.getThirdAppApplyService().findThirdApplyServerStatus(thirdAppApplyDto);
                this.updateAppApplyStatus(result);
                thirdAppApplyDto.setSecretKey(result.getSecretKey());
            }
            apiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
            ResourceClientUtil.updateKey((ThirdAppApplyDto)thirdAppApplyDto);
            apiCommonResult.setData((Object)thirdAppApplyDto);
        } else if ("R".equals(thirdAppApplyDto.getBillstatus())) {
            ThirdAppApplyDto result = ServiceFacetory.getThirdAppApplyService().findThirdApplyServerStatus(thirdAppApplyDto);
            if ("S".equals(result.getBillstatus())) {
                result.setBillno(thirdAppApplyDto.getBillno());
                this.updateAppApplyStatus(result);
                apiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
                ThirdAppApplyDto theNewApply = this.findNewThirdAppApply(RequestContext.get().getAccountId(), "S");
                ResourceClientUtil.updateKey((ThirdAppApplyDto)theNewApply);
                apiCommonResult.setData((Object)theNewApply);
            } else if ("R".equals(result.getBillstatus())) {
                ThirdAppApplyDto theNewApply = this.findNewThirdAppApply(RequestContext.get().getAccountId(), "S");
                if (theNewApply != null) {
                    apiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
                    ResourceClientUtil.updateKey((ThirdAppApplyDto)theNewApply);
                    apiCommonResult.setData((Object)theNewApply);
                } else {
                    apiCommonResult = ApiCommonResult.getFailResult((String)"APPLY02", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u4e00\u6bb5\u65f6\u95f4\u540e\u518d\u6b21\u67e5\u8be2\u3002", (String)"ThirdAppApplyClientServiceImpl_2", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                }
            } else if ("F".equals(result.getBillstatus())) {
                thirdAppApplyDto = this.findNewThirdAppApply(RequestContext.get().getAccountId(), "S");
                if (thirdAppApplyDto != null) {
                    ResourceClientUtil.updateKey((ThirdAppApplyDto)thirdAppApplyDto);
                    apiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
                    apiCommonResult.setData((Object)thirdAppApplyDto);
                } else {
                    this.updateAppApplyStatus(result);
                    apiCommonResult = ApiCommonResult.getFailResult((String)"APPLY04", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u3010\u96c6\u6210\u670d\u52a1\u4e91-\u8d44\u6e90\u4e2d\u5fc3-\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u9875\u9762\u91cd\u65b0\u7533\u8bf7\u3002", (String)"ThirdAppApplyClientServiceImpl_3", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                }
            } else if ("D".equals(result.getBillstatus())) {
                apiCommonResult = ApiCommonResult.getFailResult((String)"APPLY03", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u670d\u52a1\u7aef\u72b6\u6001\u7981\u7528\u3002", (String)"ThirdAppApplyClientServiceImpl_10", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                this.updateAppApplyStatus(result);
            } else if ("A".equals(thirdAppApplyDto.getBillstatus())) {
                apiCommonResult = ApiCommonResult.getFailResult((String)"APPLY03", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u670d\u52a1\u7aef\u72b6\u6001\u6682\u5b58\u3002", (String)"ThirdAppApplyClientServiceImpl_9", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
                this.updateAppApplyStatus(result);
            }
        } else if ("F".equals(thirdAppApplyDto.getBillstatus())) {
            thirdAppApplyDto = this.findNewThirdAppApply(RequestContext.get().getAccountId(), "S");
            if (thirdAppApplyDto != null) {
                ResourceClientUtil.updateKey((ThirdAppApplyDto)thirdAppApplyDto);
                apiCommonResult = ApiCommonResult.getSuccessResult((String)"0", (String)"");
                apiCommonResult.setData((Object)thirdAppApplyDto);
            } else {
                apiCommonResult = ApiCommonResult.getFailResult((String)"APPLY04", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u3010\u96c6\u6210\u670d\u52a1\u4e91-\u8d44\u6e90\u4e2d\u5fc3-\u5e94\u7528\u5bc6\u94a5\u7533\u8bf7\u3011\u9875\u9762\u91cd\u65b0\u7533\u8bf7\u3002", (String)"ThirdAppApplyClientServiceImpl_3", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
            }
        } else {
            apiCommonResult = "D".equals(thirdAppApplyDto.getBillstatus()) ? ApiCommonResult.getFailResult((String)"APPLY03", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u72b6\u6001\u7981\u7528\u3002", (String)"ThirdAppApplyClientServiceImpl_7", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0])) : ApiCommonResult.getFailResult((String)"APPLY03", (String)ResManager.loadKDString((String)"\u8d26\u53f7\u7533\u8bf7\u63d0\u4ea4\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u72b6\u6001\u6682\u5b58\u3002", (String)"ThirdAppApplyClientServiceImpl_8", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]));
        }
        return apiCommonResult;
    }

    private void updateAppApplyStatus(ThirdAppApplyDto thirdAppApplyDto) {
        String sql_update_status = "UPDATE  t_pub_res_app_apply SET fbillstatus=?,fmodifierid=?,fmodifytime=? WHERE fbillno=? ";
        String sql_update_secretKey_status = "UPDATE  t_pub_res_app_apply SET fbillstatus=?,fsecretkey=?,fmodifierid=?,fmodifytime=?,ffileserver=? WHERE fbillno=? ";
        ArrayList<SqlParameter> parameterList = new ArrayList<SqlParameter>(10);
        String sql = sql_update_status;
        Timestamp now = new Timestamp(new Date().getTime());
        if (StringUtil.isNotEmpty((String)thirdAppApplyDto.getSecretKey())) {
            sql = sql_update_secretKey_status;
            parameterList.add(new SqlParameter(":fbillstatus", 12, (Object)thirdAppApplyDto.getBillstatus()));
            parameterList.add(new SqlParameter(":fsecretkey", 12, (Object)thirdAppApplyDto.getSecretKey()));
            parameterList.add(new SqlParameter(":fmodifierid", -5, (Object)0L));
            parameterList.add(new SqlParameter(":fmodifytime", 93, (Object)now));
            parameterList.add(new SqlParameter(":ffileserver", 12, (Object)thirdAppApplyDto.getFileserver()));
            parameterList.add(new SqlParameter(":fbillno", 12, (Object)thirdAppApplyDto.getBillno()));
        } else {
            parameterList.add(new SqlParameter(":fbillstatus", 12, (Object)thirdAppApplyDto.getBillstatus()));
            parameterList.add(new SqlParameter(":fmodifierid", -5, (Object)0L));
            parameterList.add(new SqlParameter(":fmodifytime", 93, (Object)now));
            parameterList.add(new SqlParameter(":fbillno", 12, (Object)thirdAppApplyDto.getBillno()));
        }
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])parameterList.toArray());
    }

    private ThirdAppApplyDto saveAppApply(String parEnvType) {
        ThirdAppApplyDto thirdAppApplyDto = new ThirdAppApplyDto();
        try {
            String envType = StringUtil.isEmpty((String)parEnvType) ? "PRD" : parEnvType;
            String domainUrl = "";
            long currentUserId = RequestContext.get().getCurrUserId();
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)currentUserId, (String)"bos_user", (String)"phone,email,username");
            String targetAccountId = "";
            switch (envType) {
                case "PRD": {
                    domainUrl = "https://resource.kdcloud.com/";
                    targetAccountId = "143244152805884929";
                    break;
                }
                case "SDX": {
                    domainUrl = "https://resource.kdcloud.com/";
                    targetAccountId = "1315295202205190910";
                    break;
                }
                case "TE": {
                    domainUrl = "https://devtest.kingdee.com:2024/resource_cloud/";
                    targetAccountId = "1335512780043717632";
                    break;
                }
                case "DEV": {
                    domainUrl = "http://172.19.111.6/ierp/";
                    targetAccountId = "1335527015687654400";
                    break;
                }
                default: {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, "invalid envType, envType is only PRD, SDX, TE, DEV.", new Object[0]);
                }
            }
            domainUrl = domainUrl.endsWith("/") ? domainUrl : domainUrl + "/";
            String targetUrl = domainUrl + "kapi/v2/kdec/kdec_public_resource/thirdapplyserver/createOrUpdate";
            thirdAppApplyDto.setTargeturl(targetUrl);
            thirdAppApplyDto.setTargetaccountid(targetAccountId);
            thirdAppApplyDto.setBillstatus("A");
            int version = 1;
            String randString = Hash.mur2digital32((Object[])new Object[]{RequestContext.get().getTenantId() + ',' + RequestContext.get().getAccountId() + ',' + version});
            String thirdCode = "KDRS_" + randString + RandomUtil.getRandomString((int)2);
            String billno = thirdCode + version;
            String randomString = RandomUtil.getRandomString((int)3);
            String email = billno + randomString + "@test.kingdee.com";
            thirdAppApplyDto.setThirdcode(thirdCode);
            String name = String.format(ResManager.loadKDString((String)"\u4e91\u8d44\u6e90_%s", (String)"ThirdAppApplyFormPlugin_21", (String)ResSystemType.PUB_FORM_PLUGIN.getType(), (Object[])new Object[0]), thirdCode);
            thirdAppApplyDto.setName(name);
            thirdAppApplyDto.setEmail(email);
            thirdAppApplyDto.setPhone(user.getString("phone"));
            thirdAppApplyDto.setPublickey(EncrypterFactory.getEncrypter().encode(AESUtils.getBase64EncodeKey()));
            thirdAppApplyDto.setAccesstoken(EncrypterFactory.getEncrypter().encode(EncryptUtil.generatePwCode()));
            thirdAppApplyDto.setAppilerusername(user.get("name.") + Lang.get().name());
            thirdAppApplyDto.setVersion(Integer.valueOf(version));
            thirdAppApplyDto.setBillno(billno);
            List licenseProductInfos = LicenseServiceHelper.getProductInfos();
            String instanceNumber = CollectionUtil.isNotEmpty((Collection)licenseProductInfos) ? (String)((Map)licenseProductInfos.get(0)).get("prodInstCode") : "";
            thirdAppApplyDto.setInstancenumber(instanceNumber);
            Account account = AccountUtils.getAccountById((String)RequestContext.get().getAccountId());
            thirdAppApplyDto.setTenantid(account.getTenantId());
            thirdAppApplyDto.setTenantname(RequestContext.get().getTenantInfo().getName());
            thirdAppApplyDto.setAccountid(account.getAccountId());
            thirdAppApplyDto.setAccountname(account.getAccountName());
            thirdAppApplyDto.setSource(ProductLineEnum.getProductLineByCode((String)ProductLineUtil.getProductLine()).getSource());
            String sql = "INSERT INTO t_pub_res_app_apply(fid,fbillstatus,fthirdcode,fbillno,ftenantid,faccountid,fversion,fname,fphone,femail,fpublickey,faccesstoken,ftargetaccountid,ftargeturl,finstancenumber,fapplier,fappilerusername,ffileserver,fsource,fcreatorid,fmodifierid,fmodifytime,fcreatetime,ftenantname,faccountname) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
            Timestamp now = new Timestamp(new Date().getTime());
            Object[] params = new SqlParameter[25];
            Long id = DB.genLongId((String)"t_pub_res_app_apply");
            thirdAppApplyDto.setId(id);
            params[0] = new SqlParameter(":fid", -5, (Object)id);
            params[1] = new SqlParameter(":fbillstatus", 12, (Object)thirdAppApplyDto.getBillstatus());
            params[2] = new SqlParameter(":fthirdcode", 12, (Object)thirdAppApplyDto.getThirdcode());
            params[3] = new SqlParameter(":fbillno", 12, (Object)thirdAppApplyDto.getBillno());
            params[4] = new SqlParameter(":ftenantid", 12, (Object)thirdAppApplyDto.getTenantid());
            params[5] = new SqlParameter(":faccountid", 12, (Object)thirdAppApplyDto.getAccountid());
            params[6] = new SqlParameter(":fversion", -5, (Object)thirdAppApplyDto.getVersion());
            params[7] = new SqlParameter(":fname", 12, (Object)thirdAppApplyDto.getName());
            params[8] = new SqlParameter(":fphone", 12, (Object)" ");
            params[9] = new SqlParameter(":femail", 12, (Object)thirdAppApplyDto.getEmail());
            params[10] = new SqlParameter(":fpublickey", 12, (Object)thirdAppApplyDto.getPublickey());
            params[11] = new SqlParameter(":faccesstoken", 12, (Object)thirdAppApplyDto.getAccesstoken());
            params[12] = new SqlParameter(":ftargetaccountid", 12, (Object)thirdAppApplyDto.getTargetaccountid());
            params[13] = new SqlParameter(":ftargeturl", 12, (Object)domainUrl);
            params[14] = new SqlParameter(":finstancenumber", 12, (Object)thirdAppApplyDto.getInstancenumber());
            params[15] = new SqlParameter(":fapplier", -5, (Object)currentUserId);
            params[16] = new SqlParameter(":fappilerusername", 12, (Object)thirdAppApplyDto.getThirdcode());
            params[17] = new SqlParameter(":ffileserver", 12, (Object)" ");
            params[18] = new SqlParameter(":fsource", 12, (Object)thirdAppApplyDto.getSource());
            params[19] = new SqlParameter(":fcreatorid", -5, (Object)currentUserId);
            params[20] = new SqlParameter(":fmodifierid", -5, (Object)currentUserId);
            params[21] = new SqlParameter(":fmodifytime", 93, (Object)now);
            params[22] = new SqlParameter(":fcreatetime", 93, (Object)now);
            params[23] = new SqlParameter(":ftenantname", 12, (Object)thirdAppApplyDto.getTenantname());
            params[24] = new SqlParameter(":faccountname", 12, (Object)thirdAppApplyDto.getAccountname());
            boolean result = DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])params);
            if (result) {
                return thirdAppApplyDto;
            }
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "saveAppApply error.", new Object[0]);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "saveAppApply error:" + e.getMessage(), new Object[]{e});
        }
    }

    public void createThirdAppApplyByEnvType(String envType) {
        this.saveAppApply(envType);
    }
}

