/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.acl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.model.IpModel;
import kd.bos.openapi.base.model.IpconfigSenseEnum;
import kd.bos.openapi.base.model.IpinfoModel;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class IplimitManager {
    private static final Log log = LogFactory.getLog(IplimitManager.class);
    private static final String OPENAPI_3RDAPPS = "third_app";
    private static final String THIRD_ENTRY_IP = "entryentity_ip";
    private static final String THIRD_ENTRY_IP_FROM_IP = "startip";
    private static final String THIRD_ENTRY_IP_TO_IP = "endip";
    private static final String THIRD_NO_LIMIT_IP = "allowip";
    private static final String THIRD_ENTRY_IP_POLICY_TYPE = "policytype";
    private static final String THIRD_ENTRY_IP_TYPE = "iptype";

    private static IpinfoModel getIpInfoModelFromDb(String thirdId) {
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "The thirdId cannot be null!", new Object[0]);
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(thirdId), (String)OPENAPI_3RDAPPS);
        if (object == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, "Can't find data by thirdId:%s.", new Object[]{thirdId});
        }
        IpinfoModel model = new IpinfoModel();
        model.setNoLimitAccess(false);
        if (object.getBoolean(THIRD_NO_LIMIT_IP)) {
            model.setList(new ArrayList<IpModel>());
            model.setNoLimitAccess(true);
            return model;
        }
        DynamicObjectCollection ipObjectList = object.getDynamicObjectCollection(THIRD_ENTRY_IP);
        ipObjectList.forEach(dynamicObject -> {
            String startIp = dynamicObject.getString(THIRD_ENTRY_IP_FROM_IP);
            String endIp = dynamicObject.getString(THIRD_ENTRY_IP_TO_IP);
            String policyType = dynamicObject.getString(THIRD_ENTRY_IP_POLICY_TYPE);
            String ipType = dynamicObject.getString(THIRD_ENTRY_IP_TYPE);
            if (IpTypeEnum.IPV4.getType().equals(ipType)) {
                if (StringUtils.isNotBlank((CharSequence)startIp) && StringUtils.isNotBlank((CharSequence)endIp) && StringUtils.isNotBlank((CharSequence)policyType)) {
                    if ("0".equals(policyType)) {
                        model.add(startIp, endIp);
                    } else if ("1".equals(policyType)) {
                        model.addBlack(startIp, endIp);
                    }
                }
            } else if (StringUtils.isNotBlank((CharSequence)startIp) && StringUtils.isNotBlank((CharSequence)endIp) && StringUtils.isNotBlank((CharSequence)policyType)) {
                model.addIPv6(policyType, startIp, endIp);
            }
        });
        boolean isWhiteEmpty = CollectionUtil.isEmpty(model.getList());
        boolean isBlackEmpty = CollectionUtil.isEmpty(model.getMapBlackList());
        if (isWhiteEmpty && isBlackEmpty) {
            model.setSense(IpconfigSenseEnum.NO_CONFIG.getSense());
        } else if (!isWhiteEmpty && isBlackEmpty) {
            model.setSense(IpconfigSenseEnum.WHITE.getSense());
        } else if (isWhiteEmpty && !isBlackEmpty) {
            model.setSense(IpconfigSenseEnum.BLACK.getSense());
        } else {
            model.setSense(IpconfigSenseEnum.WHITE_AND_BLACK.getSense());
        }
        boolean ipv6IsWhiteEmpty = CollectionUtil.isEmpty(model.getIpv6WhiteList());
        boolean ipv6IsBlackEmpty = CollectionUtil.isEmpty(model.getIpv6BlackList());
        if (ipv6IsWhiteEmpty && ipv6IsBlackEmpty) {
            model.setIpv6Sense(IpconfigSenseEnum.NO_CONFIG.getSense());
        } else if (!ipv6IsWhiteEmpty && ipv6IsBlackEmpty) {
            model.setIpv6Sense(IpconfigSenseEnum.WHITE.getSense());
        } else if (ipv6IsWhiteEmpty && !ipv6IsBlackEmpty) {
            model.setIpv6Sense(IpconfigSenseEnum.BLACK.getSense());
        } else {
            model.setIpv6Sense(IpconfigSenseEnum.WHITE_AND_BLACK.getSense());
        }
        return model;
    }

    public static IpinfoModel getIpInfoModelFromCache(String thirdId) {
        IpinfoModel model = (IpinfoModel)LocalCacheUtil.getCacheByKey("IpinfoModel", thirdId);
        if (model != null) {
            return model;
        }
        model = IplimitManager.getIpInfoModelFromDb(thirdId);
        LocalCacheUtil.setCacheByKey("IpinfoModel", thirdId, model);
        return model;
    }

    private static IpinfoModel getIpInfoModelFromDbByAccountId(String thirdId, String accountId) {
        Account account = AccountUtils.getAccountById((String)accountId);
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        IpinfoModel model = new IpinfoModel();
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql_third = " select fid,fallowip from t_open_3rdapps t where t.fid = ? and t.fenable ='1'  ";
            boolean allowIpAccess = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql_third, (Object[])new SqlParameter[]{new SqlParameter(":fid", -5, (Object)Long.valueOf(thirdId))}, rs -> {
                if (rs.next()) {
                    return rs.getBoolean("fallowip");
                }
                return true;
            });
            model.setNoLimitAccess(allowIpAccess);
            model.setList(new ArrayList<IpModel>());
            String sql = " select fid,fstartip,fendip,fpolicytype,fiptype  from t_open_3rdapps_ips t where t.fid=?  ";
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{new SqlParameter(":fid", -5, (Object)Long.valueOf(thirdId))}, rs -> {
                while (rs.next()) {
                    String startIp = rs.getString("fstartip");
                    String endIp = rs.getString("fendip");
                    String policyType = rs.getString("fpolicytype");
                    String ipType = rs.getString("fiptype");
                    if (IpTypeEnum.IPV4.getType().equals(ipType)) {
                        if ("0".equals(policyType)) {
                            model.add(startIp, endIp);
                            continue;
                        }
                        if (!"1".equals(policyType)) continue;
                        model.addBlack(startIp, endIp);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)startIp) || !StringUtils.isNotBlank((CharSequence)endIp) || !StringUtils.isNotBlank((CharSequence)policyType)) continue;
                    model.addIPv6(policyType, startIp, endIp);
                }
                return null;
            });
            boolean isWhiteEmpty = CollectionUtil.isEmpty(model.getList());
            boolean isBlackEmpty = CollectionUtil.isEmpty(model.getMapBlackList());
            if (isWhiteEmpty && isBlackEmpty) {
                model.setSense(IpconfigSenseEnum.NO_CONFIG.getSense());
            } else if (!isWhiteEmpty && isBlackEmpty) {
                model.setSense(IpconfigSenseEnum.WHITE.getSense());
            } else if (isWhiteEmpty && !isBlackEmpty) {
                model.setSense(IpconfigSenseEnum.BLACK.getSense());
            } else {
                model.setSense(IpconfigSenseEnum.WHITE_AND_BLACK.getSense());
            }
            boolean ipv6IsWhiteEmpty = CollectionUtil.isEmpty(model.getIpv6WhiteList());
            boolean ipv6IsBlackEmpty = CollectionUtil.isEmpty(model.getIpv6BlackList());
            if (ipv6IsWhiteEmpty && ipv6IsBlackEmpty) {
                model.setIpv6Sense(IpconfigSenseEnum.NO_CONFIG.getSense());
            } else if (!ipv6IsWhiteEmpty && ipv6IsBlackEmpty) {
                model.setIpv6Sense(IpconfigSenseEnum.WHITE.getSense());
            } else if (ipv6IsWhiteEmpty && !ipv6IsBlackEmpty) {
                model.setIpv6Sense(IpconfigSenseEnum.BLACK.getSense());
            } else {
                model.setIpv6Sense(IpconfigSenseEnum.WHITE_AND_BLACK.getSense());
            }
        }
        catch (Exception e) {
            log.error("getIpInfoModelFromDbByAccountId.getValue error:" + e.getMessage(), (Throwable)e);
        }
        return model;
    }

    public static IpinfoModel getIpInfoModelFromCacheByAccountId(String thirdId, String accountId) {
        IpinfoModel model = (IpinfoModel)CacheUtil.getCacheByKey((String)"IpinfoModel", (String)thirdId, (String)accountId);
        if (model != null) {
            return model;
        }
        model = IplimitManager.getIpInfoModelFromDbByAccountId(thirdId, accountId);
        CacheUtil.setCacheByKey((String)"IpinfoModel", (String)thirdId, (Object)model, (String)accountId);
        return model;
    }
}

