/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.acl;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;

public class ThirdAclExtManager {
    private static final Log log = LogFactory.getLog(ThirdAclExtManager.class);
    private static boolean isThirdAppAclExtEnable = false;
    private static boolean initThirdAclExt = false;

    public static boolean checkAcl(String thirdId, String apiId, String accountId) {
        if (!ThirdAclExtManager.isThirdAclExtOpen()) {
            return false;
        }
        boolean result = false;
        try {
            result = ApiSecurityFactory.getThirdAclService().checkAcl(thirdId, apiId, accountId);
        }
        catch (Exception e) {
            log.error("An error occurred while checking checkAcl in ThirdAclExtManager:" + e.getMessage(), (Throwable)e);
            result = false;
        }
        return result;
    }

    private static boolean isThirdAclExtOpen() {
        if (!initThirdAclExt && Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty(RequestContext.get().getTenantId() + "_openapi.allow.apiacl.plugin", Boolean.FALSE.toString()))) {
            try {
                ApiSecurityFactory.getThirdAclService();
                isThirdAppAclExtEnable = true;
            }
            catch (Throwable e) {
                isThirdAppAclExtEnable = false;
            }
            initThirdAclExt = true;
        }
        return isThirdAppAclExtEnable;
    }
}

