/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.custom.info;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.openapi.base.custom.info.CustomApiErrorCode;
import kd.bos.openapi.base.custom.info.CustomApiHeader;
import kd.bos.openapi.base.custom.info.CustomApiParam;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.resource.AnnotationMulLangUtil;
import kd.bos.openapi.common.util.StringUtil;

public class CustomApiInfo
implements Serializable {
    private String number;
    private String name;
    private ILocaleString nameML;
    private String url = "";
    private String apiId;
    private String inputParamsName;
    private String outputParamsName;
    private String namespace;
    private String methodName;
    private String apidefType;
    private HttpMethod httpMethod;
    private List<CustomApiParam> request;
    private List<CustomApiParam> response;
    private List<CustomApiHeader> headers = new ArrayList<CustomApiHeader>();
    private List<CustomApiErrorCode> errorCodes = new ArrayList<CustomApiErrorCode>();

    public String getNumber() {
        this.number = this.getUrl();
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getName() {
        return this.name;
    }

    public ILocaleString getNameML() {
        return this.nameML;
    }

    public void setName(String name) {
        this.nameML = AnnotationMulLangUtil.getLocaleString((String)name);
        this.name = this.nameML.getLocaleValue();
    }

    public String getUrl() {
        if (StringUtil.isNotEmpty((String)this.url)) {
            this.url = this.handleUrl(this.url);
        }
        this.url = this.url.startsWith("/") ? this.url.substring(1) : this.url;
        return this.url.endsWith("/") ? this.url.substring(0, this.url.length() - 1) : this.url;
    }

    public void setUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        this.url = StringUtil.isEmpty((String)this.url) ? url.trim().replace("//", "/") : (this.url + '/' + url.trim()).replace("//", "/");
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public List<CustomApiParam> getRequest() {
        return this.request;
    }

    public void setRequest(List<CustomApiParam> request) {
        this.request = request;
    }

    public List<CustomApiParam> getResponse() {
        return this.response;
    }

    public void setResponse(List<CustomApiParam> response) {
        this.response = response;
    }

    private String handleUrl(String url) {
        if (url.contains("//")) {
            url = url.replace("//", "/");
            url = this.handleUrl(url);
        }
        return url;
    }

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getInputParamsName() {
        return this.inputParamsName;
    }

    public void setInputParamsName(String inputParamsName) {
        this.inputParamsName = inputParamsName;
    }

    public String getOutputParamsName() {
        return this.outputParamsName;
    }

    public void setOutputParamsName(String outputParamsName) {
        this.outputParamsName = outputParamsName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getApidefType() {
        return this.apidefType;
    }

    public void setApidefType(String apidefType) {
        this.apidefType = apidefType;
    }

    public List<CustomApiHeader> getHeaders() {
        return this.headers;
    }

    public void addHeader(CustomApiHeader header) {
        this.headers.add(header);
    }

    public List<CustomApiErrorCode> getErrorCodes() {
        return this.errorCodes;
    }

    public void addErrorCodes(CustomApiErrorCode errorCode) {
        this.errorCodes.add(errorCode);
    }
}

