/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dataservice;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.dataservice.OpenApiDataServiceImpl;
import kd.bos.openapi.base.queue.OpenQueueFactory;
import kd.bos.openapi.base.queue.OpenQueuePriority;
import kd.bos.openapi.base.queue.OpenQueueType;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiAsyncMsgModel;
import kd.bos.openapi.common.model.OpenApiAsyncStatusEnum;
import kd.bos.openapi.common.spi.OpenApiAsyncDataService;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.controller.OpenApiController;
import kd.bos.openapi.kcf.core.OpenApiDeployment;

public class OpenApiAsyncDataServiceImpl
implements OpenApiAsyncDataService {
    private static final Log log = LogFactory.getLog(OpenApiDataServiceImpl.class);

    public long saveNewRequest(ApiServiceType apiServiceType, long reqId, long apiId, OpenApiRequest openApiRequest) {
        try {
            String requestJson = JacksonUtil.writeValueAsString((Object)openApiRequest);
            String inputPara = OpenApiDataServiceImpl.getJsonDataMask(requestJson);
            SqlBuilder sql = new SqlBuilder().append("insert into t_openapi_asyncdata(fid,fapiid,fstatus,finputpara,foutputpara,fcreatetime,fstarttime,fmodifytime,ferrmsg,furl,foutstatus) values (?,?,?,?,?,?,?,?,?,?,?)", new Object[]{reqId, apiId, OpenApiAsyncStatusEnum.Accepted.getStatus(), inputPara, null, new Date(), null, null, "", openApiRequest.getServiceApiData().getUrl(), Character.valueOf('2')});
            DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
        }
        catch (Exception ex) {
            log.error((Throwable)ex);
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, "Error occurred when save inputPara to queue, reason: " + ex.getMessage(), new Object[0]);
        }
        String queueName = String.valueOf(apiId);
        String remark = openApiRequest.getServiceApiData().getUrl();
        OpenApiAsyncMsgModel msg = new OpenApiAsyncMsgModel(apiServiceType.getCode(), reqId);
        OpenQueueFactory.getQueue(queueName).publish(reqId, queueName, OpenQueueType.ApiAction, OpenQueuePriority.Normal, new Date(), 1, msg, reqId, remark);
        return reqId;
    }

    public ApiServiceData<Object> queryResult(long reqId) {
        ApiServiceData result = null;
        String outPara = "";
        String sql = "select foutputpara from t_openapi_asyncdata  where fid = ? and fstatus>202";
        Object[] params = new Object[]{reqId};
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.asyncdata", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                outPara = row.getString("foutputpara");
            }
        }
        if (StringUtil.isNotEmpty((String)outPara)) {
            result = (ApiServiceData)JacksonUtil.readValue((String)outPara, (TypeReference)new TypeReference<ApiServiceData<Object>>(){});
        }
        return result;
    }

    public int getResultStatus(long reqId) {
        String sql = "select fstatus from t_openapi_asyncdata  where fid = ?";
        Object[] params = new Object[]{reqId};
        int status = OpenApiAsyncStatusEnum.NotFound.getStatus();
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.asyncdata", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                status = row.getInteger("fstatus");
            }
        }
        return status;
    }

    public long updateStatus(long reqId, int newStatus) {
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_asyncdata set fstatus=?,fmodifytime=? WHERE fid=?", new Object[]{newStatus, new Date(), reqId});
        int count = DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
        if (count > 0) {
            return newStatus;
        }
        return 0L;
    }

    public long saveResult(long reqId, ApiServiceData<Object> result, Date startTime, String errMsg) {
        String traceId = RequestContext.get().getTraceId();
        if (result != null) {
            errMsg = errMsg + result.getMessage();
        }
        errMsg = StringUtil.trim((String)errMsg, (int)1600);
        String outPara = JacksonUtil.writeValueAsString(result);
        boolean status = result != null ? result.isStatus() : false;
        char outstatus = status ? (char)'1' : '0';
        SqlBuilder sql = new SqlBuilder().append("UPDATE t_openapi_asyncdata set fstatus=?,fmodifytime=?,foutputpara=?,fstarttime=?, ferrmsg=?,ftraceid=?,foutstatus=? WHERE fid=?", new Object[]{OpenApiAsyncStatusEnum.Ready.getStatus(), new Date(), outPara, startTime, errMsg, traceId, Character.valueOf(outstatus), reqId});
        int count = DB.update((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (SqlBuilder)sql);
        if (count > 0) {
            return OpenApiAsyncStatusEnum.Ready.getStatus();
        }
        return 0L;
    }

    public OpenApiRequest getRequestData(long reqId) {
        OpenApiRequest request = null;
        String inputPara = "";
        String sql = "select finputpara from t_openapi_asyncdata  where fid = ? ";
        Object[] params = new Object[]{reqId};
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.asyncdata", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                inputPara = row.getString("finputpara");
            }
        }
        if (StringUtil.isNotEmpty((String)inputPara)) {
            request = (OpenApiRequest)JacksonUtil.readValue((String)inputPara, (TypeReference)new TypeReference<OpenApiRequest>(){});
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeApi(ApiServiceType apiServiceType, long reqId) {
        OpenApiRequest openApiRequest = this.getRequestData(reqId);
        OpenApiController controller = OpenApiDeployment.getOpenApiController((ApiServiceType)apiServiceType);
        ApiServiceData execResult = null;
        String errMsg = "";
        try {
            execResult = controller.asyncExecute(openApiRequest);
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
        }
        finally {
            this.saveResult(reqId, (ApiServiceData<Object>)execResult, new Date(), errMsg);
        }
        return reqId;
    }
}

