/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dataservice;

import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.model.ThirdAppAclModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.HttpStatus;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiBillModel;
import kd.bos.openapi.common.spi.OpenApiBillService;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenApiBillServiceImpl
implements OpenApiBillService {
    private static Logger logger = LoggerFactory.getLogger(OpenApiBillServiceImpl.class);
    private static final Date ServiceStartedDate = new Date();
    private static final String CacheType = "ApiBill";
    private static final int CacheTimeout = 360;
    private static final String KEY_OPENAPI_BILL_ENABLE = "OpenApi.Bill.Enabled";
    private static final String KEY_OPENAPI_BILL_STARTDATE = "OpenApi.Bill.StartDate";
    private static final String KEY_OPENAPI_BILL_CREDITCOUNT = "OpenApi.Bill.CreditCount";
    private static final String KEY_OPENAPI_BILL_NOTIFY = "OpenApi.Bill.AlertPercent";
    private static final long TAG_BILL_LICENSE_GROPUPID = 41L;
    private static final String KEY_OPENAPI_BizObj_LICENSE = "OpenApi.BizObj.LicEnabled";

    public boolean getBillEnabled() {
        boolean billEnabled = "true".equalsIgnoreCase(McConfigUtil.getPropertyByCurrent((String)KEY_OPENAPI_BILL_ENABLE, (String)"false"));
        return billEnabled;
    }

    public boolean getBillEnabledByApi3rdAppId() {
        ThirdAppAclModel appAclModel;
        String thirdId;
        boolean isBill = false;
        if (this.getBillEnabled() && StringUtil.isNotEmpty((String)(thirdId = RequestContext.get().getApi3rdAppId())) && !"null".equalsIgnoreCase(thirdId) && (appAclModel = ApilAclManager.getThirdAppAclInfoModelFromCache(thirdId)) != null) {
            isBill = !appAclModel.isPreset();
        }
        return isBill;
    }

    public boolean getBillControl() {
        if (!this.getBillEnabled()) {
            return false;
        }
        String dateStr = McConfigUtil.getPropertyByCurrent((String)KEY_OPENAPI_BILL_STARTDATE, (String)"2025/07/01");
        LocalDate startDate = DataUtil.localDate((String)dateStr);
        return LocalDate.now().isAfter(startDate);
    }

    public boolean checkAppBillLicense() {
        Date checkDate;
        if (!this.getBillEnabledByApi3rdAppId()) {
            return true;
        }
        Date now = new Date();
        OpenApiBillModel billModel = this.getBillModelFromCache(false);
        if (billModel != null) {
            if (billModel.getAvailableCnt() <= 0L) {
                String licenseMsg = ResManager.loadKDString((String)"API\u6d41\u91cf\u4f59\u989d\u4e0d\u8db3\uff0c\u8bf7\u589e\u8d2dAPI\u6d41\u91cf\u8bb8\u53ef\u3002", (String)"ApiLicense_2", (String)"bos-open-base", (Object[])new Object[0]);
                String logMsg = licenseMsg + billModel.toString();
                logger.error(logMsg);
                throw new OpenApiException(ApiErrorCode.Data_NoAuth, HttpStatus.FORBIDDEN.getStatusCode(), licenseMsg, new Object[0]);
            }
            Date licenseExpireDate = billModel.getLicenseDateTo();
            if (licenseExpireDate != null && licenseExpireDate.getTime() > 0L && now.after(licenseExpireDate)) {
                String resMsg = ResManager.loadKDString((String)"API\u6d41\u91cf\u8bb8\u53ef\u5df2\u8fc7\u671f\uff0c\u8bf7\u8d2d\u4e70API\u6d41\u91cf\u8bb8\u53ef\uff0c\u8bb8\u53ef\u6709\u6548\u671f\uff1a%1s\u3002", (String)"ApiLicense_3", (String)"bos-open-base", (Object[])new Object[0]);
                String msg = String.format(resMsg, licenseExpireDate);
                logger.error(msg);
                throw new OpenApiException(ApiErrorCode.Data_NoAuth, HttpStatus.FORBIDDEN.getStatusCode(), msg, new Object[0]);
            }
        }
        if (now.after(checkDate = DateUtil.getDateAdd((Date)ServiceStartedDate, (int)12, (int)600))) {
            Date billCaclDateExpire = new Date();
            if (billModel != null) {
                billCaclDateExpire = DateUtil.getDateAdd((Date)billModel.getBillCaclDate(), (int)12, (int)600);
            }
            if (billModel == null || now.after(billCaclDateExpire)) {
                String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6API\u6d41\u91cf\u8bb8\u53ef\u6570\u636e\uff0c\u8bf7\u52ff\u7981\u7528\u8ba1\u5212\u4efb\u52a1-API\u6570\u636e\u7edf\u8ba1\u4efb\u52a1\u3002", (String)"ApiLicense_4", (String)"bos-open-base", (Object[])new Object[0]);
                logger.error(msg);
                throw new OpenApiException(ApiErrorCode.Data_NoAuth, HttpStatus.FORBIDDEN.getStatusCode(), msg, new Object[0]);
            }
        }
        return true;
    }

    public boolean getBillAlert(long usedCount, long quotaCount) {
        String alertStr;
        long alertPercent;
        if (quotaCount <= 0L) {
            quotaCount = 1L;
        }
        boolean billAlert = usedCount / quotaCount * 100L > (alertPercent = (long)DataUtil.i((Object)(alertStr = McConfigUtil.getPropertyByCurrent((String)KEY_OPENAPI_BILL_NOTIFY, (String)"80"))));
        return billAlert;
    }

    public long getBillCreditCount() {
        String defaultCreditCountStr = "100000";
        String creditCountStr = McConfigUtil.getPropertyByCurrent((String)KEY_OPENAPI_BILL_CREDITCOUNT, (String)defaultCreditCountStr);
        long creditCount = DataUtil.l((Object)creditCountStr);
        return creditCount;
    }

    public long getBillLicenseNumber() {
        int licNum = LicenseServiceHelper.getTotalNumber((Object)41L);
        return licNum * 1000;
    }

    public Map<String, Date> getBillTimeRange() {
        Map dateMap = LicenseServiceHelper.getGroupTimeRange((Long)41L);
        return dateMap;
    }

    public OpenApiBillModel getBillModelFromCache(boolean refreshCache) {
        String accountId = RequestContext.get().getAccountId();
        String cacheKey = "OpenApiBillModel-" + accountId;
        OpenApiBillModel model = (OpenApiBillModel)CacheUtil.getCacheByKey((String)CacheType, (String)cacheKey, (String)accountId);
        if ((refreshCache || model == null) && (model = this.getBillModelFromDb()) != null) {
            CacheUtil.setCacheByKey((String)CacheType, (String)cacheKey, (Object)model, (int)360, (String)accountId);
        }
        return model;
    }

    private Date getBillStatDate() {
        Map<String, Date> dateMap = this.getBillTimeRange();
        return dateMap.get("beginDate");
    }

    private Date getBillExpireDate() {
        Map<String, Date> dateMap = this.getBillTimeRange();
        return dateMap.get("expireDate");
    }

    private OpenApiBillModel getBillModelFromDb() {
        String sql = "select ftime,fcnt,fsuccesscnt,fbillcnt from t_openapi_statdata_sum where ftype=11 ";
        return (OpenApiBillModel)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rs -> {
            if (rs.next()) {
                long time = rs.getLong("ftime");
                long licenseCnt = rs.getLong("fcnt");
                long creditCnt = rs.getLong("fsuccesscnt");
                long billCnt = rs.getLong("fbillcnt");
                Date caclDate = new Date(time);
                Date licenseStart = this.getBillStatDate();
                Date licenseTo = this.getBillExpireDate();
                if (licenseStart == null) {
                    licenseStart = new Date(0L);
                }
                if (licenseTo == null) {
                    licenseTo = new Date(0L);
                }
                return new OpenApiBillModel(this.getBillEnabled(), licenseCnt, creditCnt, billCnt, caclDate, licenseStart, licenseTo);
            }
            return null;
        });
    }

    private boolean getEnableOperationApiLicense() {
        return "true".equals(McConfigUtil.getPropertyByCurrent((String)KEY_OPENAPI_BizObj_LICENSE, (String)"false"));
    }

    public boolean checkLicenseByAppAndBizObj(String bizAppID, String bizObjID, Long userID) {
        if (this.getEnableOperationApiLicense()) {
            String cacheKey = "BizObjLic-" + bizAppID + "-" + bizObjID + "-" + userID;
            LicenseCheckResult license = (LicenseCheckResult)CacheUtil.getCacheByKey((String)CacheType, (String)cacheKey, (String)RequestContext.get().getAccountId());
            if (license == null) {
                license = LicenseServiceHelper.checkByAppAndBizObj((String)bizAppID, (String)bizObjID, (Long)userID);
                CacheUtil.setCacheByKey((String)CacheType, (String)cacheKey, (Object)license, (int)360, (String)RequestContext.get().getAccountId());
            }
            if (license != null && !license.getHasLicense().booleanValue()) {
                String licenseMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u6b64\u4e1a\u52a1\u5bf9\u8c61\u7684\u8bb8\u53ef", (String)"ApiLicense_1", (String)"bos-open-base", (Object[])new Object[0]);
                String msg = String.format("OpenAPI-%1s : bizAppId:%2s, bizObjId:%3s, userId:%4s, errorMsg:%5s", licenseMsg, bizAppID, bizObjID, userID + "(" + RequestContext.get().getUserName() + ")", license.getMsg());
                logger.error(msg);
                throw new OpenApiException(ApiErrorCode.Data_NoAuth, HttpStatus.FORBIDDEN.getStatusCode(), msg, new Object[0]);
            }
        }
        return true;
    }
}

