/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dataservice;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.dlock.DLock;
import kd.bos.entity.param.AppParam;
import kd.bos.id.ID;
import kd.bos.isc.util.format.Format;
import kd.bos.isc.util.misc.Json;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.base.acl.ApilAclManager;
import kd.bos.openapi.base.acl.ThirdAclExtManager;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiAclInfoModel;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.model.AppAclModel;
import kd.bos.openapi.base.model.ThirdAppAclModel;
import kd.bos.openapi.base.script.OpenApiScriptUtil;
import kd.bos.openapi.base.statdata.ApiStatService;
import kd.bos.openapi.base.util.ApiUriModelCacheUtil;
import kd.bos.openapi.base.util.CommonConfigUtil;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ConfigConstant;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.ApiUriModel;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.model.OpenApiLogModel;
import kd.bos.openapi.common.model.OpenApiStatModel;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.CommonDateUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.kcf.context.OpenApiContext;
import kd.bos.openapi.kcf.spi.OpenApiServiceManager;
import kd.bos.openapi.security.model.ApiIpInfoDto;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterOrgUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.session.SystemPropertyUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;

public class OpenApiDataServiceImpl
implements OpenApiDataService {
    private static final Log log = LogFactory.getLog(OpenApiDataServiceImpl.class);
    private static final String BOS_OPEN_ACTION = "bos-open-action";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final String COMMA = ",";
    private static final String V2 = "/v2/";
    private static final int REP_TIMEOUT = 30000;

    public OpenApiData getOpenApiData(String url) {
        String realUri = url;
        ApiUriModel apiUriModel = null;
        ApiModel apiCacheData = OpenApiDataUtil.getApiModelFromOnlyCache(url);
        if (apiCacheData == null && (apiUriModel = OpenApiDataServiceImpl.getPathVariableApiUriModel(url)) != null) {
            realUri = apiUriModel.getApiUri();
        }
        ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache(realUri);
        OpenApiData openApiData = new OpenApiData();
        openApiData.setApiId(apiModel.getId());
        openApiData.setApiNumber(apiModel.getNumber());
        openApiData.setAppId(apiModel.getAppId());
        openApiData.setAppRealId(apiModel.getAppRealId());
        openApiData.setCloudId(apiModel.getCloudId());
        openApiData.setUrl(apiModel.getUrl());
        openApiData.setApiServiceType(apiModel.getApiServiceType());
        openApiData.setHttpMethod(apiModel.getHttpMethod());
        openApiData.setBizObject(apiModel.getBizObject());
        openApiData.setClassName(apiModel.getClassName());
        openApiData.setMethodName(apiModel.getMethodName());
        openApiData.setNamespace(apiModel.getNamespace());
        openApiData.setWsInputParam(apiModel.getWsInputParam());
        openApiData.setWsOutputParam(apiModel.getWsOutputParam());
        openApiData.setOutParaWithoutStatus(apiModel.isOutParaWithoutStatus());
        openApiData.setApiDefType(apiModel.getApiDefType());
        openApiData.setApiOperationType(apiModel.getOperation());
        openApiData.setWsMethodName(apiModel.getWsMethodName());
        openApiData.setDyObjResult(apiModel.isDyObjResult());
        openApiData.setDesensitize(apiModel.isDesensitize());
        openApiData.setAsync(apiModel.isAsync());
        openApiData.setCheckRepeatReq(apiModel.isCheckRepeatReq());
        openApiData.setDefaultHeaders(apiModel.getDefaultHeaders());
        openApiData.setDeserializerPlugin(apiModel.getApiDeserializerPlugin());
        openApiData.setSerializerPlugin(apiModel.getApiSerializerPlugin());
        openApiData.setApiUriModel(apiUriModel);
        openApiData.setMuliLang(apiModel.isMuliLang());
        openApiData.setInDigestTemplate(apiModel.getInDigestTemplate());
        openApiData.setOutDigestTemplate(apiModel.getOutDigestTemplate());
        openApiData.setApiName(apiModel.getName());
        openApiData.setApiNameML(apiModel.getNameML());
        openApiData.setPlugintype(apiModel.getPlugintype());
        return openApiData;
    }

    private static ApiUriModel getPathVariableApiUriModel(String url) {
        if (!QueryServiceHelper.exists((String)"openapi_apilist", (QFilter[])QFilterUtil.builder().put("urlformat", "=", url).put(Version.VERSION, "=", Version.TWO.getVer()).build())) {
            int wordCount = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)url, (char)'/');
            Optional<Map.Entry> optional = ApiUriModelCacheUtil.getAllApiUriModelCache().entrySet().stream().filter(it -> ((ApiUriModel)it.getValue()).isPathVariable() && ((ApiUriModel)it.getValue()).getWordCount() == wordCount && ((ApiUriModel)it.getValue()).isMatch(url)).findFirst();
            if (optional.isPresent()) {
                return (ApiUriModel)optional.get().getValue();
            }
        }
        return null;
    }

    public Set<String> getReqMulValParams(String url) {
        ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache(url);
        if (apiModel != null) {
            return apiModel.getReqMulValParams();
        }
        return null;
    }

    public OpenApiData getOpenApiOldData(Map<String, String> params) {
        OpenApiData apiModel = OpenApiDataUtil.getApiOldModelFromCache(params);
        return apiModel;
    }

    public void checkClientIP() {
        String thirdId;
        String ip = RequestContext.get().getLoginIP();
        if (McConfigUtil.isSecurityLogOpen((String)RequestContext.get().getTenantId())) {
            log.info(String.format("clientIP:%s", ip));
        }
        if (StringUtil.isEmpty((String)(thirdId = RequestContext.get().getApi3rdAppId())) || NULL.equalsIgnoreCase(thirdId)) {
            return;
        }
        if ("Anonymous".equalsIgnoreCase(thirdId)) {
            return;
        }
        ApiIpInfoDto apiIpInfoDto = new ApiIpInfoDto();
        apiIpInfoDto.setIp(ip);
        apiIpInfoDto.setThirdId(Long.valueOf(Long.parseLong(thirdId)));
        apiIpInfoDto.setAccountId(RequestContext.get().getAccountId());
        OpenApiServiceManager.getApiGateService().checkIP(apiIpInfoDto);
    }

    public void checkThirdACL(String accessUrl) {
        this.checkThirdACL(accessUrl, null);
    }

    public void checkThirdACL(String accessUrl, Map<String, Object> options) {
        String loginApiSupportAnonymous;
        String thirdId = RequestContext.get().getApi3rdAppId();
        ApiAclInfoModel currentApi = ApilAclManager.getApiAclModelFromCache(accessUrl);
        if (RequestContext.get().getCurrUserId() == -1L && !ApilAclManager.checkApiAnonymousAccess(currentApi, TRUE.equalsIgnoreCase(loginApiSupportAnonymous = SystemPropertyUtils.getProptyByTenant((String)"login_api_support_anonymous", (String)RequestContext.get().getTenantId())))) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u7981\u6b62\u533f\u540d\u8bbf\u95ee", (String)"OpenApiDataServiceImpl_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), currentApi.getUrl());
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
        if (currentApi == null || currentApi != null && !ApilAclManager.checkApiEnable(currentApi) && currentApi.getUrl().startsWith(V2)) {
            String failMessage = ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u4e0d\u5b58\u5728\u6216\u8005\u88ab\u7981\u6b62\u8bbf\u95ee\u3002", (String)"OpenApiDataServiceImpl_8", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]);
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
        if (thirdId == null || thirdId.isEmpty() || NULL.equals(thirdId)) {
            boolean isSdkInvoker;
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_1 return true api3rdAppId:%s", thirdId));
            boolean bl = isSdkInvoker = options != null && "MockHttpServletRequest".equals(options.get("httpRequest"));
            if (currentApi.isOnlyThirdAppAuth() && !isSdkInvoker) {
                String failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u9700\u8981\u7b2c\u4e09\u65b9\u5e94\u7528\u6388\u6743", (String)"OpenApiDataServiceImpl_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), currentApi.getUrl());
                throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
            }
            return;
        }
        ThirdAppAclModel appAclModel = ApilAclManager.getThirdAppAclInfoModelFromCache(thirdId);
        AppAclModel appModel = ApilAclManager.getAppAclInfoModelFromCache(currentApi.getAppId());
        if (!appAclModel.isAppAccess()) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u7b2c\u4e09\u65b9\u5e94\u7528-%s\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee", (String)"OpenApiDataServiceImpl_5", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), appAclModel.getThirdAppCode());
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
        if (!ApilAclManager.checkAppEnableDateRange(appAclModel) && currentApi.getUrl().startsWith(V2)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7b2c\u4e09\u65b9\u5e94\u7528\u4e0d\u5728\u542f\u7528\u65f6\u95f4\u8303\u56f4\u5185, enableDate: %1$s, stopDate: %2$s", (String)"OpenApiDataServiceImpl_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), CommonDateUtil.dateConvertString((Date)appAclModel.getLastEnableTime()), CommonDateUtil.dateConvertString((Date)appAclModel.getLastStopTime()));
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
        if (!ApilAclManager.checkAppAclModel(accessUrl, appModel)) {
            String failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u8fd0\u884c\u65f6\u5e94\u7528-%s\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee", (String)"OpenApiDataServiceImpl_6", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), appModel.getAppName());
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
        String loginApiSupportAnonymous2 = System.getProperty("login_api_support_anonymous");
        if (ApilAclManager.checkApiAnonymousAccess(currentApi, TRUE.equalsIgnoreCase(loginApiSupportAnonymous2))) {
            return;
        }
        if (appAclModel.isAgencyUser() && !ApilAclManager.checkAgencyUser(appAclModel, RequestContext.get().getCurrUserId())) {
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, ResManager.loadKDString((String)"\u8be5\u7528\u6237\u4e0d\u662f\u6b64\u7b2c\u4e09\u65b9\u5e94\u7528\u7684\u4ee3\u7406\u7528\u6237\uff0c\u8bf7\u68c0\u67e5\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u3002", (String)"OpenApiDataServiceImpl_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (!appAclModel.isAllowAllApi()) {
            if (ApilAclManager.checkApiAct(accessUrl, appAclModel) || ThirdAclExtManager.checkAcl(thirdId, currentApi.getApiServiceId(), RequestContext.get().getAccountId())) {
                return;
            }
            String failMessage = String.format(ResManager.loadKDString((String)"\u8be5\u7b2c\u4e09\u65b9\u5e94\u7528-%s\u6ca1\u6709\u6b64\u63a5\u53e3\u8bbf\u95ee\u6743\u9650", (String)"OpenApiDataServiceImpl_7", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), appAclModel.getThirdAppCode());
            throw new OpenApiException(ApiErrorCode.HTTP_FORBIDDEN, failMessage, new Object[0]);
        }
    }

    public void writeApiOperationLog(String reqUrl, OpenApiLogModel logModel) {
        String userName;
        String apiNumber;
        String errMsg;
        String response;
        String responseFull = "";
        String requestFull = "";
        if (this.isIgnoreLog(logModel.getApiNumber())) {
            return;
        }
        String bizObject = logModel.getBizObject();
        if (bizObject != null && bizObject.length() > 50) {
            bizObject = bizObject.substring(0, 50);
        }
        int maxLength = 1600;
        responseFull = response = logModel.getResponse();
        if (response != null && response.length() > maxLength) {
            response = response.substring(0, maxLength);
        }
        String request = logModel.getRequest();
        if (logModel.isSignAuth()) {
            request = DistributeCacheUtil.getCacheByKey("SignAuthRequestCache", RequestContext.get().getTraceId(), RequestContext.get().getAccountId());
            DistributeCacheUtil.removeCacheByKey("SignAuthRequestCache", RequestContext.get().getTraceId(), RequestContext.get().getAccountId());
        }
        requestFull = request;
        if (request != null && request.length() > maxLength) {
            request = request.substring(0, maxLength);
        }
        if ((errMsg = logModel.getErrMsg()) != null && errMsg.length() > maxLength) {
            errMsg = errMsg.substring(0, maxLength);
        }
        if (reqUrl != null && reqUrl.length() > 200) {
            reqUrl = reqUrl.substring(0, 200);
        }
        String string = apiNumber = StringUtil.isEmpty((String)logModel.getApiNumber()) ? "404" : logModel.getApiNumber();
        if (apiNumber != null && apiNumber.length() > 50) {
            apiNumber = apiNumber.substring(0, 50);
        }
        request = OpenApiDataServiceImpl.getJsonDataMask(request);
        DynamicObject apiLog = BusinessDataServiceHelper.newDynamicObject((String)"openapi_log_data");
        apiLog.set("opdesc", (Object)reqUrl);
        apiLog.set("request", (Object)request);
        apiLog.set("response", (Object)response);
        apiLog.set("errmsg", (Object)errMsg);
        apiLog.set("opname", (Object)apiNumber);
        String apiName = logModel.getApiName();
        if (apiName != null && apiName.length() > 50) {
            apiName = apiName.substring(0, 50);
        }
        apiLog.set("apiname", (Object)apiName);
        apiLog.set("status", (Object)logModel.isStatus());
        apiLog.set("opdate", (Object)new Date());
        RequestContext context = RequestContext.get();
        if (StringUtil.isNotEmpty((String)context.getApi3rdAppId()) && context.getApi3rdAppId() != null && !NULL.equalsIgnoreCase(context.getApi3rdAppId())) {
            ThirdAppAclModel appAclModel = ApilAclManager.getThirdAppAclInfoModelFromCache(context.getApi3rdAppId());
            String thirdAppName = appAclModel.getThirdAppCode();
            if (thirdAppName != null && thirdAppName.length() > 50) {
                thirdAppName = thirdAppName.substring(0, 50);
            }
            apiLog.set("thirdappname", (Object)thirdAppName);
        }
        if ((userName = context.getUserName()) != null && userName.length() > 50) {
            userName = userName.substring(0, 50);
        }
        apiLog.set("username", (Object)userName);
        apiLog.set("userid", (Object)context.getCurrUserId());
        String ip = context.getLoginIP();
        if (ip != null && ip.length() > 50) {
            ip = ip.substring(0, 50);
        }
        apiLog.set("ip", (Object)ip);
        apiLog.set("cloudname", (Object)logModel.getCloudId());
        apiLog.set("appname", (Object)logModel.getAppId());
        apiLog.set("bizobject", (Object)bizObject);
        apiLog.set("timecost", (Object)logModel.getTimeCost());
        apiLog.set("operationtimecost", (Object)logModel.getModelTimeCost());
        apiLog.set("apiid", (Object)logModel.getApiId());
        apiLog.set("traceid", (Object)context.getTraceId());
        apiLog.set("httpstatus", (Object)logModel.getHttpStatus());
        apiLog.set("asyncreqid", (Object)logModel.getAsyncReqId());
        String errCode = logModel.getErrorCode();
        if (errCode != null && errCode.length() > 50) {
            errCode = errCode.substring(0, 50);
        }
        apiLog.set("errorcode", (Object)errCode);
        boolean isBill = this.getBillCount();
        logModel.setBill(isBill);
        apiLog.set("isbill", (Object)(isBill ? "1" : "0"));
        long id = ID.genLongId();
        apiLog.set("id", (Object)id);
        this.handleDigestLog(logModel.getInDigestTemplate(), requestFull, apiLog, "indigest");
        this.handleDigestLog(logModel.getOutDigestTemplate(), responseFull, apiLog, "outdigest");
        LogORM.create().insert(Collections.singletonList(apiLog));
        String apiLogLevel = this.getSysParameter("api_log_level", "summary");
        if ("full".equalsIgnoreCase(apiLogLevel)) {
            DynamicObject apiFullLog = BusinessDataServiceHelper.newDynamicObject((String)"openapi_log_detail");
            apiFullLog.set("id", (Object)id);
            apiFullLog.set("reqpara_tag", (Object)requestFull);
            if (responseFull != null && responseFull.length() > 10000) {
                responseFull = responseFull.substring(0, 10000);
            }
            apiFullLog.set("resppara_tag", (Object)responseFull);
            apiFullLog.set("opdate", (Object)new Date());
            LogORM.create().insert(Collections.singletonList(apiFullLog));
        }
    }

    private void handleDigestLog(String digestTemplate, String reqOrRespJson, DynamicObject apiLog, String entityKey) {
        if (StringUtil.isNotEmpty((String)digestTemplate) && StringUtil.isNotEmpty((String)reqOrRespJson)) {
            try {
                String substring = reqOrRespJson.substring(reqOrRespJson.indexOf("\n") + 1).trim();
                Object map = new HashMap(8);
                map = substring.startsWith("{") && substring.endsWith("}") ? JSON.parseObject((String)substring) : OpenApiDataServiceImpl.getParamsAsMap(substring);
                String msgData = JacksonUtil.writeValueAsString(map);
                HashMap<String, Object> ctx = new HashMap<String, Object>(1);
                ctx.put("$data", Json.toObject((String)msgData));
                String translate = null;
                try {
                    translate = Format.parse((String)digestTemplate, ctx).translate(ctx);
                }
                catch (Exception exception) {
                    log.info("\u811a\u672c\u6a21\u677f\u8bed\u6cd5\u9519\u8bef\uff1a" + exception.getMessage());
                }
                apiLog.set(entityKey, (Object)(translate != null && translate.length() > 400 ? translate.substring(0, 400) : translate));
            }
            catch (Exception exception) {
                log.info("\u51fa\u5165\u53c2\u683c\u5f0f\u9519\u8bef\uff1a" + exception.getMessage(), (Object)(entityKey + "-" + reqOrRespJson));
            }
        }
    }

    private static Map<String, Object> getParamsAsMap(String paramsStr) {
        if (StringUtil.isEmpty((String)paramsStr)) {
            return Collections.emptyMap();
        }
        String[] split = paramsStr.split("&");
        HashMap<String, Object> result = new HashMap<String, Object>(split.length);
        for (String s : split) {
            String[] strings = s.split("=", 2);
            if (strings.length == 1) {
                if (StringUtil.isEmpty((String)strings[0])) continue;
                result.put(strings[0], null);
                continue;
            }
            if (StringUtil.isEmpty((String)strings[0]) && StringUtil.isEmpty((String)strings[1])) continue;
            result.put(strings[0], strings[1]);
        }
        return result;
    }

    public void writeApiStatData(long apiId, OpenApiStatModel statModel) {
        if (apiId == 0L || this.isIgnoreLog(statModel.getApiNumber())) {
            return;
        }
        int billCnt = this.getBillCount() ? 1 : 0;
        String thirdId = RequestContext.get().getApi3rdAppId();
        long nThirdId = 0L;
        try {
            nThirdId = DataUtil.l((Object)thirdId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApiStatService.getInstance().collect(apiId, nThirdId, statModel.isStatus(), statModel.getTimeCost(), billCnt);
    }

    private boolean getBillCount() {
        return OpenApiDataServiceFactory.getOpenApiBillService().getBillEnabledByApi3rdAppId();
    }

    public String getSysParameter(String key, String defaultValue) {
        return this.getSysParameter(key, null, defaultValue);
    }

    public String getSysExtPara(String key, String defaultValue) {
        String extParaStr = this.getSysParameter("extpara", null, "");
        if (StringUtil.isEmpty((String)extParaStr) || extParaStr.indexOf(key) == -1) {
            return defaultValue;
        }
        String[] orders = extParaStr.trim().split(";");
        for (int i = 0; i < orders.length; ++i) {
            String[] keyAndValue = orders[i].split("=");
            if (keyAndValue.length != 2) {
                return defaultValue;
            }
            if (!keyAndValue[0].equals(key)) continue;
            return keyAndValue[1];
        }
        return defaultValue;
    }

    public String getSysParameter(String key, String mcKey, String defaultValue) {
        String isSystemParamEnableStr;
        if (StringUtil.isEmpty((String)key)) {
            return defaultValue;
        }
        if (!this.isKeyValid(key)) {
            return defaultValue;
        }
        if (StringUtil.isEmpty((String)mcKey)) {
            mcKey = key;
        }
        if (TRUE.equals(isSystemParamEnableStr = this.getSystemParam("api_sysconfig_dev"))) {
            String value = this.getSystemParam(key);
            if (!StringUtil.isEmpty((String)value)) {
                return value;
            }
            return System.getProperty(mcKey, defaultValue);
        }
        return System.getProperty(mcKey, defaultValue);
    }

    private String getSystemParam(String key) {
        Object result;
        if (RequestContext.get() == null) {
            return null;
        }
        AppParam appParam = new AppParam("W3NF+MX967M", "15", Long.valueOf(ParameterOrgUtils.getParamRootOrgId()), ConfigConstant.OPEN_SYS_PARAMS_ACT_BOOK_ID);
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        if (paramMap != null && (result = paramMap.getOrDefault(key, null)) != null) {
            return result.toString();
        }
        return null;
    }

    private boolean isKeyValid(String key) {
        if (StringUtil.isEmpty((String)key)) {
            return false;
        }
        boolean res = false;
        switch (key) {
            case "api_openlog_showstack": 
            case "api_query_maxpagesize": 
            case "api_log_level": 
            case "api_stat": 
            case "api_sysconfig_dev": 
            case "kapiloglevel": 
            case "fulllog_days": 
            case "api1_newcontrol": 
            case "is_view_sysapi": 
            case "isallowservletapi": 
            case "extpara": 
            case "api_log_days": 
            case "authplugin": 
            case "costdata_threshold": 
            case "custom_export_apidts": 
            case "quick_query": {
                res = true;
                break;
            }
        }
        return res;
    }

    private boolean isIgnoreLog(String apiNumber) {
        if (apiNumber == null) {
            return false;
        }
        return "getRobertHome".equalsIgnoreCase(apiNumber.trim());
    }

    public static String getJsonDataMask(String json) {
        String mask = "***";
        String result = json;
        if (StringUtil.isEmpty((String)json)) {
            return "";
        }
        if (json.indexOf("accesstoken") >= 0) {
            result = result.replaceAll("(?<=\"accesstoken\":\")[^\",]*", mask);
        } else if (json.indexOf("accessToken") >= 0) {
            result = result.replaceAll("(?<=\"accessToken\":\")[^\",]*", mask);
        } else if (json.indexOf("access_token") >= 0) {
            result = result.replaceAll("(?<=\"access_token\":\")[^\",]*", mask);
        } else if (json.indexOf("jwt") >= 0) {
            result = result.replaceAll("(?<=\"jwt\":\")[^\",]*", mask);
        }
        return result;
    }

    public Map<String, Object> parseInScript(String apiUrl, Map<String, Object> reqData, Map<String, String> queryString, Map<String, String> reqHeaders) {
        return OpenApiScriptUtil.parseInScript(apiUrl, reqData, queryString, reqHeaders);
    }

    public Object parseOutScript(String apiUrl, Map<String, Object> reqData, Map<String, String> queryString, Map<String, String> reqHeaders, Object respData, Map<String, String> respHeaders) {
        return OpenApiScriptUtil.parseOutScript(apiUrl, reqData, queryString, reqHeaders, respData, respHeaders);
    }

    public boolean checkIdempotency(String apiUrl, String idempotencyKey) {
        String key = apiUrl + "_" + idempotencyKey;
        log.info("-{}--checkIdempotency>" + key, (Object)RequestContext.get().getTraceId());
        String value = DistributeCacheUtil.getCacheByKey("API_Idempotency-Key", key);
        if (value == null) {
            try (DLock lock = DLock.create((String)key);){
                lock.lock();
                value = DistributeCacheUtil.getCacheByKey("API_Idempotency-Key", key);
                if (value != null) {
                    if (System.currentTimeMillis() - Long.parseLong(value.toString()) >= 30000L) {
                        DistributeCacheUtil.setCacheByKey("API_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                DistributeCacheUtil.setCacheByKey("API_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
                boolean bl = false;
                return bl;
            }
        }
        if (System.currentTimeMillis() - Long.parseLong(value.toString()) >= 30000L) {
            DistributeCacheUtil.setCacheByKey("API_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIdempotency(String apiUrl, InputStream body, String queryString) {
        try {
            String inputPara = OpenApiContext.getInputParameter();
            String bodySha256Hex = StringUtil.isEmpty((String)inputPara) ? (body == null ? "" : DigestUtils.sha256Hex((InputStream)body)) : DigestUtils.sha256Hex((String)inputPara);
            String queryStringSha256Hex = queryString == null ? "" : DigestUtils.sha256Hex((String)queryString);
            String key = apiUrl + "_" + bodySha256Hex + "_" + queryStringSha256Hex;
            String value = DistributeCacheUtil.getCacheByKey("API_HASH_Idempotency-Key", key);
            if (value != null) {
                if (System.currentTimeMillis() - Long.parseLong(value.toString()) < 30000L) return true;
                DistributeCacheUtil.setCacheByKey("API_HASH_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
                return false;
            }
            try (DLock lock = DLock.create((String)key);){
                lock.lock();
                value = DistributeCacheUtil.getCacheByKey("API_HASH_Idempotency-Key", key);
                if (value != null) {
                    if (System.currentTimeMillis() - Long.parseLong(value.toString()) >= 30000L) {
                        DistributeCacheUtil.setCacheByKey("API_HASH_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                DistributeCacheUtil.setCacheByKey("API_HASH_Idempotency-Key", key, String.valueOf(System.currentTimeMillis()), 30000, TimeUnit.MILLISECONDS);
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable e) {
            log.error(this.getClass().getSimpleName() + ".checkIdempotency", e);
            return false;
        }
    }

    public String findObjectFieldName(Long apiId, String fieldName) {
        if (apiId == null) {
            return fieldName;
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            return "";
        }
        String fieldObjectName = (String)LocalCacheUtil.getCacheByKey("ApiObjectFieldName_" + apiId, fieldName);
        if (StringUtil.isNotEmpty((String)fieldObjectName)) {
            return fieldObjectName;
        }
        String sql = " select fobjpropname from t_open_apibodyentry t where fid = ? and fparamname = ? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":Fid", -5, (Object)apiId), new SqlParameter(":Fparamname", 12, (Object)fieldName)};
        fieldObjectName = (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
            String objPropName = "";
            while (rs.next()) {
                objPropName = rs.getString("fobjpropname");
            }
            return objPropName;
        });
        if (StringUtil.isEmpty((String)fieldObjectName)) {
            fieldObjectName = fieldName;
        }
        LocalCacheUtil.setCacheByKey("ApiObjectFieldName_" + apiId, fieldName, fieldObjectName, 180);
        return fieldObjectName;
    }

    public String findCommonConfigValueBy(int type, String key, String accountId) {
        if (type <= 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The type should be bigger than 0.", new Object[0]);
        }
        if (StringUtil.isEmpty((String)key)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The key cannot be null.", new Object[0]);
        }
        return CommonConfigUtil.getValueWithLocalCache(type, key, accountId);
    }
}

