/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dts;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dbversion.IndustryVersionInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.VarcharProp;
import kd.bos.isc.service.dts.bean.ImportStatus;
import kd.bos.isc.service.dts.bean.IscDtsSymbol;
import kd.bos.isc.util.dt.D;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.dts.ImportMode;
import kd.bos.openapi.base.dts.OpenDataTranferServiceConfig;
import kd.bos.openapi.base.dts.bean.OpenDtsSymbol;
import kd.bos.openapi.base.dts.bean.OpenImportResponse;
import kd.bos.openapi.base.dts.handler.OpenDynamicObjectHandler;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.dbversion.IndustryVersionServiceHelper;

public class ImportService {
    private static final Log LOG = LogFactory.getLog(ImportService.class);
    private final OpenDataTranferServiceConfig cfg;

    ImportService(OpenDataTranferServiceConfig cfg) {
        this.cfg = cfg;
    }

    List<OpenImportResponse> doImport(Reader reader, Map<String, Object> externInfo) throws IOException {
        List<String> dts = this.readDts(reader);
        return this.doImport(dts, externInfo, Boolean.FALSE);
    }

    List<OpenImportResponse> doImport(List<String> dts, Map<String, Object> externInfo, Boolean isFromCloud) {
        ArrayList<OpenImportResponse> responses = new ArrayList<OpenImportResponse>(dts.size());
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>(dts.size());
        for (String dt : dts) {
            this.checkValid(dt);
            String[] split = dt.split("@ISC@");
            OpenDtsSymbol openDtsSymbol = new OpenDtsSymbol(split[0]);
            openDtsSymbol.setFromCloud(isFromCloud);
            OpenImportResponse response = this.innerSaveObject(successObjs, openDtsSymbol, split[1], externInfo == null ? Collections.emptyMap() : externInfo);
            responses.add(response);
        }
        this.afterSave(successObjs);
        return responses;
    }

    private OpenImportResponse innerSaveObject(List<DynamicObject> successObjs, OpenDtsSymbol openDtsSymbol, String dataJsonStr, Map<String, Object> externInfo) {
        if (ImportMode.IGNORED == openDtsSymbol.getImportMode()) {
            return new OpenImportResponse(ImportStatus.IGNORED, (IscDtsSymbol)openDtsSymbol);
        }
        boolean isExisted = this.isExisted(openDtsSymbol.getId(), openDtsSymbol.getEntityName());
        boolean ignoredRef = openDtsSymbol.isRef();
        if (ignoredRef && isExisted) {
            return new OpenImportResponse(ImportStatus.IGNORED, (IscDtsSymbol)openDtsSymbol);
        }
        try {
            JSONArray result;
            if (isExisted && ImportMode.IGNORED.name().equals(externInfo.get("IMPORT_MODE"))) {
                return new OpenImportResponse(ImportStatus.IGNORED, (IscDtsSymbol)openDtsSymbol);
            }
            if (openDtsSymbol.getFromCloud().booleanValue() && this.isNeedIgnore((JSONObject)(result = (JSONArray)JsonUtil.parseJson((String)dataJsonStr)).get(0)).booleanValue()) {
                return new OpenImportResponse(ImportStatus.IGNORED, (IscDtsSymbol)openDtsSymbol);
            }
            successObjs.add(this.saveObject(openDtsSymbol, dataJsonStr, isExisted, externInfo));
            return new OpenImportResponse(openDtsSymbol);
        }
        catch (Throwable e) {
            return new OpenImportResponse(e, (IscDtsSymbol)openDtsSymbol);
        }
    }

    private boolean isExisted(Object id, String entityName) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Object newVal = this.cast((EntityType)entityType, "id", id);
        QFilter qFilter = new QFilter("id", "=", newVal);
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
    }

    private List<String> readDts(Reader reader) throws IOException {
        String line;
        BufferedReader bufferedReader = new BufferedReader(reader);
        ArrayList<String> dts = new ArrayList<String>(16);
        while ((line = bufferedReader.readLine()) != null) {
            dts.add(line);
        }
        return dts;
    }

    private DynamicObject saveObject(OpenDtsSymbol openDtsSymbol, String dataStr, boolean isExisted, Map<String, Object> externInfo) {
        OpenDynamicObjectHandler handler = this.cfg.getHandler(openDtsSymbol.getEntityName());
        DynamicObject object = handler.jsonToObject(dataStr);
        DynamicObject target = handler.beforeSave(object, !isExisted, externInfo, openDtsSymbol.isRef());
        handler.save(target, !isExisted, externInfo);
        return target;
    }

    private void afterSave(List<DynamicObject> successObjs) {
        Map<String, List<DynamicObject>> objectMap = this.groupByEntityName(successObjs);
        for (Map.Entry<String, List<DynamicObject>> entry : objectMap.entrySet()) {
            this.cfg.getHandler(entry.getKey()).afterSave(entry.getValue());
        }
    }

    private Map<String, List<DynamicObject>> groupByEntityName(List<DynamicObject> successObjs) {
        LinkedHashMap<String, List<DynamicObject>> objectMap = new LinkedHashMap<String, List<DynamicObject>>(successObjs.size());
        for (DynamicObject successObj : successObjs) {
            String entityName = successObj.getDataEntityType().getName();
            List objectList = objectMap.computeIfAbsent(entityName, k -> new ArrayList());
            objectList.add(successObj);
        }
        return objectMap;
    }

    public static void check(OperationResult rs) {
        if (!rs.isSuccess()) {
            StringBuilder sb = new StringBuilder();
            for (IOperateInfo op : rs.getAllErrorOrValidateInfo()) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(op.getTitle()).append(' ').append(op.getMessage());
            }
            if (sb.length() == 0) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, rs.getMessage(), new Object[0]);
            }
            throw new OpenApiException(ApiErrorCode.Data_Invalid, sb.toString(), new Object[0]);
        }
    }

    private void checkValid(String line) {
        if (!line.contains("@ISC@")) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4f20\u5165\u7684\u5b57\u7b26\u4e32\u4e0d\u5408\u6cd5\uff0c\u672a\u5305\u542b\u96c6\u6210\u7279\u6b8a\u5206\u9694\u7b26\u3002", (String)"ImportService_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
    }

    private Object cast(EntityType entityType, String field, Object oldValue) {
        if (oldValue == null) {
            return null;
        }
        return this.castSingleValue(entityType, field, oldValue);
    }

    private Object castSingleValue(EntityType entityType, String field, Object oldValue) {
        DynamicProperty property = this.getProperty(entityType, field);
        if (property instanceof BasedataProp) {
            property = ((BasedataProp)property).getRefIdProp();
        }
        String s = null;
        try {
            if (oldValue == null) {
                return null;
            }
            if (property instanceof MuliLangTextProp && oldValue instanceof Map) {
                return ((Map)oldValue).get(Lang.get().name());
            }
            if (property instanceof DateTimeProp) {
                return D.t((Object)oldValue);
            }
            if (property instanceof LongProp || property instanceof BigIntProp) {
                return D.l((Object)oldValue);
            }
            if (property instanceof IntegerProp) {
                return D.i((Object)oldValue);
            }
            if (property instanceof BooleanProp) {
                return D.x((Object)oldValue);
            }
            if (property instanceof VarcharProp && (s = D.s((Object)oldValue)) != null) {
                return s;
            }
            if (property instanceof TextProp) {
                return oldValue.toString();
            }
            return oldValue;
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u65e0\u6cd5\u5c06\u5c5e\u6027{0}\u7684\u503c{1}\u8f6c\u6362\u4e3a{2}\u7c7b\u578b!", (String)"ImportService_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[]{field, s, property.getClass()}), new Object[0]);
        }
    }

    private DynamicProperty getProperty(EntityType entityType, String field) {
        int index = field.indexOf(46);
        if (index < 0) {
            return entityType.getProperty(field);
        }
        DynamicProperty property = entityType.getProperty(field.substring(0, index));
        if (property instanceof BasedataProp) {
            String name = ((BasedataProp)property).getComplexType().getName();
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)name);
            return this.getProperty((EntityType)type, field.substring(index + 1));
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5f15\u7528\u7c7b\u578b\u5c5e\u6027\u8fc7\u6ee4, \u4e0d\u652f\u6301{0}\u7684\u5c5e\u6027{1}\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6!", (String)"ImportService_2", (String)ResSystemType.BASE.getType(), (Object[])new Object[]{entityType.getName(), property.getName()}), new Object[0]);
    }

    private Boolean isNeedIgnore(JSONObject source) throws ParseException {
        if ("openapi_custom_sort".equals(source.getString("_Type_"))) {
            return Boolean.FALSE;
        }
        Long id = source.getLong("id");
        Long stdModifyTime = source.getLong("stdmodifytime");
        String cloudCosmicver = source.getString("cosmicver");
        String cosmicver = ImportService.getCosmicVer();
        if (ImportService.checkVersion(cosmicver, cloudCosmicver) < 0) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5f53\u524d\u82cd\u7a79\u7248\u672c\u53f7\u5c0f\u4e8e\u4e91\u7aefAPI\u9002\u7528\u82cd\u7a79\u7248\u672c\u53f7\uff0c\u53ef\u80fd\u4f9d\u8d56\u7684\u57fa\u7840\u8d44\u6599\u672c\u5730\u4e0d\u5b58\u5728\uff0c\u6b64API\u5df2\u5ffd\u7565\uff0c\u5efa\u8bae\u66f4\u65b0\u82cd\u7a79\u7248\u672c\u3002", (String)"ImportService_4", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        if (stdModifyTime == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u4e91\u7aef\u8d44\u6e90\u8d44\u6e90\u66f4\u65b0\u65f6\u95f4\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8d44\u6e90\u662f\u5426\u5f02\u5e38\u3002", (String)"ImportService_3", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[0]);
        }
        Long cloudTime = stdModifyTime;
        QFilter[] qFilters = QFilterUtil.builder().put("id", "=", id).put(Version.VERSION, "=", Version.TWO.getVer()).build();
        DynamicObject api = BusinessDataServiceHelper.loadSingle((String)"openapi_apilist", (String)"id,stdmodifytime,cosmicver", (QFilter[])qFilters);
        if (api != null) {
            String localTimeStr = api.getString("stdmodifytime");
            if (StringUtil.isEmpty((String)localTimeStr)) {
                return Boolean.FALSE;
            }
            long localTime = DateUtil.convertToDate((String)localTimeStr, (String)"yyyy-MM-dd HH:mm:ss").getTime();
            if (localTime > cloudTime) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public static String getCosmicVer() {
        IndustryVersionInfo csVersion = IndustryVersionServiceHelper.getVersion((String)"cosmic_bos", (String)"kingdee");
        return ImportService.removeLastVersion(csVersion.getVersion());
    }

    private static String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }

    public static int checkVersion(String v1, String v2) {
        if (StringUtil.isEmpty((String)v1)) {
            return -1;
        }
        if (StringUtil.isEmpty((String)v2)) {
            return 1;
        }
        String[] verArr1 = v1.split("\\.");
        String[] verArr2 = v2.split("\\.");
        int minLength = Math.min(verArr1.length, verArr2.length);
        int diff = 0;
        for (int idx = 0; idx < minLength && (diff = verArr1[idx].length() - verArr2[idx].length()) == 0 && (diff = verArr1[idx].compareTo(verArr2[idx])) == 0; ++idx) {
        }
        diff = diff != 0 ? diff : verArr1.length - verArr2.length;
        return diff;
    }
}

