/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.dts.handler;

import com.alibaba.fastjson.JSON;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.openapi.base.dts.ImportService;
import kd.bos.openapi.base.dts.handler.OpenDynamicObjectHandler;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class BaseOpenDynamicObjectHandler
implements OpenDynamicObjectHandler {
    private static final Set<String> ignoreFields = new HashSet<String>(16);
    protected final String entity;
    private final MainEntityType entityType;

    public BaseOpenDynamicObjectHandler(String entity) {
        this.entity = entity;
        this.entityType = EntityMetadataCache.getDataEntityType((String)entity);
    }

    public String forEntity() {
        return this.entity;
    }

    public void addIgnoreField(String ... fieldNames) {
        if (fieldNames == null) {
            return;
        }
        ignoreFields.addAll(Arrays.asList(fieldNames));
    }

    public Set<String> excludedFields() {
        return ignoreFields;
    }

    public String objectToJson(DynamicObject object) {
        List<Map<String, Object>> mapList = DynamicObjectUtil.serializeToMapWithOutDefaultValue(new DynamicObject[]{object}, (DynamicObjectType)this.entityType);
        return JSON.toJSONString(mapList);
    }

    public DynamicObject jsonToObject(String json) {
        try {
            List mapList = (List)JSON.parse((String)json);
            return DynamicObjectUtil.deserializeFromMap(mapList, (DynamicObjectType)this.entityType).get(0);
        }
        catch (Throwable e) {
            throw new OpenApiException(e, ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\uff08\u975e\u6b63\u5e38\u65b0\u589e\u6570\u636e\uff09\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff1a{0}", (String)"BaseOpenDynamicObjectHandler_0", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]), new Object[]{e.getMessage()});
        }
    }

    @Override
    public DynamicObject beforeSave(DynamicObject source, boolean isNew, Map<String, Object> externInfo, boolean isRef) {
        DynamicObject target = isNew ? BusinessDataServiceHelper.newDynamicObject((String)this.entity) : BusinessDataServiceHelper.loadSingle((Object)source.getPkValue(), (String)this.entity);
        DataEntityPropertyCollection properties = target.getDynamicObjectType().getProperties();
        this.copyProperty(source, target, properties, 1, isNew);
        Object isasync = target.get("isasync");
        if (isasync == null) {
            target.set("isasync", (Object)"0");
        }
        return target;
    }

    public void save(DynamicObject object, boolean isNew, Map<String, Object> externInfo) {
        OperationResult result = SaveServiceHelper.saveOperate((String)this.entity, (DynamicObject[])new DynamicObject[]{object}, (OperateOption)OperateOption.create());
        ImportService.check(result);
    }

    protected void copyProperty(DynamicObject src, DynamicObject tar, String prop) {
        tar.set(prop, src.get(prop));
    }

    public void afterSave(List<DynamicObject> batch) {
    }

    private void copyProperty(DynamicObject source, DynamicObject target, DataEntityPropertyCollection properties, int level, boolean isNew) {
        if (level > 2) {
            return;
        }
        for (IDataEntityProperty property : properties) {
            if (BaseOpenDynamicObjectHandler.notIncludeProperty(property)) continue;
            if (property instanceof EntryProp) {
                DynamicObjectCollection srcEntryList = source.getDynamicObjectCollection(property.getName());
                DynamicObjectCollection tarEntryList = target.getDynamicObjectCollection(property.getName());
                tarEntryList.clear();
                if (CollectionUtil.isEmpty((Collection)srcEntryList)) continue;
                DataEntityPropertyCollection entryProperties = null;
                boolean isFirst = true;
                for (DynamicObject srcEntry : srcEntryList) {
                    DynamicObject tarEntry = tarEntryList.addNew();
                    if (isFirst) {
                        isFirst = false;
                        entryProperties = tarEntry.getDataEntityType().getProperties();
                    }
                    this.copyProperty(srcEntry, tarEntry, entryProperties, level + 1, isNew);
                }
                continue;
            }
            if (level == 1) {
                if (isNew) {
                    if (property instanceof CreaterProp) {
                        target.set(property.getName(), (Object)BaseOpenDynamicObjectHandler.getContextUser());
                        continue;
                    }
                    if (property instanceof CreateDateProp) {
                        target.set(property.getName(), (Object)Timestamp.valueOf(LocalDateTime.now()));
                        continue;
                    }
                } else if ("id".equals(property.getName()) || property instanceof CreaterProp || property instanceof CreateDateProp) continue;
            }
            this.copyProperty(source, target, property.getName());
        }
    }

    private static DynamicObject getContextUser() {
        return BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
    }

    public static boolean notIncludeProperty(IDataEntityProperty property) {
        return "multilanguagetext".equals(property.getName()) || property instanceof PKFieldProp && ((PKFieldProp)property).isRefId();
    }

    public void beforeExport(DynamicObject obj) {
    }

    static {
        ignoreFields.add("multilanguagetext");
        ignoreFields.add("creater");
        ignoreFields.add("creater_id");
        ignoreFields.add("creator");
        ignoreFields.add("creator_id");
        ignoreFields.add("modifier");
        ignoreFields.add("modifier_id");
    }
}

