/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.limit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.eye.api.armor.config.manager.EyeFlowRuleManager;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.rule.FlowRule;
import kd.bos.openapi.base.limit.FlowRuleDto;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class LimitFlowRuleConfigUtil {
    private static final Log log = LogFactory.getLog(LimitFlowRuleConfigUtil.class);
    public static final int REQUEST_TYPE_DELETE = 3;
    public static final int REQUEST_TYPE_ADD = 0;
    public static final int REQUEST_TYPE_UPDATE = 2;
    public static final String LIMIT_APP_DEFAULT = "default";
    public static final int FLOW_STRATEGY = 0;
    public static final int FLOW_GRADE = 1;
    public static final int FLOW_CONTROL_BEHAVIOR = 0;
    public static final String FLOW_APP_NAME = "default";
    public static final String FLOW_RULE_SERVICE = "FlowRuleService";
    public static final String FIND_RULE_BY_RESOURCE = "findRuleByResource";
    public static final String UPDATE_RULE_SERVICE = "updateRuleService";
    public static final String UPDATE_RULE_LIST_SERVICE = "updateRuleListService";
    public static final String RESOURCE_TYPE = "resourcetype";
    private static final String OPENAPI_LIMIT_STRATEGY = "openapi_limit_strategy";
    private static final String LIMIT_ENTRY = "limitentryentity";
    public static final String RESOURCE = "resource";
    private static final String COUNT = "count";
    public static final String THIRD_ID = "third.id";
    public static final String API_ID = "api.id";
    public static final String NIMIN_ID = "nimin.id";
    public static final String RESOURCE_TYPE_THIRD = "0";
    public static final String RULE_SPLIT = "@";
    public static final String SPLIT = ",";
    public static final String RESOURCE_TYPE_NIMIN = "2";
    public static final String RESOURCE_NIMIN_ID = "0";
    public static final String STATINTERVAL = "statinterval";
    public static final String OPENAPI = "OpenApi";

    public static FlowRule createFlowRule(String resourceThirdId, int limitCount) {
        FlowRule flowRuleVo = new FlowRule();
        flowRuleVo.setCount(Integer.valueOf(limitCount));
        flowRuleVo.setAppName("default");
        flowRuleVo.setControlBehavior(Integer.valueOf(0));
        flowRuleVo.setGrade(Integer.valueOf(1));
        flowRuleVo.setLimitApp("default");
        flowRuleVo.setResource(resourceThirdId);
        flowRuleVo.setStrategy(Integer.valueOf(0));
        flowRuleVo.setRequestType(0);
        return flowRuleVo;
    }

    public static FlowRuleVo createFlowRuleVo(String resourceThirdId, int limitCount, int statInterval) {
        FlowRuleVo flowRuleVo = new FlowRuleVo();
        flowRuleVo.setId(String.valueOf(ID.genLongId()));
        flowRuleVo.setCount(Integer.valueOf(limitCount));
        flowRuleVo.setAppName("default");
        flowRuleVo.setControlBehavior(Integer.valueOf(0));
        flowRuleVo.setGrade(Integer.valueOf(1));
        flowRuleVo.setLimitApp("default");
        flowRuleVo.setResource(resourceThirdId);
        flowRuleVo.setStrategy(Integer.valueOf(0));
        flowRuleVo.setRequestType(0);
        flowRuleVo.setStatInterval(statInterval);
        return flowRuleVo;
    }

    public static FlowRuleVo createFlowRuleVo(String resourceThirdId, int limitCount) {
        FlowRuleVo flowRuleVo = new FlowRuleVo();
        flowRuleVo.setId(String.valueOf(ID.genLongId()));
        flowRuleVo.setCount(Integer.valueOf(limitCount));
        flowRuleVo.setAppName("default");
        flowRuleVo.setControlBehavior(Integer.valueOf(0));
        flowRuleVo.setGrade(Integer.valueOf(1));
        flowRuleVo.setLimitApp("default");
        flowRuleVo.setResource(resourceThirdId);
        flowRuleVo.setStrategy(Integer.valueOf(0));
        flowRuleVo.setRequestType(0);
        return flowRuleVo;
    }

    public static void updateFlowRule(String accountId, String resourceThirdId, int limitCount) {
        String flowLimitResId = ApiDataUtil.getThirdResLimitResId((String)accountId, (String)resourceThirdId);
        LimitFlowRuleConfigUtil.updateFlowRuleByResourceId(flowLimitResId, limitCount);
    }

    public static void updateFlowRule(String accountId, String resourceThirdId, int limitCount, int statInterval) {
        String flowLimitResId = ApiDataUtil.getThirdResLimitResId((String)accountId, (String)resourceThirdId);
        LimitFlowRuleConfigUtil.updateFlowRuleByResourceId(flowLimitResId, limitCount, statInterval);
    }

    public static void updateFlowRuleByResourceId(String resourceId, int limitCount) {
        if (StringUtil.isEmpty((String)resourceId)) {
            return;
        }
        FlowRule rule = new FlowRule();
        rule.setResource(resourceId);
        rule.setCount(Integer.valueOf(limitCount));
        ArrayList<FlowRule> list = new ArrayList<FlowRule>();
        list.add(rule);
        LimitFlowRuleConfigUtil.batchUpdateFlowRule(list);
    }

    public static void updateFlowRuleByResourceId(String resourceId, int limitCount, int statInterval) {
        if (StringUtil.isEmpty((String)resourceId)) {
            return;
        }
        FlowRuleVo rule = new FlowRuleVo();
        rule.setResource(resourceId);
        rule.setCount(Integer.valueOf(limitCount));
        rule.setStatInterval(statInterval);
        ArrayList<FlowRuleVo> list = new ArrayList<FlowRuleVo>();
        list.add(rule);
        LimitFlowRuleConfigUtil.batchUpdateFlowRuleNew(list);
    }

    public static void updateFlowRule(String limitRuleId, String ruleDetailIds) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(limitRuleId), (String)OPENAPI_LIMIT_STRATEGY);
        if (object == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "Can't find object by limitRuleId:%s.", new Object[]{limitRuleId});
        }
        List ruleDetailIdList = StringUtil.strToList((String)ruleDetailIds);
        HashMap ruleDetailMap = new HashMap();
        ArrayList beforeIdList = new ArrayList();
        ArrayList afterIdList = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)ruleDetailIdList)) {
            ruleDetailIdList.forEach(ruleDetail -> {
                String[] details = ruleDetail.split(RULE_SPLIT);
                Long beforeId = Long.parseLong(details[0]);
                ruleDetailMap.put(beforeId, details[1]);
                beforeIdList.add(beforeId);
            });
        }
        Integer limitCount = object.getInt(COUNT);
        Integer statinterval = object.getInt(STATINTERVAL);
        String resourceType = object.getString(RESOURCE_TYPE);
        DynamicObjectCollection limitObjectList = object.getDynamicObjectCollection(LIMIT_ENTRY);
        limitObjectList.forEach(dynamicObject -> {
            Long ruleDetailId = dynamicObject.getLong("0".equalsIgnoreCase(resourceType) ? THIRD_ID : API_ID);
            afterIdList.add(ruleDetailId);
            ruleDetailMap.put(ruleDetailId, dynamicObject.getString(RESOURCE));
        });
        List<Long> updateList = beforeIdList.stream().filter(num -> afterIdList.contains(num)).collect(Collectors.toList());
        List<Long> deleteList = beforeIdList.stream().filter(num -> !afterIdList.contains(num)).collect(Collectors.toList());
        List<Long> addList = afterIdList.stream().filter(num -> !beforeIdList.contains(num)).collect(Collectors.toList());
        ArrayList<FlowRuleVo> flowRuleList = new ArrayList<FlowRuleVo>();
        if (CollectionUtil.isNotEmpty(addList)) {
            addList.forEach(ruleDetailId -> {
                if (StringUtil.isNotEmpty((String)((String)ruleDetailMap.get(ruleDetailId)))) {
                    FlowRuleVo rule = new FlowRuleVo();
                    rule.setResource((String)ruleDetailMap.get(ruleDetailId));
                    rule.setCount(limitCount);
                    rule.setStatInterval(statinterval.intValue());
                    flowRuleList.add(rule);
                }
            });
        }
        if (CollectionUtil.isNotEmpty(updateList)) {
            updateList.forEach(ruleDetailId -> {
                if (StringUtil.isNotEmpty((String)((String)ruleDetailMap.get(ruleDetailId)))) {
                    FlowRuleVo rule = new FlowRuleVo();
                    rule.setResource((String)ruleDetailMap.get(ruleDetailId));
                    rule.setCount(limitCount);
                    rule.setStatInterval(statinterval.intValue());
                    flowRuleList.add(rule);
                }
            });
        }
        if (CollectionUtil.isNotEmpty(deleteList)) {
            deleteList.forEach(ruleDetailId -> {
                if (StringUtil.isNotEmpty((String)((String)ruleDetailMap.get(ruleDetailId)))) {
                    FlowRuleVo rule = new FlowRuleVo();
                    rule.setResource((String)ruleDetailMap.get(ruleDetailId));
                    rule.setStatInterval(statinterval.intValue());
                    rule.setCount(Integer.valueOf(-1));
                    flowRuleList.add(rule);
                }
            });
        }
        LimitFlowRuleConfigUtil.batchUpdateFlowRuleNew(flowRuleList);
    }

    public static void batchUpdateFlowRule(List<FlowRule> flowRuleList) {
        if (CollectionUtil.isEmpty(flowRuleList)) {
            return;
        }
        ArrayList<FlowRule> updateRuleList = new ArrayList<FlowRule>();
        try {
            for (FlowRule flowRule : flowRuleList) {
                String flowLimitResId = flowRule.getResource();
                int limitCount = flowRule.getCount();
                FlowRule flowRuleVo = (FlowRule)DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)FLOW_RULE_SERVICE, (String)FIND_RULE_BY_RESOURCE, (Object[])new Object[]{flowLimitResId});
                if (flowRuleVo == null) {
                    if (limitCount <= 0) {
                        return;
                    }
                    flowRuleVo = LimitFlowRuleConfigUtil.createFlowRule(flowLimitResId, limitCount);
                } else if (limitCount <= 0) {
                    flowRuleVo.setRequestType(3);
                } else {
                    flowRuleVo.setCount(Integer.valueOf(limitCount));
                    flowRuleVo.setRequestType(2);
                }
                updateRuleList.add(flowRuleVo);
            }
            DispatchApiServiceHelper.invokeApiService((String)"kd.bos.openapi.servicehelper", (String)"api", (String)FLOW_RULE_SERVICE, (String)UPDATE_RULE_LIST_SERVICE, (Object[])new Object[]{updateRuleList});
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "batch update flowRule list error:", new Object[0]);
        }
    }

    public static void batchUpdateFlowRuleNew(List<FlowRuleVo> flowRuleVos) {
        if (CollectionUtil.isEmpty(flowRuleVos)) {
            return;
        }
        try {
            for (FlowRuleVo flowRule : flowRuleVos) {
                String flowLimitResId = flowRule.getResource();
                int limitCount = flowRule.getCount();
                int statInterval = flowRule.getStatInterval();
                List flowRuleVoList = EyeFlowRuleManager.getArmorDataSource().getRule(flowLimitResId, FlowRuleVo.class);
                FlowRuleVo flowRuleVo = new FlowRuleVo();
                if (CollectionUtil.isNotEmpty((Collection)flowRuleVoList)) {
                    flowRuleVo = (FlowRuleVo)flowRuleVoList.get(0);
                }
                if (CollectionUtil.isEmpty((Collection)flowRuleVoList)) {
                    if (limitCount <= 0) {
                        return;
                    }
                    flowRuleVo = LimitFlowRuleConfigUtil.createFlowRuleVo(flowLimitResId, limitCount, statInterval);
                } else if (limitCount <= 0) {
                    flowRuleVo.setRequestType(3);
                } else {
                    flowRuleVo.setCount(Integer.valueOf(limitCount));
                    flowRuleVo.setStatInterval(statInterval);
                    flowRuleVo.setRequestType(2);
                }
                EyeFlowRuleManager.getArmorDataSource().updateRule((RuleVo)flowRuleVo);
            }
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.HTTP_INTERNAL_ERROR, "batch update flowRule list error:", new Object[0]);
        }
    }

    public static void syncFlowRuleVo() {
        try {
            List ruleList = EyeFlowRuleManager.getArmorDataSource().getRule(OPENAPI, FlowRuleVo.class);
            List<FlowRuleVo> ruleListByMonitor = ruleList.stream().filter(f -> f.getResource().contains(RequestContext.get().getAccountId())).collect(Collectors.toList());
            List<FlowRuleVo> flowRuleVos = LimitFlowRuleConfigUtil.compareAndSyncFlowRule(ruleListByMonitor);
            if (CollectionUtil.isEmpty(flowRuleVos)) {
                return;
            }
            EyeFlowRuleManager.getArmorDataSource().updateRuleLs(flowRuleVos);
            log.info(String.format("\u6570\u636e\u4e2d\u5fc3 %s ,\u672c\u6b21\u9650\u6d41\u6570\u636e\u540c\u6b65\u6210\u529f\u6570\u636e\u6570\u636e %s \u6761;", RequestContext.get().getAccountId(), flowRuleVos.size()));
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, " setLimitRule flowRule list error, call FlowRuleService error:" + e.getMessage(), new Object[]{e});
        }
    }

    public static List<FlowRuleVo> compareAndSyncFlowRule(List<FlowRuleVo> ruleListByMonitor) {
        Set ruleListByAccountResource;
        Set result;
        List<FlowRuleDto> ruleListByAccount = LimitFlowRuleConfigUtil.getFlowRuleListByAccount();
        ruleListByAccount = ruleListByAccount.stream().filter(c -> c.getCount() > 0).collect(Collectors.toList());
        Set<Object> ruleListByMonitorResource = new HashSet();
        if (CollectionUtil.isNotEmpty(ruleListByMonitor)) {
            ruleListByMonitorResource = ruleListByMonitor.stream().map(FlowRuleVo::getResource).collect(Collectors.toSet());
        }
        if (CollectionUtil.isEmpty(result = LimitFlowRuleConfigUtil.relativeComplement(ruleListByAccountResource = ruleListByAccount.stream().map(FlowRuleDto::getFresource).collect(Collectors.toSet()), ruleListByMonitorResource))) {
            return Collections.emptyList();
        }
        List<FlowRuleDto> addResources = ruleListByAccount.stream().filter(c -> result.contains(c.getFresource())).collect(Collectors.toList());
        ArrayList<FlowRuleVo> flowRuleVos = new ArrayList<FlowRuleVo>();
        addResources.forEach(addResource -> {
            FlowRuleVo flowRuleVo = new FlowRuleVo();
            flowRuleVo.setResource(addResource.getFresource());
            flowRuleVo.setLimitApp("default");
            flowRuleVo.setGrade(Integer.valueOf(1));
            flowRuleVo.setCount(addResource.getCount());
            flowRuleVo.setStrategy(Integer.valueOf(0));
            flowRuleVo.setControlBehavior(Integer.valueOf(0));
            flowRuleVo.setStatInterval(addResource.getFstatinterval().intValue());
            flowRuleVo.setId(String.valueOf(ID.genLongId()));
            flowRuleVo.setRequestType(0);
            flowRuleVo.setAppName("default");
            flowRuleVos.add(flowRuleVo);
        });
        return flowRuleVos;
    }

    public static <T> Set<T> relativeComplement(Set<T> set1, Set<T> set2) {
        if (null == set1) {
            return null;
        }
        if (null == set2) {
            return set1;
        }
        HashSet<T> intersection = new HashSet<T>(set1);
        intersection.retainAll(set2);
        HashSet<T> result = new HashSet<T>(set1);
        result.removeAll(intersection);
        return result;
    }

    public static List<FlowRuleDto> getFlowRuleListByAccount() {
        String sql = "select config.fid, config.fnumber, config.fmasterid, config.fresourcetype, config.fcount, config.fcontrolbehavior, config.fstrategy, config.fgrade, config.fstatinterval,\n       detail.fentryid,detail.fresource,detail.fthirdid,detail.fapiid,detail.fappname,detail.flimitapp\nfrom t_open_rule_config config right join t_open_rule_config_detail detail\non config.fid = detail.fid;\n";
        ArrayList<FlowRuleDto> ruleListConfig = new ArrayList(100);
        ruleListConfig = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, res -> {
            ArrayList<FlowRuleDto> flowRuleDtos = new ArrayList<FlowRuleDto>(100);
            FlowRuleDto flowRuleVo = null;
            while (res.next()) {
                flowRuleVo = new FlowRuleDto();
                flowRuleVo.setFid(Long.valueOf(res.getString("fid")));
                flowRuleVo.setFnumber(res.getString("fnumber"));
                flowRuleVo.setFstatinterval(Integer.valueOf(res.getString("fstatinterval")));
                flowRuleVo.setCount(Integer.valueOf(res.getString("fcount")));
                flowRuleVo.setFmasterid(Long.valueOf(res.getString("fmasterid")));
                flowRuleVo.setFresourcetype(res.getString("fresourcetype"));
                flowRuleVo.setFstrategy(res.getString("fstrategy"));
                flowRuleVo.setFgrade(res.getString("fgrade"));
                flowRuleVo.setFcontrolbehavior(Integer.valueOf(res.getString("fcontrolbehavior")));
                flowRuleVo.setFentryid(Long.valueOf(res.getString("fentryid")));
                flowRuleVo.setFthirdid(Long.valueOf(res.getString("fthirdid")));
                flowRuleVo.setFapiid(Long.valueOf(res.getString("fapiid")));
                flowRuleVo.setFresource(res.getString("fresource"));
                flowRuleVo.setFappname(res.getString("fappname"));
                flowRuleVo.setFlimitapp(res.getString("flimitapp"));
                flowRuleDtos.add(flowRuleVo);
            }
            return flowRuleDtos;
        });
        return ruleListConfig;
    }
}

