/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.limit;

import dm.jdbc.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dlock.DLock;
import kd.bos.eye.api.armor.config.manager.EyeFlowRuleManager;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.eye.api.armor.vo.RuleVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.limit.LimitFlowRuleConfigUtil;
import kd.bos.openapi.base.util.DistributeCacheUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.trace.util.TraceIdUtil;
import kd.bos.util.ConfigurationUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class TenantLimitFlowRuleConfigService {
    private static final Log log = LogFactory.getLog(TenantLimitFlowRuleConfigService.class);
    private static final String LOCK_KEY_TENANT_LIMIT_FLOW_RULE_UPDATE = "/dlock/monitor/tenant/limitflowrule/update";
    private static final long LOCK_TIME = 10000L;
    private static final String SyncDataToMcCacheKey = "STARTER_MC_CONFIG_CHECK";
    private static final String SyncDataToMcKey = "TENANT_ACCOUNT_LIMIT_KEY";

    public static void syncDataToMc() {
        try {
            String value = DistributeCacheUtil.getCacheByKey(SyncDataToMcCacheKey, SyncDataToMcKey, "limit_key");
            log.info("OepnApi-TenantLimitFlowRule-start check:" + (value == null ? "" : value.toString()));
            if (value == null) {
                long startTime = System.currentTimeMillis();
                Map<String, Integer> tenantAccountLimitCountMap = TenantLimitFlowRuleConfigService.readConfigFromMc();
                TenantLimitFlowRuleConfigService.setLimitRule(tenantAccountLimitCountMap);
                long endTime = System.currentTimeMillis();
                TenantLimitFlowRuleConfigService.initMcConfigListener();
                log.info("\u521d\u59cb\u5316\u9650\u6d41\u6570\u636e\u8017\u65f6\uff1a{}", (Object)(endTime - startTime));
                DistributeCacheUtil.setCacheByKey(SyncDataToMcCacheKey, SyncDataToMcKey, "started", "limit_key", 600);
            }
        }
        catch (Exception e) {
            log.error(" initConfig flowRule error:" + e.getMessage(), (Throwable)e);
        }
    }

    private static Map<String, Integer> readConfigFromMc() {
        HashMap<String, Integer> tenantAccountLimitCountMap = new HashMap<String, Integer>();
        List tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
        if (CollectionUtil.isEmpty((Collection)tenantInfoList)) {
            return tenantAccountLimitCountMap;
        }
        tenantInfoList.forEach(tenantInfo -> {
            if (tenantInfo != null) {
                tenantAccountLimitCountMap.put(tenantInfo.getId(), TenantLimitFlowRuleConfigService.getMcTenantLimitCount(tenantInfo.getId()));
            }
        });
        return tenantAccountLimitCountMap;
    }

    private static Integer getMcTenantLimitCount(String tenantId) {
        String tenantLimitCount = McConfigUtil.getPropertyByTenantWithDefault((String)tenantId, (String)"OpenApi.LimitQtyByTenant", (String)"0");
        if (NumberUtils.isDigits((String)tenantLimitCount)) {
            return Integer.parseInt(tenantLimitCount);
        }
        return 0;
    }

    private static void initMcConfigListener() {
        List tenantInfoList = AccountUtils.getAllTenantsByCurrentEnv();
        if (CollectionUtil.isEmpty((Collection)tenantInfoList)) {
            return;
        }
        ConfigurationUtil.observeChange((String)"OpenApi.LimitQtyByTenant", (key, newValue) -> {
            DLock dLock = DLock.create((String)LOCK_KEY_TENANT_LIMIT_FLOW_RULE_UPDATE);
            if (!dLock.tryLock(10000L)) {
                return;
            }
            try {
                tenantInfoList.forEach(tenantInfo -> {
                    if (tenantInfo != null) {
                        HashMap<String, Integer> limitMap = new HashMap<String, Integer>();
                        limitMap.put(tenantInfo.getId(), TenantLimitFlowRuleConfigService.getMcTenantLimitCount(tenantInfo.getId()));
                        TenantLimitFlowRuleConfigService.updateLimitRule(limitMap);
                    }
                });
            }
            finally {
                dLock.unlock();
            }
        });
        tenantInfoList.forEach(tenantInfo -> {
            if (tenantInfo != null) {
                String limitKey = tenantInfo.getId() + "_" + "OpenApi.LimitQtyByTenant";
                ConfigurationUtil.observeChange((String)limitKey, (key, newValue) -> {
                    DLock dLock = DLock.create((String)LOCK_KEY_TENANT_LIMIT_FLOW_RULE_UPDATE);
                    if (!dLock.tryLock(10000L)) {
                        return;
                    }
                    try {
                        HashMap<String, Integer> limitMap = new HashMap<String, Integer>();
                        limitMap.put(tenantInfo.getId(), TenantLimitFlowRuleConfigService.getMcTenantLimitCount(tenantInfo.getId()));
                        TenantLimitFlowRuleConfigService.updateLimitRule(limitMap);
                    }
                    finally {
                        dLock.unlock();
                    }
                });
            }
        });
    }

    private static void setLimitRule(Map<String, Integer> tenantLimitCountMap) {
        if (CollectionUtil.isEmpty(tenantLimitCountMap)) {
            return;
        }
        try {
            List ruleListByMonitor = EyeFlowRuleManager.getArmorDataSource().getRule("OpenApi", FlowRuleVo.class);
            if (CollectionUtil.isNotEmpty((Collection)ruleListByMonitor)) {
                return;
            }
            ArrayList<FlowRuleVo> flowRuleVoList = new ArrayList<FlowRuleVo>();
            for (Map.Entry<String, Integer> entry : tenantLimitCountMap.entrySet()) {
                List accountList;
                String tenantId = entry.getKey();
                Integer limitCount = entry.getValue();
                if (StringUtil.isEmpty((String)tenantId) || limitCount == null || limitCount < 0 || CollectionUtil.isEmpty((Collection)(accountList = AccountUtils.getAllAccounts((String)tenantId)))) continue;
                for (Account account : accountList) {
                    if (account == null) continue;
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    if (StringUtil.isEmpty((String)context.getTraceId())) {
                        context.setTraceId(TraceIdUtil.createTraceIdString());
                    }
                    if (TenantLimitFlowRuleConfigService.updateLimitRule(account, tenantId, limitCount)) {
                        return;
                    }
                    List<FlowRuleVo> flowRuleVos = LimitFlowRuleConfigUtil.compareAndSyncFlowRule(ruleListByMonitor);
                    flowRuleVoList.addAll(flowRuleVos);
                }
            }
            if (CollectionUtil.isEmpty(flowRuleVoList)) {
                return;
            }
            EyeFlowRuleManager.getArmorDataSource().updateRuleLs(flowRuleVoList);
            log.info(String.format("\u6570\u636e\u4e2d\u5fc3 %s ,\u672c\u6b21\u9650\u6d41\u6570\u636e\u540c\u6b65\u6210\u529f\u6570\u636e\u6570\u636e %s \u6761;", RequestContext.get().getAccountId(), flowRuleVoList.size()));
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, " setLimitRule flowRule list error, call FlowRuleService error:" + e.getMessage(), new Object[]{e});
        }
    }

    private static boolean updateLimitRule(Account account, String tenantId, Integer limitCount) throws Exception {
        String flowLimitResId = ApiDataUtil.getTenantResLimitResId((String)tenantId, (String)account.getAccountId());
        List flowRuleVoList = EyeFlowRuleManager.getArmorDataSource().getRule(flowLimitResId, FlowRuleVo.class);
        FlowRuleVo flowRuleVo = new FlowRuleVo();
        if (CollectionUtil.isNotEmpty((Collection)flowRuleVoList)) {
            flowRuleVo = (FlowRuleVo)flowRuleVoList.get(0);
        }
        if (CollectionUtil.isEmpty((Collection)flowRuleVoList)) {
            if (limitCount <= 0) {
                return true;
            }
            flowRuleVo = LimitFlowRuleConfigUtil.createFlowRuleVo(flowLimitResId, limitCount);
        } else if (limitCount <= 0) {
            flowRuleVo.setRequestType(3);
        } else {
            flowRuleVo.setCount(limitCount);
            flowRuleVo.setRequestType(2);
        }
        EyeFlowRuleManager.getArmorDataSource().updateRule((RuleVo)flowRuleVo);
        return false;
    }

    private static void updateLimitRule(Map<String, Integer> tenantLimitCountMap) {
        if (CollectionUtil.isEmpty(tenantLimitCountMap)) {
            return;
        }
        ArrayList<FlowRuleVo> updateRuleList = new ArrayList<FlowRuleVo>();
        try {
            for (Map.Entry<String, Integer> entry : tenantLimitCountMap.entrySet()) {
                List accountList;
                String tenantId = entry.getKey();
                Integer limitCount = entry.getValue();
                if (StringUtil.isEmpty((String)tenantId) || limitCount == null || limitCount < 0 || CollectionUtil.isEmpty((Collection)(accountList = AccountUtils.getAllAccounts((String)tenantId)))) continue;
                for (Account account : accountList) {
                    if (account == null) continue;
                    RequestContext context = RequestContext.create();
                    context.setAccountId(account.getAccountId());
                    context.setTenantId(account.getTenantId());
                    if (StringUtil.isEmpty((String)context.getTraceId())) {
                        context.setTraceId(TraceIdUtil.createTraceIdString());
                    }
                    String flowLimitResId = ApiDataUtil.getTenantResLimitResId((String)tenantId, (String)account.getAccountId());
                    List flowRuleVoList = EyeFlowRuleManager.getArmorDataSource().getRule(flowLimitResId, FlowRuleVo.class);
                    FlowRuleVo flowRuleVo = new FlowRuleVo();
                    if (CollectionUtil.isNotEmpty((Collection)flowRuleVoList)) {
                        flowRuleVo = (FlowRuleVo)flowRuleVoList.get(0);
                    }
                    if (CollectionUtil.isEmpty((Collection)flowRuleVoList)) {
                        if (limitCount <= 0) {
                            return;
                        }
                        flowRuleVo = LimitFlowRuleConfigUtil.createFlowRuleVo(flowLimitResId, limitCount);
                    } else if (limitCount <= 0) {
                        flowRuleVo.setRequestType(3);
                    } else {
                        flowRuleVo.setCount(limitCount);
                        flowRuleVo.setRequestType(2);
                    }
                    updateRuleList.add(flowRuleVo);
                    EyeFlowRuleManager.getArmorDataSource().updateRule((RuleVo)flowRuleVo);
                }
            }
            log.info("openapi-updateRuleListService:" + JsonUtil.toJSON(updateRuleList));
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, " setLimitRule flowRule list error, call FlowRuleService error:" + e.getMessage(), new Object[]{e});
        }
    }
}

